/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachOnePortSubProcessor;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackDetachPortSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5660380256054152752L;
    private static Log logger = LogFactory.getInstance(OpenStackDetachPortSubProcessor.class);

    public OpenStackDetachPortSubProcessor() {
        logger.trace((Object)"OpenStackDetachPortSubProcessor defautl constructor");
    }

    public OpenStackDetachPortSubProcessor(String regionUuid, String projectUuid, String portIdStr, String vmName, String vmUuid) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("portIdsOfVM", portIdStr);
        this.addString("vmName", vmName);
        this.addString("vmUuid", vmUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors();
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        if (null == recoveryTemplate) {
            logger.info((Object)"recoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        String vmUuid = this.getString("vmUuid");
        String vmName = this.getString("vmName");
        String portIdStr = this.getString("portIdsOfVM");
        List<String> portIdList = OpenStackCommonUtil.getListFromStr(portIdStr, ",");
        HashSet<OpenStackDetachOnePortSubProcessor> subProcSet = new HashSet<OpenStackDetachOnePortSubProcessor>();
        OpenStackDetachOnePortSubProcessor prePro = null;
        for (String portId : portIdList) {
            OpenStackDetachOnePortSubProcessor subProc = new OpenStackDetachOnePortSubProcessor(regionUuid, projectUuid, portId, vmName, vmUuid);
            this.initProc((RecoveryProcessor)subProc);
            subProc.setPreviousProcessor((RecoveryProcessor)prePro);
            if (null != prePro) {
                prePro.setNextProcessor((RecoveryProcessor)subProc);
            }
            prePro = subProc;
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        logger.debug((Object)"calcProcessResultBySubProc start");
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

