/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.MigrationParam;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;

public class OpenStackHotMigrationVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -729290830188252874L;
    private static Log logger = LogFactory.getInstance(OpenStackHotMigrationVmSubProcessor.class);

    public OpenStackHotMigrationVmSubProcessor() {
    }

    public OpenStackHotMigrationVmSubProcessor(String regionUuid, String projectUuid, String availableZoneUuid, String vmUuid, String vmName, String replicaInfoStr) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("migrateAzUuid", availableZoneUuid);
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
        this.addString("poReplicaInfo", replicaInfoStr);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String vmName = this.getString("vmName");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackHotMigrationVmSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.updateProcessNameParams(new String[]{vmName});
        String replicaInfoStr = this.getString("poReplicaInfo");
        if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("vm(" + vmName + ") 's replicaInfo is empty."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)replicaInfo) || VerifyUtil.isEmpty((Object)replicaInfo.getPhVmInfo())) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("vm(" + vmName + ") has no placehold vm."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        HashMap<String, String> volumeMap = new HashMap<String, String>();
        replicaInfo.getPairInfos().forEach(pair -> {
            String volumeUuid = pair.getVolumeUuid();
            String drVolumeUuid = pair.getDrVolumeUuid();
            if (!VerifyUtil.isEmpty((String)volumeUuid) && !VerifyUtil.isEmpty((String)drVolumeUuid)) {
                volumeMap.put(OpenStackCommonUtil.getIdFromUuid(volumeUuid), OpenStackCommonUtil.getIdFromUuid(drVolumeUuid));
            }
        });
        String regionUuId = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String drAzName = this.getString("migrateAzUuid");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        MigrationParam migrationParam = new MigrationParam();
        migrationParam.setProduct(true);
        migrationParam.setRegionUuid(regionUuId);
        migrationParam.setProjectUuid(projUuid);
        migrationParam.setTokenId(tokenId);
        migrationParam.setVmUuid(this.getString("vmUuid"));
        migrationParam.setMigrationAz(drAzName);
        migrationParam.setVolumeMap(volumeMap);
        migrationParam.setPoSize(context.getProtectGroup().getPolist().size());
        AsyncTaskResponse response = novaMgr.migration(migrationParam);
        logger.info((Object)("leave OpenStackHotMigrationVmSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (!response.isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err." + response.getErrorCode(), response.getErrorParameter());
            logger.error((Object)"hot migration vm(%s) failed. errMsg:%s", new Object[]{vmName, response.getErrorCode()});
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }
}

