/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackHyperMetroCheckDataConsistencyProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7629564109837738252L;
    private static Log logger = LogFactory.getInstance(OpenStackHyperMetroCheckDataConsistencyProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("Enter into OpenStackHyperMetroCheckDataStatusProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drReplicaCgUuid"));
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("drProjectId");
            drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProdrCgUuid"));
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.isCurrentFCVersionHighThan63() ? mgr.queryRealtimeVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid), new int[0]) : mgr.queryVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid));
        if (null == cgInfo) {
            logger.error((Object)"replica is null.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return false;
        }
        String replicationStatus = cgInfo.getReplicationStatus();
        String status = cgInfo.getStatus();
        if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(status)) {
            logger.error((Object)("replica's status is not avaiable,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return false;
        }
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(replicationStatus)) {
            logger.info((Object)("replica's replicaionstatus is " + replicationStatus + ",recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        logger.error((Object)("replica's replicaionstatus is not expected:" + replicationStatus + ",recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail("lego.err." + OpenstackEnumDefine.REPLICATION_REP_STATUS_E.getErrorCode((String)replicationStatus), null);
        return false;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        this.setProcName("com.huawei.ism.drm.openstack.recovery.processor.OpenStackCheckDataConsistencyProcessor");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.des");
    }
}

