/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.MigrationParam;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.ReleaseActionEnum;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackPhVmRebuidSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -729290830188252874L;
    private static Log logger = LogFactory.getInstance(OpenStackPhVmRebuidSubProcessor.class);

    public OpenStackPhVmRebuidSubProcessor() {
    }

    public OpenStackPhVmRebuidSubProcessor(String vmName, String replicaInfoStr) {
        this.addString("vmName", vmName);
        this.addString("poReplicaInfo", replicaInfoStr);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackPhVmRebuidSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.updateProcessNameParams(new String[]{this.getString("vmName")});
        String vmName = this.getString("vmName");
        String replicaInfoStr = this.getString("poReplicaInfo");
        if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("vm(" + vmName + ") 's replicaInfo is empty."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)replicaInfo) || VerifyUtil.isEmpty((Object)replicaInfo.getPhVmInfo())) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("vm(" + vmName + ") has no placehold vm."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        this.recapturePhVmResource(recoveryPlan, replicaInfo);
        this.updateReplication(recoveryPlan, replicaInfo);
        AsyncTaskResponse response = this.rebuildPhVm(recoveryPlan, replicaInfo);
        logger.info((Object)("leave OpenStackPhVmRebuidSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (!response.isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err." + response.getErrorCode(), response.getErrorParameter());
            logger.error((Object)"rebuild phvm(%s) failed. errMsg:%s", new Object[]{replicaInfo.getPhVmInfo().getVmUuid(), response.getErrorCode()});
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private void recapturePhVmResource(RecoveryPlan recoveryPlan, PoReplicaInfo replicaInfo) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        String drRegionUuId = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuId = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
        }
        String phVmUuid = replicaInfo.getPhVmInfo().getVmUuid();
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drProjUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        novaMgr.releaseOrRecapturePhVmResource(drProjUuid, drRegionUuId, drTokenId, phVmUuid, ReleaseActionEnum.RECAPTURE);
    }

    private void updateReplication(RecoveryPlan recoveryPlan, PoReplicaInfo replicaInfo) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        String regionUuId = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String drRegionUuId = isCshaCsdrWithinRegionRecovery ? regionUuId : (String)pg.getProps().get("drRegionId");
        String drProjUuid = isCshaCsdrWithinRegionRecovery ? projUuid : (String)pg.getProps().get("drProjectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        IDrExtendManager mgr = ManagerFactory.getInstance().getDrExtendManager(openstackUuid);
        replicaInfo.getPairInfos().forEach(pair -> {
            VolumeReplicationInfo updateRepInfo;
            String volumeUuid = pair.getVolumeUuid();
            String replicaUuid = pair.getReplicaUuid();
            String drVolumeUuid = pair.getDrVolumeUuid();
            String drReplicaUuid = pair.getDrReplicaUuid();
            if (!VerifyUtil.isEmpty((String)volumeUuid) && !VerifyUtil.isEmpty((String)drReplicaUuid)) {
                updateRepInfo = new VolumeReplicationInfo();
                updateRepInfo.setId(OpenStackCommonUtil.getIdFromUuid(drReplicaUuid));
                updateRepInfo.setVolumeId(OpenStackCommonUtil.getIdFromUuid(volumeUuid));
                mgr.updateReplication(drRegionUuId, drTokenId, drProjUuid, updateRepInfo);
            }
            if (!VerifyUtil.isEmpty((String)drVolumeUuid) && !VerifyUtil.isEmpty((String)replicaUuid)) {
                updateRepInfo = new VolumeReplicationInfo();
                updateRepInfo.setId(OpenStackCommonUtil.getIdFromUuid(replicaUuid));
                updateRepInfo.setVolumeId(OpenStackCommonUtil.getIdFromUuid(drVolumeUuid));
                mgr.updateReplication(regionUuId, tokenId, projUuid, updateRepInfo);
            }
        });
    }

    private AsyncTaskResponse rebuildPhVm(RecoveryPlan recoveryPlan, PoReplicaInfo replicaInfo) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        String projUuid = (String)pg.getProps().get("projectId");
        String drRegionUuId = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String azName = (String)pg.getProps().get("zoneName");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuId = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        MigrationParam migrationParam = new MigrationParam();
        migrationParam.setProduct(false);
        migrationParam.setRegionUuid(drRegionUuId);
        migrationParam.setProjectUuid(drProjUuid);
        migrationParam.setTokenId(drTokenId);
        migrationParam.setVmUuid(replicaInfo.getPhVmInfo().getVmUuid());
        migrationParam.setMigrationAz(azName);
        return novaMgr.migration(migrationParam);
    }
}

