/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.concurrent.TimeUnit;

public class OpenStackReverseStorageRepDirectionProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1972358718194932791L;
    private static Log logger = LogFactory.getInstance(OpenStackReverseStorageRepDirectionProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        String drReplicaCgUuid;
        logger.info((Object)"enter into OpenStackReverseStorageRepDirectionProcessor");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        if ((34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) && !this.checkAndStopHyperMetroStatus(pg)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)"Stop hyperMetroStatus failed, pg is %s.", new Object[]{pg.getName()});
            return false;
        }
        if (pg.getTemplate().getType() != 29 && pg.getTemplate().getType() != 25 && !this.checkAndSplitReplicationStatus(pg)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)"Split ReplicationStatus failed, pg is %s.", new Object[]{pg.getName()});
            return false;
        }
        boolean useDrRes = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && 25 == pg.getTemplate().getType();
        String regionUuid = useDrRes ? (String)pg.getProps().get("drRegionId") : (String)pg.getProps().get("regionId");
        String projUuid = useDrRes ? (String)pg.getProps().get("drProjectId") : (String)pg.getProps().get("projectId");
        String replicaCgUuid = useDrRes ? (String)pg.getProps().get("drReplicaCgUuid") : (String)pg.getProps().get("replicaCgUuid");
        String drRegionUuid = useDrRes ? (String)pg.getProps().get("regionId") : (String)pg.getProps().get("drRegionId");
        String drProjUuid = useDrRes ? (String)pg.getProps().get("projectId") : (String)pg.getProps().get("drProjectId");
        String string = drReplicaCgUuid = useDrRes ? (String)pg.getProps().get("replicaCgUuid") : (String)pg.getProps().get("drReplicaCgUuid");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
            replicaCgUuid = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() ? (String)pg.getProps().get("hyperProdrCgUuid") : (String)pg.getProps().get("hyperProCgUuid");
            drReplicaCgUuid = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() ? (String)pg.getProps().get("hyperProCgUuid") : (String)pg.getProps().get("hyperProdrCgUuid");
        }
        try {
            DrExtendManager mgr = new DrExtendManager();
            if (!this.setHyperMasterSite(pg)) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)(pg.getName() + ": set Hyper Master  failed."));
                return false;
            }
            if (this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue()) {
                OpenStackRecoveryTool.updateReplicationCGRecoverStrategyForHyper(pg, drRegionUuid, drProjUuid, drReplicaCgUuid, OpenstackEnumDefine.RecoverStrategy.AUTO);
            }
            logger.debug((Object)(pg.getName() + ": trying to switch master/slave. drReplicaCgUUID=" + drReplicaCgUuid));
            boolean switchSlaveResult = this.reverseVolumeReplication(drRegionUuid, drProjUuid, drReplicaCgUuid, true);
            if (!switchSlaveResult) {
                logger.error((Object)(pg.getName() + ": Slave Switch failed. drReplicaCgUUID=" + drReplicaCgUuid));
                return false;
            }
            logger.debug((Object)(pg.getName() + ": trying to switch master/slave. replicaCgUuid=" + replicaCgUuid));
            boolean switchMasterResult = this.reverseVolumeReplication(regionUuid, projUuid, replicaCgUuid, false);
            if (!switchMasterResult) {
                logger.error((Object)(pg.getName() + ": Master Switch failed. replicaCgUuid=" + replicaCgUuid));
                return false;
            }
            logger.debug((Object)(pg.getName() + ": switch master/slave successfully. drReplicaCgUUID=" + drReplicaCgUuid + ",replicaCgUuid =" + replicaCgUuid));
            if (34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
                String standByDrReplicaCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
                logger.debug((Object)(pg.getName() + ": trying to switch standby master/slave. standByDrReplicaCgUuid=" + standByDrReplicaCgUuid));
                switchSlaveResult = this.reverseVolumeReplication(drRegionUuid, drProjUuid, standByDrReplicaCgUuid, true);
                if (!switchSlaveResult) {
                    logger.error((Object)(pg.getName() + ": Slave Switch failed. standByDrReplicaCgUuid=%s"), new Object[]{standByDrReplicaCgUuid});
                    return false;
                }
                String standByReplicaCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
                logger.debug((Object)(pg.getName() + ": trying to switch standby master/slave. standByReplicaCgUuid=" + standByReplicaCgUuid));
                switchMasterResult = this.reverseVolumeReplication(regionUuid, projUuid, standByReplicaCgUuid, false);
                if (!switchMasterResult) {
                    logger.error((Object)(pg.getName() + ": Master Switch failed. standByReplicaCgUuid=%s"), new Object[]{standByReplicaCgUuid});
                    return false;
                }
                logger.debug((Object)(pg.getName() + ": standBy switch master/slave successfully. standByDrReplicaCgUuid=" + standByDrReplicaCgUuid + "standByReplicaCgUuid=" + standByReplicaCgUuid));
            }
            if ((34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) && !((String)pg.getProps().get("originalAvailableRegion")).equals(regionUuid)) {
                String standRing = (String)pg.getProps().get("prodRingID");
                String replicaCgNormalUuid = OpenStackCommonUtil.getIdFromUuid(OpenStackRecoveryTool.getReplicaCgUuid(pg));
                logger.debug((Object)"%s: trying to set write-protect of slave. replicaCgUUID=%s", new Object[]{pg.getName(), replicaCgNormalUuid});
                String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
                AsyncTaskResponse writeProtectResponse = mgr.splitRingVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgNormalUuid, standRing, "ro");
                if (!writeProtectResponse.isSuccess()) {
                    this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                    logger.error((Object)"%s: set write-protect of slave failed,errorCode:%s", new Object[]{pg.getName(), writeProtectResponse.getErrorCode()});
                    this.updateProcessDetail("lego.err." + writeProtectResponse.getErrorCode(), null);
                    return false;
                }
            }
            if (!this.restartHyperMetro(pg)) {
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("OpenStackReverseStorageRepDirectionProcessor failed." + e.getErrorCode()));
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave OpenStackReverseStorageRepDirectionProcessor");
        return true;
    }

    private boolean setHyperMasterSite(ProtectGroup pg) {
        if (!PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() != this.getProcType() || OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            logger.info((Object)"%s do not need to set hyper master site", new Object[]{pg.getName()});
            return true;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String replicaCgUuid = (String)pg.getProps().get("replicaCgUuid");
        boolean isActive = OpenStackRecoveryTool.checkReplicationStatus(regionUuid, projectUuid, replicaCgUuid);
        boolean isSecondDisasterRecovery = Boolean.parseBoolean(pg.getProperty("IsSecondDisasterRecovery"));
        if (isActive && !isSecondDisasterRecovery) {
            logger.info((Object)"%s do not need to set hyper master site", new Object[]{pg.getName()});
            return true;
        }
        String hyperReplicaCgUuid = (String)pg.getProps().get("hyperProCgUuid");
        String hyperDrReplicaCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
        logger.debug((Object)(pg.getName() + ": trying to switch master/slave. drReplicaCgUUID=" + hyperDrReplicaCgUuid + ",replicaCgUuid =" + hyperReplicaCgUuid));
        boolean switchSlaveResult = this.reverseVolumeReplication(regionUuid, projectUuid, isSecondDisasterRecovery ? hyperReplicaCgUuid : hyperDrReplicaCgUuid, true);
        if (!switchSlaveResult) {
            logger.error((Object)(pg.getName() + ": Slave Switch failed. drReplicaCgUUID=" + hyperDrReplicaCgUuid));
            this.updateProcessDetail("lego.err.1073948756", new String[]{hyperDrReplicaCgUuid});
            return false;
        }
        boolean switchMasterResult = this.reverseVolumeReplication(regionUuid, projectUuid, isSecondDisasterRecovery ? hyperDrReplicaCgUuid : hyperReplicaCgUuid, false);
        if (!switchMasterResult) {
            logger.error((Object)(pg.getName() + ": Master Switch failed. replicaCgUuid=" + hyperReplicaCgUuid));
            this.updateProcessDetail("lego.err.1073948756", new String[]{hyperReplicaCgUuid});
            return false;
        }
        logger.debug((Object)(pg.getName() + ": switch master/slave successfully. drReplicaCgUUID=" + hyperDrReplicaCgUuid + ",replicaCgUuid =" + hyperReplicaCgUuid));
        pg.getProps().remove("IsSecondDisasterRecovery");
        return true;
    }

    private boolean checkAndStopHyperMetroStatus(ProtectGroup pg) {
        String tokenId;
        DrExtendManager drExtendMgr;
        VolumeReplicationCgInfo cgInfo;
        if (OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            return true;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String hyperMetroCgid = OpenStackRecoveryTool.getHyperProCgUuid(pg);
        boolean isSecondDisasterRecovery = Boolean.parseBoolean(pg.getProperty("IsSecondDisasterRecovery"));
        if (isSecondDisasterRecovery) {
            OpenStackRecoveryTool.updateReplicationCGRecoverStrategy(regionUuid, projUuid, hyperMetroCgid, OpenstackEnumDefine.RecoverStrategy.AUTO);
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (null == (cgInfo = (drExtendMgr = new DrExtendManager()).queryRealtimeVolumeReplicationCG(regionUuid, tokenId = TokenUtil.getInstance().getTokenId(projUuid), projUuid, hyperMetroCgid, new int[0]))) {
            logger.error((Object)(pg.getName() + ": hyperMetroCg not found"));
            return false;
        }
        String status = cgInfo.getStatus();
        if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(status)) {
            logger.error((Object)(pg.getName() + ": replica's status is not avaiable."));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948223", null);
            return false;
        }
        if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(cgInfo.getReplicationStatus()) && !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(cgInfo.getReplicationStatus())) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)(pg.getName() + ": OpenStackReverseStorageRepDirectionProcessor failed.HyperMetro replication status is " + cgInfo.getReplicationStatus()));
            this.updateProcessDetail("lego.err.1073948223", null);
            return false;
        }
        hyperMetroCgid = OpenStackCommonUtil.getIdFromUuid(hyperMetroCgid);
        try {
            AsyncTaskResponse response = drExtendMgr.splitVolumeReplicationCG(regionUuid, tokenId, projUuid, hyperMetroCgid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.info((Object)(pg.getName() + ": set volRepCg(" + hyperMetroCgid + ") split failed: errorcode is " + response.getErrorCode()));
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)(pg.getName() + ": volRepCg(" + hyperMetroCgid + ") fault switch failed."), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean restartHyperMetro(ProtectGroup pg) {
        String drReplicaCgUuid;
        if (34 != pg.getTemplate().getType() && !PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            return true;
        }
        if (!OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            return true;
        }
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("drProjectId");
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        AsyncTaskResponse response = mgr.syncVolumeReplicationCG(regionUuid, tokenId, projUuid, drReplicaCgUuid = (String)pg.getProps().get("hyperProdrCgUuid"));
        if (!response.isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948904", null);
            logger.info((Object)(pg.getName() + ": Failed to startup the HyperMetro: errorcode is " + response.getErrorCode()));
            return false;
        }
        return true;
    }

    protected boolean reverseVolumeReplication(String regionUuid, String projUuid, String replicaCgUuid, boolean isMaster) {
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        DrExtendManager mgr = new DrExtendManager();
        logger.debug((Object)("Trying to switch master/slave. drReplicaCgUUID=" + replicaCgUuid));
        try {
            AsyncTaskResponse switchResponse = mgr.reverseVolumeReplicationCG(isMaster, replicaCgUuid, regionUuid, tokenId, projUuid);
            if (!switchResponse.isSuccess()) {
                logger.error((Object)("Master/Slave Switch failed." + switchResponse.getErrorCode()));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err." + switchResponse.getErrorCode(), null);
                return false;
            }
            logger.info((Object)("3DC ring standby switch master/slave successfully. drReplicaCgUUID=" + replicaCgUuid));
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        return true;
    }

    private boolean checkAndSplitReplicationStatus(ProtectGroup pg) {
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            return true;
        }
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid(OpenStackRecoveryTool.getDrReplicaCgUuid(pg));
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        String originalRegionUuid = (String)pg.getProps().get("originalAvailableRegion");
        String regionUuid = (String)pg.getProps().get("regionId");
        DrExtendManager drExtendMgr = new DrExtendManager();
        VolumeReplicationCgInfo cgInfo = drExtendMgr.queryVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, drReplicaCgUuid);
        if (null == cgInfo) {
            logger.error((Object)(pg.getName() + " : hyperMetroCg not found"));
            return false;
        }
        String status = cgInfo.getStatus();
        if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(status)) {
            logger.error((Object)(pg.getName() + "replica's status is not avaiable."));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.INACTIVE.getValue().equals(cgInfo.getReplicationStatus()) && !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(cgInfo.getReplicationStatus())) {
            AsyncTaskResponse response;
            if ((34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) && regionUuid.equals(originalRegionUuid)) {
                String standRing = (String)pg.getProps().get("standbyDRRingUuid");
                response = drExtendMgr.splitRingVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, drReplicaCgUuid, standRing, "rw");
            } else {
                response = drExtendMgr.splitVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, drReplicaCgUuid);
            }
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948904", null);
                logger.error((Object)(pg.getName() + "set volRepCg(" + drReplicaCgUuid + ") writable failed: error code is " + response.getErrorCode()));
                return false;
            }
        }
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorStorageRelationProcessor.des");
    }
}

