/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.EndRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Set;

public class OpenStackSynchronizeDataProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5467416927457531551L;
    private static final Log logger = LogFactory.getInstance(OpenStackSynchronizeDataProcessor.class);
    private static final long MONITOR_TIME = 1440L;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("Enter into OpenStackSynchronizeDataProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicatrionUuid = OpenStackRecoveryTool.getReplicaCgUuid(pg);
        if (21 == pg.getTemplate().getType() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() != this.getProcType() && !this.isLastSynchronizeProcess()) {
            logger.info((Object)("recoveryplan is sync, recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        try {
            logger.info((Object)("sync begin. replicaUuid:" + replicatrionUuid + ", regionUuid:" + regionUuid + ", projUuid:" + projUuid + ", recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
            ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).syncReplication(regionUuid, projUuid, replicatrionUuid, true);
            logger.info((Object)("sync monitoring. replicaUuid:" + replicatrionUuid + ", regionUuid:" + regionUuid + ", projUuid:" + projUuid));
            for (long index = 0L; index < 1440L; ++index) {
                CommUtil.pauseThread((long)5000L);
                int progress = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).getReplicationSyncProcess(regionUuid, projUuid, replicatrionUuid, true);
                if (100 != progress) continue;
                logger.info((Object)("Synchronize replication success. recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758784000L);
                if (this.changeProtectGroupStatusAndSendMsg(context, pg)) {
                    return false;
                }
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Executing protect group failed.recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), (Throwable)e, 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Executing protect group failed.recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947418", new String[0]);
            return false;
        }
        this.updateProcessDetail("lego.err.1073948744", new String[0]);
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        logger.info((Object)("leave into OpenStackSynchronizeDataProcessor, recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        return false;
    }

    private boolean changeProtectGroupStatusAndSendMsg(RecoveryProcessorContext context, ProtectGroup pg) {
        if (this.isLastSynchronizeProcess()) {
            Set protectGroups = context.getRecoveryPlan().getProtectGroups();
            String[] pgIds = RecoveryProcessUtil.getProtectGroupIds((Set)protectGroups);
            boolean result = RecoveryProcessUtil.changeProtectGroupStatus((String[])pgIds, (DrmEnumDefine.PROTECT_GROUP_STATUS)DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL);
            if (!result) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.-1", new String[0]);
                return true;
            }
            IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
            reprotectService.sendReprotectSuccessMsg(context.getRecoveryPlan());
            AlarmReporter.restoreAlarm((long)52625455L, (String[])new String[]{pg.getUuid()});
        }
        return false;
    }

    private boolean isLastSynchronizeProcess() {
        return null != this.getNextProcessor() && this.getNextProcessor() instanceof EndRecoveryProcessor;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor.des");
    }
}

