/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackUnReserveVolumeSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class OpenStackUnReserveVolumeProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6612201285034706555L;
    private static Log logger = LogFactory.getInstance(OpenStackUnReserveVolumeProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackUnReserveVolumeSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.generateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"no child processor");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != this.getProcStatus()) {
            return false;
        }
        logger.info((Object)("leave OpenStackUnReserveVolumeSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        return true;
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
        }
        HashSet<OpenStackUnReserveVolumeSubProcessor> subProcessors = new HashSet<OpenStackUnReserveVolumeSubProcessor>();
        Map<String, String> productVoldToDrVolId = OpenStackRecoveryTool.getProductVolIdToDrVolId(context.getRecoveryPlan(), PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg));
        HashSet<String> drVolUuids = new HashSet<String>();
        for (Map.Entry<String, String> entry : productVoldToDrVolId.entrySet()) {
            String drVolId;
            String string = drVolId = VerifyUtil.isEmpty((String)entry.getValue()) ? entry.getKey() + "-drvol" : entry.getValue();
            if (drVolUuids.contains(drVolId)) continue;
            drVolUuids.add(drVolId);
            OpenStackUnReserveVolumeSubProcessor subProcessor = new OpenStackUnReserveVolumeSubProcessor(OpenStackCommonUtil.getIdFromUuid(drVolId), drRegionUuid, drProjUuid);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

