/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackNetwork;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackSubnet;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.INetWorkService;
import com.huawei.ism.drm.openstack.sdk.service.IOpenStackRecoveryService;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.base.thread.FutureResult;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IOpenStackRecoveryService", Desc="", Interface=IOpenStackRecoveryService.class)
public class OpenStackRecoveryServiceImpl
extends BaseService
implements IOpenStackRecoveryService {
    private static final Log logger = LogFactory.getInstance(OpenStackRecoveryServiceImpl.class);
    private INetWorkService netWorkService;

    public void setNetWorkService(INetWorkService netWorkService) {
        this.netWorkService = netWorkService;
    }

    public List<OpenStackVM> getAvailablePlaceHoldVms(String planId, String regionUuid, String projUuid, String azName) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)azName) || VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List result = ((IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class)).getVmInfos(regionUuid, projUuid, azName);
        if (VerifyUtil.isEmpty((Collection)result)) {
            return new ArrayList<OpenStackVM>();
        }
        Set<String> usedVms = this.getUsedPlaceHoldVmUuids(planId);
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            OpenStackVM vm = (OpenStackVM)itr.next();
            if (VerifyUtil.isEmpty((String)vm.getVolumeAttached()) && !usedVms.contains(vm.getUuid())) continue;
            itr.remove();
        }
        return result;
    }

    private Set<String> getUsedPlaceHoldVmUuids(String planId) {
        String hql = "from RecoverySetting where name = ? and recoveryPlan.planId <> ?";
        List settings = CommonDAOLocator.getMoDao().getHibernateTemplate().find(hql, new Object[]{"PLACEHOLDVM", planId});
        HashSet<String> usedVms = new HashSet<String>();
        if (!VerifyUtil.isEmpty((Collection)settings)) {
            for (RecoverySetting setting : settings) {
                usedVms.add(setting.getValue());
            }
        }
        return usedVms;
    }

    public void createTestPort(String planId, OpenStackPort port) {
        if (VerifyUtil.isEmpty((String)planId) || null == port) {
            logger.error((Object)"param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
        if (null == plan) {
            logger.error((Object)("plan is null:" + planId));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in plan is null:" + planId));
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = pg.getPoProviderSN();
        ManagedObject mo = CommonDAOLocator.getMoDao().getMoByUuid(openstackUuid, Boolean.TRUE);
        if (null == mo) {
            logger.error((Object)"openstack is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("drProjectId");
        this.netWorkService.createPort(openstackUuid, regionUuid, projUuid, port);
    }

    public List<OpenStackNetwork> getAvailableTestNetWorksByVm(String openstackUuid, String regionUuid, String projUuid, String vmUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            logger.error((Object)"param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        INeutronManager neutronMgr = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        List<OpenStackNetwork> result = neutronMgr.getNetworks(openstackUuid, regionUuid, tokenId, null);
        Iterator<OpenStackNetwork> itr = result.iterator();
        while (itr.hasNext()) {
            OpenStackNetwork network = itr.next();
            if (projUuid.equals(network.getProjectUuid()) || network.getShared().booleanValue()) continue;
            itr.remove();
        }
        return result;
    }

    public List<OpenStackSubnet> getAvailableTestSubNetByNetWork(String openstackUuid, String regionUuid, String projUuid, String netWorkUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)netWorkUuid)) {
            logger.error((Object)"param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        String netWorkId = OpenStackCommonUtil.getIdFromUuid(netWorkUuid);
        HashMap<String, String> reqPram = new HashMap<String, String>();
        reqPram.put("network_id", netWorkId);
        return ManagerFactory.getInstance().getNeutronManager(OpenStackCommonUtil.getOpenstackUuidFromStr(netWorkUuid)).getSubnets(openstackUuid, regionUuid, tokenId, null, reqPram);
    }

    public String getRecoveryRegionAz(RecoveryPlan recoveryPlan) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg || 37 != pg.getTemplate().getType()) {
            throw new LegoCheckedException(1073947393L);
        }
        if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue() == recoveryPlan.getPlanStatus() && PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg) && !OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            return this.getAvailableRecoveryRegionAz(pg, recoveryPlan.getPlanStatus(), true);
        }
        return this.getAvailableRecoveryRegionAz(pg, recoveryPlan.getPlanStatus(), false);
    }

    public String getRecoveryRegionAz(String recoveryPlanID) {
        RecoveryPlan recoveryPlan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(recoveryPlanID);
        return this.getRecoveryRegionAz(recoveryPlan);
    }

    private String getAvailableRecoveryRegionAz(ProtectGroup pg, int planStatus, boolean isSecondDisasterRecovery) {
        List<Integer> susccessStatuList = Arrays.asList(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue());
        boolean isRetry = true;
        if (susccessStatuList.contains(planStatus)) {
            isRetry = false;
        }
        if (isRetry) {
            String drRegionUuid = pg.getProperty("current_disaster_region");
            String drZoneName = pg.getProperty("drZoneName");
            if (null != drRegionUuid && drRegionUuid.equals(OpenStackCommonUtil.getIdFromUuid(pg.getProperty("regionId")))) {
                drZoneName = pg.getProperty("prod_region_drZoneName");
            }
            return this.constructRecoveryReginAz(drRegionUuid, drZoneName);
        }
        if (isSecondDisasterRecovery) {
            return this.getSecondDisasterRecoveryAzMap(pg);
        }
        if (OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            return this.getCsdrCshaRecoveryAzMap(pg);
        }
        return this.getCshaCsdrRecoveryAzMap(pg);
    }

    private String getCshaCsdrRecoveryAzMap(ProtectGroup pg) {
        ArrayList regionAzList = new ArrayList();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drRegionName = (String)pg.getProps().get("drRegionName");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drZoneName = (String)pg.getProps().get("drZoneName");
        String drReplicaCgId = (String)pg.getProps().get("drReplicaCgUuid");
        String hyperDrRegionUuid = (String)pg.getProps().get("regionId");
        String hyperDrRegionName = (String)pg.getProps().get("regionName");
        String hyperDrProjUuid = (String)pg.getProps().get("projectId");
        String hyperDrZoneName = (String)pg.getProps().get("prod_region_drZoneName");
        String hyperDrReplicaCgId = (String)pg.getProps().get("hyperProdrCgUuid");
        try {
            ArrayList<RealtimeDrextendStatusCallable> taskList = new ArrayList<RealtimeDrextendStatusCallable>();
            taskList.add(new RealtimeDrextendStatusCallable(drRegionUuid, drZoneName, drProjUuid, drReplicaCgId));
            taskList.add(new RealtimeDrextendStatusCallable(hyperDrRegionUuid, hyperDrZoneName, hyperDrProjUuid, hyperDrReplicaCgId));
            int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
            int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 180);
            List queryResult = ExecutionService.execute(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)timeout, (int)batchNum);
            regionAzList.addAll(queryResult.stream().filter(FutureResult::success).map(FutureResult::getData).collect(Collectors.toList()));
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Region(%s) is not available to do disaster recovery or plan migration. drRegion:%s", new Object[]{hyperDrRegionName, drRegionName});
        }
        return JSONArray.fromObject(regionAzList).toString();
    }

    private String getCsdrCshaRecoveryAzMap(ProtectGroup pg) {
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        String drReplicCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        String drZoneName = (String)pg.getProps().get("drZoneName");
        boolean isActive = OpenStackRecoveryTool.checkReplicationStatus(drRegionUuid, drProjectUuid, drReplicCgUuid);
        if (isActive) {
            return this.constructRecoveryReginAz(drRegionUuid, drZoneName);
        }
        logger.error((Object)"Zone(%s) is not active side. Cannot do disaster recovery or plan migration.", new Object[]{drZoneName});
        isActive = OpenStackRecoveryTool.checkReplicationStatus(drRegionUuid, drProjectUuid, (String)pg.getProps().get("hyperProRemotedrCgUuid"));
        drZoneName = (String)pg.getProps().get("prod_region_drZoneName");
        if (isActive) {
            return this.constructRecoveryReginAz(drRegionUuid, drZoneName);
        }
        logger.error((Object)"Zone(%s) is not active side. Cannot do disaster recovery or plan migration.", new Object[]{drZoneName});
        return "";
    }

    private String getSecondDisasterRecoveryAzMap(ProtectGroup pg) {
        String drRegionUuid = pg.getProperty("drRegionId");
        String drRegionName = pg.getProperty("drRegionName");
        String drProjUuid = pg.getProperty("drProjectId");
        String drZoneName = pg.getProperty("drZoneName");
        String drReplicaCgId = pg.getProperty("drReplicaCgUuid");
        try {
            if (!this.isStorageAvailableForRecovery(drRegionUuid, drProjUuid, drReplicaCgId)) {
                logger.error((Object)"Region(%s) is not available to do disaster recovery or plan migration.", new Object[]{drRegionName});
                return "";
            }
            return this.constructRecoveryReginAz(drRegionUuid, drZoneName);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Region(%s) is not available to do disaster recovery or plan migration.", new Object[]{drRegionName});
            return "";
        }
    }

    private String constructRecoveryReginAz(String drRegionUuid, String drZoneName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("recovery_region_id", OpenStackCommonUtil.getIdFromUuid(drRegionUuid));
        map.put("recovery_az_id", OpenStackCommonUtil.getIdFromUuid(drZoneName));
        return JSONArray.fromObject(Arrays.asList(map)).toString();
    }

    private boolean isStorageAvailableForRecovery(String regionUuid, String projUuid, String cgUuid) {
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        DrExtendManager mgr = new DrExtendManager();
        try {
            VolumeReplicationCgInfo cgInfo = mgr.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(cgUuid), 0);
            if (null == cgInfo) {
                logger.error((Object)("the VolumeReplicationCgInfo is null: " + cgUuid));
                return false;
            }
            String replicationCgStatus = cgInfo.getStatus();
            String replicationStatus = cgInfo.getReplicationStatus();
            if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(replicationCgStatus)) {
                logger.debug((Object)"regionUuid is %s, cgUuid is %s, replica's status is(%s) not available, can't execute planed-motion or test.", new Object[]{regionUuid, cgUuid, replicationCgStatus});
                return false;
            }
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ERROR.getValue().equals(replicationStatus) || OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue().equals(replicationStatus)) {
                logger.debug((Object)"regionUuid is %s, cgUuid is %s, replica's  replica status is %s, can't execute planed-motion or test.", new Object[]{regionUuid, cgUuid, replicationStatus});
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Query realtime Cg error. RegionUuid is %s, cgUuid is %s.  Not available to do disaster recovery or plan migration to this region", new Object[]{regionUuid, cgUuid});
            return false;
        }
        return true;
    }

    private class RealtimeDrextendStatusCallable
    implements Callable<Map> {
        private String regionUuid;
        private String azUuid;
        private String projectUuid;
        private String cgUuid;

        public RealtimeDrextendStatusCallable(String regionUuid, String azUuid, String projectUuid, String cgUuid) {
            this.regionUuid = regionUuid;
            this.azUuid = azUuid;
            this.projectUuid = projectUuid;
            this.cgUuid = cgUuid;
        }

        @Override
        public Map call() {
            if (OpenStackRecoveryServiceImpl.this.isStorageAvailableForRecovery(this.regionUuid, this.projectUuid, this.cgUuid)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("recovery_region_id", OpenStackCommonUtil.getIdFromUuid(this.regionUuid));
                map.put("recovery_az_id", OpenStackCommonUtil.getIdFromUuid(this.azUuid));
                return map;
            }
            throw new LegoCheckedException(0x300001L);
        }
    }
}

