/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.OpenStackVmResRollBackExecutor;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenStackVMActionEnum;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;

public class OpenStackVmResRollBackExecutorEx
extends OpenStackVmResRollBackExecutor {
    private static Log logger = LogFactory.getInstance(OpenStackVmResRollBackExecutorEx.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean execute(String param) {
        JSONObject json = JSONObject.fromObject((Object)param);
        String replicaStr = json.getJSONObject("replicationInfo").toString();
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
        try {
            super.execute(param);
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                return true;
            }
            if (null == replicaInfo || null == replicaInfo.getPhVmInfo()) {
                return true;
            }
            String drRegionUuid = replicaInfo.getDrRegionUuid();
            String drProjUuid = replicaInfo.getDrProjUuid();
            PhVmInfo phVmInfo = replicaInfo.getPhVmInfo();
            String vmUuid = phVmInfo.getVmUuid();
            if (!VerifyUtil.isEmpty((String)vmUuid)) {
                this.deletePhVm(drRegionUuid, drProjUuid, vmUuid);
            }
            String bootVolumeUuid = phVmInfo.getBootVolumeUuid();
            this.deleteBootVolume(drRegionUuid, drProjUuid, bootVolumeUuid);
            List portIdList = phVmInfo.getPortIdList();
            this.deletePorts(drRegionUuid, drProjUuid, portIdList);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"roll back failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"roll back task execute failed", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        return true;
    }

    private void deletePhVm(String drRegionUuid, String drProjUuid, String vmUuid) {
        AsyncTaskResponse shutdownResponse;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        OpenStackVM phVm = novaMgr.getVm(drRegionUuid, tokenId, drProjUuid, vmUuid, new int[0]);
        if (null == phVm) {
            logger.info((Object)("the vm is not exist,vmUuid=" + vmUuid));
            return;
        }
        if (phVm.getStatus().intValue() == OpenstackEnumDefine.VM_STATUS_E.ACTIVE.getValue() && !(shutdownResponse = novaMgr.vmAction(vmUuid, drProjUuid, drRegionUuid, tokenId, OpenStackVMActionEnum.HARD_STOP)).isSuccess()) {
            logger.error((Object)("shutdown vm(" + vmUuid + ") failed" + shutdownResponse.getErrorCode()));
            throw new LegoCheckedException(1073948109L);
        }
        AsyncTaskResponse delVmResponse = novaMgr.deleteVm(drRegionUuid, drProjUuid, tokenId, vmUuid);
        if (!delVmResponse.isSuccess()) {
            logger.error((Object)("delete vm(" + vmUuid + ") failed" + delVmResponse.getErrorCode()));
            throw new LegoCheckedException(1073948109L);
        }
    }

    private void deleteBootVolume(String drRegionUuid, String drProjUuid, String volumeUuid) {
        String volumeId;
        if (VerifyUtil.isEmpty((String)volumeUuid)) {
            logger.info((Object)"the volume uuid is empty");
            return;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        AsyncTaskResponse response = cinderMgr.deleteVolume(volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid), drRegionUuid, tokenId, drProjUuid);
        if (!response.isSuccess()) {
            logger.error((Object)("delete the temp boot volume failed:volumeId=" + volumeId));
            throw new LegoCheckedException(1073948109L);
        }
    }

    private void deletePorts(String drRegionUuid, String drProjUuid, List<String> portIdList) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        INeutronManager networkMgr = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        for (String portId : portIdList) {
            AsyncTaskResponse response = networkMgr.deletePort(drRegionUuid, tokenId, portId);
            if (response.isSuccess()) continue;
            logger.info((Object)("delete port failed:portId=" + portId));
            throw new LegoCheckedException(1073948109L);
        }
    }
}

