/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.CreateServerInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService", Desc="", Interface=IVirtualMachineService.class)
public class VirtualMachineServiceImpl
extends BaseService
implements IVirtualMachineService {
    private static Log logger = LogFactory.getInstance(VirtualMachineServiceImpl.class);

    public Page pageQueryVmsByOpenstackUuid(String openstackUuid, String orderBy, int pageNo, int pageSize, boolean isAsc) {
        return new Page();
    }

    public List<OpenStackVM> queryVmByUuids(String regionUuid, String projectUuid, String ... vmUuids) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((Object[])vmUuids)) {
            logger.warn((Object)"vmuuid is empty", 90160758786989L);
            return new ArrayList<OpenStackVM>();
        }
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (String uuid : vmUuids) {
            vmUuidSet.add(uuid);
        }
        List<OpenStackVM> vmList = this.getVmInfosFromOpenstack(regionUuid, projectUuid);
        Iterator<OpenStackVM> iterator = vmList.iterator();
        while (iterator.hasNext()) {
            if (vmUuidSet.contains(iterator.next().getUuid())) continue;
            iterator.remove();
        }
        return vmList;
    }

    public List<OpenStackVM> getVmInfos(String regionUuid, String projUuid, String azName) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)azName)) {
            logger.error((Object)"query param is empty");
            return new ArrayList<OpenStackVM>();
        }
        List<OpenStackVM> vmList = this.getVmInfosFromOpenstack(regionUuid, projUuid);
        Iterator<OpenStackVM> iterator = vmList.iterator();
        while (iterator.hasNext()) {
            if (azName.equals(iterator.next().getAzName())) continue;
            iterator.remove();
        }
        return vmList;
    }

    public List<OpenStackVM> getVmInfosFromOpenstack(String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager mgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        return mgr.getVms(regionUuid, tokenId, projUuid);
    }

    public OpenStackVM createVm(String regionUuid, String projUuid, String tokenId, CreateServerInfo createInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createInfo)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        INovaManager novaManger = ManagerFactory.getInstance().getNovaManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        AsyncTaskResponse response = novaManger.createVm(regionUuid, projUuid, tokenId, createInfo);
        if (!response.isSuccess()) {
            String[] errParam = null;
            if (null != response.getTaskResult() && response.getTaskResult() instanceof OpenStackVM) {
                OpenStackVM result = (OpenStackVM)response.getTaskResult();
                errParam = new String[]{result.getUuid()};
                logger.error((Object)("create volume failed:" + result.getUuid()));
            }
            throw new LegoCheckedException(1073948363L, errParam);
        }
        return (OpenStackVM)response.getTaskResult();
    }
}

