/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource.authentication;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.resource.authentication.CertificateCache;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

public class CertificateUpdateThread
extends CommonThread {
    private static final Log logger = LogFactory.getInstance(CertificateUpdateThread.class);
    private CertificateCache certificateCache = CertificateCache.getInstance();

    protected void execute() {
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String urlStr = "https://" + open.getIp() + ":" + open.getPort() + OpenstackEnumDefine.REQUEST_URL.IAM_SIGNCA.getUri();
        try {
            String tokenId = TokenUtil.getInstance().getTokenId(open, null);
            if (this.certificateCache.updateCertificate(urlStr, tokenId)) {
                AlarmReporter.restoreAlarm((long)52625471L, (String[])new String[]{open.getIp()});
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)("update certificate failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        AlarmReporter.sendAlarm((long)52625471L, (String)String.valueOf(open.getIp()), (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])new String[]{open.getIp()});
    }
}

