/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.ExecuteLogBO;
import com.huawei.ism.drm.openstack.sdk.bo.ExecuteLogsBO;
import com.huawei.ism.drm.openstack.sdk.bo.ExecuteProcessesBO;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.PageForExecuteLogs;
import com.huawei.ism.drm.openstack.sdk.bo.PageForInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.SynProgressInfo;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeInfoBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.checker.ConsistanceGroupCheck;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.LikeExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

public abstract class AbstractServiceInstanceQueryImpl
extends BaseService
implements IServiceInstanceService {
    private static final Log logger = LogFactory.getInstance(AbstractServiceInstanceQueryImpl.class);
    private static final String PROGRESS = "progress";
    private static final String SYNC_LEFT_TIME = "sync_left_time";
    private static final String TOTAL_KEY = "total";
    private static final String ACCURATE_KEY = "accurate";

    public PageForInstanceInfo queryServiceInstances(Map<String, Object> conditions) {
        String projectId = (String)conditions.get("projectId");
        String sortKey = (String)conditions.get("sortKey");
        String sortType = (String)conditions.get("sortType");
        Integer limit = (Integer)conditions.get("limit");
        Integer marker = (Integer)conditions.get("marker");
        StringBuilder logBuf = new StringBuilder("query ServiceInstances by projectId , the project id is ").append(projectId).append(", sort Key is ").append(sortKey).append(", sort type is ").append(sortType);
        logger.info((Object)logBuf.toString());
        this.verifyParams(projectId, sortKey, limit, marker, conditions);
        HashMap<String, String> protectGroupConditions = new HashMap<String, String>();
        List<ServiceInstance> instList = this.isQueryWithVM(conditions) ? this.queryInstanceWithVmInfo(conditions, protectGroupConditions) : this.queryInstanceWithInstanceInfo(conditions, protectGroupConditions);
        PageForInstanceInfo pageForInst = new PageForInstanceInfo();
        pageForInst.setTotalCount(instList.size());
        int finalLimit = limit;
        int finalMarker = marker;
        return OpenstackCache.run(() -> {
            protectGroupConditions.put("updateReplicaStatus", Boolean.TRUE.toString());
            pageForInst.setInstances(this.buildInstanceList(this.getSubList(finalMarker, finalLimit, instList), protectGroupConditions));
            return pageForInst;
        });
    }

    private void verifyParams(String projectId, String sortKey, Integer limit, Integer marker, Map<String, Object> conditions) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)"Failed to query serviceInstances.project Id is null");
            throw new LegoCheckedException(1073947393L, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((Object)limit)) {
            logger.error((Object)"Failed to query serviceInstances.limit Id is null");
            throw new LegoCheckedException(1073947393L, "limit is empty.");
        }
        limit = Math.max(limit, 1);
        limit = Math.min(limit, 512);
        conditions.put("limit", limit);
        if (VerifyUtil.isEmpty((Object)marker)) {
            logger.error((Object)"Failed to query serviceInstances.marker Id is null");
            throw new LegoCheckedException(1073947393L, "marker is empty.");
        }
        marker = Math.max(marker, 0);
        conditions.put("marker", marker);
        if (VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)"project Id is null");
            throw new LegoCheckedException(1073947393L, "project_id is empty.");
        }
        if (!CommonUtil.isValidDbColumn((String)sortKey)) {
            logger.error((Object)("Failed to query serviceInstances.sortKey is not db column.sortKey=" + sortKey));
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean isQueryWithVM(Map<String, Object> conditions) {
        Object name = conditions.get("name");
        Object status = conditions.get("status");
        Object vmName = conditions.get("vmName");
        return VerifyUtil.isEmpty((Object)name) && VerifyUtil.isEmpty((Object)status) && !VerifyUtil.isEmpty((Object)vmName);
    }

    private List<ServiceInstance> queryInstanceWithInstanceInfo(Map<String, Object> conditions, Map<String, String> protectGroupConditions) {
        List<ServiceInstance> instList;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(ServiceInstance.class);
            this.getConditions(criteria, conditions, protectGroupConditions);
            Object regionIdCondition = conditions.get("regionId");
            String regionId = null;
            if (regionIdCondition != null) {
                regionId = (String)regionIdCondition;
            }
            instList = this.filterServiceInstanceByRegionId(session, criteria.list(), regionId);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return instList;
    }

    private List<ServiceInstance> queryInstanceWithVmInfo(Map<String, Object> conditions, Map<String, String> protectGroupConditions) {
        Map<String, List<String>> pgIdMap;
        Object typeCondition = conditions.get("vmType");
        String vmType = null;
        if (!VerifyUtil.isEmpty((Object)typeCondition)) {
            vmType = (String)typeCondition;
        }
        Object nameCondition = conditions.get("vmName");
        String vmName = (String)nameCondition;
        if (VerifyUtil.isEmpty((String)vmType) || "product".equals(vmType)) {
            pgIdMap = this.queryPgIdsWithProduct(vmName);
        } else if ("placeholder".equals(vmType)) {
            Map<String, List<RecoverySetting>> recoverySettingMap = this.queryRecoverySetting(vmName);
            pgIdMap = this.queryPgIdsWithRecoverySetting(recoverySettingMap);
        } else {
            logger.error((Object)"Param vm_type must be placeholder or product.");
            throw new LegoCheckedException(1073947393L);
        }
        return this.queryInstanceWithPgIds(conditions, protectGroupConditions, pgIdMap);
    }

    private List<ServiceInstance> queryInstanceWithPgIds(Map<String, Object> conditions, Map<String, String> protectGroupConditions, Map<String, List<String>> pgIdMap) {
        List<ServiceInstance> accurateInstanceList;
        List<ServiceInstance> instanceList;
        Session session;
        block6: {
            List<String> pgIdList = pgIdMap.get(TOTAL_KEY);
            List<String> accurateIdList = pgIdMap.get(ACCURATE_KEY);
            if (VerifyUtil.isEmpty(pgIdList)) {
                return Collections.EMPTY_LIST;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(ServiceInstance.class);
                Disjunction dis = Restrictions.disjunction();
                pgIdList.forEach(id -> dis.add((Criterion)Restrictions.eq((String)"protectGroupId", (Object)id)));
                criteria.add((Criterion)dis);
                this.getConditions(criteria, conditions, protectGroupConditions);
                Object regionIdCondition = conditions.get("regionId");
                String regionId = regionIdCondition == null ? null : (String)regionIdCondition;
                instanceList = this.filterServiceInstanceByRegionId(session, criteria.list(), regionId);
                if (VerifyUtil.isEmpty(accurateIdList)) {
                    accurateInstanceList = new ArrayList<ServiceInstance>();
                    break block6;
                }
                Criteria accurateCriteria = session.createCriteria(ServiceInstance.class);
                Disjunction accurateDis = Restrictions.disjunction();
                accurateIdList.forEach(id -> accurateDis.add((Criterion)Restrictions.eq((String)"protectGroupId", (Object)id)));
                accurateCriteria.add((Criterion)accurateDis);
                this.getConditions(accurateCriteria, conditions, protectGroupConditions);
                accurateInstanceList = this.filterServiceInstanceByRegionId(session, accurateCriteria.list(), regionId);
            }
            catch (DataAccessException e) {
                try {
                    logger.error((Object)"failed to query RecoverySetting.", (Throwable)e, 90160758786896L);
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return this.adjustOrder(instanceList, accurateInstanceList);
    }

    private List<ServiceInstance> adjustOrder(List<ServiceInstance> instanceList, List<ServiceInstance> accurateInstanceList) {
        if (VerifyUtil.isEmpty(accurateInstanceList)) {
            return instanceList;
        }
        block0: for (ServiceInstance accurateInstance : accurateInstanceList) {
            String uuid = accurateInstance.getUuid();
            for (ServiceInstance instance : instanceList) {
                if (!instance.getUuid().equals(uuid)) continue;
                instanceList.remove(instance);
                continue block0;
            }
        }
        instanceList.addAll(0, accurateInstanceList);
        return instanceList;
    }

    private Map<String, List<String>> queryPgIdsWithProduct(String vmName) {
        Session session = null;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        String vmNameForLike = "%" + vmName.replace("%", "\\%").replace("_", "\\_") + "%";
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hql = "select pgid from ti_protectobject where lower(poname) like lower(?)";
            List pgIdList = session.createSQLQuery(hql).setParameter(0, (Object)vmNameForLike).list();
            String accurateHql = "select pgid from ti_protectobject where poname=?";
            List accurateIdList = session.createSQLQuery(accurateHql).setParameter(0, (Object)vmName).list();
            result.put(TOTAL_KEY, pgIdList);
            result.put(ACCURATE_KEY, accurateIdList);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return result;
    }

    private Map<String, List<String>> queryPgIdsWithRecoverySetting(Map<String, List<RecoverySetting>> settingMap) {
        List<RecoverySetting> recoverySettingList = settingMap.get(TOTAL_KEY);
        List<RecoverySetting> accurateSettingList = settingMap.get(ACCURATE_KEY);
        ArrayList productVmIdList = new ArrayList();
        recoverySettingList.forEach(recoverySetting -> productVmIdList.add(recoverySetting.getOwnerId()));
        ArrayList accurateVmIdList = new ArrayList();
        accurateSettingList.forEach(recoverySetting -> accurateVmIdList.add(recoverySetting.getOwnerId()));
        if (VerifyUtil.isEmpty(productVmIdList)) {
            return Collections.EMPTY_MAP;
        }
        Session session = null;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hql = "select pgid from ti_protectobject where uuid in (:list)";
            List pgIdList = session.createSQLQuery(hql).setParameterList("list", productVmIdList).list();
            String accurateHql = "select pgid from ti_protectobject where uuid in (:list)";
            List accurateIdList = session.createSQLQuery(accurateHql).setParameterList("list", accurateVmIdList).list();
            result.put(TOTAL_KEY, pgIdList);
            result.put(ACCURATE_KEY, accurateIdList);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return result;
    }

    private Map<String, List<RecoverySetting>> queryRecoverySetting(String vmName) {
        Session session = null;
        HashMap<String, List<RecoverySetting>> result = new HashMap<String, List<RecoverySetting>>();
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(RecoverySetting.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"name", (Object)"PLACEHOLDVMNAME"), (Criterion)Restrictions.eq((String)"name", (Object)"CSHAPLACEHOLDVMNAME")));
            EscapingLikeExpression like = new EscapingLikeExpression("value", this.escapeString(vmName));
            criteria.add((Criterion)like);
            List settingList = criteria.list();
            Criteria accurateCriteria = session.createCriteria(RecoverySetting.class);
            accurateCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"name", (Object)"PLACEHOLDVMNAME"), (Criterion)Restrictions.eq((String)"name", (Object)"CSHAPLACEHOLDVMNAME")));
            accurateCriteria.add((Criterion)Restrictions.eq((String)"value", (Object)vmName));
            List accurateSettingList = accurateCriteria.list();
            result.put(TOTAL_KEY, settingList);
            result.put(ACCURATE_KEY, accurateSettingList);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query RecoverySetting.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return result;
    }

    private List<ServiceInstance> filterServiceInstanceByRegionId(Session session, List<ServiceInstance> instances, String regionId) {
        if (regionId == null) {
            return instances;
        }
        Set collection = instances.stream().map(ServiceInstance::getProtectGroupId).collect(Collectors.toSet());
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        FusionSphereOpenStack openStack = OpenStackCommonUtil.getOpenstack();
        if (openStack == null) {
            return Collections.emptyList();
        }
        Query query = session.createQuery("select pgId from ProtectGroup where props['regionId']=:regionId and pgId in (:collection)");
        query.setParameter("regionId", (Object)OpenStackBasicUtil.getObjectUuid(openStack.getUuid(), regionId));
        query.setParameterList("collection", collection);
        List list = query.list();
        return instances.stream().filter(instance -> list.contains(instance.getProtectGroupId())).collect(Collectors.toList());
    }

    private void getConditions(Criteria criteria, Map<String, Object> conditions, Map<String, String> pgConditions) {
        Object queryCondition = conditions.get("instanceType");
        if (queryCondition != null) {
            ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType = (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E)queryCondition;
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)instanceType.getValue()));
        }
        if ((queryCondition = conditions.get("name")) != null) {
            EscapingLikeExpression likeExpression = new EscapingLikeExpression("name", this.escapeString(String.valueOf(queryCondition)));
            criteria.add((Criterion)likeExpression);
        }
        if ((queryCondition = conditions.get("sortType")) != null) {
            String sortType = (String)queryCondition;
            String sortKey = (String)conditions.get("sortKey");
            if ("asc".equals(sortType)) {
                criteria.addOrder(Order.asc((String)sortKey));
            } else {
                criteria.addOrder(Order.desc((String)sortKey));
            }
        }
        if ((queryCondition = conditions.get("status")) != null) {
            String[] statuses;
            Disjunction dis = Restrictions.disjunction();
            for (String status : statuses = queryCondition.toString().split(",")) {
                dis.add((Criterion)Restrictions.eq((String)"status", (Object)status.trim()));
            }
            criteria.add((Criterion)dis);
        }
        if ((queryCondition = conditions.get("projectId")) != null) {
            criteria.add((Criterion)Restrictions.eq((String)"projectId", (Object)queryCondition));
        }
        if ((queryCondition = conditions.get("id")) != null) {
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)queryCondition));
        }
        if ((queryCondition = conditions.get("protectType")) != null) {
            criteria.add((Criterion)Restrictions.eq((String)"protectType", (Object)queryCondition));
        }
        if ((queryCondition = conditions.get("availableZone")) != null) {
            pgConditions.put("availableZone", queryCondition.toString());
        }
        if ((queryCondition = conditions.get("salveAvailableZone")) != null) {
            pgConditions.put("salveAvailableZone", queryCondition.toString());
        }
    }

    protected <T> List<T> getSubList(int marker, int limit, List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        if (null == list || list.isEmpty()) {
            logger.error((Object)"list is empty.");
            return result;
        }
        if (marker > list.size() || limit <= 0) {
            logger.error((Object)"marker is more than list's size.");
            return result;
        }
        int count = 0;
        for (int i = marker; i < list.size(); ++i) {
            result.add(list.get(i));
            if (++count == limit) break;
        }
        return result;
    }

    public InstanceInfoBO queryServiceInstance(String projectId, String instanceId, Map<String, String> conditions) {
        logger.info((Object)("query ServiceInstance by instance id , the project id is " + projectId + " the instanceId is " + instanceId));
        this.validateParams(instanceId, projectId);
        ServiceInstance instance = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId);
        this.checkInstanceIsNull(instance, instanceId);
        this.checkInstanceProjectId(projectId, instance);
        ArrayList<ServiceInstance> insList = new ArrayList<ServiceInstance>();
        insList.add(instance);
        List<InstanceInfoBO> instanceList = this.buildInstanceList(insList, conditions);
        if (null == instanceList || instanceList.isEmpty()) {
            logger.error((Object)("Failed to query service instance.instanceId=" + instanceId + ", build data error."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        return instanceList.get(0);
    }

    protected void checkInstanceProjectId(String projectId, ServiceInstance instance) {
        if (!projectId.equals(instance.getProjectId())) {
            logger.error((Object)("Failed to check instance projectId.project_id or instance_id error.,projectId=" + projectId + ",instance projectId=" + instance.getProjectId()));
            throw new LegoCheckedException(1073947393L, "project_id or instance_id error.");
        }
    }

    private List<InstanceInfoBO> buildInstanceList(List<ServiceInstance> instanceDBList, Map<String, String> conditions) {
        ArrayList<InstanceInfoBO> returnInsList = new ArrayList<InstanceInfoBO>();
        if (null == instanceDBList || instanceDBList.isEmpty()) {
            logger.info((Object)"DB instances is null");
            return returnInsList;
        }
        for (ServiceInstance instanceDBInfo : instanceDBList) {
            InstanceInfoBO instanceInfo = new InstanceInfoBO();
            this.buildInstBoBasicInfo(instanceDBInfo, instanceInfo);
            this.buildProtectGroupInfo(instanceInfo, instanceDBInfo, conditions);
            if (!this.isSatisfiedCondition(instanceInfo, conditions)) continue;
            Date modifyDate = null == instanceDBInfo.getCreateTime() ? new Date() : new Date(instanceDBInfo.getCreateTime());
            instanceInfo.setCreateTime(OpenStackCommonUtil.formatDate(modifyDate));
            if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instanceInfo.getType())) {
                instanceInfo.setSupportTenant(this.isSupportTenantRecovery());
            }
            boolean isConfirmReprotection = LegoConfig.getInstance().getBoolean("is.confirm.reprotection", Boolean.valueOf(true));
            instanceInfo.setSupportConfirmReprotection(isConfirmReprotection);
            returnInsList.add(instanceInfo);
        }
        return returnInsList;
    }

    protected void buildInstBoBasicInfo(ServiceInstance instanceDBInfo, InstanceInfoBO instanceInfo) {
        instanceInfo.setId(instanceDBInfo.getUuid());
        instanceInfo.setName(instanceDBInfo.getName());
        instanceInfo.setProjectId(instanceDBInfo.getProjectId());
        instanceInfo.setType(instanceDBInfo.getType());
        instanceInfo.setStatus(instanceDBInfo.getStatus());
        instanceInfo.setDescription(instanceDBInfo.getDescription());
        instanceInfo.setRecoveryPlanId(instanceDBInfo.getRecoveryPlanId());
        instanceInfo.setProtectGroupId(instanceDBInfo.getProtectGroupId());
        instanceInfo.setProtectType(instanceDBInfo.getProtectType());
    }

    private void buildProtectGroupInfo(InstanceInfoBO instanceInfo, ServiceInstance instanceDBInfo, Map<String, String> conditions) {
        if (!VerifyUtil.isEmpty((String)instanceDBInfo.getProtectGroupId())) {
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instanceDBInfo.getProtectGroupId(), true);
            if (null == pg) {
                logger.error((Object)"protect group is null.");
                return;
            }
            if (null != conditions && Boolean.valueOf(conditions.get("updateReplicaStatus")).booleanValue()) {
                this.updateReplicaStatus(instanceInfo, pg, conditions);
            }
            this.configInstanceInfo(pg, instanceInfo);
            ArrayList<String> servers = new ArrayList<String>();
            for (ProtectObject ptObject : pg.getPolist()) {
                servers.add(OpenStackCommonUtil.getIdFromUuid(ptObject.getMoUuid()));
                if (VerifyUtil.isEmpty((String)instanceInfo.getVmType()) || VerifyUtil.isEmpty((String)ptObject.getProperty("vm_type"))) continue;
                instanceInfo.setVmType(ptObject.getProperty("vm_type"));
            }
            instanceInfo.setServers(servers);
        }
    }

    private void configInstanceInfo(ProtectGroup pg, InstanceInfoBO instanceInfo) {
        if (null != pg.getProps() && !pg.getProps().isEmpty()) {
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(instanceInfo.getType()) && null != drProjUuid) {
                instanceInfo.setRemoteProjectId(OpenStackCommonUtil.getIdFromUuid(drProjUuid));
            }
            instanceInfo.setRegion(OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("regionId")));
            instanceInfo.setAvailableZone((String)pg.getProps().get("zoneName"));
            instanceInfo.setRecoveryRegionType(pg.getProperty("RECOVERY_REGION_TYPE"));
            instanceInfo.setSalveAvailableZone((String)pg.getProps().get("drZoneName"));
            instanceInfo.setOriginalAvailableZone((String)pg.getProps().get("originalAvailableZone"));
            this.queryReplicationInfo(instanceInfo, pg);
            int startPriority = 3;
            String dbStartPriority = (String)pg.getProps().get("StartPriority");
            if (!VerifyUtil.isEmpty((String)dbStartPriority)) {
                try {
                    startPriority = Integer.parseInt(dbStartPriority);
                }
                catch (NumberFormatException e) {
                    logger.error((Object)"start priority number format exception.");
                    return;
                }
            }
            instanceInfo.setStartPriority(Integer.valueOf(startPriority));
        }
    }

    private boolean isSatisfiedCondition(InstanceInfoBO instanceInfoBO, Map<String, String> conditions) {
        if (conditions != null && conditions.containsKey("availableZone") && !VerifyUtil.isEmpty((String)instanceInfoBO.getAvailableZone()) && !instanceInfoBO.getAvailableZone().equals(conditions.get("availableZone"))) {
            return false;
        }
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instanceInfoBO.getType()) || conditions == null || !conditions.containsKey("salveAvailableZone") || VerifyUtil.isEmpty((String)instanceInfoBO.getSalveAvailableZone()) || instanceInfoBO.getSalveAvailableZone().equals(conditions.get("salveAvailableZone"));
    }

    private void updateReplicaStatus(InstanceInfoBO instanceInfo, ProtectGroup pg, Map<String, String> conditions) {
        String primaryReplicaStatus = this.queryReplicaCgInfoStatus(pg, true, conditions);
        if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue().equals(primaryReplicaStatus)) {
            instanceInfo.setReplicaStatus(primaryReplicaStatus);
            return;
        }
        instanceInfo.setReplicaStatus(this.queryReplicaCgInfoStatus(pg, false, conditions));
    }

    private String queryReplicaCgInfoStatus(ProtectGroup pg, boolean isPrimaryStatus, Map<String, String> conditions) {
        String regionKey;
        String string = regionKey = isPrimaryStatus ? pg.getProperty("regionId") : pg.getProperty("drRegionId");
        if (VerifyUtil.isEmpty((String)conditions.get(regionKey)) || Boolean.valueOf(conditions.get(regionKey)).booleanValue()) {
            try {
                VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.getVolumeReplicationCgInfo(pg, isPrimaryStatus, 1);
                if (pg.getTemplate().getType() == 34 || pg.getTemplate().getType() == 37) {
                    VolumeReplicationCgInfo createStandbyCgInfo = OpenStackCommonUtil.getVolumeReplicaCgInfoForStandby(pg, isPrimaryStatus);
                    VolumeReplicationCgInfo createHyperMetroCgInfo = new VolumeReplicationCgInfo();
                    createHyperMetroCgInfo.setReplicationStatus(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue());
                    if (!(isPrimaryStatus ^ !OpenStackCommonUtil.isCsdrVhaMode(pg))) {
                        createHyperMetroCgInfo = OpenStackCommonUtil.getVolumeReplicaCgInfoForHyperMetro(pg, isPrimaryStatus);
                    }
                    return OpenStackCommonUtil.getReplicationStatusForRing(pg, cgInfo, createStandbyCgInfo, createHyperMetroCgInfo);
                }
                if (null == cgInfo) {
                    return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue();
                }
                return cgInfo.getReplicationStatus();
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"QueryReplicaCgInfoStatus error.", (Throwable)e);
                if (e.getErrorCode() == 1073947401L || e.getErrorCode() == 1073947398L) {
                    conditions.put(regionKey, Boolean.FALSE.toString());
                }
            }
            catch (Exception ex) {
                logger.error((Object)"QueryReplicaCgInfoStatus error.", (Throwable)ex);
            }
        }
        return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue();
    }

    private void queryReplicationInfo(InstanceInfoBO instanceInfo, ProtectGroup pg) {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType")) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType")) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType"))) {
            List<Integer> list;
            instanceInfo.setSlaveRegionName((String)pg.getProps().get("drRegionId"));
            if (null != pg.getLastExecTime()) {
                Date lastExcutionTime = new Date(pg.getLastExecTime());
                instanceInfo.setLastExcutionTime(OpenStackCommonUtil.formatDate(lastExcutionTime));
            }
            if (this.configInstancePolicy(instanceInfo, pg, list = Arrays.asList(21))) {
                return;
            }
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType"))) {
            instanceInfo.setCshaRemoteAvailableZone((String)pg.getProps().get("prod_region_drZoneName"));
            instanceInfo.setOriginaRegion((String)pg.getProps().get("originalAvailableRegion"));
        }
    }

    private boolean configInstancePolicy(InstanceInfoBO instanceInfo, ProtectGroup pg, List<Integer> list) {
        if (list.contains(pg.getTemplate().getType())) {
            instanceInfo.setReplicationType(ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.SYNCHRONIZE.getValue());
        } else {
            instanceInfo.setReplicationType(ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.ASYNCHRONIZE.getValue());
            PolicyBO policyBO = new PolicyBO();
            String uuid = pg.getTemplate().getUuid();
            PolicyTemplate policyTemplate = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getPtByUuid(uuid);
            Set pgTemplateSchedules = policyTemplate.getSchedules();
            Schedule autoSchedule = null;
            for (Schedule pgSchedule : pgTemplateSchedules) {
                if (pgSchedule.getScheduleMode() != 0) continue;
                autoSchedule = pgSchedule;
            }
            if (null == autoSchedule) {
                return true;
            }
            if (0 == autoSchedule.getPeriodType()) {
                policyBO.setPeriodType("minute");
            } else if (1 == autoSchedule.getPeriodType()) {
                policyBO.setPeriodType("hour");
            } else if (2 == autoSchedule.getPeriodType()) {
                policyBO.setPeriodType("day");
                policyBO.setTimePoint(autoSchedule.getHours() + ":" + autoSchedule.getMinutes());
            }
            policyBO.setPeriodInterval(String.valueOf(autoSchedule.getPeriodInterval()));
            instanceInfo.setPolicy(policyBO);
        }
        return false;
    }

    protected void validateParams(String instanceId, String projectId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)"project Id is null");
            throw new LegoCheckedException(1073947393L, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            logger.error((Object)"instanceId Id is null");
            throw new LegoCheckedException(1073947393L, "instance_id is empty.");
        }
    }

    public List<VolumeInfoBO> queryVolumes(String projectId, String instanceId, String serverId) {
        logger.info((Object)("query Volumes by Server Id , the project id is " + projectId + " the instanceId is " + instanceId + " the server id is " + serverId));
        this.validateParams(instanceId, projectId);
        if (VerifyUtil.isEmpty((String)serverId)) {
            logger.error((Object)"Failed to query volumes.server Id is null");
            throw new LegoCheckedException(1073947393L, "server_id is empty.");
        }
        ServiceInstance instance = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId);
        this.checkInstanceIsNull(instance, instanceId);
        this.checkInstanceProjectId(projectId, instance);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        if (null == pg) {
            logger.error((Object)("Failed to query volumes.pg is empty.instanceId=" + instanceId));
            throw new LegoCheckedException(1073947393L, "config err.");
        }
        ConsistanceGroupCheck checker = new ConsistanceGroupCheck();
        CheckContext context = new CheckContext(instance, pg);
        checker.checkCgStatus(context);
        FusionSphereOpenStack openstack = this.getOpenstack();
        String moUuid = OpenStackCommonUtil.getObjectUuid(openstack.getUuid(), serverId);
        IProtectGroupService pgServie = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectObject po = pgServie.getProtectObjectByMoUUID(pg.getUuid(), moUuid);
        if (VerifyUtil.isEmpty((Object)po)) {
            logger.error((Object)("Failed to query volumes.DB protectOject is null,instanceName=" + instance.getName()));
            throw new LegoCheckedException(201L, "server(" + serverId + ") is not found.");
        }
        return this.buildVolumeInfoList(instance, pg, po);
    }

    private List<VolumeInfoBO> buildVolumeInfoList(ServiceInstance instance, ProtectGroup pg, ProtectObject po) {
        ArrayList<VolumeInfoBO> vts = new ArrayList<VolumeInfoBO>();
        if (null != pg.getProps() && !pg.getProps().isEmpty()) {
            Map<String, String> drVolNameMap;
            Map<String, String> volNameMap = this.getVolNameMap((String)pg.getProps().get("regionId"), (String)pg.getProps().get("projectId"));
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instance.getType()) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instance.getType())) {
                drVolNameMap = volNameMap;
            } else {
                String drRegionUuid = (String)pg.getProps().get("drRegionId");
                drVolNameMap = this.getVolNameMap(drRegionUuid, (String)pg.getProps().get("drProjectId"));
            }
            if (null != poReplicaInfo && !poReplicaInfo.getPairInfos().isEmpty()) {
                this.configVolumeInfo(pg, po, vts, volNameMap, poReplicaInfo, drVolNameMap);
            }
        }
        vts.sort(Comparator.comparing(VolumeInfoBO::getName));
        return vts;
    }

    private void configVolumeInfo(ProtectGroup pg, ProtectObject po, List<VolumeInfoBO> vts, Map<String, String> volNameMap, PoReplicaInfo poReplicaInfo, Map<String, String> drVolNameMap) {
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            VolumeInfoBO volumeTemp = new VolumeInfoBO();
            volumeTemp.setId(OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid()));
            volumeTemp.setName(volNameMap.get(volumeTemp.getId()));
            volumeTemp.setStatus(pairInfo.getVolumeStatus());
            volumeTemp.setVolType(pairInfo.getVolumeType());
            volumeTemp.setCapacity(pairInfo.getSize());
            volumeTemp.setReplicationExtendInfo((Object)OpenStackBasicUtil.buildVolumeExtendInfo(pairInfo, pg, drVolNameMap));
            if (34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) {
                if (OpenStackBasicUtil.isCsdrVhaMode(pg)) {
                    OpenStackBasicUtil.buildVolumeExtendHyperMetroInfo(pairInfo, pg, drVolNameMap, po, volumeTemp);
                } else {
                    OpenStackBasicUtil.buildVolumeExtendHyperMetroInfo(pairInfo, pg, volNameMap, po, volumeTemp);
                }
            }
            vts.add(volumeTemp);
        }
    }

    private void checkInstanceIsNull(ServiceInstance instance, String instanceId) {
        if (null == instance) {
            logger.error((Object)"Failed to query serviceInstance.instance is null.instanceId=%s", new Object[]{instanceId});
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
    }

    protected FusionSphereOpenStack getOpenstack() {
        List openstackList = CommonDAOLocator.getMoDao().getAllMo(FusionSphereOpenStack.class);
        if (VerifyUtil.isEmpty((Collection)openstackList)) {
            logger.error((Object)"openstack instance is not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        FusionSphereOpenStack openstack = (FusionSphereOpenStack)CommonUtil.getFirstElement((Collection)openstackList);
        return openstack;
    }

    public static ServiceInstance queryServiceInstance(String instanceId) {
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        return instance;
    }

    public PageForExecuteLogs queryRecoveryLogs(String projectId, String instanceId, int marker, int limit) {
        ServiceInstance instanceInDB;
        logger.info((Object)("query ServiceInstances by projectId , the project id is " + projectId + ", marker : " + marker + ", limit : " + limit));
        this.validateParams(instanceId, projectId);
        if (512 < limit || limit <= 0) {
            limit = 512;
        }
        if (null == (instanceInDB = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId))) {
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        if (VerifyUtil.isEmpty((String)instanceInDB.getRecoveryPlanId())) {
            return null;
        }
        this.checkInstanceProjectId(projectId, instanceInDB);
        List<RecoveryLog> recoveryLogs = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getHistoryReocveryLogsByPlanId(instanceInDB.getRecoveryPlanId());
        if (null == recoveryLogs || recoveryLogs.isEmpty()) {
            return new PageForExecuteLogs();
        }
        PageForExecuteLogs pageForRecoveryLogs = new PageForExecuteLogs();
        pageForRecoveryLogs.setTotalCount(recoveryLogs.size());
        recoveryLogs = this.getSubList(marker, limit, recoveryLogs);
        pageForRecoveryLogs.setLogs(this.buildRecoveryLogs(recoveryLogs));
        return pageForRecoveryLogs;
    }

    private List<ExecuteLogsBO> buildRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        ArrayList<ExecuteLogsBO> recoveryLogsList = new ArrayList<ExecuteLogsBO>();
        for (RecoveryLog recoveryLog : recoveryLogs) {
            ExecuteLogsBO logBO = new ExecuteLogsBO();
            logBO.setId(recoveryLog.getLogId());
            logBO.setEndTime(OpenStackCommonUtil.formatDate(this.strFormatDate(recoveryLog.getEndTime())));
            logBO.setStartTime(OpenStackCommonUtil.formatDate(this.strFormatDate(recoveryLog.getStartTime())));
            logBO.setStatus(this.statusToStr(recoveryLog.getLogStatus()));
            logBO.setType(this.typeToStr(recoveryLog.getLogType()));
            recoveryLogsList.add(logBO);
        }
        return recoveryLogsList;
    }

    private List<ExecuteProcessesBO> buildProcessDetails(List<RecoveryProcessorDetail> recoveryProcessDetails, ExecuteLogBO logBO) {
        if (null == recoveryProcessDetails || recoveryProcessDetails.isEmpty()) {
            return null;
        }
        ArrayList<ExecuteProcessesBO> processesBoList = new ArrayList<ExecuteProcessesBO>();
        for (RecoveryProcessorDetail detail : recoveryProcessDetails) {
            ExecuteProcessesBO recoveryProcessesBO = new ExecuteProcessesBO();
            recoveryProcessesBO.setProcId(detail.getProcId());
            recoveryProcessesBO.setName(detail.getProcessName());
            recoveryProcessesBO.setNameParam(this.strToArray(detail.getProcessNameParams()));
            recoveryProcessesBO.setNote(this.parseProcDetails(detail.getProcessDetail()));
            recoveryProcessesBO.setNoteParam(this.strToArray(detail.getProcessDetailParams()));
            recoveryProcessesBO.setStartTime(OpenStackCommonUtil.formatDate(this.strFormatDate(detail.getStartTime())));
            recoveryProcessesBO.setEndTime(OpenStackCommonUtil.formatDate(this.strFormatDate(detail.getEndTime())));
            recoveryProcessesBO.setStatus(this.statusToStr(detail.getProcessStatus()));
            if (!VerifyUtil.isEmpty((Collection)detail.getChildDetails())) {
                recoveryProcessesBO.setChildProc(this.buildProcessDetails(detail.getChildDetails(), null));
            }
            processesBoList.add(recoveryProcessesBO);
        }
        if (null != logBO) {
            logBO.setProcesses(processesBoList);
            return null;
        }
        return processesBoList;
    }

    private Object[] strToArray(String str) {
        Object[] obj = new Object[]{};
        if (!VerifyUtil.isEmpty((String)str)) {
            obj = JSONArray.fromObject((Object)str).toArray();
        }
        return obj;
    }

    public ExecuteLogBO queryRecoveryLog(String projectId, String instanceId, String logId) {
        logger.info((Object)("query ServiceInstances by projectId , the project id is " + projectId + ", instanceId : " + instanceId + ", logId : " + logId));
        this.validateParams(instanceId, projectId);
        if (VerifyUtil.isEmpty((String)logId)) {
            logger.error((Object)"Failed to query recoveryLog.log_id is empty.");
            throw new LegoCheckedException(1073947393L, "log_id is empty.");
        }
        ServiceInstance serviceInstance = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId);
        if (null == serviceInstance) {
            logger.error((Object)("Failed to query recoveryLog.serviceInstance is null instanceID=" + instanceId));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        this.checkInstanceProjectId(projectId, serviceInstance);
        ExecuteLogBO recoveryLogBO = new ExecuteLogBO();
        IRecoveryPlanService service = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        if ("0".equals(logId)) {
            return this.queryLatestRecoveryLog(service, serviceInstance.getRecoveryPlanId(), recoveryLogBO);
        }
        RecoveryLog recoveryLog = service.getRecoveryLog(logId);
        if (null == recoveryLog) {
            throw new LegoCheckedException(201L, "log(" + logId + ") is not found.");
        }
        recoveryLogBO.setId(recoveryLog.getLogId());
        recoveryLogBO.setEndTime(OpenStackCommonUtil.formatDate(this.strFormatDate(recoveryLog.getEndTime())));
        recoveryLogBO.setStartTime(OpenStackCommonUtil.formatDate(this.strFormatDate(recoveryLog.getStartTime())));
        recoveryLogBO.setStatus(this.statusToStr(recoveryLog.getLogStatus()));
        recoveryLogBO.setType(this.typeToStr(recoveryLog.getLogType()));
        List recoveryProcessorDetails = service.getRecoveryProcessorDetailsByLogId(serviceInstance.getRecoveryPlanId(), recoveryLog.getLogId());
        this.buildProcessDetails(recoveryProcessorDetails, recoveryLogBO);
        return recoveryLogBO;
    }

    private ExecuteLogBO queryLatestRecoveryLog(IRecoveryPlanService service, String recoveryPlanId, ExecuteLogBO recoveryLogBO) {
        RecoveryLog recoveryLog = service.getLatestRecoveryLog(recoveryPlanId);
        if (null == recoveryLog) {
            return null;
        }
        recoveryLogBO.setId(recoveryLog.getLogId());
        recoveryLogBO.setEndTime(OpenStackCommonUtil.formatDate(this.strFormatDate(recoveryLog.getEndTime())));
        recoveryLogBO.setStartTime(OpenStackCommonUtil.formatDate(this.strFormatDate(recoveryLog.getStartTime())));
        recoveryLogBO.setStatus(this.statusToStr(recoveryLog.getLogStatus()));
        recoveryLogBO.setType(this.typeToStr(recoveryLog.getLogType()));
        List processorDetails = service.getRecoveryProcessorDetailsByPlanId(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)recoveryLog.getLogType()));
        this.buildProcessDetails(processorDetails, recoveryLogBO);
        return recoveryLogBO;
    }

    protected Date strFormatDate(String time) {
        if (VerifyUtil.isEmpty((String)time)) {
            return null;
        }
        Date date = null;
        try {
            date = new Date(Long.parseLong(time));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"time parseLong error.");
        }
        return date;
    }

    private String typeToStr(int type) {
        switch (type) {
            case 0: {
                return "failover";
            }
            case 1: {
                return "switchover";
            }
            case 7: {
                return "reprotect";
            }
            case 2: {
                return "test";
            }
            case 3: {
                return "clear";
            }
            case 11: {
                return "hotmigration";
            }
        }
        return "--";
    }

    private String statusToStr(int status) {
        switch (status) {
            case 0: {
                return "success";
            }
            case 1: {
                return "failed";
            }
            case 2: {
                return "part_success";
            }
            case 3: {
                return "running";
            }
            case 4: {
                return "paused";
            }
        }
        return "--";
    }

    private String escapeString(String inputString) {
        inputString = inputString.replace("_", "!_");
        inputString = inputString.replace("%", "!%");
        inputString = "%" + inputString + "%";
        return inputString;
    }

    private Map<String, String> getVolNameMap(String regionUuid, String projectUuid) {
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List vols = volumeService.getVolumesFromOpenstack(regionUuid, projectUuid);
        HashMap<String, String> volNameMap = new HashMap<String, String>();
        for (OpenStackVolume vol : vols) {
            volNameMap.put(OpenStackCommonUtil.getIdFromUuid(vol.getUuid()), vol.getName());
        }
        return volNameMap;
    }

    protected String parseProcDetails(String details) {
        if (VerifyUtil.isEmpty((String)details)) {
            return details;
        }
        if (details.startsWith("lego.err.")) {
            details = details.replace("lego.err.", "");
        }
        return details;
    }

    public SynProgressInfo queryInstanceSynProgress(String projectId, String instanceId) {
        logger.debug((Object)("query ServiceInstances by projectId , the project id is " + projectId + ", instanceId : " + instanceId));
        this.validateParams(instanceId, projectId);
        ServiceInstance instance = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId);
        if (null == instance) {
            logger.error((Object)"Failed to query instance synProgress.instance is null.");
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        logger.debug((Object)("query instance synProgress.instance name: " + instance.getName()));
        this.checkInstanceProjectId(projectId, instance);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        if (null == pg) {
            logger.error((Object)("Failed to query instance synProgress. protect group is null, the projectId: " + projectId));
            throw new LegoCheckedException(1073947393L);
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        return this.buildProcessInfo(pg, regionUuid, projUuid);
    }

    private SynProgressInfo buildProcessInfo(ProtectGroup pg, String regionUuid, String projUuid) {
        if (34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType()) {
            String replicaCgUuid = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("replicaCgUuid"));
            IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("replicationcg_id", OpenStackCommonUtil.getIdFromUuid(replicaCgUuid));
            List<VolumeReplicationInfo> replicationInfos = drExtendMgr.getVolumeReplications(regionUuid, tokenId, projUuid, uriVariables, false);
            if (VerifyUtil.isEmpty(replicationInfos)) {
                logger.error((Object)("Failed to query instance synProgress.replicationInfos is null , replicationCg uuid: " + replicaCgUuid + ",instanceName=" + pg.getName()));
                throw new LegoCheckedException(1073947393L);
            }
            int progress = 100;
            long leftTime = -1L;
            for (VolumeReplicationInfo volume : replicationInfos) {
                SynProgressInfo syn = this.getSynInfo(volume);
                int synProgress = Integer.parseInt(syn.getProgress());
                if (progress > synProgress) {
                    progress = synProgress;
                }
                if (leftTime >= syn.getRemainingTime()) continue;
                leftTime = syn.getRemainingTime();
            }
            SynProgressInfo result = new SynProgressInfo();
            result.setProgress(String.valueOf(progress));
            result.setRemainingTime(leftTime);
            return result;
        }
        return this.getVhaCsdrSynProgressInfo(pg, regionUuid, projUuid);
    }

    private SynProgressInfo getVhaCsdrSynProgressInfo(ProtectGroup pg, String regionUuid, String projUuid) {
        boolean isMove = OpenStackCommonUtil.isCsdrVhaMode(pg);
        if (!isMove) {
            return this.commonSynProgressInfo(pg, regionUuid, projUuid);
        }
        return this.afterReProtect(pg, regionUuid, projUuid);
    }

    private SynProgressInfo commonSynProgressInfo(ProtectGroup pg, String regionUuid, String projUuid) {
        logger.debug((Object)("start query vha+csdr sync progress info, protectGroupName=" + pg.getName()));
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("hyperProCgUuid", OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProCgUuid")));
        paramsMap.put("replicaCgUuid", OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("replicaCgUuid")));
        paramsMap.put("hyperProRemoteCgUuid", OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProRemoteCgUuid")));
        paramsMap.put("tokenId", TokenUtil.getInstance().getTokenId(projUuid));
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        VolumeReplicationCgInfo hyperProCgInfo = drExtendMgr.queryVolumeReplicationCG(regionUuid, (String)paramsMap.get("tokenId"), projUuid, (String)paramsMap.get("hyperProCgUuid"));
        VolumeReplicationCgInfo replicaCgInfo = drExtendMgr.queryVolumeReplicationCG(regionUuid, (String)paramsMap.get("tokenId"), projUuid, (String)paramsMap.get("replicaCgUuid"));
        VolumeReplicationCgInfo hyperProRemoteCgInfo = drExtendMgr.queryVolumeReplicationCG(regionUuid, (String)paramsMap.get("tokenId"), projUuid, (String)paramsMap.get("hyperProRemoteCgUuid"));
        this.checkCgAvailable(hyperProCgInfo, replicaCgInfo, hyperProRemoteCgInfo);
        paramsMap.put("hyperProReplicaStatus", hyperProCgInfo.getReplicationStatus());
        paramsMap.put("replicaReplicaStatus", replicaCgInfo.getReplicationStatus());
        paramsMap.put("hyperProRemoteReplicaStatus", hyperProRemoteCgInfo.getReplicationStatus());
        return this.buildProcessInfoResult(pg, regionUuid, projUuid, drExtendMgr, paramsMap);
    }

    private SynProgressInfo buildProcessInfoResult(ProtectGroup pg, String regionUuid, String projUuid, IDrExtendManager drExtendMgr, Map<String, String> paramsMap) {
        String hyperProCgUuid = paramsMap.get("hyperProCgUuid");
        String replicaCgUuid = paramsMap.get("replicaCgUuid");
        String hyperProRemoteCgUuid = paramsMap.get("hyperProRemoteCgUuid");
        String tokenId = paramsMap.get("tokenId");
        String hyperProReplicaStatus = paramsMap.get("hyperProReplicaStatus");
        String replicaReplicaStatus = paramsMap.get("replicaReplicaStatus");
        String hyperProRemoteReplicaStatus = paramsMap.get("hyperProRemoteReplicaStatus");
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(hyperProReplicaStatus)) {
            SynProgressInfo hyperProResult = this.getProcessLeftTime(hyperProCgUuid, drExtendMgr, regionUuid, tokenId, projUuid);
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(replicaReplicaStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(hyperProRemoteReplicaStatus)) {
                SynProgressInfo replicaResult = this.getProcessLeftTime(replicaCgUuid, drExtendMgr, regionUuid, tokenId, projUuid);
                return this.compareSynProgressInfoResult(hyperProResult, replicaResult);
            }
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaReplicaStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(hyperProRemoteReplicaStatus)) {
                SynProgressInfo hyperProRemoteResult = this.getProcessLeftTime(hyperProRemoteCgUuid, drExtendMgr, regionUuid, tokenId, projUuid);
                return this.compareSynProgressInfoResult(hyperProResult, hyperProRemoteResult);
            }
            return hyperProResult;
        }
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(replicaReplicaStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(hyperProRemoteReplicaStatus)) {
            return this.getProcessLeftTime(replicaCgUuid, drExtendMgr, regionUuid, tokenId, projUuid);
        }
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaReplicaStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(hyperProRemoteReplicaStatus)) {
            return this.getProcessLeftTime(hyperProRemoteCgUuid, drExtendMgr, regionUuid, tokenId, projUuid);
        }
        logger.error((Object)("the Replication status error\uff1a " + replicaCgUuid + ", " + hyperProRemoteCgUuid + ", protectGroupName=" + pg.getName()));
        throw new LegoCheckedException(-1L);
    }

    private SynProgressInfo afterReProtect(ProtectGroup pg, String regionUuid, String projUuid) {
        logger.debug((Object)("start query after reprotected vha+csdr sync progress info, protectGroupName=" + pg.getName()));
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        String replicaDrCgUuid = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("replicaCgUuid"));
        String hyperProRemoteDrCgUuid = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProRemoteCgUuid"));
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        if (VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)replicaDrCgUuid) || VerifyUtil.isEmpty((String)hyperProRemoteDrCgUuid)) {
            logger.error((Object)("after reprotected, the value is null, protectGroupName=" + pg.getName()));
        }
        VolumeReplicationCgInfo replicaDrCgInfo = drExtendMgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaDrCgUuid);
        VolumeReplicationCgInfo hyperProRemoteDrCgInfo = drExtendMgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, hyperProRemoteDrCgUuid);
        this.checkMoveCgAvailable(replicaDrCgInfo, hyperProRemoteDrCgInfo);
        String replicaReplicaDrStatus = replicaDrCgInfo.getReplicationStatus();
        String hyperProRemoteReplicaDrStatus = hyperProRemoteDrCgInfo.getReplicationStatus();
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(replicaReplicaDrStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(hyperProRemoteReplicaDrStatus)) {
            SynProgressInfo result = this.getProcessLeftTime(replicaDrCgUuid, drExtendMgr, regionUuid, tokenId, projUuid);
            logger.debug((Object)("progress: " + result.getProgress() + ", left time: " + result.getRemainingTime() + ", protectGroupName=" + pg.getName()));
            return result;
        }
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaReplicaDrStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(hyperProRemoteReplicaDrStatus)) {
            SynProgressInfo result = this.getProcessLeftTime(hyperProRemoteDrCgUuid, drExtendMgr, regionUuid, tokenId, projUuid);
            logger.debug((Object)("progress: " + result.getProgress() + ", left time: " + result.getRemainingTime() + ", protectGroupName=" + pg.getName()));
            return result;
        }
        logger.error((Object)("the Replication status error\uff1a " + replicaDrCgUuid + ", " + hyperProRemoteDrCgUuid + ", protectGroupName=" + pg.getName()));
        throw new LegoCheckedException(-1L);
    }

    private void checkMoveCgAvailable(VolumeReplicationCgInfo replicaDrCgInfo, VolumeReplicationCgInfo hyperProRemoteDrCgInfo) {
        if (null == replicaDrCgInfo || null == hyperProRemoteDrCgInfo) {
            logger.error((Object)"the VolumeReplicationCgInfo after reprotected  is null. ");
            throw new LegoCheckedException(1073947393L);
        }
        if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(replicaDrCgInfo.getStatus()) && OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(hyperProRemoteDrCgInfo.getStatus())) {
            logger.error((Object)("the replicaDrCgInfo status is error, id\uff1a " + replicaDrCgInfo.getId() + ", status: " + replicaDrCgInfo.getStatus() + ", the hyperProRemoteDrCgInfo status error, id: " + hyperProRemoteDrCgInfo.getId() + ", status: " + hyperProRemoteDrCgInfo.getStatus() + "the hyperProRemoteCgInfo status is error, id:  " + hyperProRemoteDrCgInfo.getId()));
            throw new LegoCheckedException(-1L);
        }
    }

    private void checkCgAvailable(VolumeReplicationCgInfo hyperProCgInfo, VolumeReplicationCgInfo replicaCgInfo, VolumeReplicationCgInfo hyperProRemoteCgInfo) {
        if (null == hyperProCgInfo || null == replicaCgInfo || null == hyperProRemoteCgInfo) {
            logger.error((Object)"the VolumeReplicationCgInfo is null. ");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(hyperProCgInfo.getStatus()) && OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(replicaCgInfo.getStatus()) && OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(hyperProRemoteCgInfo.getStatus()))) {
            logger.error((Object)("the hyperProCgInfo status is error, id\uff1a " + hyperProCgInfo.getId() + ", status: " + hyperProCgInfo.getStatus() + ", the replicaCgInfo status error, id: " + replicaCgInfo.getId() + ", status: " + replicaCgInfo.getStatus() + "the hyperProRemoteCgInfo status is error, id:  " + hyperProRemoteCgInfo.getId() + ", status: " + hyperProRemoteCgInfo.getStatus()));
            throw new LegoCheckedException(-1L);
        }
    }

    private SynProgressInfo compareSynProgressInfoResult(SynProgressInfo firstInfo, SynProgressInfo secondInfo) {
        long tempRemainingTime;
        SynProgressInfo result = new SynProgressInfo();
        int minProgress = NumberUtil.parseInteger((Object)firstInfo.getProgress());
        long maxLeftTime = firstInfo.getRemainingTime();
        int tempProgress = NumberUtil.parseInteger((Object)secondInfo.getProgress());
        if (minProgress > tempProgress) {
            minProgress = tempProgress;
        }
        if (maxLeftTime < (tempRemainingTime = secondInfo.getRemainingTime())) {
            maxLeftTime = tempRemainingTime;
        }
        result.setProgress(String.valueOf(minProgress));
        result.setRemainingTime(maxLeftTime);
        return result;
    }

    private SynProgressInfo getProcessLeftTime(String cgUuid, IDrExtendManager drExtendMgr, String regionUuid, String tokenId, String projUuid) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("replicationcg_id", OpenStackCommonUtil.getIdFromUuid(cgUuid));
        List<VolumeReplicationInfo> volumeInfos = drExtendMgr.getRealtimeVolumeReplications(regionUuid, tokenId, projUuid, uriVariables);
        if (VerifyUtil.isEmpty(volumeInfos)) {
            logger.error((Object)"replicationInfos is null. ");
            throw new LegoCheckedException(1073947393L);
        }
        int repProgress = 100;
        long repLeftTime = -1L;
        for (VolumeReplicationInfo volume : volumeInfos) {
            SynProgressInfo syn = this.getSynInfo(volume);
            int synProgress = NumberUtil.parseInteger((Object)syn.getProgress());
            if (repProgress > synProgress) {
                repProgress = synProgress;
            }
            if (repLeftTime >= syn.getRemainingTime()) continue;
            repLeftTime = syn.getRemainingTime();
        }
        SynProgressInfo result = new SynProgressInfo();
        result.setProgress(String.valueOf(repProgress));
        result.setRemainingTime(repLeftTime);
        return result;
    }

    private SynProgressInfo getSynInfo(VolumeReplicationInfo volume) {
        SynProgressInfo syn = new SynProgressInfo();
        String jsonStr = volume.getReplicationExtendedStatus();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        if (!json.containsKey((Object)PROGRESS) || !json.containsKey((Object)SYNC_LEFT_TIME)) {
            logger.error((Object)("VolumeReplicationInfo is error, it's extendedStatus: " + jsonStr));
            throw new LegoCheckedException(1073947393L);
        }
        try {
            int progress = Integer.parseInt(json.getString(PROGRESS));
            if (progress < 0) {
                throw new LegoCheckedException(201L, "replication progress is not found.");
            }
            long leftTime = Long.parseLong(json.getString(SYNC_LEFT_TIME));
            syn.setProgress(json.getString(PROGRESS));
            syn.setRemainingTime(leftTime);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("VolumeReplicationInfo is error, it's extendedStatus: " + jsonStr + " error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return syn;
    }

    private boolean isSupportTenantRecovery() {
        String isSupport = LegoConfig.getInstance().getKeyValue("hcs_is_support_tenant_restore", "");
        return Boolean.valueOf(isSupport);
    }

    static class EscapingLikeExpression
    extends LikeExpression {
        public EscapingLikeExpression(String propertyName, String value) {
            super(propertyName, value, Character.valueOf('!'), true);
        }
    }
}

