/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.google.common.base.Joiner;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.ServiceInstanceBackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.VerifyServerResultBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceServerQueryImpl;
import com.huawei.ism.drm.openstack.serviceinstance.AutoDisasterRecovery;
import com.huawei.ism.drm.openstack.serviceinstance.AutoReProtect;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VmChecker;
import com.huawei.ism.drm.openstack.serviceinstance.task.MonitorRecoveryTask;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public abstract class AbstractServiceInstanceRecoveryImpl
extends AbstractServiceInstanceServerQueryImpl {
    private static final Log logger = LogFactory.getInstance(AbstractServiceInstanceRecoveryImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plannedMigration(String projectId, String instanceId, User user) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((Object)user)) {
            logger.error((Object)"instance_id or project_id or user is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id or project_id or user is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            logger.error((Object)("instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        String fcVersion = LegoConfig.getInstance().getKeyValue("fusioncloud.version");
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instance.getType()) && !VerifyUtil.isEmpty((String)fcVersion) && fcVersion.compareToIgnoreCase(OpenstackEnumDefine.FUSION_CLOUD_VERSION_E.VERSION_6_3.getValue()) >= 0) {
            logger.info((Object)("fc 6.3 ,csha not support plannedMigration from consoleUI,Instance is:" + instanceId));
            throw new LegoCheckedException(1073947453L);
        }
        this.checkInstanceProjectId(projectId, instance);
        String instanceStatus = instance.getStatus();
        logger.info((Object)"start planned migration verify instance status");
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instanceStatus) && !ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED.getValue().equals(instanceStatus)) {
            logger.error((Object)("planned migration failed, instance status (" + instanceStatus + ")"));
            throw new LegoCheckedException(1073948693L, "planned migration failed, instance status (" + instanceStatus + ")");
        }
        ServiceInstanceHelper.getInstance().checkServiceInstPoInfo(instance);
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        if (!instanceHelper.getLock(instanceId)) {
            logger.error((Object)("get instance( " + instanceId + " ) lock faild."));
            throw new LegoCheckedException(1073948693L);
        }
        IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
        String recoveryPlanId = instance.getRecoveryPlanId();
        try {
            HashMap recoveryContext = new HashMap();
            recoveryManager.startPlanedMotion(recoveryPlanId, recoveryContext, user);
            instanceHelper.changeStatus(instanceId, ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_RUNNING);
            MonitorRecoveryTask task = new MonitorRecoveryTask(instance);
            ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"check recoveryPlan failed, ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Exception)e, (String)"plannedmigration failed", (long)0x300001L, (String[])new String[0]);
        }
        finally {
            instanceHelper.releaseLock(instanceId);
        }
    }

    public void plannedMigration(String projectId, String instanceId, Map<String, String> recoveryContext) {
        RecoveryInstanceParam recoveryInstanceParam = new RecoveryInstanceParam(projectId, instanceId, "plannedMigration").invoke();
        ServiceInstance instance = recoveryInstanceParam.getInstance();
        IRecoveryManager recoveryManager = recoveryInstanceParam.getRecoveryManager();
        String recoveryPlanId = recoveryInstanceParam.getRecoveryPlanId();
        try {
            recoveryManager.startPlanedMotion(recoveryPlanId, recoveryContext, this.getAdminUser());
        }
        catch (Exception ex) {
            logger.error((Object)String.format(Locale.ROOT, "Failed to planedMotion recoveryPlan, instanceName=%s.", instance.getName()), (Throwable)ex);
            if (ex instanceof LegoCheckedException) {
                throw ex;
            }
            ExceptionUtil.rethrowException((Exception)ex, (String)"planedMotion recoveryPlan failed", (long)0x300001L, (String[])new String[0]);
        }
    }

    public void autoDisaterRecovery(String regionId, String arbStatus) {
        Properties resource = this.readPropertiesInConf("conf/arb.properties");
        String azs = null;
        if (OpenstackEnumDefine.ARB_STATUS_E.FAIL_REMOTE.getValue().equalsIgnoreCase(arbStatus)) {
            azs = resource.getProperty(regionId + ".arb.remoteAZ");
        } else if (OpenstackEnumDefine.ARB_STATUS_E.FAIL_LOCAL.getValue().equalsIgnoreCase(arbStatus)) {
            azs = resource.getProperty(regionId + ".arb.localAZ");
        }
        if (VerifyUtil.isEmpty(azs)) {
            logger.error((Object)("empty azs, arbStatus:" + arbStatus));
            return;
        }
        ArrayList<String> status = new ArrayList<String>();
        status.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue());
        status.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue());
        logger.debug((Object)"%s starts disater recovery, errorAZ: %s", new Object[]{regionId, azs});
        this.addToDiscoveryQueue(regionId, azs, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDiscoveryQueue(String regionId, String remoteAZs, List<String> status) {
        AutoDisasterRecovery autoRecovery;
        String[] azs = remoteAZs.split(",");
        List<InstanceInfoBO> instList = this.queryServiceInsts(regionId, azs, status);
        AutoDisasterRecovery autoDisasterRecovery = autoRecovery = AutoDisasterRecovery.getInstance();
        synchronized (autoDisasterRecovery) {
            ConcurrentLinkedQueue<InstanceInfoBO> sortedQueue = autoRecovery.getSortedQueue();
            for (InstanceInfoBO one : sortedQueue) {
                if (!instList.contains(one)) continue;
                instList.remove(one);
            }
        }
        this.sortInstList(instList);
        autoRecovery.addToSortedStack(instList);
    }

    public void autoReprotect(String regionId) {
        Properties resource = this.readPropertiesInConf("conf/arb.properties");
        String localAz = resource.getProperty(regionId + ".arb.localAZ");
        String remoteAZs = resource.getProperty(regionId + ".arb.remoteAZ");
        if (VerifyUtil.isEmpty((String)localAz)) {
            logger.error((Object)"no local az");
            return;
        }
        if (VerifyUtil.isEmpty((String)remoteAZs)) {
            logger.error((Object)"no remote az");
            return;
        }
        logger.debug((Object)"%s starts reprotection, localAZ: %s, remoteAZ: %s", new Object[]{regionId, localAz, remoteAZs});
        this.autoReprotect(regionId, localAz, remoteAZs);
        this.autoReprotect(regionId, remoteAZs, localAz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoReprotect(String regionId, String localAz, String remoteAZs) {
        AutoReProtect autoReProtect;
        ArrayList<String> status = new ArrayList<String>();
        status.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED.getValue());
        status.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue());
        String[] azs = localAz.split(",");
        List<InstanceInfoBO> instList = this.queryServiceInsts(regionId, azs, status);
        AutoReProtect autoReProtect2 = autoReProtect = AutoReProtect.getInstance();
        synchronized (autoReProtect2) {
            ConcurrentLinkedQueue<InstanceInfoBO> sortedQueue = autoReProtect.getSortedQueue();
            for (InstanceInfoBO one : sortedQueue) {
                if (!instList.contains(one)) continue;
                instList.remove(one);
            }
        }
        this.sortInstList(instList);
        autoReProtect.addToSortedStack(instList);
        ArrayList<String> recvoeryFailStatus = new ArrayList<String>();
        recvoeryFailStatus.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue());
        this.addToDiscoveryQueue(regionId, remoteAZs, recvoeryFailStatus);
    }

    private void sortInstList(List<InstanceInfoBO> instList) {
        Collections.sort(instList, new Comparator<InstanceInfoBO>(){

            @Override
            public int compare(InstanceInfoBO o1, InstanceInfoBO o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                int priortyCompare = o1.getStartPriority().compareTo(o2.getStartPriority());
                if (0 == priortyCompare) {
                    int nameCompare = o1.getProjectId().compareTo(o2.getProjectId());
                    if (0 == nameCompare) {
                        return o1.getId().compareTo(o2.getId());
                    }
                    return nameCompare;
                }
                return priortyCompare;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties readPropertiesInConf(String propFile) {
        Properties props;
        block8: {
            File file = new File(propFile);
            props = new Properties();
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                InputStreamReader inputReader = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    inputReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
                    props.load(inputReader);
                    CommonUtil.close((Closeable)inputReader);
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)("read lego.properties fail." + ExceptionUtil.getErrorMessage((Throwable)e)));
                    CommonUtil.close((Closeable)inputReader);
                    CommonUtil.close((Closeable)fileInputStream);
                    break block8;
                }
                catch (IOException e2) {
                    logger.error((Object)"read lego.properties fail.", (Throwable)e2);
                    break block8;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CommonUtil.close(inputReader);
                    CommonUtil.close((Closeable)fileInputStream);
                }
                CommonUtil.close((Closeable)fileInputStream);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InstanceInfoBO> queryServiceInsts(String regionId, String[] azs, List<String> status) {
        logger.info((Object)("azNameArr :" + JSONArray.fromObject((Object)azs).toString() + "instStatusList : " + JSONArray.fromObject(status).toString()));
        Session session = null;
        ArrayList<InstanceInfoBO> returnList = new ArrayList<InstanceInfoBO>();
        ArrayList<String> failStatus = new ArrayList<String>();
        failStatus.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED.getValue());
        failStatus.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue());
        failStatus.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue());
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ServiceInstance.class);
            crit.add(Restrictions.in((String)"status", status));
            List instList = crit.list();
            for (ServiceInstance serviceInstance : instList) {
                if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceInstance.getType()) && !"csha_csdr".equals(serviceInstance.getProtectType())) {
                    logger.debug((Object)("The type is not hypermetro: " + serviceInstance.getName()));
                    continue;
                }
                Map<String, String> props = this.getProtectGroupProps(serviceInstance.getProtectGroupId(), session);
                if (failStatus.contains(serviceInstance.getStatus()) && props.containsKey("RECOVERY_REGION_TYPE") && props.get("RECOVERY_REGION_TYPE").equals("REGION_TYPE_BETWEEN")) {
                    logger.debug((Object)"The type is csha_csdr REGION_TYPE_BETWEEN: %s", new Object[]{serviceInstance.getName()});
                    continue;
                }
                if (VerifyUtil.isEmpty((String)props.get("zoneName")) || !Arrays.asList(azs).contains(props.get("zoneName")) || VerifyUtil.isEmpty((String)props.get("regionName")) || !regionId.equals(props.get("regionName"))) continue;
                InstanceInfoBO bo = new InstanceInfoBO();
                ProtectGroup protectGroup = new ProtectGroup();
                protectGroup.setProps(props);
                bo.setProtectGroup(protectGroup);
                int startPriority = 3;
                try {
                    startPriority = Integer.parseInt(props.get("StartPriority"));
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("parse startPriority error:" + props.get("StartPriority")));
                }
                bo.setStartPriority(Integer.valueOf(startPriority));
                this.buildInstBoBasicInfo(serviceInstance, bo);
                returnList.add(bo);
            }
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)("query instance or query protectGroup props fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786896L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        logger.debug((Object)("instance size is " + returnList.size()));
        return returnList;
    }

    private Map<String, String> getProtectGroupProps(String pgId, Session session) {
        logger.debug((Object)("pgId:" + pgId));
        Map<String, String> props = new HashMap<String, String>();
        String strSQL = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID=:pgId";
        NativeQuery query = session.createSQLQuery(strSQL);
        query.setString("pgId", pgId);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            props = this.constructExtendProperties(results);
        }
        return props;
    }

    private Map<String, String> constructExtendProperties(List<?> result) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 3 != (values = (Object[])object).length) continue;
            String propName = CommUtil.convertToString((Object)values[1]);
            String propValue = CommUtil.convertToString((Object)values[2]);
            props.put(propName, propValue);
        }
        return props;
    }

    protected boolean isSingleVmExistRollBackTask(String vmUuid) {
        if (VerifyUtil.isEmpty((String)vmUuid)) {
            logger.info((Object)"vmUuid is empty");
            return false;
        }
        HashSet<String> vmUuids = new HashSet<String>();
        vmUuids.add(vmUuid);
        return this.isVmExistRollBackTask(vmUuids);
    }

    protected boolean isVmExistRollBackTask(Set<String> vmUuids) {
        if (VerifyUtil.isEmpty(vmUuids)) {
            logger.info((Object)"vmUUids is empty.");
            return false;
        }
        List tasks = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from RollBackTaskInfo", new Object[0]);
        if (VerifyUtil.isEmpty((Collection)tasks)) {
            logger.info((Object)"There is no RollBackTask in db.");
            return false;
        }
        for (RollBackTaskInfo task : tasks) {
            if (!vmUuids.contains(task.getTaskId())) continue;
            logger.info((Object)("vm(" + vmUuids + ") exists rollBack task, taskId is " + task.getTaskId()));
            return true;
        }
        return false;
    }

    public void drilling(String projectId, String instanceId) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)"Failed to drilling.instance_id or project_id is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id or project_id is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            logger.error((Object)("Failed to drilling.instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        this.checkInstanceProjectId(projectId, instance);
        String instanceStatus = instance.getStatus();
        logger.info((Object)("start dri verify instance status instanceName=" + instance.getName()));
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instanceStatus)) {
            logger.error((Object)("Failed to drilling, instance status (" + instanceStatus + "), not normal, instanceName=" + instance.getName()));
            throw new LegoCheckedException(1073948693L, "drilling failed, instance status (" + instanceStatus + ")");
        }
        ServiceInstanceHelper.getInstance().checkServiceInstPoInfo(instance);
        IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
        String recoveryPlanId = instance.getRecoveryPlanId();
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = protectGroupService.getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        licenseControl.checkEnablePgCount(protectGroup);
        try {
            HashMap recoveryContext = new HashMap();
            recoveryManager.startRecoveryDrilling(recoveryPlanId, recoveryContext, this.getAdminUser());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to test recoveryPlan, instanceName=" + instance.getName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to test recoveryPlan, instanceName=" + instance.getName()));
            ExceptionUtil.rethrowException((Exception)e, (String)"test recoveryPlan failed", (long)0x300001L, (String[])new String[0]);
        }
    }

    public void clearDrilling(String projectId, String instanceId) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)"Failed to clear Drilling.instance_id or project_id or user is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id or project_id or user is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            logger.error((Object)("Failed to clear Drilling.instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        this.checkInstanceProjectId(projectId, instance);
        String instanceStatus = instance.getStatus();
        logger.info((Object)("start clearDrilling verify instance status,instanceName=" + instance.getName()));
        if (!(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTED.getValue().equals(instanceStatus) || ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_CLEAR.getValue().equals(instanceStatus) || ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_TEST.getValue().equals(instanceStatus))) {
            logger.error((Object)("clearDrilling failed, instance status (" + instanceStatus + "),instanceName=" + instance.getName()));
            throw new LegoCheckedException(1073948693L, "clearDrilling failed, instance status (" + instanceStatus + ")");
        }
        ServiceInstanceHelper.getInstance().checkServiceInstPoInfo(instance);
        IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
        String recoveryPlanId = instance.getRecoveryPlanId();
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        String protectGroupId = instance.getProtectGroupId();
        IProtectGroupService groupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = groupService.getProtectGroupByID(protectGroupId, true);
        licenseControl.checkEnablePgCount(protectGroup);
        try {
            recoveryManager.cleanRecoveryDrilling(recoveryPlanId, this.getAdminUser());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("clear recoveryPlan failed,instanceName=" + instance.getName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("clear recoveryPlan failed,instanceName=" + instance.getName()));
            ExceptionUtil.rethrowException((Exception)e, (String)"clear recoveryPlan failed", (long)0x300001L, (String[])new String[0]);
        }
    }

    private User getAdminUser() {
        IUserMgr userMgr = (IUserMgr)ServiceLocator.getInstance().getService(IUserMgr.class);
        if (null == userMgr) {
            logger.error((Object)"get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        User user = userMgr.getUserByName("admin");
        if (null == user) {
            logger.error((Object)"get admin user failed.");
            throw new LegoCheckedException(1073947393L);
        }
        return user;
    }

    protected List<OpenStackVM> getVMByUuids(String regionUuid, String projectUuid, Set<String> vmUuidSet) {
        ArrayList<OpenStackVM> targetVMList = new ArrayList<OpenStackVM>();
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty(vmUuidSet)) {
            return targetVMList;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        for (OpenStackVM vm : vmList) {
            if (!vmUuidSet.contains(vm.getUuid())) continue;
            targetVMList.add(vm);
        }
        return targetVMList;
    }

    protected boolean checkVMSIntfaceExist(String regionUuid, String projectUuid, Set<String> vmUuidSet, List<OpenStackVM> vmList) {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            for (OpenStackVM vm : vmList) {
                if (!VerifyUtil.isEmpty((Map)vm.getAddresses()) && !VerifyUtil.isEmpty(vm.getAddresses().values())) continue;
                logger.error((Object)("VM interface is empty ,VM :" + vm));
                return false;
            }
            return true;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        for (String vmUuid : vmUuidSet) {
            List<VMInterface> vmInerfaces = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, vmUuid);
            if (!VerifyUtil.isEmpty(vmInerfaces)) continue;
            logger.info((Object)("vm(" + vmUuid + ") doesn't have any interfaces."));
            return false;
        }
        return true;
    }

    protected boolean checkVolumesOfVm(String regionUuid, String projectUuid, Set<ProtectObject> poList) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        HashSet<String> vmUuidSetOfPo = new HashSet<String>();
        HashMap tgtVolumeMap = new HashMap();
        for (ProtectObject po : poList) {
            vmUuidSetOfPo.add(po.getMoUuid());
            ArrayList<String> volumeSet = new ArrayList<String>();
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                com.huawei.lego.core.sdk.util.JSONObject json = array.getJSONObject(i);
                volumeSet.add(json.getString("volumeId"));
            }
            tgtVolumeMap.put(po.getMoUuid(), volumeSet);
        }
        for (OpenStackVM vm : vmList) {
            if (!vmUuidSetOfPo.contains(vm.getUuid())) continue;
            List<String> currentUseVolumeSet = OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ",");
            logger.info((Object)("the vm " + vm.getName() + " current use volumes:" + currentUseVolumeSet));
            List willOperVolumeSet = (List)tgtVolumeMap.get(vm.getUuid());
            if (VerifyUtil.isEmpty((Collection)willOperVolumeSet) || VerifyUtil.isEmpty(currentUseVolumeSet)) {
                logger.error((Object)"vm has no volumes or will operate none volume");
                return false;
            }
            if (!currentUseVolumeSet.containsAll(willOperVolumeSet)) {
                logger.error((Object)("will operate volume does't in use of vm,vm=" + vm.getName() + " will operate volumes:" + willOperVolumeSet));
                return false;
            }
            if (currentUseVolumeSet.size() == willOperVolumeSet.size()) continue;
            if (!VerifyUtil.isEmpty((Collection)vm.getTags()) && vm.getTags().contains("__type_baremetal")) {
                logger.debug((Object)"bms service instance");
                return true;
            }
            logger.error((Object)("operate volumes does't equals vmVolume,vm=" + vm.getName() + " will operate volumes:" + willOperVolumeSet));
            return false;
        }
        return true;
    }

    protected boolean checkSharedVolums(String regionUuid, String projectUuid, Set<ProtectObject> currentPoList, Set<ProtectObject> poList, boolean isDelete) {
        Set<String> notContainVmUuidSet = VmChecker.getAllSharedVolumeNotInPgVmUuids(regionUuid, projectUuid, currentPoList, poList, isDelete, true, false);
        if (VerifyUtil.isEmpty(notContainVmUuidSet)) {
            return true;
        }
        logger.info((Object)("notContainVmUuidSet:" + notContainVmUuidSet));
        List<OpenStackVM> vmList = this.getVMByUuids(regionUuid, projectUuid, notContainVmUuidSet);
        ArrayList<String> sharedVolumeNotInPgVmList = new ArrayList<String>();
        for (OpenStackVM openStackVM : vmList) {
            sharedVolumeNotInPgVmList.add(openStackVM.getName());
        }
        throw new LegoCheckedException(1073948135L, new String[]{((Object)sharedVolumeNotInPgVmList).toString()});
    }

    protected void checkSharedVolumesWhenAddVolume(ProtectGroup pg, Set<ProtectedVolumeInfo> addVolumes) {
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty(addVolumes)) {
            logger.error((Object)"param is null:");
            return;
        }
        HashSet<String> currentVmUuidSet = new HashSet<String>();
        for (ProtectObject protectObject : pg.getPolist()) {
            currentVmUuidSet.add(protectObject.getMoUuid());
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        HashSet<String> volumeUuidSet = new HashSet<String>();
        for (ProtectedVolumeInfo protectedVolumeInfo : addVolumes) {
            String volumeId = protectedVolumeInfo.getVolumeId();
            volumeUuidSet.add(OpenStackCommonUtil.getObjectUuid(openstackUuid, volumeId));
        }
        Set<String> notContainVmUuidSet = VmChecker.getAllSharedVolumeNotValidVmUuids(regionUuid, projUuid, volumeUuidSet, currentVmUuidSet, false, true, false);
        if (VerifyUtil.isEmpty(notContainVmUuidSet)) {
            return;
        }
        logger.info((Object)("notContainVmUuidSet:" + notContainVmUuidSet));
        List<OpenStackVM> vmList = this.getVMByUuids(regionUuid, projUuid, notContainVmUuidSet);
        ArrayList<String> sharedVolumeNotInPgVmList = new ArrayList<String>();
        for (OpenStackVM openStackVM : vmList) {
            sharedVolumeNotInPgVmList.add(openStackVM.getName());
        }
        throw new LegoCheckedException(1073948135L, new String[]{((Object)sharedVolumeNotInPgVmList).toString()});
    }

    protected void checkUnSupportVolume(String regionUuid, String projectUuid, Set<ProtectObject> poList) {
        Set<String> shareOrScsiVmSet = VmChecker.getUnSupportVolumeVm(regionUuid, projectUuid, poList);
        HashSet<String> filterVmidSet = new HashSet<String>();
        for (ProtectObject protectObject : poList) {
            if (!shareOrScsiVmSet.contains(protectObject.getMoUuid())) continue;
            filterVmidSet.add(protectObject.getMoUuid());
        }
        if (!filterVmidSet.isEmpty()) {
            throw new LegoCheckedException(1073948138L, new String[]{((Object)filterVmidSet).toString()});
        }
    }

    protected Set<String> checkVmCommonProperties(List<ServerBO> servers, Map<String, String> paramAZMap, Map<String, OpenStackVM> vmsMap, Map<String, VerifyServerResultBO.ResultItem> resultMap, String instanceType, List<Map<String, Object>> azMappings) {
        String projectId = paramAZMap.get("projectId");
        String srcRegion = paramAZMap.get("regionName");
        String openstackUuid = this.getOpenstack().getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, srcRegion);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        String preAzName = null;
        for (OpenStackVM vm : vmsMap.values()) {
            if (VerifyUtil.isEmpty(preAzName)) {
                preAzName = vm.getAzName();
                paramAZMap.put("zoneName", preAzName);
            }
            if (vm.getAzName().equals(preAzName)) continue;
            logger.info((Object)"vms are not in the same az.");
            this.initAndGetItem(String.valueOf(1073948121L), resultMap);
            break;
        }
        Map<String, String> volAndVolTypeMap = OpenStackCommonUtil.getVolAndVolTypeMap(regionUuid, projectUuid);
        HashSet<String> volTypeSet = new HashSet<String>();
        for (ServerBO server : servers) {
            if (VerifyUtil.isEmpty((Collection)server.getVolumes())) {
                logger.error((Object)"Server volumes is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            for (VolumeBO vol : server.getVolumes()) {
                String sourceType;
                String volId = vol.getVolumeId();
                if (VerifyUtil.isEmpty((String)volId)) {
                    logger.error((Object)"Volume id is empty.");
                    throw new LegoCheckedException(1073947393L);
                }
                if (VerifyUtil.isEmpty((String)vol.getVolumeType())) {
                    sourceType = volAndVolTypeMap.containsKey(volId) ? volAndVolTypeMap.get(volId) : "error-null";
                    volTypeSet.add(sourceType);
                    continue;
                }
                sourceType = vol.getVolumeType();
                volTypeSet.add(sourceType);
            }
        }
        if (!VerifyUtil.isEmpty(volTypeSet)) {
            try {
                if (!this.checkVolTypeFromSameDev(regionUuid, projectUuid, volTypeSet)) {
                    logger.info((Object)"vms' volumes are not from the same storage.");
                    this.initAndGetItem(String.valueOf(1073948415L), resultMap);
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("some volume type config error , volume types : " + volTypeSet));
                this.initAndGetItem(String.valueOf(1073948129L), resultMap);
            }
            String volType = (String)CommonUtil.getFirstElement(volTypeSet);
            OpenStackStorageResourcePool pool = this.getResPoolByVolumeType(regionUuid, projectUuid, volType);
            if (!this.checkVolumeType(pool, instanceType)) {
                logger.info((Object)("The storage which volumes' from doesn't support this instancetype " + instanceType));
                this.initAndGetItem(String.valueOf(1073948114L), resultMap);
            }
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(instanceType)) {
            this.checkVolumeTypeForVhaCsdr(azMappings, resultMap, volTypeSet, paramAZMap, instanceType);
        }
        return volTypeSet;
    }

    protected VerifyServerResultBO.ResultItem initAndGetItem(String key, Map<String, VerifyServerResultBO.ResultItem> resultMap) {
        VerifyServerResultBO.ResultItem item = resultMap.get(key);
        if (null == item) {
            item = new VerifyServerResultBO.ResultItem();
            item.setErrCode(key);
            resultMap.put(key, item);
        }
        return item;
    }

    protected boolean checkVolTypeFromSameDev(String regionUuid, String projectUuid, Set<String> volumeTypeSet) {
        logger.info((Object)("add volume type (" + volumeTypeSet + ")"));
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty(volumeTypeSet)) {
            logger.error((Object)"the params is empty");
            throw new LegoCheckedException(1073947393L);
        }
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List typeList = volumeService.getVolumeTypesByName(volumeTypeSet, regionUuid, projectUuid);
        if (typeList.size() != volumeTypeSet.size()) {
            logger.info((Object)"add volumes exist invalid volume type");
            throw new LegoCheckedException(1073949726L);
        }
        boolean sameDevFlag = volumeService.isVolTypesFromSameDev(typeList);
        if (!sameDevFlag) {
            logger.error((Object)"volumeTypes are from different device");
            return false;
        }
        return true;
    }

    protected OpenStackStorageResourcePool getResPoolByVolumeType(String regionUuid, String projectUuid, String volType) {
        String localdevSn;
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        HashSet<String> srcVolTypeSet = new HashSet<String>();
        srcVolTypeSet.add(volType);
        List typeList = volumeService.getVolumeTypesByName(srcVolTypeSet, regionUuid, projectUuid);
        if (VerifyUtil.isEmpty((Collection)typeList)) {
            logger.error((Object)" volumeType list is empty.");
            return null;
        }
        OpenStackVolumeType srcType = (OpenStackVolumeType)CommonUtil.getFirstElement((Collection)typeList);
        String extraSpecs = srcType.getExtraSpecs();
        logger.debug((Object)(srcType.getName() + " voltype extraSpecs:" + extraSpecs));
        JSONObject obj = JSONObject.fromObject((Object)extraSpecs);
        String string = localdevSn = obj.containsKey((Object)"hw:localdev") ? obj.getString("hw:localdev") : null;
        if (null == localdevSn) {
            logger.error((Object)(srcType.getName() + " volumeType has no localDevSn"));
            return null;
        }
        logger.info((Object)("will find storage, local devsn =" + localdevSn));
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        List poolList = volumeService.getStorageResourcePools(openstackUuid, regionUuid, projectUuid);
        OpenStackStorageResourcePool poolOfType = null;
        logger.info((Object)("poolList  size from drExtend is = " + poolList.size()));
        for (OpenStackStorageResourcePool pool : poolList) {
            if (!localdevSn.equals(pool.getLocalDevSn())) continue;
            poolOfType = pool;
            break;
        }
        return poolOfType;
    }

    protected void checkVolumesExist(String regionUuid, String projectUuid, String serverId, Set<ProtectedVolumeInfo> addVolumes) {
        String tokenId;
        if (VerifyUtil.isEmpty(addVolumes)) {
            return;
        }
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)serverId)) {
            logger.info((Object)"regionUuid or projectUuid or serverId is empty.");
            throw new LegoCheckedException(1073947393L, "regionUuid or projectUuid or serverId is empty.");
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String vmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, serverId);
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        OpenStackVM vm = novaManager.getVm(regionUuid, tokenId = TokenUtil.getInstance().getTokenId(projectUuid), projectUuid, vmUuid, new int[0]);
        if (null == vm) {
            logger.info((Object)"Vm is null, regionUuid:%s, projectUuid:%s, vmUuid:%s", new Object[]{regionUuid, projectUuid, vmUuid});
            throw new LegoCheckedException(201L);
        }
        String volumeUuids = vm.getVolumeAttached();
        List<String> volumeUuidsList = OpenStackCommonUtil.getListFromStr(volumeUuids, ",");
        if (VerifyUtil.isEmpty(volumeUuidsList)) {
            logger.info((Object)("this volumes(" + addVolumes + ") is not exist in vm(serverId = " + serverId + ")."));
            throw new LegoCheckedException(201L, "this volumes(" + addVolumes + ") is not exist in vm(serverId = " + serverId + ").");
        }
        HashSet<String> volumeUuidsSet = new HashSet<String>(volumeUuidsList);
        Set<String> volumeIds = OpenStackCommonUtil.getIdFromUuid(volumeUuidsSet);
        for (ProtectedVolumeInfo volumeInfo : addVolumes) {
            String volumeIdParam = volumeInfo.getVolumeId();
            if (volumeIds.contains(volumeIdParam)) continue;
            logger.info((Object)("this volume(" + volumeIdParam + ") is not exist in vm(serverId = " + serverId + ")."));
            throw new LegoCheckedException(201L, "this volume(" + volumeIdParam + ") is not exist in vm(serverId = " + serverId + ").");
        }
    }

    protected Set<ProtectObject> checkServerExist(String pgId, Set<String> serverIdSet) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(pgId, true);
        if (null == pg) {
            throw new LegoCheckedException(201L, "update volumes error, because serverId is not in current instance and serverId is " + serverIdSet);
        }
        HashSet<ProtectObject> pos = new HashSet<ProtectObject>();
        for (ProtectObject po : pg.getPolist()) {
            for (String serverId : serverIdSet) {
                if (!po.getMoUuid().contains(serverId)) continue;
                pos.add(po);
            }
        }
        if (serverIdSet.size() != pos.size()) {
            throw new LegoCheckedException(201L, "update volumes error, because serverId is not in current instance and serverId is " + serverIdSet);
        }
        return pos;
    }

    protected void filterUnSupportVm(String regionUuid, String projectUuid, List<OpenStackVM> vmList) {
        HashSet<String> volumeUuidSet = new HashSet<String>();
        Iterator<OpenStackVM> iterator = vmList.iterator();
        while (iterator.hasNext()) {
            List<String> vMvolumeList = OpenStackCommonUtil.getListFromStr(iterator.next().getVolumeAttached(), ",");
            HashSet<String> vMvolumeSet = new HashSet<String>(vMvolumeList);
            volumeUuidSet.addAll(vMvolumeSet);
        }
        Set<String> vmUuidSet = VmChecker.getShareOrScsiVmUuids(regionUuid, projectUuid, volumeUuidSet);
        Iterator<OpenStackVM> iterator1 = vmList.iterator();
        while (iterator1.hasNext()) {
            String vmUuid = iterator1.next().getUuid();
            if (!vmUuidSet.contains(vmUuid)) continue;
            logger.error((Object)("vm Uuid:" + vmUuid + " has share or scsi volumes."));
            iterator1.remove();
        }
    }

    protected boolean checkVolumeType(OpenStackStorageResourcePool pool, String serviceType) {
        logger.debug((Object)("service type =" + serviceType));
        if (VerifyUtil.isEmpty((Object)pool)) {
            logger.error((Object)"the pool is null");
            return false;
        }
        pool.generateRemoteDevInfo();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(serviceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(serviceType)) {
            if (VerifyUtil.isEmpty((Collection)pool.getRemoteHyperMetroDevs())) {
                logger.error((Object)"the dev not support hypermetro");
                return false;
            }
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceType)) {
            if (VerifyUtil.isEmpty((Collection)pool.getRemoteDevs())) {
                logger.error((Object)"the dev not support replication");
                return false;
            }
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType)) {
            if (VerifyUtil.isEmpty((Collection)pool.getRemoteDevs()) || VerifyUtil.isEmpty((Collection)pool.getRemoteHyperMetroDevs())) {
                logger.error((Object)"the dev not support replication or hypermetro");
                return false;
            }
        } else {
            logger.error((Object)("serviceType not support:" + serviceType));
            return false;
        }
        return true;
    }

    protected Map<String, String> checkVmCommonProperties(String regionUuid, String projectUuid, String instanceType, List<OpenStackVM> vmList, OpenStackVM protectedServerVM) {
        HashMap<String, String> vmStorageMap = new HashMap<String, String>();
        HashSet<String> volUuidSet = new HashSet<String>();
        for (OpenStackVM vm : vmList) {
            volUuidSet.addAll(OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ","));
        }
        List<String> protectedServerVolumeIDList = OpenStackCommonUtil.getListFromStr(protectedServerVM.getVolumeAttached(), ",");
        volUuidSet.addAll(protectedServerVolumeIDList);
        List volumeList = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumesByUuid(regionUuid, projectUuid, new ArrayList(volUuidSet), false);
        String protectedServerStorageSN = null;
        for (OpenStackVolume volume : volumeList) {
            if (!protectedServerVolumeIDList.contains(volume.getUuid())) continue;
            protectedServerStorageSN = this.getResPoolByVolumeType(regionUuid, projectUuid, volume.getVolType()).getLocalDevSn();
        }
        HashSet<String> csdrVolTypesSet = new HashSet<String>();
        HashSet<String> cshaVolTypesSet = new HashSet<String>();
        this.initializeCsdrCshaVolType(csdrVolTypesSet, cshaVolTypesSet, vmList);
        HashMap<String, OpenStackStorageResourcePool> caches = new HashMap<String, OpenStackStorageResourcePool>();
        HashSet<String> volTypeSet = new HashSet<String>();
        Iterator<OpenStackVM> it = vmList.iterator();
        while (it.hasNext()) {
            OpenStackStorageResourcePool pool;
            OpenStackVM vm;
            block13: {
                vm = it.next();
                List<String> uuidList = OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ",");
                volTypeSet.clear();
                for (OpenStackVolume volume : volumeList) {
                    if (!uuidList.contains(volume.getUuid())) continue;
                    volTypeSet.add(volume.getVolType());
                }
                if (instanceType.equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue()) && !csdrVolTypesSet.containsAll(volTypeSet)) {
                    logger.info((Object)("CSDR : vm uuid:" + vm.getUuid() + "'s Volumes has a volume type that is not paired "));
                    it.remove();
                    continue;
                }
                if (instanceType.equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue()) && !cshaVolTypesSet.containsAll(volTypeSet)) {
                    logger.info((Object)("CSHA : vm uuid:" + vm.getUuid() + "'s Volumes has a volume type that is not paired "));
                    it.remove();
                    continue;
                }
                if (VerifyUtil.isEmpty(volTypeSet)) continue;
                try {
                    if (!this.checkVolTypeFromSameDev(regionUuid, projectUuid, volTypeSet)) {
                        logger.info((Object)("vm Uuid:" + vm.getUuid() + " volumes are not from the same storage."));
                        it.remove();
                    }
                    break block13;
                }
                catch (LegoCheckedException e) {
                    logger.error((Object)("vm Uuid:" + vm.getUuid() + " some volume type config error , volume types : " + volTypeSet));
                    it.remove();
                }
                continue;
            }
            String volType = (String)CommonUtil.getFirstElement(volTypeSet);
            String cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projectUuid, volType});
            if (caches.containsKey(cacheKey)) {
                pool = (OpenStackStorageResourcePool)caches.get(cacheKey);
            } else {
                pool = this.getResPoolByVolumeType(regionUuid, projectUuid, volType);
                caches.put(cacheKey, pool);
            }
            if (!this.checkVolumeType(pool, instanceType)) {
                logger.info((Object)("vm Uuid:" + vm.getUuid() + " The storage which volumes' from doesn't support this instancetype " + instanceType));
                it.remove();
                continue;
            }
            if (!pool.getLocalDevSn().equals(protectedServerStorageSN) && !VerifyUtil.isEmpty((String)protectedServerStorageSN)) {
                logger.info((Object)"vm Uuid:%s  not from same storage with vm %s storageSN=%s, instancetype=%s", new Object[]{vm.getUuid(), protectedServerVM.getUuid(), protectedServerStorageSN, instanceType});
                it.remove();
                continue;
            }
            vmStorageMap.put(vm.getUuid(), pool.getLocalDevSn());
        }
        return vmStorageMap;
    }

    private void initializeCsdrCshaVolType(Set<String> csdrVolTypesSet, Set<String> cshaVolTypesSet, List<OpenStackVM> vmList) {
        if (VerifyUtil.isEmpty(vmList)) {
            return;
        }
        String azName = vmList.get(0).getAzName();
        String regionName = vmList.get(0).getRegionName();
        String azId = OpenStackVolTypeMapping.getMappingAzId((String)regionName, (String)azName);
        IOpenstackResourceService openstackResourceService = (IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class);
        List volTypeMappings = openstackResourceService.getVolTypeMappingsFromDB();
        for (OpenStackVolTypeMapping openStackVolTypeMapping : volTypeMappings) {
            if (openStackVolTypeMapping.getType().equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue())) {
                if (openStackVolTypeMapping.getPrimaryAzId().equals(azId)) {
                    csdrVolTypesSet.add(openStackVolTypeMapping.getPrimaryVolType());
                } else if (openStackVolTypeMapping.getSecondAzId().equals(azId)) {
                    csdrVolTypesSet.add(openStackVolTypeMapping.getSecondVolType());
                }
            }
            if (!openStackVolTypeMapping.getType().equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue())) continue;
            if (openStackVolTypeMapping.getPrimaryAzId().equals(azId)) {
                cshaVolTypesSet.add(openStackVolTypeMapping.getPrimaryVolType());
                continue;
            }
            if (!openStackVolTypeMapping.getSecondAzId().equals(azId)) continue;
            cshaVolTypesSet.add(openStackVolTypeMapping.getSecondVolType());
        }
    }

    private void checkVolumeTypeForVhaCsdr(List<Map<String, Object>> azMappings, Map<String, VerifyServerResultBO.ResultItem> resultMap, Set<String> volTypeSet, Map<String, String> paramAZMap, String serviceType) {
        if (azMappings.isEmpty()) {
            logger.info((Object)"The storage which volumes' from doesn't support this instancetype ");
            this.initAndGetItem(String.valueOf(1073948114L), resultMap);
            return;
        }
        HashSet<String> volDrTypeSet = new HashSet<String>();
        HashSet<String> drHyperVolSet = new HashSet<String>();
        for (String srVolType : volTypeSet) {
            boolean foundDrVolumeType = false;
            for (Map<String, Object> item : azMappings) {
                String azVolumeMap = this.getAzIdentity(item, serviceType);
                String azSourceMap = this.getAzIdentityByParamAZMap(paramAZMap, serviceType);
                if (VerifyUtil.isEmpty((String)azVolumeMap) || !azVolumeMap.equals(azSourceMap)) continue;
                String sourceType = (String)item.get("sourceType");
                String drHyperMetorType = (String)item.get("drHyperMetorType");
                String drType = (String)item.get("drType");
                if (sourceType.equals(srVolType)) {
                    foundDrVolumeType = true;
                    volDrTypeSet.add(drType);
                    drHyperVolSet.add(drHyperMetorType);
                    logger.info((Object)("srVolType " + srVolType + ",drType=" + drType + ",drHyperMetorType=" + drHyperMetorType));
                    break;
                }
                if (!drHyperMetorType.equals(srVolType)) continue;
                foundDrVolumeType = true;
                volDrTypeSet.add(drType);
                drHyperVolSet.add(sourceType);
                logger.info((Object)("srVolType " + drHyperMetorType + ",drType=" + drType + ",drHyperMetorType=" + srVolType));
                break;
            }
            if (foundDrVolumeType) continue;
            logger.error((Object)("SrVolType " + srVolType + "do have drType and drHyperMetorType, az maping:" + azMappings));
            this.initAndGetItem(String.valueOf(1073948114L), resultMap);
            return;
        }
        logger.info((Object)"Successfully found all drVolumeType, volTypeSet: %s, volDrTypeSet:%s, drHyperVolSet:%s", new Object[]{volTypeSet.toString(), ((Object)volDrTypeSet).toString(), ((Object)drHyperVolSet).toString()});
    }

    private String getAzIdentity(Map<String, Object> item, String serviceType) {
        String primaryRegionId = (String)item.get("primary_region_id");
        String primaryAzId = (String)item.get("primary_az_id");
        String secondRegionId = (String)item.get("second_region_id");
        String secondAzId = (String)item.get("second_az_id");
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType)) {
            String drSecondRegionId = (String)item.get("dr_second_region_id");
            String drSecondAzId = (String)item.get("dr_second_az_id");
            return OpenStackBasicUtil.getSortStr(new String[]{OpenStackVolTypeMapping.getMappingAzId((String)secondRegionId, (String)secondAzId), OpenStackVolTypeMapping.getMappingAzId((String)primaryRegionId, (String)primaryAzId), OpenStackVolTypeMapping.getMappingAzId((String)drSecondRegionId, (String)drSecondAzId)});
        }
        return OpenStackVolTypeMapping.getAzIdentity((String)primaryRegionId, (String)primaryAzId, (String)secondRegionId, (String)secondAzId);
    }

    private String getAzIdentityByParamAZMap(Map<String, String> azMap, String serviceType) {
        String azName = azMap.get("zoneName");
        String drAzName = azMap.get("drZoneName");
        String regionName = azMap.get("regionName");
        String drRegionName = azMap.get("drRegionName");
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType)) {
            String prodRegionDrZoneName = azMap.get("prod_region_drZoneName");
            return OpenStackBasicUtil.getSortStr(new String[]{OpenStackVolTypeMapping.getMappingAzId((String)regionName, (String)azName), OpenStackVolTypeMapping.getMappingAzId((String)drRegionName, (String)drAzName), OpenStackVolTypeMapping.getMappingAzId((String)regionName, (String)prodRegionDrZoneName)});
        }
        return OpenStackVolTypeMapping.getAzIdentity((String)regionName, (String)azName, (String)drRegionName, (String)drAzName);
    }

    public void plannedMigrationContinue(String projectId, String instanceId, Map<String, String> recoveryContext) {
        RecoveryInstanceParam recoveryInstanceParam = new RecoveryInstanceParam(projectId, instanceId, "plannedMigrationContinue").invoke();
        IRecoveryManager recoveryManager = recoveryInstanceParam.getRecoveryManager();
        String recoveryPlanId = recoveryInstanceParam.getRecoveryPlanId();
        recoveryManager.continuePlannedMigration(recoveryPlanId, recoveryContext, this.getAdminUser());
    }

    public void diasterRecovery(String projectId, String instanceId, Map<String, String> recoveryContext) {
        RecoveryInstanceParam recoveryInstanceParam = new RecoveryInstanceParam(projectId, instanceId, "diasterRecovery").invoke();
        ServiceInstance instance = recoveryInstanceParam.getInstance();
        IRecoveryManager recoveryManager = recoveryInstanceParam.getRecoveryManager();
        String recoveryPlanId = recoveryInstanceParam.getRecoveryPlanId();
        try {
            RecoveryPlan recoveryPlan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(recoveryPlanId);
            String regionUuid = recoveryPlan.getProtectGroup().getProperty("regionId");
            if (((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).checkArbitrationSwitchMode(OpenStackBasicUtil.getIdFromUuid(regionUuid))) {
                if (this.validateIsHypermetro(recoveryPlan)) {
                    throw new LegoCheckedException(1073948807L);
                }
                if (this.isCshaCsdrWithinRegion(recoveryPlan, recoveryContext)) {
                    throw new LegoCheckedException(1073949723L);
                }
            }
            recoveryManager.startDisasterRecovery(recoveryPlanId, recoveryContext, this.getAdminUser());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to diasterRecovery recoveryPlan, instanceName=" + instance.getName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to diasterRecovery recoveryPlan, instanceName=" + instance.getName()));
            ExceptionUtil.rethrowException((Exception)e, (String)"diasterRecovery recoveryPlan failed", (long)0x300001L, (String[])new String[0]);
        }
    }

    private boolean validateIsHypermetro(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            if (pg.getTemplate().getType() != 25) continue;
            return true;
        }
        return false;
    }

    private boolean isCshaCsdrWithinRegion(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (pg.getTemplate().getType() != 37) {
            return false;
        }
        return null != recoveryContext.get("recovery_region_id") && pg.getProperty("regionId").contains(recoveryContext.get("recovery_region_id"));
    }

    public void hotMigration(String projectId, String instanceId, Map<String, String> recoveryContext) {
        RecoveryInstanceParam recoveryInstanceParam = new RecoveryInstanceParam(projectId, instanceId, "hotMigration").invoke();
        ServiceInstance instance = recoveryInstanceParam.getInstance();
        IRecoveryManager recoveryManager = recoveryInstanceParam.getRecoveryManager();
        String recoveryPlanId = recoveryInstanceParam.getRecoveryPlanId();
        try {
            recoveryManager.startHotMigration(recoveryPlanId, recoveryContext, this.getAdminUser());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to hotMigration recoveryPlan, instanceName=" + instance.getName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to hotMigration recoveryPlan, instanceName=" + instance.getName()));
            ExceptionUtil.rethrowException((Exception)e, (String)"hotMigration recoveryPlan failed", (long)0x300001L, (String[])new String[0]);
        }
    }

    public void reprotect(String projectId, String instanceId, Map<String, String> recoveryContext) {
        RecoveryInstanceParam recoveryInstanceParam = new RecoveryInstanceParam(projectId, instanceId, "reprotect").invoke();
        ServiceInstance instance = recoveryInstanceParam.getInstance();
        IRecoveryManager recoveryManager = recoveryInstanceParam.getRecoveryManager();
        String recoveryPlanId = recoveryInstanceParam.getRecoveryPlanId();
        try {
            RecoveryPlan recoveryPlan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(recoveryPlanId);
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            String regionUuid = pg.getProperty("regionId");
            if ((this.validateIsHypermetro(recoveryPlan) || pg.getTemplate().getType() == 37 && "REGION_TYPE_WITHIN".equals(pg.getProperty("RECOVERY_REGION_TYPE"))) && ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).checkArbitrationSwitchMode(OpenStackBasicUtil.getIdFromUuid(regionUuid))) {
                throw new LegoCheckedException(1073948807L);
            }
            recoveryManager.reprotectRecoveryPlan(recoveryPlanId, recoveryContext, this.getAdminUser());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to reprotect recoveryPlan, instanceName=" + instance.getName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to reprotect recoveryPlan, instanceName=" + instance.getName()));
            ExceptionUtil.rethrowException((Exception)e, (String)"reprotect recoveryPlan failed", (long)0x300001L, (String[])new String[0]);
        }
    }

    private class RecoveryInstanceParam {
        private String projectId;
        private String instanceId;
        private ServiceInstance instance;
        private IRecoveryManager recoveryManager;
        private String recoveryPlanId;
        private String operationName;

        public RecoveryInstanceParam(String projectId, String instanceId, String operationName) {
            this.projectId = projectId;
            this.instanceId = instanceId;
            this.operationName = operationName;
        }

        public ServiceInstance getInstance() {
            return this.instance;
        }

        public IRecoveryManager getRecoveryManager() {
            return this.recoveryManager;
        }

        public String getRecoveryPlanId() {
            return this.recoveryPlanId;
        }

        public RecoveryInstanceParam invoke() {
            if (VerifyUtil.isEmpty((String)this.instanceId) || VerifyUtil.isEmpty((String)this.projectId)) {
                logger.error((Object)"Failed to %s .instance_id or project_id is empty.", new Object[]{this.operationName});
                throw new LegoCheckedException(1073947393L, "instance_id or project_id is empty.");
            }
            this.instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)this.instanceId));
            if (null == this.instance) {
                logger.error((Object)"Failed to %s.instance( %s ) is not exist.", new Object[]{this.operationName, this.instanceId});
                throw new LegoCheckedException(201L, "instance(" + this.instanceId + ") is not exist.");
            }
            AbstractServiceInstanceRecoveryImpl.this.checkInstanceProjectId(this.projectId, this.instance);
            logger.info((Object)"start to %s for verifing instance status instanceName=%s", new Object[]{this.operationName, this.instance.getName()});
            this.recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
            this.recoveryPlanId = this.instance.getRecoveryPlanId();
            ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup protectGroup = protectGroupService.getProtectGroupBasicInfo(this.instance.getProtectGroupId(), true);
            licenseControl.checkEnablePgCount(protectGroup);
            return this;
        }
    }
}

