/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.task.ServiceInstReprotectTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AutoReProtect
extends Thread {
    private static final Log logger = LogFactory.getInstance(AutoReProtect.class);
    private static final int CONCURRENT_NUM = 10;
    private static AutoReProtect notify = new AutoReProtect();
    private static ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private ConcurrentLinkedQueue<InstanceInfoBO> sortedQueue = new ConcurrentLinkedQueue();

    private AutoReProtect() {
    }

    public static AutoReProtect getInstance() {
        return notify;
    }

    public void addToSortedStack(List<InstanceInfoBO> sortedList) {
        this.sortedQueue.addAll(sortedList);
    }

    public ConcurrentLinkedQueue<InstanceInfoBO> getSortedQueue() {
        return this.sortedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleareSortedQueue() {
        AutoReProtect autoReProtect = this;
        synchronized (autoReProtect) {
            this.sortedQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
        while (true) {
            AutoReProtect autoReProtect;
            InstanceInfoBO instBo;
            if (VerifyUtil.isEmpty(this.sortedQueue)) {
                CommonUtil.sleep((long)5000L);
                continue;
            }
            AutoReProtect autoReProtect2 = this;
            synchronized (autoReProtect2) {
                instBo = this.sortedQueue.peek();
            }
            ServiceInstReprotectTask task = new ServiceInstReprotectTask(instBo);
            if (!this.checkServiceInst(instBo)) {
                autoReProtect = this;
                synchronized (autoReProtect) {
                    this.sortedQueue.poll();
                }
            }
            logger.debug((Object)("The task will put:" + instBo.getName()));
            task.putToExcutingQue();
            logger.debug((Object)("The task is begin: " + instBo.getRecoveryPlanId()));
            if (!ServiceInstanceHelper.getInstance().getLock(instBo.getId())) {
                logger.error((Object)("getLockfailed: " + instBo.getId()));
                task.removeFromExcutingQue();
                continue;
            }
            try {
                ServiceInstanceHelper.getInstance().changeStatus(instBo.getId(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_RUNNING);
                autoReProtect = this;
                synchronized (autoReProtect) {
                    this.sortedQueue.remove();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Change status error: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                ServiceInstanceHelper.getInstance().releaseLock(instBo.getId());
                task.removeFromExcutingQue();
                continue;
            }
            Future<?> future = threadPool.submit(task);
            if (null != future) continue;
            logger.error((Object)("the task submit error: " + instBo.getRecoveryPlanId()));
        }
    }

    private boolean checkServiceInst(InstanceInfoBO instBo) {
        try {
            ServiceInstance instance = new ServiceInstance();
            instance.setProtectGroupId(instBo.getProtectGroupId());
            instance.setName(instBo.getName());
            instance.setType(instBo.getType());
            instance.setStatus(instBo.getStatus());
            instance.setProtectType(instBo.getProtectType());
            ServiceInstanceHelper.getInstance().checkServiceInstAutoReProtect(instance);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("check checkServiceInstPoInfo for Auto Reprotect error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("OtherException: check checkServiceInstPoInfo for Auto Reprotect error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
        return true;
    }
}

