/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.arbitration.service.ArbitrationCenterHelper;
import com.huawei.ism.drm.arbitration.util.ArbProperties;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.serviceinstance.AutoDisasterRecovery;
import com.huawei.ism.drm.openstack.serviceinstance.AutoReProtect;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;

public class CheckArbitrationStatus
extends TimerTask {
    public static final int HA_ARBITRATION_STATUS_NORMAL = 0;
    public static final int HA_ARBITRATION_STATUS_CHECK = 1;
    public static final int HA_ARBITRATION_STATUS_FAILURE = 3;
    private static final Log logger = LogFactory.getInstance(CheckArbitrationStatus.class);
    private static final String ARB_FILE = File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "arb.properties";
    private static final Properties PROPS = new Properties();
    private static Map<String, Integer> timesForRecoveryMap = new HashMap<String, Integer>();
    private static Map<String, Integer> timesForReprotectMap = new HashMap<String, Integer>();
    private AutoDisasterRecovery autoDisasterRecovery = null;
    private AutoReProtect autoReProtect = null;
    public static final String MANAGEMENT_ARBITRATION_REGION_ID_KEY = "config.hcs.node.region";

    private static void setTimesForRecovery(String region, int timesForRecovery) {
        timesForRecoveryMap.put(region, timesForRecovery);
    }

    private static void setTimesForReprotect(String region, int timesForReprotect) {
        timesForReprotectMap.put(region, timesForReprotect);
    }

    @Override
    public void run() {
        ArrayList<String> isAutoExeRegion = new ArrayList<String>();
        try {
            Map<String, Boolean> isAutoExe = this.isAutoExe();
            for (Map.Entry<String, Boolean> isAutoEntry : isAutoExe.entrySet()) {
                if (!isAutoEntry.getValue().booleanValue()) {
                    logger.debug((Object)"%s auto is false", new Object[]{isAutoEntry.getKey()});
                    CheckArbitrationStatus.setTimesForRecovery(isAutoEntry.getKey(), 0);
                    CheckArbitrationStatus.setTimesForReprotect(isAutoEntry.getKey(), 0);
                    continue;
                }
                isAutoExeRegion.add(isAutoEntry.getKey());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting RegionId error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        this.checkManagementArb();
        for (String regionId : isAutoExeRegion) {
            String arbStatus;
            block12: {
                try {
                    String detail = ArbitrationCenterHelper.getInstance().getDetailStatus(regionId);
                    logger.debug((Object)"detail info: %s", new Object[]{detail});
                    JSONObject jsonObject = JSONObject.fromObject((Object)detail);
                    String isMatch = String.valueOf(jsonObject.get("isMatch"));
                    arbStatus = String.valueOf(jsonObject.get("localDcStatus"));
                    boolean cerAuthFlag = Boolean.parseBoolean(String.valueOf(jsonObject.get("cert_auth_flag")));
                    if (cerAuthFlag) {
                        AlarmReporter.restoreAlarm((long)52625462L, (String[])new String[]{regionId});
                    } else {
                        logger.error((Object)"cert auth failed");
                        AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{regionId});
                    }
                    if (!Boolean.parseBoolean(isMatch)) {
                        logger.error((Object)"the remote info is not match");
                        CheckArbitrationStatus.setTimesForRecovery(regionId, 0);
                        CheckArbitrationStatus.setTimesForReprotect(regionId, 0);
                    }
                    break block12;
                }
                catch (Exception e) {
                    logger.error((Object)"check arbStatus error: %s ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160784211993L});
                    AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{regionId});
                    CheckArbitrationStatus.setTimesForRecovery(regionId, 0);
                    CheckArbitrationStatus.setTimesForReprotect(regionId, 0);
                }
                continue;
            }
            try {
                this.operateRecoveryByArbStatus(regionId, arbStatus);
            }
            catch (Exception e) {
                logger.error((Object)"operate Recovery error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private void checkManagementArb() {
        if (Boolean.parseBoolean(PROPS.getProperty("arb.enable"))) {
            String regionId = LegoConfig.getNodeConfig().getKeyValue(MANAGEMENT_ARBITRATION_REGION_ID_KEY);
            try {
                String detail = ArbitrationCenterHelper.getInstance().getDetailStatus("");
                JSONObject jsonObject = JSONObject.fromObject((Object)detail);
                boolean cerAuthFlag = Boolean.parseBoolean(String.valueOf(jsonObject.get("cert_auth_flag")));
                if (cerAuthFlag) {
                    AlarmReporter.restoreAlarm((long)52625462L, (String[])new String[]{regionId});
                } else {
                    logger.error((Object)"Failed to verify the management arbitration certificate.");
                    AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{regionId});
                }
            }
            catch (Exception e) {
                logger.error((Object)"Management arbitration verification error: %s ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{regionId});
            }
        }
    }

    private int getHaArbitrationStatus() {
        Integer status;
        Path path = Paths.get(PathUtil.getRuntimePath(), "tmp/haArbitrationStatus");
        File file = path.toFile();
        if (!file.exists()) {
            logger.debug((Object)"server ha module heartbeat is normal");
            return 0;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty("status");
            status = NumberUtil.convertToInteger((Object)value, (int)1);
        }
        catch (IOException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            status = 1;
        }
        logger.info((Object)("server ha module status is " + status));
        return status;
    }

    private Map<String, Boolean> isAutoExe() {
        Map<String, Boolean> checkIsConfigArb = this.checkIsConfigArb();
        ICloudConfigService cloudService = (ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class);
        CloudConfig config = cloudService.getCloudConfigBy("system");
        if (null == config || null == config.getProps()) {
            return checkIsConfigArb;
        }
        for (Map.Entry<String, Boolean> entry : checkIsConfigArb.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            String autoRecoveryValue = config.getProps().getOrDefault(entry.getKey() + "_" + "system_autorecovery", "true");
            checkIsConfigArb.put(entry.getKey(), Boolean.parseBoolean(autoRecoveryValue));
        }
        return checkIsConfigArb;
    }

    private Map<String, Boolean> checkIsConfigArb() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (!this.loadProperties()) {
            logger.error((Object)"read the arb.enable property of arb.properties file fail.");
            return result;
        }
        List regionIds = ArbProperties.getInstance().getRegions();
        for (String regionId : regionIds) {
            result.put(regionId, Boolean.parseBoolean(PROPS.getProperty(regionId + ".arb.enable")));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties() {
        boolean result = true;
        FileInputStream fileInputStream = null;
        try {
            String path = new File("").getCanonicalPath();
            path = path.substring(0, path.length() - (File.separator + "LegoRuntime").length());
            File file = new File(path + ARB_FILE);
            if (!file.exists()) {
                logger.error((Object)"arb.properties file is not exist");
                boolean bl = false;
                return bl;
            }
            fileInputStream = new FileInputStream(file);
            PROPS.load(fileInputStream);
        }
        catch (IOException e) {
            result = false;
            logger.error((Object)("load arb.properties file is fail, cause by " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e2) {
                    logger.error((Object)("close load arb.properties file fileInputStream failed, cause by " + ExceptionUtil.getErrorMessage((Throwable)e2)));
                }
            }
        }
        return result;
    }

    private void operateRecoveryByArbStatus(String regionId, String arbStatus) {
        IServiceInstanceService instService = (IServiceInstanceService)ServiceLocator.getInstance().getService(IServiceInstanceService.class);
        if (OpenstackEnumDefine.ARB_STATUS_E.FAIL_REMOTE.getValue().equalsIgnoreCase(arbStatus) || OpenstackEnumDefine.ARB_STATUS_E.FAIL_LOCAL.getValue().equalsIgnoreCase(arbStatus)) {
            CheckArbitrationStatus.setTimesForReprotect(regionId, 0);
            this.doRecovery(instService, regionId, arbStatus);
        } else if (OpenstackEnumDefine.ARB_STATUS_E.OK.getValue().equalsIgnoreCase(arbStatus)) {
            logger.debug((Object)"begin auto reprotect");
            CheckArbitrationStatus.setTimesForRecovery(regionId, 0);
            this.doReprotect(instService, regionId);
        } else {
            CheckArbitrationStatus.setTimesForReprotect(regionId, 0);
            CheckArbitrationStatus.setTimesForRecovery(regionId, 0);
        }
    }

    private void doRecovery(IServiceInstanceService instService, String regionId, String arbStatus) {
        int status = this.getHaArbitrationStatus();
        if (status == 1) {
            logger.info((Object)"server is about to switch, waiting for check");
            return;
        }
        if (status == 3) {
            CheckArbitrationStatus.setTimesForRecovery(regionId, 0);
            logger.info((Object)"server is about to switch, cancel the recovery operation");
            return;
        }
        int timesForRecovery = timesForRecoveryMap.getOrDefault(regionId, 0);
        if (++timesForRecovery == 3) {
            CheckArbitrationStatus.setTimesForRecovery(regionId, 0);
            CheckArbitrationStatus.setTimesForReprotect(regionId, 0);
            if (null != this.autoReProtect) {
                this.autoReProtect.cleareSortedQueue();
            }
            if (null == this.autoDisasterRecovery) {
                this.autoDisasterRecovery = AutoDisasterRecovery.getInstance();
                this.autoDisasterRecovery.start();
            }
            instService.autoDisaterRecovery(regionId, arbStatus);
        } else {
            CheckArbitrationStatus.setTimesForRecovery(regionId, timesForRecovery);
        }
    }

    private void doReprotect(IServiceInstanceService instService, String regionId) {
        int timesForReprotect = timesForReprotectMap.getOrDefault(regionId, 0);
        if (++timesForReprotect == 3) {
            CheckArbitrationStatus.setTimesForRecovery(regionId, 0);
            CheckArbitrationStatus.setTimesForReprotect(regionId, 0);
            if (null != this.autoDisasterRecovery) {
                this.autoDisasterRecovery.cleareSortedQueue();
            }
            if (null == this.autoReProtect) {
                this.autoReProtect = AutoReProtect.getInstance();
                this.autoReProtect.start();
            }
            if (null == this.autoDisasterRecovery) {
                this.autoDisasterRecovery = AutoDisasterRecovery.getInstance();
                this.autoDisasterRecovery.start();
            }
            instService.autoReprotect(regionId);
        } else {
            CheckArbitrationStatus.setTimesForReprotect(regionId, timesForReprotect);
        }
    }
}

