/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.serviceinstance.task.RegisterSDRTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class SDRRegisterHelper {
    private static final Log logger = LogFactory.getInstance(SDRRegisterHelper.class);
    private static final String SDR_FLOATIP_KEY = "sdr.service.address";
    private static final long REGISTER_DELAY = 300000L;
    private static final long REGISTER_PERIOD = 1800000L;
    private static final String IP_KEY = "float_ip";
    private static final String SDR_CHECK_VERSION_URL = "https://float_ip:9443/v1/meterticket/version";
    private static final String VERSION_REFERENCE = "8.1.0";
    private final Map<String, SDRRegisterInfo> sdrRegisterInfoMap = new HashMap<String, SDRRegisterInfo>();

    public static SDRRegisterHelper getInstance() {
        return Singleton.INSTANCE;
    }

    private SDRRegisterHelper() {
        Timer timer = new Timer(true);
        RegisterTask registerTask = new RegisterTask();
        timer.schedule((TimerTask)registerTask, 300000L, 1800000L);
    }

    private void updateRegisterInfo() {
        String[] infos;
        LegoConfig.updateInstance();
        String sdrValue = LegoConfig.getInstance().getKeyValue(SDR_FLOATIP_KEY);
        if (VerifyUtil.isEmpty((String)sdrValue)) {
            logger.info((Object)"SDR config is empty.");
            return;
        }
        for (String info : infos = sdrValue.split(",")) {
            try {
                String[] sdrInfoProps = info.split("@");
                String regionId = sdrInfoProps[0];
                String regionInfo = sdrInfoProps[1];
                String[] ipAndService = regionInfo.split("#");
                String[] services = ipAndService[1].split("&");
                SDRRegisterInfo sdrRegisterInfo = new SDRRegisterInfo();
                sdrRegisterInfo.regionId = regionId;
                sdrRegisterInfo.sdrIp = ipAndService[0];
                sdrRegisterInfo.serviceList = Arrays.asList(services);
                this.sdrRegisterInfoMap.put(regionId, sdrRegisterInfo);
            }
            catch (Exception e) {
                logger.error((Object)"Update sdr config error. config: %s", new Object[]{info});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSDR() {
        Map<String, SDRRegisterInfo> map = this.sdrRegisterInfoMap;
        synchronized (map) {
            logger.info((Object)"registerSDR");
            this.updateRegisterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSuccess(String regionId) {
        Map<String, SDRRegisterInfo> map = this.sdrRegisterInfoMap;
        synchronized (map) {
            this.sdrRegisterInfoMap.remove(regionId);
        }
    }

    private void registerSDR(String regionId, String tokenId) {
        logger.info((Object)"Start registering SDR plugin: %s", new Object[]{regionId});
        if (!this.checkSDRVersion(regionId, tokenId)) {
            return;
        }
        SDRRegisterInfo info = this.sdrRegisterInfoMap.get(regionId);
        for (String serviceName : info.serviceList) {
            RegisterSDRTask task = new RegisterSDRTask(regionId, info.sdrIp, serviceName);
            long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
            logger.info((Object)"Register SDR plugin: %s", new Object[]{String.valueOf(taskId)});
        }
    }

    private boolean checkSDRVersion(String regionId, String tokenId) {
        SDRRegisterInfo registerInfo = this.sdrRegisterInfoMap.get(regionId);
        String url = SDR_CHECK_VERSION_URL.replace(IP_KEY, registerInfo.sdrIp);
        String respStr = ClientUtil.sendGetRequest(url, tokenId);
        JSONObject respJson = JSONObject.fromObject((Object)respStr);
        Object version = respJson.get("version");
        if (version instanceof String && !VerifyUtil.isEmpty((Object)version)) {
            return this.versionCompare((String)version) >= 0;
        }
        return false;
    }

    private int versionCompare(String version) {
        String[] subVersion = version.split("\\.");
        String[] subReference = VERSION_REFERENCE.split("\\.");
        int minSize = Math.min(subVersion.length, subReference.length);
        for (int i = 0; i < minSize; ++i) {
            if (subVersion[i].equals(subReference[i])) continue;
            return subVersion[i].compareTo(subReference[i]);
        }
        return Integer.compare(subVersion.length, subReference.length);
    }

    private class RegisterTask
    extends TimerTask {
        private RegisterTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.info((Object)"Start RegisterTask.");
                Map map = SDRRegisterHelper.this.sdrRegisterInfoMap;
                synchronized (map) {
                    OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
                    String tokenId = TokenUtil.getInstance().getTokenId(open, null);
                    for (String regionId : SDRRegisterHelper.this.sdrRegisterInfoMap.keySet()) {
                        SDRRegisterHelper.this.registerSDR(regionId, tokenId);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"RegisterTask wrong.", (Throwable)e);
            }
        }
    }

    private static class SDRRegisterInfo {
        String regionId;
        String sdrIp;
        List<String> serviceList;

        private SDRRegisterInfo() {
        }

        public String toString() {
            return "SDRRegisterInfo{regionId='" + this.regionId + '\'' + ", sdrIp='" + this.sdrIp + '\'' + ", serviceList=" + this.serviceList.toString() + '}';
        }
    }

    private static class Singleton {
        static final SDRRegisterHelper INSTANCE = new SDRRegisterHelper();

        private Singleton() {
        }
    }
}

