/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.AggregateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.HypervisorInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.serviceinstance.HypervisorCheckInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ServiceInstanceHelper {
    private static final Log logger = LogFactory.getInstance(ServiceInstanceHelper.class);
    private static Set<String> lockedInstanceSet = new HashSet<String>();
    private static ServiceInstanceHelper helper = new ServiceInstanceHelper();

    private ServiceInstanceHelper() {
    }

    public static ServiceInstanceHelper getInstance() {
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLock(String instanceId) {
        Set<String> set = lockedInstanceSet;
        synchronized (set) {
            if (lockedInstanceSet.contains(instanceId)) {
                logger.error((Object)"get instance( %s ) lock failed.", new Object[]{instanceId});
                return false;
            }
            logger.debug((Object)"get instance( %s ) lock success.", new Object[]{instanceId});
            lockedInstanceSet.add(instanceId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(String instanceId) {
        Set<String> set = lockedInstanceSet;
        synchronized (set) {
            if (lockedInstanceSet.contains(instanceId)) {
                logger.debug((Object)"release instance( %s ) lock success.", new Object[]{instanceId});
                lockedInstanceSet.remove(instanceId);
            }
        }
    }

    public ServiceInstance changeStatus(String instanceId, ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E status) {
        if (VerifyUtil.isEmpty((String)instanceId) || null == status) {
            logger.error((Object)"instanceId or status is empty.");
            throw new LegoCheckedException(1073947393L, "instanceId or status is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            logger.error((Object)"instance is empty.");
            throw new LegoCheckedException(201L, "instance is empty.");
        }
        logger.info((Object)"Change instance (%s) status from %s to %s.", new Object[]{instance.getName(), instance.getStatus(), status.getValue()});
        instance.setStatus(status.getValue());
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)instance);
            return instance;
        }
        catch (Exception e) {
            logger.error((Object)("save instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, "save instance error.", (Throwable)e);
        }
    }

    public void checkServiceInstPoInfo(ServiceInstance instance) {
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(instance.getProtectGroupId(), false);
        if (null == pg) {
            logger.error((Object)("the protectgroup is null,instanceName=" + instance.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        for (ProtectObject po : pg.getPolist()) {
            if (ProtectObjectStatusEnum.VALID.getValue() != po.getPoStatus()) {
                logger.error((Object)("po(" + po.getName() + ") is not valid.instanceName=" + instance.getName()));
                throw new LegoCheckedException(1073948909L, po.getName() + " status is invalid");
            }
            String replicaInfoStr = (String)po.getProps().get("replicationInfo");
            if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
                logger.debug((Object)("replicaInfo is empty. vm is " + po.getName()));
                continue;
            }
            logger.debug((Object)("replicaInfo:" + replicaInfoStr + ", instanceName=" + instance.getName()));
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
            if (null == replicaInfo) {
                logger.error((Object)("convert PoReplicaInfo return null, replicaInfoStr=" + replicaInfoStr + ", instanceName=" + instance.getName()));
                continue;
            }
            List pairList = replicaInfo.getPairInfos();
            if (VerifyUtil.isEmpty((Collection)pairList)) continue;
            this.checkServiceVolProtectStatus(instance, pg, po, pairList);
        }
    }

    private void checkServiceVolProtectStatus(ServiceInstance instance, ProtectGroup pg, ProtectObject po, List<PoReplicaPairInfo> pairList) {
        for (PoReplicaPairInfo pairInfo : pairList) {
            String regionUuid;
            if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
            String vmUuid = ((ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist())).getMoUuid();
            String projectUuid = (String)pg.getProps().get("projectId");
            OpenStackVM vm = OpenStackCommonUtil.getServerByUuid(projectUuid, regionUuid = (String)pg.getProps().get("regionId"), vmUuid);
            if (OpenStackCommonUtil.isBareMetalServer(vm) && OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
            logger.error((Object)("po(" + po.getName() + ") has one volume not protected.volumeName+" + pairInfo.getVolumeName() + ", instanceName=" + instance.getName()));
            throw new LegoCheckedException(1073948909L, "po(" + po.getName() + ") has one volume not protected.volumeName+" + pairInfo.getVolumeName());
        }
    }

    public void checkServiceInstAutoRecovery(ServiceInstance instance) {
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instance.getType()) && !"csha_csdr".equals(instance.getProtectType())) {
            logger.debug((Object)("The type is not hypermetro or csha+csdr: " + instance.getName()));
            return;
        }
        this.checkIsAllowedCshaCsdrAutoRecovery(instance);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue().equals(instance.getStatus())) {
            logger.debug((Object)("The status is err-failover: " + instance.getName()));
            return;
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(instance.getProtectGroupId(), false);
        if (null == pg) {
            logger.error((Object)("the protectgroup is null,instanceName=" + instance.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        this.checkAutoRecoveryWithStorage(pg);
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            this.checkAutoRecoveryWithAZHypervisor(pg);
            return;
        }
        this.checkAutoRecoveryWithHypervisor(pg);
    }

    private void checkIsAllowedCshaCsdrAutoRecovery(ServiceInstance instance) {
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(instance.getProtectGroupId(), false);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue().equals(instance.getStatus()) && PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            logger.error((Object)"instance(%s)  is between region recovery fail, not allowed to do auto disasterRecovery", new Object[]{instance.getName()});
            throw new LegoCheckedException(1073948693L);
        }
    }

    public HypervisorInfo getHypervisorInfoByVm(String regionUuid, String projUuid, OpenStackVM vm) {
        if (null == vm || VerifyUtil.isEmpty((String)vm.getHypervisorHostName())) {
            return null;
        }
        return this.getHypervisorByName(regionUuid, projUuid, vm.getHypervisorHostName());
    }

    private void checkAutoRecoveryWithStorage(ProtectGroup pg) {
        String drRegionUuid = (String)pg.getProps().get("regionId");
        String drProjUuid = (String)pg.getProps().get("projectId");
        String drReplicaCgId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drReplicaCgUuid"));
        if (37 == pg.getTemplate().getType()) {
            drReplicaCgId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProdrCgUuid"));
        }
        this.isStorageAvailableForRecovery(drRegionUuid, drProjUuid, drReplicaCgId);
    }

    public void isStorageAvailableForRecovery(String drRegionUuid, String drProjUuid, String drReplicaCgId) {
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid));
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("replicationcg_id", drReplicaCgId);
        List<VolumeReplicationInfo> replicationInfos = OpenStackCommonUtil.isCurrentFCVersionHighThan63() ? drExtendMgr.getRealtimeVolumeReplications(drRegionUuid, tokenId, drProjUuid, uriVariables) : drExtendMgr.getVolumeReplications(drRegionUuid, tokenId, drProjUuid, uriVariables, false);
        if (VerifyUtil.isEmpty(replicationInfos)) {
            return;
        }
        for (VolumeReplicationInfo replica : replicationInfos) {
            if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(replica.getStatus())) {
                logger.error((Object)("the replica(" + replica.getId() + ") in cg(" + drReplicaCgId + ")'s status is " + replica.getStatus()));
                throw new LegoCheckedException(1073948693L);
            }
            if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.INACTIVE.getValue().equals(replica.getReplicationStatus())) {
                logger.error((Object)("the replica(" + replica.getId() + ") in cg(" + drReplicaCgId + ") is not error.current status is " + replica.getReplicationStatus()));
                throw new LegoCheckedException(1073948693L);
            }
            if (this.isLocalVolWrite(replica)) continue;
            logger.error((Object)("the replica(" + replica.getId() + ") in cg(" + drReplicaCgId + ") is not localaccess.ReplicationExtendedStatus is " + replica.getReplicationExtendedStatus()));
            throw new LegoCheckedException(1073948693L);
        }
    }

    private boolean isLocalVolWrite(VolumeReplicationInfo replicationInfo) {
        String jsonStr = replicationInfo.getReplicationExtendedStatus();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        if (!json.containsKey((Object)"localaccessstatus")) {
            return false;
        }
        String accessStatus = json.getString("localaccessstatus");
        return "3".equals(accessStatus);
    }

    private void checkAutoRecoveryWithHypervisor(ProtectGroup pg) {
        String tokenId;
        HashMap<String, HypervisorCheckInfo> hypervisorInfos = new HashMap<String, HypervisorCheckInfo>();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String azName = (String)pg.getProps().get("zoneName");
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        List<OpenStackVM> vms = novaMgr.getVms(regionUuid, tokenId = TokenUtil.getInstance().getTokenId(projUuid), projUuid);
        if (VerifyUtil.isEmpty(vms)) {
            logger.error((Object)("vm in proj(" + projUuid + ") is empty."));
            throw new LegoCheckedException(1073947394L);
        }
        List<AggregateInfo> aggregates = novaMgr.getAggregateInfosByAz(regionUuid, projUuid, tokenId, azName);
        for (ProtectObject po : pg.getPolist()) {
            HypervisorCheckInfo checkInfo;
            OpenStackVM vm = this.getVmInfoFromVMList(po.getMoUuid(), vms);
            if (!hypervisorInfos.containsKey(vm.getHypervisorHostName())) {
                this.initHypervisorStates(regionUuid, projUuid, vm, hypervisorInfos, aggregates);
            }
            if (null == (checkInfo = (HypervisorCheckInfo)hypervisorInfos.get(vm.getHypervisorHostName()))) {
                logger.error((Object)("vm(" + vm.getUuid() + ")'s host(" + vm.getHypervisorHostName() + ") is not exist."));
                throw new LegoCheckedException(1073947394L);
            }
            if ("down".equals(checkInfo.getAggregateState())) continue;
            logger.error((Object)("vm(" + vm.getUuid() + ")'s hypervisor is not down:" + checkInfo.toString()));
            throw new LegoCheckedException(1073948693L);
        }
    }

    private OpenStackVM getVmInfoFromVMList(String vmUuid, List<OpenStackVM> vms) {
        for (OpenStackVM vm : vms) {
            if (!vmUuid.equals(vm.getUuid())) continue;
            return vm;
        }
        logger.error((Object)("vm is not exist:" + vmUuid));
        throw new LegoCheckedException(1073947394L);
    }

    private AggregateInfo getAggregateInfoByHostName(String hostName, List<AggregateInfo> aggregates) {
        for (AggregateInfo aggregate : aggregates) {
            if (null == aggregate.getHosts() || !aggregate.getHosts().contains(hostName)) continue;
            return aggregate;
        }
        return null;
    }

    private String getAggregateState(String regionUuid, String projUuid, AggregateInfo aggregate) {
        for (String hostName : aggregate.getHosts()) {
            HypervisorInfo hypervisor = this.getHypervisorByName(regionUuid, projUuid, hostName);
            if (null == hypervisor) {
                logger.warn((Object)("hypervisor is not exists:" + hostName));
                return "unkonwn";
            }
            if ("down".equals(hypervisor.getState())) continue;
            logger.warn((Object)("hypervisor is not down:" + hostName));
            return hypervisor.getState();
        }
        return "down";
    }

    private HypervisorInfo getHypervisorByName(String regionUuid, String projUuid, String hostName) {
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        List<HypervisorInfo> hypervisors = novaMgr.getHypervisorInfoByName(regionUuid, projUuid, tokenId, hostName);
        for (HypervisorInfo hypervisorInfo : hypervisors) {
            if (!hostName.equals(hypervisorInfo.getName())) continue;
            return hypervisorInfo;
        }
        return null;
    }

    private void initHypervisorStates(String regionUuid, String projUuid, OpenStackVM vm, Map<String, HypervisorCheckInfo> hypervisorInfos, List<AggregateInfo> aggregates) {
        HypervisorInfo hypervisor = this.getHypervisorByName(regionUuid, projUuid, vm.getHypervisorHostName());
        if (null == hypervisor) {
            logger.warn((Object)("the hypervisor not exist:" + vm.getHypervisorHostName()));
            HypervisorCheckInfo checkInfo = new HypervisorCheckInfo();
            checkInfo.setHypervisorName(vm.getHypervisorHostName());
            checkInfo.setHypervisorType("unkonwn");
            checkInfo.setHypervisorState("unkonwn");
            checkInfo.setAggregateState("unkonwn");
            hypervisorInfos.put(vm.getHypervisorHostName(), checkInfo);
            return;
        }
        HypervisorCheckInfo checkInfo = new HypervisorCheckInfo();
        checkInfo.setHypervisorName(hypervisor.getName());
        checkInfo.setHypervisorType(hypervisor.getHypervisorType());
        checkInfo.setHypervisorState(hypervisor.getState());
        hypervisorInfos.put(hypervisor.getName(), checkInfo);
        if ("FusionCompute".equals(hypervisor.getHypervisorType())) {
            checkInfo.setAggregateState(hypervisor.getState());
        } else {
            AggregateInfo aggregate = this.getAggregateInfoByHostName(hypervisor.getName(), aggregates);
            if (null == aggregate) {
                logger.warn((Object)("vm'host(" + vm.getHypervisorHostName() + ") is not in this az(" + vm.getAzName() + ")"));
                checkInfo.setAggregateName("unkonwn");
                checkInfo.setAggregateState("unkonwn");
                return;
            }
            String state = this.getAggregateState(regionUuid, projUuid, aggregate);
            checkInfo.setAggregateName(aggregate.getName());
            checkInfo.setAggregateState(state);
            for (String hostName : aggregate.getHosts()) {
                if (hypervisorInfos.containsKey(hostName)) continue;
                HypervisorCheckInfo othorCheckInfo = new HypervisorCheckInfo();
                othorCheckInfo.setHypervisorName(hostName);
                othorCheckInfo.setHypervisorType(hypervisor.getHypervisorType());
                othorCheckInfo.setAggregateName(aggregate.getName());
                othorCheckInfo.setAggregateState(state);
                hypervisorInfos.put(hostName, othorCheckInfo);
            }
        }
    }

    private void checkAutoRecoveryWithAZHypervisor(ProtectGroup pg) {
        String tokenId;
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String azName = (String)pg.getProps().get("zoneName");
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        List<HypervisorInfo> list = novaMgr.getHypervisorInfoByAz(regionUuid, projUuid, tokenId = TokenUtil.getInstance().getTokenId(projUuid), azName);
        if (VerifyUtil.isEmpty(list)) {
            logger.error((Object)("AZ(" + azName + ") Hypervisor is empty."));
            throw new LegoCheckedException(1073947394L);
        }
        for (HypervisorInfo visor : list) {
            Map watcherHostStatus = visor.getWatcherHostStatus();
            if (VerifyUtil.isEmpty((Map)watcherHostStatus)) {
                logger.error((Object)"WatcherHostStatus is empty.");
                throw new LegoCheckedException(1073947394L);
            }
            for (Map.Entry status : watcherHostStatus.entrySet()) {
                String value = (String)status.getValue();
                if ("down".equals(value) || "unknown".equals(value)) continue;
                logger.error((Object)("hypervisor is not down/unknown:" + visor.toString()));
                throw new LegoCheckedException(1073948693L);
            }
        }
    }

    public void checkServiceInstAutoReProtect(ServiceInstance instance) {
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(instance.getProtectGroupId(), false);
        if (null == pg) {
            logger.error((Object)"the protectgroup is null,instanceName=%s", new Object[]{instance.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        if (PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            logger.error((Object)"instance(%s)  is between region recovery, not allowed to do auto reprotect", new Object[]{instance.getName()});
            throw new LegoCheckedException(1073948693L);
        }
        String drRegionUuid = (String)pg.getProps().get("regionId");
        String drProjUuid = (String)pg.getProps().get("projectId");
        String drReplicaCgId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drReplicaCgUuid"));
        if (37 == pg.getTemplate().getType()) {
            drReplicaCgId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProdrCgUuid"));
        }
        this.isStorageAvailableForReProtect(drRegionUuid, drProjUuid, drReplicaCgId);
    }

    public void isStorageAvailableForReProtect(String drRegionUuid, String drProjUuid, String drReplicaCgId) {
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid));
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("replicationcg_id", drReplicaCgId);
        List<VolumeReplicationInfo> replicationInfos = drExtendMgr.getVolumeReplications(drRegionUuid, tokenId, drProjUuid, uriVariables, false);
        if (VerifyUtil.isEmpty(replicationInfos)) {
            return;
        }
        for (VolumeReplicationInfo replica : replicationInfos) {
            if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(replica.getStatus())) {
                logger.error((Object)("the replica(" + replica.getId() + ") in cg(" + drReplicaCgId + ")'s status is " + replica.getStatus()));
                throw new LegoCheckedException(1073948693L);
            }
            List<String> availableRepStatus = Arrays.asList(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue(), OpenstackEnumDefine.REPLICATION_REP_STATUS_E.INACTIVE.getValue(), OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue());
            if (availableRepStatus.contains(replica.getReplicationStatus())) continue;
            logger.error((Object)("the hyperReplica(" + replica.getId() + ") in cg(" + drReplicaCgId + ") is not normal.current status is " + replica.getReplicationStatus()));
            throw new LegoCheckedException(1073948693L);
        }
    }
}

