/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.ServiceInstanceBackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.RecoverySettingBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VerifyServerResultBO;
import com.huawei.ism.drm.openstack.sdk.bo.VmInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VMFlavor;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.sdk.struct.Project;
import com.huawei.ism.drm.openstack.sdk.struct.Region;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceModifyImpl;
import com.huawei.ism.drm.openstack.serviceinstance.ProjectInfo;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VmChecker;
import com.huawei.ism.drm.openstack.serviceinstance.task.AddVolumesToVmBackTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.CheckInstanceConfigTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.CreateServerTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.DelVolumesFromVmBackTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.DeleteInstanceTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.DeleteServerTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.UpgradeInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService", Desc="", Interface=IServiceInstanceService.class)
public class ServiceInstanceServiceImpl
extends AbstractServiceInstanceModifyImpl {
    private static final Log logger = LogFactory.getInstance(ServiceInstanceServiceImpl.class);
    private static final List<String> HYPER_ALLOWDELETE_STATUS = Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_DELETE.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.MAINTAIN.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_MODIFY_TYPE.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_FAILED.getValue());
    private static final List<String> REPLICATION_ALLOWDELETE_STATUS = Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_DELETE.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_COMPLETED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.MAINTAIN.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_MODIFY_TYPE.getValue());
    private static final int MONITORINTERVAL = 2;
    private static final Object SYN_OBJ = new Object();

    public String deleteServiceInstance(String projectId, String instanceId, ExtendParamInfo extendParam) {
        if (VerifyUtil.isEmpty((String)instanceId)) {
            logger.error((Object)"instance_id is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        this.checkInstanceProjectId(projectId, instance);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        List<String> allowdList = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType) ? REPLICATION_ALLOWDELETE_STATUS : HYPER_ALLOWDELETE_STATUS;
        if (!allowdList.contains(instance.getStatus())) {
            logger.error((Object)("instance name " + instance.getName() + ", instance id=" + instance.getId() + " status is not allow delete,status: " + instance.getStatus()));
            throw new LegoCheckedException(1073948693L, "delete instance(" + instanceId + ") error, because its status is " + instance.getStatus() + ".");
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue().equals(instance.getStatus()) || ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue().equals(instance.getStatus())) {
            String primaryReplicaStatus;
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(serviceType)) {
                primaryReplicaStatus = OpenStackCommonUtil.getVolumeReplicationCgInfo(pg, true, new int[0]).getReplicationStatus();
                if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(primaryReplicaStatus)) {
                    logger.error((Object)("instance name " + instance.getName() + ", instance id=" + instance.getId() + " status is not allow delete,status: " + instance.getStatus() + "primaryReplicaStatus is : " + primaryReplicaStatus));
                    throw new LegoCheckedException(1073948693L, "delete instance(" + instanceId + ") error, because its status is " + instance.getStatus() + "its primaryReplicaStatus is " + primaryReplicaStatus);
                }
            }
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType) && PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
                primaryReplicaStatus = OpenStackCommonUtil.getVolumeReplicaCgInfoForHyperMetro(pg, true).getReplicationStatus();
                if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(primaryReplicaStatus)) {
                    logger.error((Object)("instance name " + instance.getName() + ", instance id=" + instance.getId() + " status is not allow delete CSHA+CSDR not support delete within region recovery,status: " + instance.getStatus() + "primaryReplicaStatus is : " + primaryReplicaStatus));
                    throw new LegoCheckedException(1073948693L, "delete instance(" + instanceId + ") error, because its status is " + instance.getStatus() + "its primaryReplicaStatus is " + primaryReplicaStatus);
                }
            }
        }
        Map newProps = pg.getProps();
        newProps.put("before_delete_instance_status", instance.getStatus());
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(pg.getUuid(), newProps);
        if (null != extendParam && extendParam.isCheck()) {
            return null;
        }
        DeleteInstanceTask task = new DeleteInstanceTask(projectId, serviceType, instance.getId(), instance.getName());
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, pg.getName(), serviceType, projectId, (String)pg.getProps().get("regionId"));
        this.updateTaskInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_INSTANCE, extendParam, task, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    private boolean isVmInInstance(String vmUuid) {
        HashSet<String> vmUuids = new HashSet<String>();
        vmUuids.add(vmUuid);
        return this.checkPoExists(vmUuids);
    }

    public String checkServiceInstance(String projectId, String instanceId) {
        if (VerifyUtil.isEmpty((String)instanceId)) {
            logger.error((Object)"Failed to check serviceInstance.instance_id is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        this.checkInstanceProjectId(projectId, instance);
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instance.getStatus())) {
            logger.error((Object)("Failed to check serviceInstance.instance status is not normal,statu: " + instance.getStatus()));
            throw new LegoCheckedException(1073948693L, "delete instance(" + instanceId + ") error, because its status is " + instance.getStatus() + ".");
        }
        CheckInstanceConfigTask task = new CheckInstanceConfigTask(instance, null, true);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    public String addVolumesToVm(String projectId, String instanceId, String serverId, Set<ProtectedVolumeInfo> addVolumes, ExtendParamInfo extendParam) {
        return OpenstackCache.run(() -> {
            this.checkAddVolumeParam(instanceId, serverId, addVolumes);
            ServiceInstance instance = this.checkInstance(projectId, instanceId);
            String protectGroupId = instance.getProtectGroupId();
            IProtectGroupService groupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup protectGroup = groupService.getProtectGroupByID(protectGroupId, false);
            if (null == protectGroup) {
                logger.error((Object)("the protectgroup is empty,instanceId=" + instance.getId() + " protectGroupId=" + protectGroupId));
                throw new LegoCheckedException(1073947393L, "cant find instance data");
            }
            HashSet<String> serverIdSet = new HashSet<String>();
            serverIdSet.add(serverId);
            ProtectObject po = new ArrayList<ProtectObject>(this.checkServerExist(protectGroupId, serverIdSet)).get(0);
            String projectUuid = (String)protectGroup.getProps().get("projectId");
            String regionUuid = (String)protectGroup.getProps().get("regionId");
            String drRegionUuid = (String)protectGroup.getProps().get("drRegionId");
            OpenstackCache.preloadVmAndVolume(protectGroup);
            String azName = (String)protectGroup.getProps().get("zoneName");
            String srcAzName = (String)protectGroup.getProps().get("originalAvailableZone");
            String serviceType = (String)protectGroup.getProps().get("serviceInstanceType");
            this.checkAzName(azName, srcAzName, serviceType, "add volumes to server(" + instanceId + ") error, because the instance do not in src available zone.");
            this.checkRegion(protectGroup);
            this.checkVolumesExist(regionUuid, projectUuid, serverId, addVolumes);
            this.checkVolumeIsShareOrScsi(serviceType, addVolumes, regionUuid, projectUuid);
            this.checkParamForAddVolume(protectGroup, addVolumes, regionUuid, serverId, projectUuid);
            this.updateProtectedVolDrVolType(instance.getType(), addVolumes, protectGroup);
            this.addVolumeDrHyperVolumeType(addVolumes, protectGroup, po);
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instance.getType()) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instance.getType())) {
                drRegionUuid = regionUuid;
            }
            this.checkAddVols(regionUuid, drRegionUuid, projectUuid, addVolumes, protectGroup);
            HashSet<String> addVolumeStatus = new HashSet<String>();
            addVolumeStatus.add(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus());
            addVolumeStatus.add(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.CONFIGING.getStatus());
            if (!VerifyUtil.isEmpty((Collection)addVolumes) && !this.checkVolumeStatus(po, addVolumes, addVolumeStatus)) {
                logger.error((Object)"will add volume staus is invalid");
                throw new LegoCheckedException(1073948416L);
            }
            if (null != extendParam && extendParam.isCheck()) {
                return null;
            }
            this.checkLicense(protectGroup);
            AddVolumesToVmBackTask task = new AddVolumesToVmBackTask(projectId, serviceType, instanceId, protectGroup, serverId, addVolumes);
            task.setServiceType(instance.getType());
            OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, protectGroup.getName(), serviceType, projectId, regionUuid);
            this.updateTaskInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_VOLUMES, extendParam, task, inst, instance);
            long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
            return String.valueOf(taskId);
        });
    }

    private void checkAddVolumeParam(String instanceId, String serverId, Set<ProtectedVolumeInfo> addVolumes) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty((String)serverId) || VerifyUtil.isEmpty(addVolumes)) {
            logger.info((Object)"instance_id or server_id or volumes is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id or server_id or volumes is empty.");
        }
    }

    private void checkVolumeIsShareOrScsi(String serviceType, Set<ProtectedVolumeInfo> addVolumes, String regionUuid, String projectUuid) {
        if (this.hasVolumeDuplicated(addVolumes)) {
            logger.error((Object)"will add or delete volumes are duplicated");
            throw new LegoCheckedException(1073948115L);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(serviceType)) {
            HashSet<String> volumeIdSet = new HashSet<String>();
            for (ProtectedVolumeInfo volumeInfo : addVolumes) {
                volumeIdSet.add(volumeInfo.getVolumeId());
            }
            Set<String> shareOrScsiId = VmChecker.getVolumeShareOrScsiId(regionUuid, projectUuid, volumeIdSet);
            if (!VerifyUtil.isEmpty(shareOrScsiId)) {
                logger.error((Object)"The Volumes is share or SCSI type, can't operate it.");
                throw new LegoCheckedException(1073948138L);
            }
        }
    }

    private void addVolumeDrHyperVolumeType(Set<ProtectedVolumeInfo> addVolumes, ProtectGroup protectGroup, ProtectObject po) {
        if (34 != protectGroup.getTemplate().getType() && 37 != protectGroup.getTemplate().getType()) {
            return;
        }
        if (VerifyUtil.isEmpty(addVolumes)) {
            logger.error((Object)"addVolumes is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String serviceType = protectGroup.getProperty("serviceInstanceType");
        String regionUuid = (String)protectGroup.getProps().get("regionId");
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        addPos.add(po);
        String azIdentity = this.getAzIdentity(protectGroup, serviceType);
        this.updateProtectGroupDrVolType(serviceType, addPos, azIdentity, regionUuid, protectGroup);
        JSONArray volArr = (JSONArray)po.getProperty("volumeConfig", JSONArray.class);
        block0: for (ProtectedVolumeInfo volumeInfo : addVolumes) {
            for (int i = 0; i < volArr.size(); ++i) {
                JSONObject jsonObject = volArr.getJSONObject(i);
                if (!volumeInfo.getVolumeId().equals(jsonObject.getString("volumeId"))) continue;
                volumeInfo.setDrHyperVolumeType(jsonObject.getString("drHyperVolumeType"));
                volumeInfo.setDrVolumeType(jsonObject.getString("drVolumeType"));
                continue block0;
            }
        }
    }

    private void checkParamForAddVolume(ProtectGroup protectGroup, Set<ProtectedVolumeInfo> addVolumes, String regionUuid, String serverId, String projectUuid) {
        this.checkSharedVolumesWhenAddVolume(protectGroup, addVolumes);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String vmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, serverId);
        if (this.isSingleVmExistRollBackTask(vmUuid)) {
            logger.error((Object)"The server has rollback task, can't operate it.");
            throw new LegoCheckedException(1073948118L);
        }
        this.refactorVolumesInfo(openstackUuid, addVolumes);
        OpenStackCommonUtil.updateProtectedVolType(regionUuid, projectUuid, addVolumes);
    }

    public String delVolumesFromVm(String projectId, String instanceId, String serverId, Set<ProtectedVolumeInfo> delVolumes, ExtendParamInfo extendParam) {
        this.checkAddVolumeParam(instanceId, serverId, delVolumes);
        ServiceInstance instance = this.checkInstance(projectId, instanceId);
        String protectGroupId = instance.getProtectGroupId();
        IProtectGroupService groupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = groupService.getProtectGroupByID(protectGroupId, false);
        if (null == protectGroup) {
            logger.error((Object)("the protectgroup is empty,instanceId=" + instance.getId() + " protectGroupId=" + protectGroupId));
            throw new LegoCheckedException(1073947393L, "cant find instance data");
        }
        String projectUuid = (String)protectGroup.getProps().get("projectId");
        String azName = (String)protectGroup.getProps().get("zoneName");
        String srcAzName = (String)protectGroup.getProps().get("originalAvailableZone");
        String serviceType = (String)protectGroup.getProps().get("serviceInstanceType");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String srcRegionId = (String)protectGroup.getProps().get("originalAvailableRegion");
        String protectType = instance.getProtectType();
        if (OpenStackCommonUtil.shouldCheckWhetherNotSwitch(serviceType, protectType) && (VerifyUtil.isEmpty((String)srcAzName) || !srcAzName.equals(azName))) {
            throw new LegoCheckedException(1073948927L, "delete volumes from vm in instance(" + instanceId + ") error, because the instance do not in src available zone.").log(logger);
        }
        this.checkCshaCsdrParam(regionId, srcRegionId, azName, srcAzName, protectType);
        HashSet<String> serverIdSet = new HashSet<String>();
        serverIdSet.add(serverId);
        ProtectObject po = new ArrayList<ProtectObject>(this.checkServerExist(protectGroupId, serverIdSet)).get(0);
        String regionUuid = (String)protectGroup.getProps().get("regionId");
        if (this.hasVolumeDuplicated(delVolumes)) {
            logger.error((Object)"will add or delete volumes are duplicated");
            throw new LegoCheckedException(1073948115L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String vmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, serverId);
        if (this.isSingleVmExistRollBackTask(vmUuid)) {
            logger.error((Object)"The server has rollback task, can't operate it.");
            throw new LegoCheckedException(1073948118L);
        }
        this.refactorVolumesInfo(openstackUuid, delVolumes);
        HashSet<String> delVolumeStatus = new HashSet<String>();
        delVolumeStatus.add(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.REMOVED.getStatus());
        delVolumeStatus.add(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.RELEASING.getStatus());
        OpenStackVM vm = OpenStackCommonUtil.getServerById(projectUuid, regionUuid, serverId);
        if (OpenStackCommonUtil.isBareMetalServer(vm)) {
            delVolumeStatus.add(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus());
        }
        if (!this.checkVolumeStatus(po, delVolumes, delVolumeStatus)) {
            logger.error((Object)"will delete volume staus is invalid");
            throw new LegoCheckedException(1073948416L);
        }
        this.checkProtectedHaveVolumes(protectGroup, delVolumes);
        if (null != extendParam && extendParam.isCheck()) {
            return null;
        }
        DelVolumesFromVmBackTask task = new DelVolumesFromVmBackTask(projectId, serviceType, instanceId, protectGroup, serverId, delVolumes);
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, protectGroup.getName(), serviceType, projectId, regionUuid);
        this.updateTaskInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_VOLUMES, extendParam, task, inst, instance);
        task.setServiceType(instance.getType());
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    private void checkCshaCsdrParam(String regionId, String srcRegionId, String azName, String srcAzName, String protectType) {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue().equals(protectType) && regionId.equals(srcRegionId) && !azName.equals(srcAzName)) {
            throw new LegoCheckedException(1073948927L, "delete volumes from vm in instance error, because the instance do not in src available zone.").log(logger);
        }
    }

    private void checkProtectedHaveVolumes(ProtectGroup protectGroup, Set<ProtectedVolumeInfo> delVolumes) {
        List<ProtectObject> objs = this.checkHaveProtectedVolumes(protectGroup, delVolumes);
        if (!objs.isEmpty()) {
            ArrayList projectNames = new ArrayList();
            objs.forEach(protectObject -> projectNames.add(protectObject.getName()));
            logger.error((Object)("the protectObj will  haven't protected vol" + projectNames));
            throw new LegoCheckedException(1073948139L, projectNames.toArray(new String[projectNames.size()]), "remove volume protect failed.");
        }
    }

    private ServiceInstance checkInstance(String projectId, String instanceId) {
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            logger.info((Object)("instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        this.checkInstanceProjectId(projectId, instance);
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instance.getStatus())) {
            logger.info((Object)("update volumes error, because instance( instance_id = " + instanceId + ")status is " + instance.getStatus() + "."));
            throw new LegoCheckedException(1073948693L, "update volumes error, because instance( instance_id = " + instanceId + ")status is " + instance.getStatus() + ".");
        }
        return instance;
    }

    private void checkAddVols(String regionUuid, String drRegionUuid, String projectUuid, Set<ProtectedVolumeInfo> addVolumes, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty(addVolumes)) {
            logger.error((Object)"the params is empty");
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<String> srcVolTypeSet = new HashSet<String>();
        HashSet<String> drVolTypeSet = new HashSet<String>();
        HashSet<String> drHyperVolTypeSet = new HashSet<String>();
        this.addProtectedVolType(pg, srcVolTypeSet, drVolTypeSet, drHyperVolTypeSet);
        HashMap<String, String> addVolumesMap = new HashMap<String, String>();
        this.analysisAddVolumes(srcVolTypeSet, drVolTypeSet, addVolumesMap, addVolumes);
        if (!this.checkVolTypeFromSameDev(regionUuid, projectUuid, srcVolTypeSet) || !this.checkVolTypeFromSameDev(drRegionUuid, projectUuid, drVolTypeSet)) {
            logger.error((Object)"volume types are not from the same dev");
            throw new LegoCheckedException(1073948415L);
        }
        if (!this.isRealVolumesType(regionUuid, projectUuid, addVolumesMap)) {
            logger.error((Object)"volume types are not really");
            throw new LegoCheckedException(1073948116L);
        }
    }

    private void addProtectedVolType(ProtectGroup pg, Set<String> srcVolTypeSet, Set<String> drVolTypeSet, Set<String> drHyperVolTypeSet) {
        Set pos = pg.getPolist();
        for (ProtectObject po : pos) {
            String replicaStr;
            PoReplicaInfo replicaInfo;
            String status;
            if (34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) {
                String hyperMetorRpliaStr = (String)po.getProps().get("hypermetor_replicationInfo");
                PoReplicaInfo hyperMetorReplicaInfo = JsonUtil.jsonToBean(hyperMetorRpliaStr, PoReplicaInfo.class);
                if (null == hyperMetorReplicaInfo) {
                    logger.error((Object)("convert PoReplicaInfo return null, hyperMetorReplicaInfo" + hyperMetorRpliaStr));
                    throw new LegoCheckedException(0x300001L);
                }
                List hyperMetorPairList = hyperMetorReplicaInfo.getPairInfos();
                for (PoReplicaPairInfo pairInfo : hyperMetorPairList) {
                    status = pairInfo.getVolumeStatus();
                    if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(status) || OpenstackEnumDefine.VOL_PROTECT_STATUS_E.CONFIGING.getStatus().equals(status)) continue;
                    drHyperVolTypeSet.add(pairInfo.getDrVolumeType());
                    break;
                }
            }
            if (null == (replicaInfo = JsonUtil.jsonToBean(replicaStr = (String)po.getProps().get("replicationInfo"), PoReplicaInfo.class))) {
                logger.error((Object)("convert PoReplicaInfo return null, replicaStr=" + replicaStr));
                throw new LegoCheckedException(0x300001L);
            }
            List pairList = replicaInfo.getPairInfos();
            for (PoReplicaPairInfo pairInfo : pairList) {
                status = pairInfo.getVolumeStatus();
                if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(status) || OpenstackEnumDefine.VOL_PROTECT_STATUS_E.CONFIGING.getStatus().equals(status)) continue;
                srcVolTypeSet.add(pairInfo.getVolumeType());
                drVolTypeSet.add(pairInfo.getDrVolumeType());
                return;
            }
        }
    }

    private void analysisAddVolumes(Set<String> srcVolTypeSet, Set<String> drVolTypeSet, Map<String, String> addVolumesMap, Set<ProtectedVolumeInfo> addVolumes) {
        if (!VerifyUtil.isEmpty(addVolumes)) {
            for (ProtectedVolumeInfo addVolume : addVolumes) {
                String volumeType = addVolume.getVolumeType();
                srcVolTypeSet.add(volumeType);
                drVolTypeSet.add(addVolume.getDrVolumeType());
                addVolumesMap.put(addVolume.getVolumeId(), volumeType);
            }
        }
    }

    private boolean checkVolumeStatus(ProtectObject po, Set<ProtectedVolumeInfo> volumes, Set<String> statusSet) {
        String replicaStr = (String)po.getProps().get("replicationInfo");
        if (VerifyUtil.isEmpty((String)replicaStr)) {
            return false;
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
        if (null == replicaInfo) {
            logger.error((Object)("convert PoReplicaInfo return null, replicaStr=" + replicaStr));
            throw new LegoCheckedException(0x300001L);
        }
        HashMap<String, PoReplicaPairInfo> pairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
            pairInfoMap.put(pairInfo.getVolumeUuid(), pairInfo);
        }
        for (ProtectedVolumeInfo protectVolume : volumes) {
            if (!pairInfoMap.keySet().contains(protectVolume.getVolumeId())) {
                return false;
            }
            String volumeStatus = ((PoReplicaPairInfo)pairInfoMap.get(protectVolume.getVolumeId())).getVolumeStatus();
            if (statusSet.contains(volumeStatus)) continue;
            return false;
        }
        return true;
    }

    private List<ProtectObject> checkHaveProtectedVolumes(ProtectGroup protectGroup, Set<ProtectedVolumeInfo> volumes) {
        ArrayList<ProtectObject> objs = new ArrayList<ProtectObject>();
        for (ProtectObject po : protectGroup.getPolist()) {
            String replicaStr = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
            if (null == replicaInfo) {
                logger.error((Object)("convert PoReplicaInfo return null, replicaStr=" + replicaStr));
                throw new LegoCheckedException(0x300001L);
            }
            HashSet pairUuid = new HashSet();
            HashSet willDelVolUuid = new HashSet();
            replicaInfo.getPairInfos().stream().filter(pairInfo -> OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())).map(PoReplicaPairInfo::getVolumeUuid).forEach(pairUuid::add);
            volumes.forEach(volume -> willDelVolUuid.add(volume.getVolumeId()));
            Set protectedVols = pairUuid.stream().filter(item -> !willDelVolUuid.contains(item)).collect(Collectors.toSet());
            if (!protectedVols.isEmpty()) continue;
            objs.add(po);
        }
        return objs;
    }

    private boolean hasVolumeDuplicated(Set<ProtectedVolumeInfo> volumes) {
        HashSet<String> uuidSet = new HashSet<String>();
        for (ProtectedVolumeInfo volume : volumes) {
            uuidSet.add(volume.getVolumeId());
        }
        return uuidSet.size() != volumes.size();
    }

    private void refactorVolumesInfo(String openstackUuid, Set<ProtectedVolumeInfo> volumes) {
        if (VerifyUtil.isEmpty(volumes)) {
            return;
        }
        for (ProtectedVolumeInfo volumeInfo : volumes) {
            String id = volumeInfo.getVolumeId();
            String uuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, id);
            volumeInfo.setVolumeId(uuid);
        }
    }

    public String deleteServerInServiceInstance(String projectId, String instanceId, Set<String> serverIdSet, ExtendParamInfo extendParam) {
        if (VerifyUtil.isEmpty((String)instanceId)) {
            logger.error((Object)"instance_id is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id is empty.");
        }
        if (VerifyUtil.isEmpty(serverIdSet)) {
            logger.error((Object)"serverIdSet is empty.");
            throw new LegoCheckedException(1073947393L, "server_id is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            logger.error((Object)("instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        if (VerifyUtil.isEmpty((String)instance.getProtectGroupId())) {
            logger.error((Object)("server (" + serverIdSet + "@" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "server (" + serverIdSet + "@" + instanceId + ") is not exist.");
        }
        this.checkInstanceProjectId(projectId, instance);
        Set<ProtectObject> delPos = this.checkServerExist(instance.getProtectGroupId(), serverIdSet);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String azName = (String)pg.getProps().get("zoneName");
        String srcAzName = (String)pg.getProps().get("originalAvailableZone");
        String regionId = (String)pg.getProps().get("regionId");
        String srcRegionId = (String)pg.getProps().get("originalAvailableRegion");
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        String protectType = instance.getProtectType();
        if (OpenStackCommonUtil.shouldCheckWhetherNotSwitch(serviceType, protectType) && (VerifyUtil.isEmpty((String)srcAzName) || !srcAzName.equals(azName))) {
            logger.error((Object)("delete servers to instance(" + instanceId + ") error, because the instance do not in src available zone."));
            throw new LegoCheckedException(1073948927L, "delete servers to instance(" + instanceId + ") error, because the instance do not in src available zone.");
        }
        this.checkCshaCsdrParam(regionId, srcRegionId, azName, srcAzName, protectType);
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instance.getStatus())) {
            logger.error((Object)("delete server(" + serverIdSet + "@" + instanceId + ") error, because its status is " + instance.getStatus() + "."));
            throw new LegoCheckedException(1073948693L, "delete server(" + serverIdSet + "@" + instanceId + ") error, because its status is " + instance.getStatus() + ".");
        }
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            this.checkSharedDelServer(pg, delPos);
        }
        if (null != extendParam && extendParam.isCheck()) {
            return null;
        }
        DeleteServerTask task = new DeleteServerTask(projectId, serviceType, instance.getId(), instance.getName(), serverIdSet);
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, pg.getName(), serviceType, projectId, (String)pg.getProps().get("regionId"));
        this.updateTaskInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_SERVERS, extendParam, task, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    private void checkSharedDelServer(ProtectGroup pg, Set<ProtectObject> delPos) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        HashSet<ProtectObject> currentPoList = new HashSet<ProtectObject>();
        for (ProtectObject po : pg.getPolist()) {
            boolean delContain = false;
            for (ProtectObject delPo : delPos) {
                if (!delPo.getMoUuid().equals(po.getMoUuid())) continue;
                delContain = true;
                break;
            }
            if (delContain) continue;
            currentPoList.add(po);
        }
        HashSet<ProtectObject> poList = new HashSet<ProtectObject>();
        for (ProtectObject po : delPos) {
            if (ProtectObjectStatusEnum.VALID.getValue() != po.getPoStatus()) continue;
            poList.add(po);
        }
        OpenstackCache.run(() -> {
            OpenstackCache.preloadVmAndVolume(new Project(new Region(regionUuid), projectUuid));
            return this.checkSharedVolums(regionUuid, projectUuid, currentPoList, poList, true);
        });
    }

    private void checkParams(String instanceId, Set<ProtectObject> addPos) {
        if (VerifyUtil.isEmpty((String)instanceId)) {
            logger.info((Object)"Failed to add server to ServiceInstance.instance_id is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id is empty.");
        }
        if (VerifyUtil.isEmpty(addPos)) {
            logger.info((Object)"Failed to add server to ServiceInstance.add servers is empty.");
            throw new LegoCheckedException(1073947393L, "add servers is empty.");
        }
    }

    public String addServerToServiceInstance(String projectId, String instanceId, Set<ProtectObject> addPos, ExtendParamInfo extendParam) {
        this.checkParams(instanceId, addPos);
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance || VerifyUtil.isEmpty((String)instance.getProtectGroupId())) {
            logger.error((Object)("Failed to add server to ServiceInstance.instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        this.checkInstanceProjectId(projectId, instance);
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instance.getStatus())) {
            logger.error((Object)("add servers to instance(" + instanceId + ") error, because its status is " + instance.getStatus() + " not normal status. instanceName=" + instance.getName()));
            throw new LegoCheckedException(1073948693L, "add servers to instance(" + instanceId + ") error, because its status is " + instance.getStatus() + ".");
        }
        FusionSphereOpenStack openstack = this.getOpenstack();
        String openstackUuid = openstack.getUuid();
        this.refactorPos(addPos, openstackUuid);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String azName = (String)pg.getProps().get("zoneName");
        String srcAzName = (String)pg.getProps().get("originalAvailableZone");
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        this.checkAzName(azName, srcAzName, serviceType, "add servers to instance(" + instanceId + ") error, because the instance do not in src available zone.");
        this.checkRegion(pg);
        this.checkLicense(pg);
        if (null != extendParam && extendParam.isCheck()) {
            return OpenstackCache.run(() -> {
                this.checkAddServerParam(instanceId, addPos);
                return null;
            });
        }
        CreateServerTask task = new CreateServerTask(projectId, serviceType, instance.getId(), instance.getName(), addPos);
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, pg.getName(), serviceType, projectId, (String)pg.getProps().get("regionId"));
        this.updateTaskInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_SERVERS, extendParam, task, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    private void checkRegion(ProtectGroup pg) {
        if ((34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) && OpenStackBasicUtil.isCsdrVhaMode(pg)) {
            logger.error((Object)("vha+csdr after reprotect not support add po or add vol opt, origional region uuid:" + pg.getProperty("originalAvailableRegion") + " current region uuid:" + pg.getProperty("regionId") + ",protectGroupName=" + pg.getName()));
            throw new LegoCheckedException(1073948147L);
        }
    }

    private void addPoVhaVolumeType(Set<ProtectObject> addPos, ProtectGroup pg) {
        int i;
        if (34 != pg.getTemplate().getType()) {
            return;
        }
        if (addPos == null) {
            logger.error((Object)"addPos is null");
            throw new LegoCheckedException(1073947393L);
        }
        String hyperVolumeType = null;
        block0: for (ProtectObject protectObject : pg.getPolist()) {
            JSONArray jsonArray = JSONArray.fromObject(protectObject.getProps().get("volumeConfig"));
            for (i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (VerifyUtil.isEmpty((String)jsonObject.getString("drHyperVolumeType"))) continue;
                hyperVolumeType = jsonObject.getString("drHyperVolumeType");
                continue block0;
            }
        }
        if (VerifyUtil.isEmpty(hyperVolumeType)) {
            logger.error((Object)"addPos not match hyperDrVolumeType");
            throw new LegoCheckedException(1073947393L);
        }
        for (ProtectObject po : addPos) {
            JSONArray volConfigArray = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            for (i = 0; i < volConfigArray.size(); ++i) {
                JSONObject volJson = volConfigArray.getJSONObject(i);
                volJson.put((Object)"drHyperVolumeType", (Object)hyperVolumeType);
            }
            po.setProperty("volumeConfig", (Object)volConfigArray.toString());
        }
    }

    public void checkAddServerParam(String instanceId, Set<ProtectObject> addPos) {
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance || VerifyUtil.isEmpty((String)instance.getProtectGroupId())) {
            logger.error((Object)("Failed to check add serverParam.instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        OpenstackCache.preloadVmAndVolume(pg);
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        String prodRegionDrZoneName = (String)pg.getProps().get("prod_region_drZoneName");
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (ProtectObject po : addPos) {
            vmUuidSet.add(po.getMoUuid());
        }
        this.checkValidityOfProductionVM(regionUuid, projectUuid, azName, vmUuidSet);
        if (pg.getTemplate().getType() == 25 || pg.getTemplate().getType() == 37) {
            this.checkUnSupportVolume(regionUuid, projectUuid, addPos);
        }
        HashSet<ProtectObject> currentPoList = new HashSet<ProtectObject>();
        currentPoList.addAll(pg.getPolist());
        currentPoList.addAll(addPos);
        this.checkSharedVolums(regionUuid, projectUuid, currentPoList, addPos, false);
        String azIdentity = this.getAzIdentity(pg, serviceType);
        if (this.isNeedCheckOccupiedVm(serviceType)) {
            this.checkOccupiedVm(new ProjectInfo(serviceType, projectUuid, drProjectUuid, "occupied_vm"), addPos, OpenStackCommonUtil.initOpenStackAvailabilityZoneMapping(OpenStackCommonUtil.getIdFromUuid(regionUuid), OpenStackCommonUtil.getIdFromUuid(drRegionUuid), drAzName));
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType)) {
                this.checkOccupiedVm(new ProjectInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue(), projectUuid, projectUuid, "csha_occupied_vm"), addPos, OpenStackCommonUtil.initOpenStackAvailabilityZoneMapping(OpenStackCommonUtil.getIdFromUuid(regionUuid), OpenStackCommonUtil.getIdFromUuid(regionUuid), prodRegionDrZoneName));
            }
        }
        if (!this.checkVolumesOfVm(regionUuid, projectUuid, addPos)) {
            logger.error((Object)"will operate volume not in use with vm");
            throw new LegoCheckedException(1073948112L);
        }
        this.updateProtectGroupVolType(regionUuid, projectUuid, addPos);
        this.updateProtectGroupDrVolType(serviceType, addPos, azIdentity, regionUuid, pg);
        this.checkVolFromSameDev(addPos, pg);
        Map<String, String> volumesMap = this.getTypeInfoMap(addPos);
        if (!this.isRealVolumesType(regionUuid, projectUuid, volumesMap)) {
            logger.error((Object)"volume types are not really");
            throw new LegoCheckedException(1073948116L);
        }
    }

    private void checkVolFromSameDev(Set<ProtectObject> addPos, ProtectGroup pg) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        HashSet<String> srcVolTypeSet = new HashSet<String>();
        HashSet<String> drVolTypeSet = new HashSet<String>();
        HashSet<String> drHyperVolTypeSet = new HashSet<String>();
        this.addProtectedVolType(pg, srcVolTypeSet, drVolTypeSet, drHyperVolTypeSet);
        OpenStackCommonUtil.getVolTypeSet(addPos, srcVolTypeSet, drVolTypeSet, drHyperVolTypeSet);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(serviceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(serviceType)) {
            drRegionUuid = regionUuid;
        }
        if (!this.checkVolTypeFromSameDev(regionUuid, projectUuid, srcVolTypeSet) || !this.checkVolTypeFromSameDev(drRegionUuid, projectUuid, drVolTypeSet)) {
            logger.error((Object)"volume types are not from the same dev");
            throw new LegoCheckedException(1073948415L);
        }
        if ((ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType)) && !this.checkVolTypeFromSameDev(regionUuid, projectUuid, drHyperVolTypeSet)) {
            logger.error((Object)"DR HyperMetor volume types are not from the same dev");
            throw new LegoCheckedException(1073948415L);
        }
    }

    public String upgradeServiceInstanceTask(ExtendParamInfo extendParam, ServiceInstanceBO serviceInstanceBO) {
        String instanceId = serviceInstanceBO.getId();
        String projectId = serviceInstanceBO.getProjectId();
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(instance.getProtectGroupId(), false);
        this.checkInstance(instance, pg, serviceInstanceBO);
        this.setUpgradePgProps(pg, serviceInstanceBO);
        if (null != extendParam && extendParam.isCheck()) {
            return null;
        }
        pg.setTemplate(this.generateUpgradePolicyTemplate(pg, serviceInstanceBO));
        UpgradeInstanceTask task = new UpgradeInstanceTask(projectId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue(), pg, instance);
        String regionUuid = (String)pg.getProps().get("regionId");
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        OrderInstanceInfo inst = this.createOrderInstanceInfo(null, pg.getName(), serviceType, projectId, regionUuid);
        this.updateTaskInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.UPGRADE_INSTANCE, extendParam, task, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    private void checkInstance(ServiceInstance instance, ProtectGroup pg, ServiceInstanceBO serviceInstanceBO) {
        this.checkInstanceProjectId(instance.getProjectId(), instance);
        this.checkUpgradeStatus(pg, instance, serviceInstanceBO);
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        this.checkSharedVolums(regionUuid, projectUuid, pg.getPolist(), pg.getPolist(), false);
    }

    private void checkUpgradeStatus(ProtectGroup pg, ServiceInstance instance, ServiceInstanceBO serviceInstanceBO) {
        String instanceId = instance.getId();
        VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.getVolumeReplicationCgInfo(pg, true, new int[0]);
        if (null == cgInfo) {
            logger.error((Object)"The cg info which get from pg is null.");
            throw new LegoCheckedException(2117645L);
        }
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instance.getStatus()) || OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(cgInfo.getReplicationStatus()) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(cgInfo.getReplicationStatus())) {
            logger.error((Object)("The instance(" + instanceId + ") does not allow the operation.The instance of status is " + instance.getStatus() + "The instance of PairStatus is " + cgInfo.getReplicationStatus()));
            throw new LegoCheckedException(1073948693L, "The instance(" + instanceId + ") does not allow the operation.The instance of status is " + instance.getStatus() + "The instance of PairStatus is " + cgInfo.getReplicationStatus());
        }
        if (VerifyUtil.isEmpty((String)instance.getProtectGroupId())) {
            logger.error((Object)("instance(" + instanceId + ") is not exist."));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not exist.");
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(instance.getType()) && 21 == pg.getTemplate().getType()) {
            logger.error((Object)("The instance(" + instance.getId() + ") does not support upgrades. Synchronous CSDR does not allow upgrades"));
            throw new LegoCheckedException(1073948146L, "The instance(" + instance.getId() + ") does not support upgrades. Synchronous CSDR does not allow upgrades");
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(pg.getProps().get("serviceInstanceType"))) {
            ArrayList<String> keyList = new ArrayList<String>();
            for (ServerBO serverBO : serviceInstanceBO.getServers()) {
                if (keyList.contains(serverBO.getServerId())) {
                    logger.error((Object)("The occupied_vm (" + serverBO.getServerId() + ") is repeat."));
                    throw new LegoCheckedException(-1L, "The occupied_vm (" + serverBO.getServerId() + ") is repeat.");
                }
                keyList.add(serverBO.getServerId());
            }
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(pg.getProperty("serviceInstanceType"))) {
            this.checkDrInfo(serviceInstanceBO.getSlaveRegionName(), serviceInstanceBO.getRemoteProjectId(), serviceInstanceBO.getSlaveAzName());
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType"))) {
            logger.error((Object)("The instance(" + instanceId + ") does not support upgrades."));
            throw new LegoCheckedException(1073948921L, new String[]{ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue()});
        }
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (ProtectObject po : pg.getPolist()) {
            vmUuidSet.add(po.getMoUuid());
        }
        this.isVmExistRollBackTask(vmUuidSet);
    }

    private void setUpgradePgProps(ProtectGroup pg, ServiceInstanceBO serviceInstanceBO) {
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        pg.setProperty("BEFORE_UPGRADE_TYPE", (Object)serviceType);
        pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue());
        pg.getTemplate().setType(34);
        FusionSphereOpenStack openStack = this.getOpenstack();
        String openStackUuid = openStack.getUuid();
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = serviceInstanceBO.getSlaveRegionName();
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = serviceInstanceBO.getSlaveAzName();
        String azIdentity = OpenStackVolTypeMapping.getAzIdentity((String)OpenStackCommonUtil.getIdFromUuid(regionUuid), (String)azName, (String)OpenStackCommonUtil.getIdFromUuid(drRegionUuid), (String)drAzName);
        List volTypeList = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getVolTypeMappingsFromDB(openStackUuid);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(serviceType)) {
            for (ProtectObject po : pg.getPolist()) {
                String volConfigStr = (String)po.getProps().get("volumeConfig");
                JSONArray array = JSONArray.fromObject((Object)volConfigStr);
                JSONArray newArray = new JSONArray();
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject json = array.getJSONObject(i);
                    if (!json.containsKey((Object)"drVolumeType")) continue;
                    String hyperVolType = json.get("drVolumeType").toString();
                    json.put((Object)"drHyperVolumeType", (Object)hyperVolType);
                    json.remove((Object)"drVolumeType");
                    newArray.add((Object)json);
                }
                po.setProperty("volumeConfig", (Object)newArray.toString());
            }
        }
        this.getProtectGroupDrVolType(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue(), regionUuid, pg.getPolist(), azIdentity, volTypeList, null);
        for (ProtectObject po : pg.getPolist()) {
            po.setProtectGroup(pg);
            for (ServerBO bo : serviceInstanceBO.getServers()) {
                if (!po.getMoUuid().endsWith(bo.getServerId())) continue;
                po.setProperty("occupied_vm", (Object)bo.getOccupiedServerId());
            }
        }
        pg.setProperty("drRegionId", (Object)(openStackUuid + ":" + serviceInstanceBO.getSlaveRegionName()));
        pg.setProperty("drProjectId", (Object)(openStackUuid + ":" + serviceInstanceBO.getRemoteProjectId()));
        pg.setProperty("drZoneName", (Object)serviceInstanceBO.getSlaveAzName());
        pg.setProperty("originalAvailableRegion", pg.getProps().get("regionId"));
        IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().lookup("user/usermgr");
        if (null == userMgr) {
            logger.error((Object)"get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        User user = userMgr.getUserByName("admin");
        pg.setOwnerId(user.getUserId());
    }

    private void checkDrInfo(String slaveRegion, String remoteProject, String slaveAzName) {
        if (VerifyUtil.isEmpty((String)slaveRegion)) {
            logger.error((Object)"The 'slaveRegion' is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)remoteProject)) {
            logger.error((Object)"The 'remoteProject' is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)slaveAzName)) {
            logger.error((Object)"The 'slaveAzName' is null.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private PolicyTemplate generateUpgradePolicyTemplate(ProtectGroup pg, ServiceInstanceBO serviceInstanceBO) {
        PolicyTemplate newPolicyTemplate;
        PolicyTemplate policyTemplate = this.getOriginalTemplate(34);
        if (VerifyUtil.isEmpty((Object)policyTemplate)) {
            logger.error((Object)"Policy template is null,", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            newPolicyTemplate = (PolicyTemplate)policyTemplate.clone();
            newPolicyTemplate.setPtId(pg.getTemplate().getPtId());
            newPolicyTemplate.setUuid(newPolicyTemplate.getPtId());
            newPolicyTemplate.setReplicationType(newPolicyTemplate.getType());
            newPolicyTemplate.setParentId(policyTemplate.getUuid());
            newPolicyTemplate.getProps().clear();
            newPolicyTemplate.getProps().putAll(pg.getTemplate().getProps());
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"failed to Clone policyTemplate.", (Throwable)e, 90160758786897L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        newPolicyTemplate.setType(34);
        newPolicyTemplate.setIsSystemDefine(Boolean.valueOf(false));
        Schedule manualSchedule = new Schedule();
        manualSchedule.setScheduleMode(1);
        manualSchedule.setPolicyTemplate(newPolicyTemplate);
        manualSchedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.A_B.getValue());
        manualSchedule.setScheduleId(UUIDGenerator.getUUID());
        newPolicyTemplate.getSchedules().add(manualSchedule);
        PolicyBO policy = serviceInstanceBO.getPolicy();
        Schedule autoSchedule = new Schedule();
        autoSchedule.setScheduleMode(0);
        autoSchedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.A_B.getValue());
        autoSchedule.setScheduleId(UUIDGenerator.getUUID());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 30);
        Date beginTime = cal.getTime();
        autoSchedule.setStartTime(String.valueOf(beginTime.getTime()));
        autoSchedule.setPeriodInterval(Integer.parseInt(policy.getPeriodInterval()));
        if ("minute".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(0);
        } else if ("hour".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(1);
        } else {
            autoSchedule.setPeriodType(2);
            String[] scheduleTime = policy.getTimePoint().split(":");
            if (scheduleTime.length != 2) {
                throw new LegoCheckedException(1073947393L, "TimePoint is error.");
            }
            autoSchedule.setHours(scheduleTime[0]);
            autoSchedule.setMinutes(scheduleTime[1]);
        }
        newPolicyTemplate.getSchedules().add(autoSchedule);
        this.updateAutoScheduleAndManualScheduleID(manualSchedule, autoSchedule, pg);
        return newPolicyTemplate;
    }

    private void updateAutoScheduleAndManualScheduleID(Schedule manualSchedule, Schedule autoSchedule, ProtectGroup pg) {
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            if (1 == schedule.getScheduleMode()) {
                manualSchedule.setScheduleId(schedule.getScheduleId());
                continue;
            }
            if (0 != schedule.getScheduleMode()) continue;
            autoSchedule.setScheduleId(schedule.getScheduleId());
        }
    }

    private void checkAzName(String azName, String srcAzName, String serviceType, String message) {
        ArrayList<String> needCheckAzNameType = new ArrayList<String>();
        needCheckAzNameType.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue());
        needCheckAzNameType.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue());
        needCheckAzNameType.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue());
        if (needCheckAzNameType.contains(serviceType) && (VerifyUtil.isEmpty((String)srcAzName) || !srcAzName.equals(azName))) {
            logger.error((Object)("Failed to check AzName.srcAzName=" + (srcAzName != null ? srcAzName : " is empty.") + ", azName=" + azName + ", " + message));
            throw new LegoCheckedException(1073948927L, message);
        }
    }

    public void updateServiceInsBasicInfo(String projectId, ServiceInstance inst, ProtectGroup pg) {
        String uuid = inst.getUuid();
        ServiceInstance oldInst = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)inst.getUuid()));
        if (null == oldInst) {
            logger.error((Object)"Failed to update serviceInstance basicInfo.instance(%s) is not exist.", new Object[]{uuid});
            throw new LegoCheckedException(201L, "instance(" + uuid + ") is not exist.");
        }
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(oldInst.getStatus())) {
            logger.error((Object)"Failed to update serviceInstance basicInfo.instance status is %s,not normal status.", new Object[]{oldInst.getStatus()});
            throw new LegoCheckedException(1073948693L);
        }
        this.checkInstanceProjectId(projectId, oldInst);
        inst.setProtectGroupId(oldInst.getProtectGroupId());
        pg.setUuid(inst.getProtectGroupId());
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        long updateTaskId = pgService.updateProtectGroupBasicInfo(pg, Boolean.valueOf(false));
        if (!this.checkPgUpdateTask(2L, pg, oldInst, updateTaskId)) {
            logger.error((Object)"Failed to update serviceInstance basicInfo.ProtectGroup name: %s", new Object[]{pg.getName()});
            throw new LegoCheckedException(0x300001L, "update pg error:" + pg.getName());
        }
        pgService.saveOrUpdateProtectGroupProps(pg.getUuid(), pg.getProps());
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)oldInst.getType()) != ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA) {
            IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            recoveryPlanService.modifyRpBasicInfo(oldInst.getRecoveryPlanId(), Integer.valueOf(RecoveryPlanUse.PUBLIC_USE.getValue()), inst.getName(), inst.getDescription());
        }
        OpenStackCommonUtil.updateBasicInfo(inst);
        IOpenstackResourceService resourceService = (IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class);
        resourceService.updateMeterInstName(inst.getProtectGroupId(), inst.getName());
    }

    private boolean checkPgUpdateTask(long waitSeconds, ProtectGroup pg, ServiceInstance oldInst, long updateTaskId) {
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        BackTask task = taskService.readTask(updateTaskId);
        if (null == task) {
            logger.error((Object)("update task null " + updateTaskId + "@" + oldInst.getName()));
            return false;
        }
        for (int times = 30; times > 0; --times) {
            CommUtil.pauseThread((long)(waitSeconds * 1000L));
            task = taskService.readTask(updateTaskId);
            if (CommonConstant.BACKTASK_RESULT_FAIL != task.getTaskResult()) continue;
            logger.error((Object)("update pg " + pg.getUuid() + " task is error: " + updateTaskId + ",reTryTimes=" + (30 - times)));
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerInfo(String projectId, String instanceId, String serverId, ServerBO serverBOInfo) {
        if (null == serverBOInfo || null == serverBOInfo.getRecoverySetting()) {
            logger.error((Object)("Failed to update serverInfo.serverBOInfo error, RecoverySetting :" + serverBOInfo));
            throw new LegoCheckedException(1073947393L, "serverBOInfo error.");
        }
        RecoverySettingBO recoverySetting = serverBOInfo.getRecoverySetting();
        String startPriority = recoverySetting.getStartPriority();
        String interfaceSetting = JSONArray.fromObject((Object)recoverySetting.getInterfaceSetting()).toString();
        this.validateParams(instanceId, projectId);
        if (VerifyUtil.isEmpty((String)serverId)) {
            logger.error((Object)("Failed to update serverInfo.server Id is null.instanceId=" + instanceId));
            throw new LegoCheckedException(1073947393L, "server_id is empty.");
        }
        ServiceInstance instanceInDB = ServiceInstanceServiceImpl.queryServiceInstance(instanceId);
        if (null == instanceInDB) {
            logger.error((Object)("Failed to update serverInfo.instance is null.instanceId=" + instanceId));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        this.checkInstanceProjectId(projectId, instanceInDB);
        FusionSphereOpenStack openstack = this.getOpenstack();
        String moUuid = OpenStackCommonUtil.getObjectUuid(openstack.getUuid(), serverId);
        IProtectGroupService pgServie = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectObject po = pgServie.getProtectObjectByMoUUID(instanceInDB.getProtectGroupId(), moUuid);
        if (VerifyUtil.isEmpty((Object)po)) {
            logger.error((Object)("Failed to update serverInfo.DB protectOject is null.instanceName=" + instanceInDB.getName()));
            throw new LegoCheckedException(201L, "server(" + serverId + ") is not found.");
        }
        ProtectGroup protectGroup = pgServie.getProtectGroupBasicInfo(instanceInDB.getProtectGroupId(), true);
        this.checkLicense(protectGroup);
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        Object object = SYN_OBJ;
        synchronized (object) {
            RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlan(instanceInDB.getRecoveryPlanId());
            if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
                logger.error((Object)("Failed to update serverInfo.DB recoveryPlan is null.instanceName=" + instanceInDB.getName()));
                throw new LegoCheckedException(201L, "recoveryPlan(" + recoveryPlan + ") is not found.");
            }
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_RUNNING.getValue());
            statusList.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_RUNNING.getValue());
            statusList.add(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_RUNNING.getValue());
            if (statusList.contains(instanceInDB.getStatus())) {
                logger.error((Object)("Failed to update serverInfo.recovery plan is runnning." + recoveryPlan.getPlanStatus() + ", instanceName=" + instanceInDB.getName()));
                throw new LegoCheckedException(1073948693L);
            }
            boolean updated = Arrays.asList(OpenStackCommonUtil.updateRecoverySetting("startOrder", startPriority, po.getUuid(), recoveryPlan), OpenStackCommonUtil.updateRecoverySetting("start_delay_time", recoverySetting.getStartDelayTime(), po.getUuid(), recoveryPlan), OpenStackCommonUtil.updateRecoverySetting("interface_setting", interfaceSetting, po.getUuid(), recoveryPlan)).contains(Boolean.TRUE);
            if (updated) {
                ArrayList recoverySettingList = new ArrayList(recoveryPlan.getRecoverySettings());
                recoveryPlanService.saveOrUpdateRecoverySettings(recoveryPlan.getPlanId(), recoverySettingList);
            }
        }
    }

    private void updateProtectedVolDrVolType(String serviceType, Set<ProtectedVolumeInfo> addVolumes, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(addVolumes)) {
            return;
        }
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        String regionName = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("regionId"));
        String drRegionName = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drRegionId"));
        String openStackUuid = this.getOpenstack().getUuid();
        List volTypeList = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getVolTypeMappingsFromDB(openStackUuid);
        String azIdentity = OpenStackVolTypeMapping.getAzIdentity((String)regionName, (String)azName, (String)drRegionName, (String)drAzName);
        Iterator volTypeIterator = volTypeList.iterator();
        while (volTypeIterator.hasNext()) {
            OpenStackVolTypeMapping openStackVolTypeMapping = (OpenStackVolTypeMapping)volTypeIterator.next();
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)serviceType) != ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)openStackVolTypeMapping.getType())) {
                volTypeIterator.remove();
                continue;
            }
            if (VerifyUtil.isEmpty((String)openStackVolTypeMapping.getAzIdentity()) || openStackVolTypeMapping.getAzIdentity().equals(azIdentity)) continue;
            volTypeIterator.remove();
        }
        for (ProtectedVolumeInfo vol : addVolumes) {
            String drVolType = vol.getDrVolumeType();
            String srVolType = vol.getVolumeType();
            if (VerifyUtil.isEmpty((String)drVolType)) {
                drVolType = ServiceInstanceServiceImpl.findDrVolType(srVolType, volTypeList, pg);
            }
            if (VerifyUtil.isEmpty((String)drVolType)) {
                logger.error((Object)(srVolType + " doesn't have the corresponding drVolType"));
                throw new LegoCheckedException(1073948122L, new String[]{srVolType});
            }
            vol.setDrVolumeType(drVolType);
        }
    }

    public VerifyServerResultBO verifyServers(Map<String, String> paramMap, String drAvailableZone, String instanceType, List<ServerBO> servers, List<Map<String, Object>> azMappings) {
        return OpenstackCache.run(() -> {
            String projectId = (String)paramMap.get("projectId");
            String srcRegion = (String)paramMap.get("regionName");
            String remoteProjectId = (String)paramMap.get("drProjectId");
            String drRegion = (String)paramMap.get("drRegionName");
            OpenstackCache.preloadVmAndVolume(JSONObject.fromObject((Object)paramMap).rename("regionName", "regionId").rename("drRegionName", "drRegionId").toMap(String.class));
            String openstackUuid = this.getOpenstack().getUuid();
            String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, srcRegion);
            String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
            String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
            HashMap<String, OpenStackVM> vmsMap = new HashMap<String, OpenStackVM>();
            for (ServerBO server : servers) {
                String vmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, server.getServerId());
                for (OpenStackVM vm : vmList) {
                    if (!vm.getUuid().equals(vmUuid)) continue;
                    vmsMap.put(vmUuid, vm);
                }
            }
            HashMap<String, VerifyServerResultBO.ResultItem> resultMap = new HashMap<String, VerifyServerResultBO.ResultItem>();
            this.checkVmSelfProperties(servers, vmsMap, resultMap);
            Set<String> volTypeSet = this.checkVmCommonProperties(servers, paramMap, vmsMap, resultMap, instanceType, azMappings);
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(instanceType)) {
                String prodAZ = null;
                Iterator<Object> iterator = vmsMap.values().iterator();
                if (iterator.hasNext()) {
                    OpenStackVM vm;
                    vm = (OpenStackVM)iterator.next();
                    prodAZ = vm.getAzName();
                }
                if (null == prodAZ) {
                    logger.error((Object)"prodAZ is null");
                    throw new LegoCheckedException(0x300001L);
                }
                String drHyperMetorType = null;
                for (Map mapping : azMappings) {
                    String prodRegion = (String)mapping.get("primary_region_id");
                    String drMapRegion = (String)mapping.get("second_region_id");
                    String proAZ = (String)mapping.get("primary_az_id");
                    String proDrAZ = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(instanceType) ? (String)mapping.get("dr_second_az_id") : null;
                    String drAZ = (String)mapping.get("second_az_id");
                    boolean equalAZ = prodRegion.equals(srcRegion) && drMapRegion.equals(drRegion) && proAZ.equals(prodAZ) && drAZ.equals(drAvailableZone);
                    boolean equalDrAZ = prodRegion.equals(srcRegion) && drMapRegion.equals(drRegion) && prodAZ.equals(proDrAZ) && drAZ.equals(drAvailableZone);
                    boolean equalReverseAZ = prodRegion.equals(drRegion) && drMapRegion.equals(srcRegion) && proAZ.equals(drAvailableZone) && drAZ.equals(prodAZ);
                    String sourceType = (String)mapping.get("sourceType");
                    String hyperMetorType = (String)mapping.get("drHyperMetorType");
                    if (!equalAZ && !equalReverseAZ && !equalDrAZ || !volTypeSet.contains(sourceType) && !volTypeSet.contains(hyperMetorType)) continue;
                    drHyperMetorType = (String)mapping.get("drHyperMetorType");
                    break;
                }
                this.checkVhaCSDR(drHyperMetorType, regionUuid, projectUuid, instanceType, resultMap);
            }
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instanceType) && OpenStackCommonUtil.isCurrentFCVersionHighThan63() || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(instanceType)) {
                String remoteProjectUuid = VerifyUtil.isEmpty((String)remoteProjectId) ? remoteProjectId : OpenStackCommonUtil.getObjectUuid(openstackUuid, remoteProjectId);
                this.checkOccupiedVm(new ProjectInfo(instanceType, projectUuid, remoteProjectUuid, "occupied_vm"), servers, resultMap, OpenStackCommonUtil.initOpenStackAvailabilityZoneMapping(srcRegion, drRegion, drAvailableZone));
                if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(instanceType)) {
                    this.checkOccupiedVm(new ProjectInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue(), projectUuid, projectUuid, "csha_occupied_vm"), servers, resultMap, OpenStackCommonUtil.initOpenStackAvailabilityZoneMapping(srcRegion, srcRegion, (String)paramMap.get("prod_region_drZoneName")));
                }
            }
            this.checkShareVolume(servers, openstackUuid, regionUuid, projectUuid, resultMap);
            this.checkVmTags(vmsMap, resultMap);
            VerifyServerResultBO result = new VerifyServerResultBO();
            result.getCheckResult().addAll(resultMap.values());
            return result;
        });
    }

    private void checkVhaCSDR(String drHyperMetorType, String regionUuid, String projectUuid, String instanceType, Map<String, VerifyServerResultBO.ResultItem> resultMap) {
        if (drHyperMetorType == null) {
            this.initAndGetItem(String.valueOf(1073948121L), resultMap);
        } else {
            OpenStackStorageResourcePool pool = this.getResPoolByVolumeType(regionUuid, projectUuid, drHyperMetorType);
            if (!this.checkVolumeType(pool, instanceType)) {
                logger.info((Object)("The hypermetor storage which volumes' from doesn't support this instancetype " + instanceType));
                this.initAndGetItem(String.valueOf(1073948114L), resultMap);
            }
        }
    }

    private void checkShareVolume(List<ServerBO> servers, String openstackUuid, String regionUuid, String projectUuid, Map<String, VerifyServerResultBO.ResultItem> resultMap) {
        HashSet<String> volumeUuidSet = new HashSet<String>();
        HashSet<String> currentVmUuidSet = new HashSet<String>();
        for (ServerBO server : servers) {
            String vmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, server.getServerId());
            currentVmUuidSet.add(vmUuid);
            for (VolumeBO vol : server.getVolumes()) {
                String volUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, vol.getVolumeId());
                volumeUuidSet.add(volUuid);
            }
        }
        Set<String> notContainVmUuidSet = VmChecker.getAllSharedVolumeNotValidVmUuids(regionUuid, projectUuid, volumeUuidSet, currentVmUuidSet, false, true, false);
        if (!VerifyUtil.isEmpty(notContainVmUuidSet)) {
            VerifyServerResultBO.ResultItem sharedVmNotExistItem = this.initAndGetItem(String.valueOf(1073948135L), resultMap);
            Set<String> sharedVmUuidSet = VmChecker.getAllSharedVmUuids(regionUuid, projectUuid, volumeUuidSet, true, false);
            sharedVmUuidSet.removeAll(notContainVmUuidSet);
            for (String vmUuid : sharedVmUuidSet) {
                sharedVmNotExistItem.getServerIds().add(OpenStackCommonUtil.getIdFromUuid(vmUuid));
            }
            List<OpenStackVM> vmList = this.getVMByUuids(regionUuid, projectUuid, notContainVmUuidSet);
            ArrayList sharedVolumeNotInPgVmList = new ArrayList();
            for (OpenStackVM openStackVM : vmList) {
                sharedVolumeNotInPgVmList.add(openStackVM.getName());
            }
            sharedVmNotExistItem.setErrParams(new String[]{((Object)sharedVolumeNotInPgVmList).toString()});
        } else {
            Map<String, String> shareVolumeMap = this.getShareVolumes(regionUuid, projectUuid, volumeUuidSet);
            ArrayList shareVolumeNotExistInVmList = new ArrayList();
            HashSet<String> errorVmList = new HashSet<String>();
            logger.info((Object)("share volume: " + shareVolumeMap.toString()));
            for (ServerBO server : servers) {
                HashSet<String> volumeUuids = new HashSet<String>();
                for (VolumeBO volumeBO : server.getVolumes()) {
                    String volUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, volumeBO.getVolumeId());
                    volumeUuids.add(volUuid);
                }
                for (Map.Entry entry : shareVolumeMap.entrySet()) {
                    logger.debug((Object)("server: " + server.getServerId() + ", volumes: " + ((Object)volumeUuids).toString()));
                    HashSet<String> volumeSet = new HashSet<String>();
                    volumeSet.add((String)entry.getKey());
                    Set<String> sharedVmUuidSet = VmChecker.getAllSharedVmUuids(regionUuid, projectUuid, volumeSet, true, false);
                    if (!sharedVmUuidSet.contains(OpenStackCommonUtil.getObjectUuid(openstackUuid, server.getServerId()))) {
                        logger.debug((Object)("server " + server.getServerId() + "no use volume " + (String)entry.getKey()));
                        continue;
                    }
                    if (volumeUuids.contains(entry.getKey())) continue;
                    logger.info((Object)("server: " + server.getServerId() + " not choose to protect: " + entry));
                    shareVolumeNotExistInVmList.add(entry.getValue());
                    errorVmList.addAll(sharedVmUuidSet);
                }
            }
            logger.info((Object)("share volume not chosen in all relative vms: " + ((Object)shareVolumeNotExistInVmList).toString()));
            logger.info((Object)("share volume not chosen in all relative vms: " + ((Object)errorVmList).toString()));
            if (!VerifyUtil.isEmpty(shareVolumeNotExistInVmList)) {
                VerifyServerResultBO.ResultItem shareVolumeNotExistInVmItem = this.initAndGetItem(String.valueOf(1073948158L), resultMap);
                for (String vmUuid : errorVmList) {
                    shareVolumeNotExistInVmItem.getServerIds().add(OpenStackCommonUtil.getIdFromUuid(vmUuid));
                }
                shareVolumeNotExistInVmItem.setErrParams(new String[]{((Object)shareVolumeNotExistInVmList).toString()});
            }
        }
    }

    private Map<String, String> getShareVolumes(String regionUuid, String projectUuid, Set<String> volumeUuidSet) {
        HashMap<String, String> shareVolumeMap = new HashMap<String, String>();
        if (VerifyUtil.isEmpty(volumeUuidSet)) {
            return shareVolumeMap;
        }
        ArrayList<String> volumeUuidList = new ArrayList<String>(volumeUuidSet);
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volumes = volumeService.queryVolumesByUuid(regionUuid, projectUuid, volumeUuidList, false);
        if (VerifyUtil.isEmpty((Collection)volumes)) {
            return shareVolumeMap;
        }
        volumes.stream().filter(OpenStackVolume::getShareable).forEach(vol -> shareVolumeMap.put(vol.getUuid(), vol.getName()));
        return shareVolumeMap;
    }

    private void checkVmTags(Map<String, OpenStackVM> vmsMap, Map<String, VerifyServerResultBO.ResultItem> resultMap) {
        HashSet<String> noTagServerIdSet = new HashSet<String>();
        for (OpenStackVM openStackVM : vmsMap.values()) {
            Set tags = openStackVM.getTags();
            if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63() || !VerifyUtil.isEmpty((Collection)tags) && tags.contains("__single_storage")) continue;
            noTagServerIdSet.add(OpenStackCommonUtil.getIdFromUuid(openStackVM.getUuid()));
        }
        if (!VerifyUtil.isEmpty(noTagServerIdSet)) {
            VerifyServerResultBO.ResultItem noTagItem = this.initAndGetItem(String.valueOf(1073948415L), resultMap);
            for (String vmId : noTagServerIdSet) {
                noTagItem.getServerIds().add(vmId);
            }
        }
    }

    protected void checkOccupiedVm(ProjectInfo projectInfo, List<ServerBO> servers, Map<String, VerifyServerResultBO.ResultItem> resultMap, OpenStackAvailabilityZoneMapping zoneMapping) {
        HashMap<String, String> vmAndOccvmMap = new HashMap<String, String>();
        for (ServerBO server : servers) {
            String occupiedVmId;
            String serverId = server.getServerId();
            String string = occupiedVmId = projectInfo.getOccupiedVMKey().equals("occupied_vm") ? server.getOccupiedServerId() : server.getCshaOccupiedServerId();
            if (VerifyUtil.isEmpty((String)occupiedVmId)) {
                logger.error((Object)("the vm(" + serverId + ") not set occupied vm"));
                VerifyServerResultBO.ResultItem vmNotSetOccupied = this.initAndGetItem(String.valueOf(1073948908L), resultMap);
                vmNotSetOccupied.getServerIds().add(server.getServerId());
            }
            if (vmAndOccvmMap.containsValue(occupiedVmId)) {
                logger.error((Object)("the vm(" + occupiedVmId + ") has been uesd."));
                VerifyServerResultBO.ResultItem vmHasBeenUsed = this.initAndGetItem(String.valueOf(1073948130L), resultMap);
                vmHasBeenUsed.getServerIds().add(server.getServerId());
            }
            vmAndOccvmMap.put(serverId, occupiedVmId);
        }
        Map<String, List<VmInfoBO>> matchedVms = this.queryAvailableOccupiedVmMap(projectInfo.getInstanceType(), OpenStackCommonUtil.getIdFromUuid(projectInfo.getProjectUuid()), OpenStackCommonUtil.getIdFromUuid(projectInfo.getRemoteProjectUuid()), vmAndOccvmMap.keySet(), zoneMapping);
        for (Map.Entry entry : vmAndOccvmMap.entrySet()) {
            String srcVmId = (String)entry.getKey();
            String occVmId = (String)entry.getValue();
            List<VmInfoBO> avalibelVms = matchedVms.get(srcVmId);
            if (VerifyUtil.isEmpty(avalibelVms)) {
                logger.error((Object)("the vm(" + occVmId + ") is not avalible because srcvm has no matched vm."));
                VerifyServerResultBO.ResultItem vmNotMatchedVm = this.initAndGetItem(String.valueOf(1073948130L), resultMap);
                vmNotMatchedVm.getServerIds().add(srcVmId);
            }
            boolean isMatched = false;
            for (VmInfoBO avalibelVm : avalibelVms) {
                if (!occVmId.equals(OpenStackCommonUtil.getIdFromUuid(avalibelVm.getServerId()))) continue;
                isMatched = true;
                break;
            }
            if (isMatched) continue;
            logger.error((Object)("the vm(" + occVmId + ") is not avalible."));
            VerifyServerResultBO.ResultItem vmNotAvalible = this.initAndGetItem(String.valueOf(1073948130L), resultMap);
            vmNotAvalible.getServerIds().add(srcVmId);
        }
    }

    private void checkVmSelfProperties(List<OpenStackVM> vmList, String azName) {
        Iterator<OpenStackVM> it = vmList.iterator();
        while (it.hasNext()) {
            OpenStackVM vm = it.next();
            if (!azName.equals(vm.getAzName())) {
                logger.debug((Object)("checkVmSelfProperties vm name:" + vm.getName() + ",is not zaName" + azName));
                it.remove();
                continue;
            }
            Set tags = vm.getTags();
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                if (VerifyUtil.isEmpty((Collection)tags) || !tags.contains("__single_storage")) {
                    logger.debug((Object)("checkVmSelfProperties vm :" + vm.getName() + " do not have esc single storage tag"));
                    it.remove();
                    continue;
                }
                if (!VerifyUtil.isEmpty((Collection)tags) && (tags.contains("__type_pd") || tags.contains("__type_dr"))) {
                    logger.debug((Object)("checkVmSelfProperties vm :" + vm.getName() + " have  __type_dr or __type_pd tag, vm tags=" + tags));
                    it.remove();
                    continue;
                }
                if (this.checkVmIllegalStatus(vm)) {
                    logger.debug((Object)("checkVmSelfProperties  vm name" + vm.getName() + ",metadata is " + vm.getMetadata() + " softdelete or expiry"));
                    it.remove();
                    continue;
                }
                if (!VerifyUtil.isEmpty((Collection)tags) && tags.contains("__type_baremetal") && vm.getStatus().intValue() != OpenstackEnumDefine.VM_STATUS_E.ACTIVE.getValue()) {
                    logger.debug((Object)("checkVmSelfProperties vm name" + vm.getName() + " status is:" + vm.getMetadata() + ",not active status"));
                    it.remove();
                    continue;
                }
            }
            if (this.checkVmExist(new HashMap<String, VerifyServerResultBO.ResultItem>(), OpenStackCommonUtil.getIdFromUuid(vm.getUuid()), vm.getUuid(), vm)) continue;
            logger.debug((Object)("checkVmSelfProperties vm :" + vm.getName() + " checkVmExist"));
            it.remove();
        }
    }

    private void checkVmSelfProperties(List<ServerBO> servers, Map<String, OpenStackVM> vmsMap, Map<String, VerifyServerResultBO.ResultItem> resultMap) {
        String openstackUuid = this.getOpenstack().getUuid();
        for (ServerBO server : servers) {
            String vmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, server.getServerId());
            OpenStackVM vm = vmsMap.get(vmUuid);
            this.checkVmExist(resultMap, server.getServerId(), vmUuid, vm);
        }
    }

    private boolean checkVmExist(Map<String, VerifyServerResultBO.ResultItem> resultMap, String serverId, String vmUuid, OpenStackVM vm) {
        if (null == vm) {
            logger.info((Object)("vm(" + vmUuid + ") doesn't exist."));
            VerifyServerResultBO.ResultItem vmNotExistItem = this.initAndGetItem(String.valueOf(2117645L), resultMap);
            vmNotExistItem.getServerIds().add(serverId);
            return false;
        }
        boolean result = true;
        if (VerifyUtil.isEmpty((String)vm.getVolumeAttached())) {
            logger.info((Object)("vm uuid(" + vmUuid + " ,vm name=" + vm.getName() + ") doesn't have any volumes."));
            VerifyServerResultBO.ResultItem vmNoVolume = this.initAndGetItem(String.valueOf(1073948119L), resultMap);
            vmNoVolume.getServerIds().add(serverId);
            result = false;
        }
        if (!this.isVmInInstance(vmUuid)) {
            logger.info((Object)("vm(" + vmUuid + " ,vm name=" + vm.getName() + ") is already protected."));
            VerifyServerResultBO.ResultItem vmBeenProtected = this.initAndGetItem(String.valueOf(1073948113L), resultMap);
            vmBeenProtected.getServerIds().add(serverId);
            result = false;
        }
        if (this.isSingleVmExistRollBackTask(vmUuid)) {
            logger.info((Object)("vm(" + vmUuid + " ,vm name=" + vm.getName() + ") has rollBack task."));
            VerifyServerResultBO.ResultItem vmHasRollBackTask = this.initAndGetItem(String.valueOf(1073948118L), resultMap);
            vmHasRollBackTask.getServerIds().add(serverId);
            result = false;
        }
        HashSet<String> vmUuidSet = new HashSet<String>();
        vmUuidSet.add(vmUuid);
        ArrayList<OpenStackVM> vmList = new ArrayList<OpenStackVM>();
        vmList.add(vm);
        if (!this.checkVMSIntfaceExist(vm.getRegionUuid(), vm.getProjectUuid(), vmUuidSet, vmList)) {
            logger.info((Object)("vm:" + vmUuid + " ,vm name=" + vm.getName() + "  don't have any interfaces."));
            VerifyServerResultBO.ResultItem vmHasRollBackTask = this.initAndGetItem(String.valueOf(1073948120L), resultMap);
            vmHasRollBackTask.getServerIds().add(serverId);
            result = false;
        }
        return result;
    }

    public void modifPolicy(String projectId, String instanceId, Schedule autoSchedule) {
        ServiceInstance instance = ServiceInstanceServiceImpl.queryServiceInstance(instanceId);
        if (null == instance) {
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String uuid = protectGroup.getTemplate().getUuid();
        PolicyTemplate policyTemplate = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getPtByUuid(uuid);
        protectGroup.setTemplate(policyTemplate);
        autoSchedule.setPolicyTemplate(policyTemplate);
        Schedule oldAutoSchedule = null;
        for (Schedule schedule : policyTemplate.getSchedules()) {
            if (0 != schedule.getScheduleMode()) continue;
            oldAutoSchedule = schedule;
        }
        if (null != oldAutoSchedule) {
            autoSchedule.setScheduleId(oldAutoSchedule.getScheduleId());
            policyTemplate.getSchedules().remove(oldAutoSchedule);
            policyTemplate.getSchedules().add(autoSchedule);
        } else {
            autoSchedule.setScheduleId(UUIDGenerator.getUUID());
            policyTemplate.getSchedules().add(autoSchedule);
        }
        this.checkLicense(protectGroup);
        long taskId = pgService.updateProtectGroupTemplate(instance.getProtectGroupId(), policyTemplate);
        if (!this.checkPgUpdateTask(1L, protectGroup, instance, taskId)) {
            logger.error((Object)("updateProtectGroupTemplate pg error:" + protectGroup.getName()));
            throw new LegoCheckedException(1073948131L, "update pg template error:" + protectGroup.getName());
        }
    }

    public List<VmInfoBO> queryAvailableVms(String instanceType, String projectId, String regionId, String azName, List<String> protectedServerIdList) {
        return OpenstackCache.run(() -> {
            String openstackUuid = this.getOpenstack().getUuid();
            String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, regionId);
            String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
            OpenstackCache.preloadVmAndVolume(new Project(new Region(regionUuid), projectUuid));
            String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
            if (VerifyUtil.isEmpty(vmList)) {
                logger.error((Object)"Vm in region(%s) is empty.", new Object[]{regionUuid});
                return Collections.emptyList();
            }
            OpenStackVM protectedServerVM = this.getProtectedServerStorageSN(vmList, protectedServerIdList);
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(instanceType)) {
                this.filterUnSupportVm(regionUuid, projectUuid, vmList);
            }
            this.checkVmSelfProperties(vmList, azName);
            Map<String, String> vmStorage = this.checkVmCommonProperties(regionUuid, projectUuid, instanceType, vmList, protectedServerVM);
            List<VMFlavor> vmFlavor = novaMgr.getVmFlavors(regionUuid, tokenId, projectUuid);
            Map<String, VMFlavor> flavorMap = this.getFlavorMap(vmFlavor);
            ArrayList<VmInfoBO> vmInfoBOList = new ArrayList<VmInfoBO>();
            for (OpenStackVM vm : vmList) {
                vmInfoBOList.add(this.convertOpenStackVMToVMInfoBo(vmStorage, vm, flavorMap.get(vm.getFlavorId())));
            }
            logger.info((Object)("product vm :" + vmInfoBOList.size()));
            return vmInfoBOList;
        });
    }

    private OpenStackVM getProtectedServerStorageSN(List<OpenStackVM> vmList, List<String> protectedServerIdList) {
        if (VerifyUtil.isEmpty(protectedServerIdList)) {
            logger.debug((Object)"ProtectedServerIdList is empty, will query all available protected vm.");
            return new OpenStackVM();
        }
        for (OpenStackVM tempVM : vmList) {
            for (String protectedServerID : protectedServerIdList) {
                if (!OpenStackCommonUtil.getIdFromUuid(tempVM.getUuid()).equals(protectedServerID)) continue;
                return tempVM;
            }
        }
        return new OpenStackVM();
    }

    public List<QuotaResourcesBo> addServerToServiceInstanceAndCalQuota(String projectId, String instanceId, Set<ProtectObject> addPos, ExtendParamInfo extendParam) {
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        return OpenstackCache.run(() -> {
            this.addServerToServiceInstance(projectId, instanceId, addPos, extendParam);
            return quotaService.calculateAddServerQuota(instanceId, addPos);
        });
    }

    public List<QuotaResourcesBo> checkCreateInstanceParamAndCalQuota(ProtectGroup pg, String projectId, ExtendParamInfo extendParam) {
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        return OpenstackCache.run(() -> {
            this.createServiceInstance(pg, extendParam);
            return quotaService.calculateCreateInstanceQuota(projectId, pg);
        });
    }

    public List<QuotaResourcesBo> checkAddVolumeParamAndCalQuota(String projectId, String instanceId, String serverId, Set<ProtectedVolumeInfo> addVolumes, ExtendParamInfo extendParam) {
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        return OpenstackCache.run(() -> {
            this.addVolumesToVm(projectId, instanceId, serverId, addVolumes, extendParam);
            return quotaService.calculateAddVolumesQuota(instanceId, addVolumes);
        });
    }
}

