/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.util.ArrayList;
import java.util.Map;

public class DeleteInstanceTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final int DEL_PG_TIMEOUT = 2147483;
    private static final int MONITORINTERVAL = 10;
    private static final Log logger = LogFactory.getInstance(DeleteInstanceTask.class);
    private String instanceId;
    private String instanceName;
    private String regionUuid;
    private String drRegionUuid;
    private String openstackUuid;

    public DeleteInstanceTask(String proId, String type, String instanceId, String instanceName) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instanceName, (String)"ism.drm.instance.delete", (String)proId, (String)type, (String)"", null), 2147483, true);
        this.instanceId = instanceId;
        this.instanceName = instanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.handleHighThan63();
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            logger.error((Object)("not get this instance lock,instanceId:" + this.instanceId));
            throw new LegoCheckedException(1073948693L);
        }
        boolean deleteComplate = false;
        try {
            ServiceInstance instance = ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DELETING);
            this.checkVolSnapshots(instance);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map<String, Object> meterInfos = this.calcMeterBeforeUpdate(instance, meterService);
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            String planId = instance.getRecoveryPlanId();
            if (!this.deleteRecoveryPlan(planId)) {
                logger.error((Object)("Not support delete this recoveryPlan,planId:" + planId + ",instance name=" + instance.getName() + ", instance id=" + instance.getId()));
                throw new LegoCheckedException(1073948688L);
            }
            String pgId = instance.getProtectGroupId();
            if (!this.deleteProtectGroup(pgId)) {
                logger.error((Object)("Not support delete this ProtectGroup,pgId:" + pgId + ",instance name=" + instance.getName() + ", instance id=" + instance.getId()));
                throw new LegoCheckedException(1073948105L);
            }
            this.deleteInstance(instance);
            ArrayList<String> sourceIdList = new ArrayList<String>();
            sourceIdList.add(this.instanceId);
            ((IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class)).deleteAlarmAndEventBySorceId(sourceIdList);
            deleteComplate = true;
            this.reportMeter(instance, meterService, meterInfos);
        }
        finally {
            this.finallyWork(deleteComplate);
        }
    }

    private void finallyWork(boolean deleteComplate) {
        ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
        if (!deleteComplate) {
            try {
                ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_DELETE);
            }
            catch (Exception e) {
                logger.error((Object)("set instance name(" + this.instanceName + ", instance id=" + this.instanceId + " err_delete error."), (Throwable)e);
            }
        }
    }

    private void handleHighThan63() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
            IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
            String quotas = quotaService.calculateDeleteInstanceQuota(this.instanceId);
            Map param = this.getExtendParam();
            param.put("order_quotas", quotas);
            this.setExtendParam(param);
        }
    }

    private Map<String, Object> calcMeterBeforeUpdate(ServiceInstance instance, IMeterService meterService) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        Map meterInfos = meterService.calculateMeterInfos(pg);
        meterInfos.put("change_type", "inst_delete");
        meterInfos.put("meter_pg", pg);
        return meterInfos;
    }

    private void reportMeter(ServiceInstance instance, IMeterService meterService, Map<String, Object> meterInfos) {
        meterService.reportChangedMeterInfo(this.regionUuid, instance, this.openstackUuid, meterInfos);
        meterService.reportChangedMeterInfo(this.drRegionUuid, instance, this.openstackUuid, meterInfos);
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
    }

    private void deleteInstance(ServiceInstance instance) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)instance);
        }
        catch (Exception e) {
            logger.error((Object)("delete instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948105L, "delete instance error.", (Throwable)e);
        }
    }

    private boolean deleteProtectGroup(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            return true;
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, false);
        if (null == pg) {
            return true;
        }
        this.regionUuid = (String)pg.getProps().get("regionId");
        this.drRegionUuid = (String)pg.getProps().get("drRegionId");
        this.openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
        long taskId = this.getDeletePgTaskId(pgId, pgService);
        if (taskId == -1L) {
            return false;
        }
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        BackTask task = taskService.readTask(taskId);
        if (null == task) {
            logger.error((Object)("del " + this.instanceName + " task is null: " + taskId));
            return false;
        }
        for (int times = 214748; times > 0; --times) {
            CommUtil.pauseThread((long)10000L);
            task = taskService.readTask(taskId);
            if (CommonConstant.BACKTASK_RESULT_FAIL != task.getTaskResult()) continue;
            logger.error((Object)("del " + this.instanceName + " task is fail: " + taskId + ",reTryTimes=" + (214748 - times)));
            OpenStackCommonUtil.throwTaskError(task);
            return false;
        }
        logger.error((Object)("del " + this.instanceName + " task is timeout: " + taskId));
        return false;
    }

    private long getDeletePgTaskId(String pgId, IProtectGroupService pgService) {
        try {
            return pgService.deleteProtectGroup(pgId, Boolean.valueOf(false));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"delete pg error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"delete pg error.", (Throwable)e);
            return -1L;
        }
    }

    private boolean deleteRecoveryPlan(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            return true;
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan plan = planService.getRecoveryPlan(planId, false, false);
        if (null == plan) {
            return true;
        }
        try {
            planService.removeRecoveryPlan(planId);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"delete plan error.", (Throwable)e);
            return false;
        }
    }

    private void checkVolSnapshots(ServiceInstance instance) {
        if (VerifyUtil.isEmpty((Object)instance)) {
            logger.error((Object)"checkVolSnapshots failed, instance is null");
            return;
        }
        String pgId = instance.getProtectGroupId();
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, true);
        if (null == pg) {
            logger.error((Object)("checkVolSnapshots failed, pg is null,instance ID=" + instance.getId() + ",instance name=" + instance.getName()));
            return;
        }
        ArrayList<String> volumesId = new ArrayList<String>();
        ArrayList<String> volumesDRHyperMetorId = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo poHyperMetorReplicaInfo;
            String replicationHyperMetorInfo;
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null != poReplicaInfo && !poReplicaInfo.getPairInfos().isEmpty()) {
                for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                    String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
                    logger.debug((Object)("Check volume snapshots.instance ID=" + instance.getId() + ",instance name=" + instance.getName() + ", remotevol id is: " + volId + " producerVolid: " + OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid())));
                    volumesId.add(volId);
                }
            }
            if (VerifyUtil.isEmpty((String)(replicationHyperMetorInfo = (String)po.getProps().get("hypermetor_replicationInfo"))) || null == (poHyperMetorReplicaInfo = JsonUtil.jsonToBean(replicationHyperMetorInfo, PoReplicaInfo.class)) || poHyperMetorReplicaInfo.getPairInfos().isEmpty()) continue;
            for (PoReplicaPairInfo pairInfo : poHyperMetorReplicaInfo.getPairInfos()) {
                String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
                logger.debug((Object)("Check volume snapshots.instance ID=" + instance.getId() + ",instance name=" + instance.getName() + ",hypermetor remotevol id is: " + volId + " producerVolid: " + OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid())));
                volumesDRHyperMetorId.add(volId);
            }
        }
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        volService.checkVolumesExitSnapshots((String)pg.getProps().get("drRegionId"), (String)pg.getProps().get("drProjectId"), volumesId);
        volService.checkVolumesExitSnapshots((String)pg.getProps().get("regionId"), (String)pg.getProps().get("projectId"), volumesDRHyperMetorId);
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }
}

