/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.task.AbstractServiceInstRecoveryTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ServiceInstRecoveryTask
extends AbstractServiceInstRecoveryTask {
    private static final Log logger = LogFactory.getInstance(ServiceInstRecoveryTask.class);
    private InstanceInfoBO instBo;
    private CompletableFuture<Map.Entry<InstanceInfoBO, Boolean>> future;

    public ServiceInstRecoveryTask(InstanceInfoBO serviceInst) {
        this.instBo = serviceInst;
        this.future = new CompletableFuture();
    }

    public CompletableFuture<Map.Entry<InstanceInfoBO, Boolean>> getFuture() {
        return this.future;
    }

    @Override
    public void run() {
        if (null == this.instBo) {
            logger.error((Object)"instBo is null");
            this.future.complete(new AbstractMap.SimpleEntry<InstanceInfoBO, Object>(this.instBo, null));
            return;
        }
        Boolean isSuccessed = null;
        try {
            isSuccessed = this.checkLicense(this.instBo) ? Boolean.valueOf(this.doDisasterRecovery()) : null;
        }
        catch (Exception e) {
            logger.error((Object)("task excute error: " + this.instBo.getRecoveryPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)));
            isSuccessed = false;
        }
        finally {
            this.future.complete(new AbstractMap.SimpleEntry<InstanceInfoBO, Boolean>(this.instBo, isSuccessed));
            logger.debug((Object)("final:" + this.instBo.getRecoveryPlanId()));
            this.changeServiceInstStatus(isSuccessed);
            ServiceInstanceHelper.getInstance().releaseLock(this.instBo.getId());
            this.sendAlarm(isSuccessed, 52625463L, this.instBo);
        }
    }

    private boolean doDisasterRecovery() {
        HashMap<String, String> recoveryContext = new HashMap<String, String>();
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(this.instBo.getProtectGroupId(), true);
        recoveryContext.put("DISASTER_SITE_ID", pg.getProductSiteId());
        recoveryContext.put("RecoveryType", "");
        if (37 == pg.getTemplate().getType()) {
            recoveryContext.put("recovery_region_id", OpenStackCommonUtil.getIdFromUuid(pg.getProperty("regionId")));
            recoveryContext.put("recovery_az_id", OpenStackCommonUtil.getIdFromUuid(pg.getProperty("prod_region_drZoneName")));
        }
        User user = new User();
        user.setUserName("admin");
        IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
        String planId = this.instBo.getRecoveryPlanId();
        recoveryManager.startDisasterRecovery(planId, recoveryContext, user);
        return this.checkPlanExcutionResult(this.instBo, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue());
    }

    private void changeServiceInstStatus(Boolean isSuccess) {
        if (isSuccess == null) {
            return;
        }
        if (isSuccess.booleanValue()) {
            ServiceInstanceHelper.getInstance().changeStatus(this.instBo.getId(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED);
        } else {
            ServiceInstanceHelper.getInstance().changeStatus(this.instBo.getId(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED);
        }
    }
}

