/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.backup;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.drm.openstack.system.backup.task.OpenStackBackupRegisterTask;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackBackupRegisterService
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(OpenStackBackupRegisterService.class);

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && this.available()) {
            logger.info((Object)"backup service creat a task to handle on register.");
            OpenStackBackupRegisterTask openStackBackupRegisterTask = new OpenStackBackupRegisterTask("ism.drm.backup.register", "backup.register");
            logger.info((Object)"submit a task for register.");
            long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)openStackBackupRegisterTask);
            logger.info((Object)String.format("submit a task for register success taskId is: %s", taskId));
        }
    }

    private boolean available() {
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.info((Object)"Unified Backup server url is empty, Unified Backup management is not supported.");
            return false;
        }
        logger.info((Object)"Unified Backup management is supported.");
        return true;
    }
}

