/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.tools;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public final class OpenstackResourceUtil
implements InitializingBean {
    private static Log logger = LogFactory.getInstance(OpenstackResourceUtil.class);
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static OpenstackResourceUtil instance;
    private Properties props = new Properties();

    public static synchronized OpenstackResourceUtil getInstance() {
        if (null == instance) {
            instance = new OpenstackResourceUtil();
        }
        return instance;
    }

    public String getValue(String key) {
        return this.getValue(key, null);
    }

    public String getValue(String key, String defaultValue) {
        String value = defaultValue;
        if (this.props != null) {
            value = this.props.getProperty(key, defaultValue);
        }
        return value;
    }

    public void afterPropertiesSet() {
        this.props = this.readProperties(DEFAULT_PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties readProperties(String propFile) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            String jarfileName = AdapterUtils.getClassJarPath(OpenstackResourceUtil.class);
            if (null == jarfileName) {
                logger.error((Object)"read default.properties fail.", 90160758786989L);
            } else {
                URL url = AdapterUtils.getUrlResourceFromJar((ClassLoader)OpenstackResourceUtil.class.getClassLoader(), (String)jarfileName, (String)propFile);
                if (null != url) {
                    inputStream = url.openStream();
                    properties.load(inputStream);
                }
            }
            this.closeInputStream(inputStream);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("read default.properties fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                this.closeInputStream(inputStream);
            }
            catch (Throwable throwable) {
                this.closeInputStream(inputStream);
                throw throwable;
            }
        }
        return properties;
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Closing input stream failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }
}

