/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.checker;

import com.huawei.csr.framework.common.model.ApplicationBo;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.AppOpt;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.Normalizer;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AppChecker {
    private static final String NAME_REGEXP = "^[\\u4e00-\\u9fa50-9a-zA-Z_][\\u4e00-\\u9fa5a-zA-Z_0-9-]{3,31}$";
    private static final Log LOG = LogFactory.getInstance(AppChecker.class);
    private static final String APP_NOT_EXIST = "App is not exist";
    private static final int NAME_MINSIZE = 4;
    private static final int NAME_MAXSIZE = 32;
    private static final int DESC_MAXSIZE = 255;

    private AppChecker() {
    }

    public static void checkAppCanRemoveInstances(Application application) {
        if (application == null) {
            LOG.error((Object)APP_NOT_EXIST);
            throw new LegoCheckedException(1073952008L);
        }
        if (application.getServiceInstances().size() == 1) {
            LOG.error((Object)"App(%s) only one instance", new Object[]{application.getId()});
            throw new LegoCheckedException(1073952010L, new String[]{application.getName()});
        }
        StatusOptChecker.checkAppStatusOpt(AppStatus.from(application.getStatus()).getIndex(), AppOpt.REMOVE_INSTANCE.getIndex(), 1073952006L, new String[]{application.getName()});
    }

    public static void checkAppCanRefresh(Application application) {
        if (application == null) {
            LOG.error((Object)APP_NOT_EXIST);
            throw new LegoCheckedException(1073952008L);
        }
        StatusOptChecker.checkAppStatusOpt(AppStatus.from(application.getStatus()).getIndex(), AppOpt.REFRESH.getIndex(), 1073952006L, new String[]{application.getName()});
    }

    public static void checkCreateApp(Application application) {
        boolean isDescLegal;
        String name = application.getName();
        boolean isNameLegal = AppChecker.checkParam(name, NAME_REGEXP, 4, 32);
        if (!isNameLegal) {
            LOG.error((Object)"App(%s) name illeagal", new Object[]{application.getId()});
            throw new LegoCheckedException(1073952400L);
        }
        String description = application.getDescription();
        if (!VerifyUtil.isEmpty((String)description) && !(isDescLegal = AppChecker.checkParam(description, 0, 255))) {
            LOG.error((Object)"App(%s) desc", new Object[]{application.getId()});
            throw new LegoCheckedException(1073952400L);
        }
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        Integer appCountByName = appService.getAppCountByName(application.getName());
        if (appCountByName > 0) {
            LOG.error((Object)"App name(%s) exist", new Object[]{application.getName()});
            throw new LegoCheckedException(1073952009L, new String[]{application.getName()});
        }
        Set<AppServiceInstance> instanceList = application.getServiceInstances();
        for (AppServiceInstance serviceInstance : instanceList) {
            ServiceInstanceQuery serviceInstanceQuery = new ServiceInstanceQuery();
            serviceInstanceQuery.setPage(false);
            serviceInstanceQuery.setProjectId(application.getProjectId());
            serviceInstanceQuery.setInstanceId(serviceInstance.getInstanceId());
            serviceInstanceQuery.setServiceType(serviceInstance.getServiceType());
            long serviceInstanceCount = appService.getServiceInstanceCount(serviceInstanceQuery);
            if (serviceInstanceCount <= 0L) continue;
            LOG.error((Object)"Instance(%s) already exist.", new Object[]{serviceInstance.getInstanceName()});
            throw new LegoCheckedException(1073952000L, new String[]{serviceInstance.getInstanceName()});
        }
        AppChecker.checkAppLimit(application, appService);
    }

    private static void checkAppLimit(Application application, AppService appService) {
        if (application.getServiceInstances().size() > 64) {
            LOG.error((Object)"App(%s) instances count out limit", new Object[]{application.getId()});
            throw new LegoCheckedException(1073952001L, new String[]{application.getName(), String.valueOf(64)});
        }
        if (appService.getAllAppCount() >= 512) {
            LOG.error((Object)"The total number of application is out of limit. Create App(%s) failed.", new Object[]{application.getName()});
            throw new LegoCheckedException(1073952011L, new String[]{String.valueOf(512)});
        }
        if (appService.getAllServiceInstanceCount() + application.getServiceInstances().size() > 3000) {
            LOG.error((Object)"The total number of serviceInstance is out of limit. Create App(%s) failed.", new Object[]{application.getName()});
            throw new LegoCheckedException(1073952012L, new String[]{String.valueOf(3000)});
        }
    }

    public static void checkDeleteApp(Application application) {
        if (application == null) {
            LOG.error((Object)APP_NOT_EXIST);
            throw new LegoCheckedException(1073952008L);
        }
        AppStatus status = AppStatus.from(application.getStatus());
        long errorCode = 1073952004L;
        String[] params = new String[]{application.getName()};
        if (!VerifyUtil.isEmpty((String)application.getRecoverPlanId())) {
            errorCode = 1073952005L;
            RecoverPlan recoverPlanById = ((PlanService)ServiceLocator.getInstance().getService(PlanService.class)).getRecoverPlanById(application.getRecoverPlanId());
            params = new String[]{application.getName(), recoverPlanById.getName()};
            throw new LegoCheckedException(errorCode, params);
        }
        StatusOptChecker.checkAppStatusOpt(status.getIndex(), AppOpt.DELETE.getIndex(), errorCode, params);
    }

    public static Application checkAddServiceInstances(Set<AppServiceInstance> serviceInstances, String projectId, String appId) {
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        Application app = appService.getApplicationById(appId);
        if (app == null) {
            LOG.error((Object)"App is null.");
            throw new LegoCheckedException(1073952008L);
        }
        StatusOptChecker.checkAppStatusOpt(AppStatus.from(app.getStatus()).getIndex(), AppOpt.ADD_INSTANCE.getIndex(), 1073952006L, new String[]{app.getName()});
        AppChecker.checkServiceInstanceUsed(serviceInstances, app);
        return app;
    }

    public static void checkServiceInstanceUsed(Set<AppServiceInstance> serviceInstances, Application app) {
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        if (appService.getServiceInstanceCountByAppId(app.getId()) + (long)serviceInstances.size() > 64L) {
            LOG.error((Object)"App(%s) instances count out limit", new Object[]{app.getId()});
            throw new LegoCheckedException(1073952001L, new String[]{app.getName(), String.valueOf(64)});
        }
        for (AppServiceInstance serviceInstance : serviceInstances) {
            serviceInstance.setApplication(app);
            ServiceInstanceQuery serviceInstanceQuery = new ServiceInstanceQuery();
            serviceInstanceQuery.setPage(false);
            serviceInstanceQuery.setInstanceId(serviceInstance.getInstanceId());
            serviceInstanceQuery.setServiceType(serviceInstance.getServiceType());
            long serviceInstanceCount = appService.getServiceInstanceCount(serviceInstanceQuery);
            if (serviceInstanceCount <= 0L) continue;
            LOG.error((Object)"Instance(%s) already exist.", new Object[]{serviceInstance.getInstanceName()});
            throw new LegoCheckedException(1073952000L, new String[]{serviceInstance.getInstanceName()});
        }
        if (appService.getAllServiceInstanceCount() + serviceInstances.size() > 3000) {
            LOG.error((Object)"The total number of service instance is out of limit.");
            throw new LegoCheckedException(1073952012L, new String[]{String.valueOf(3000)});
        }
    }

    public static void checkUpdateApp(ApplicationBo bo) {
        if (VerifyUtil.isEmpty((String)bo.getProjectId()) || VerifyUtil.isEmpty((String)bo.getApplicationId()) || VerifyUtil.isEmpty((String)bo.getApplicationName())) {
            LOG.error((Object)"appId or name is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        Application application = appService.getApplicationById(bo.getApplicationId());
        StatusOptChecker.checkAppStatusOpt(AppStatus.from(application.getStatus()).getIndex(), AppOpt.MODIFY_INFO.getIndex(), 1073952006L, new String[]{bo.getApplicationName()});
        Application app = ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).getAppByName(bo.getApplicationName());
        Optional.ofNullable(app).map(application1 -> app.getId()).filter(id -> !id.equals(bo.getApplicationId())).ifPresent(id -> {
            LOG.error((Object)"Update app(%s) info failed. appName(%s) already exists.", new Object[]{bo.getApplicationId(), bo.getApplicationName()});
            throw new LegoCheckedException(1073952009L, new String[]{bo.getApplicationName()});
        });
    }

    public static boolean checkParam(String param, String match, int minSize, int maxSize) {
        if (minSize > param.length() || maxSize < param.length()) {
            LOG.error((Object)"Param length is not match.");
            return false;
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        if (!mat.matches() || !mat.find(0) || mat.groupCount() < 0) {
            LOG.error((Object)"Param pattern is not match.");
            return false;
        }
        return true;
    }

    public static boolean checkParam(String param, int minSize, int maxSize) {
        if (minSize > param.length() || maxSize < param.length()) {
            LOG.error((Object)"Param length is not match.");
            return false;
        }
        return true;
    }
}

