/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.checker;

import com.huawei.csr.framework.common.constants.DisasterRecoveryType;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.dao.SiteInfoDao;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.ServiceInfo;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ConfigChecker {
    private static final Log LOG = LogFactory.getInstance(ConfigChecker.class);
    private static final int MAX_SITE_ITEM_SIZE = 50;
    private static final int MAX_SITE_SIZE = 10;
    private static final int MAX_SITE_REGION_SIZE = 2;
    private static final int MAX_SERVICE_SIZE = 100;
    private static final int MAX_REGION_AZ_SIZE = 10;

    private ConfigChecker() {
    }

    public static void checkCreateSite(String siteName, List<SiteInfo> siteList) {
        ConfigChecker.checkSiteRegionAzRepeat(siteList, false);
        ConfigChecker.checkSiteRegionSize(siteList);
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        List<SiteInfo> dbSiteList = service.getSiteInfosForChecker();
        ConfigChecker.checkSiteNameExist(siteName, dbSiteList);
        List<SiteInfo> allSiteList = ConfigChecker.combine(siteList, dbSiteList);
        ConfigChecker.checkSiteRegionAzRepeat(allSiteList, true);
        ConfigChecker.checkSiteSize(allSiteList);
        ConfigChecker.checkSiteRegionAzCount(allSiteList);
        ConfigChecker.checkSiteItemSize(allSiteList);
    }

    public static void checkSiteRegionAzCount(List<SiteInfo> allSiteList) {
        allSiteList.forEach(item -> {
            int azCount = allSiteList.stream().filter(siteInfo -> siteInfo.getSiteName().equals(item.getSiteName()) && siteInfo.getRegionId().equals(item.getRegionId())).collect(Collectors.toSet()).size();
            if (azCount > 10) {
                LOG.error((Object)"Az of same region in Site %s over limit.", new Object[]{item.getSiteName()});
                throw new LegoCheckedException(1073952218L, new String[]{String.valueOf(10)});
            }
        });
    }

    private static void checkSiteRegionAzRepeat(List<SiteInfo> siteList, boolean existDbData) {
        HashSet<String> regionAzSet = new HashSet<String>();
        for (SiteInfo site : siteList) {
            String regionAz = ConfigChecker.getRegionAzId(site.getRegionId(), site.getAzId());
            if (regionAzSet.contains(regionAz)) {
                LOG.error((Object)"Site region az repeat:%s", new Object[]{regionAz});
                throw new LegoCheckedException(existDbData ? 1073952201L : 1073952400L, new String[]{regionAz});
            }
            regionAzSet.add(regionAz);
        }
    }

    private static String getRegionAzId(String regionId, String azId) {
        return regionId + "_@_" + azId;
    }

    private static void checkSiteRegionSize(List<SiteInfo> siteList) {
        if (siteList.stream().map(SiteInfo::getRegionId).collect(Collectors.toSet()).size() > 2) {
            LOG.error((Object)"The size of regions of the one site exceeds limit.");
            throw new LegoCheckedException(1073952207L, new String[]{String.valueOf(2)});
        }
    }

    private static void checkSiteNameExist(String siteName, List<SiteInfo> dbSiteList) {
        boolean match;
        if (!VerifyUtil.isEmpty(dbSiteList) && (match = dbSiteList.stream().anyMatch(site -> site.getSiteName().equals(siteName)))) {
            LOG.error((Object)"SiteInfo name exist, siteName is:%s", new Object[]{siteName});
            throw new LegoCheckedException(1073952200L, new String[]{siteName});
        }
    }

    private static void checkSiteItemSize(List<SiteInfo> allSiteList) {
        int itemSize = allSiteList.size();
        if (itemSize > 50) {
            LOG.error((Object)"Size of site item exceeds limit:%s", new Object[]{String.valueOf(itemSize)});
            throw new LegoCheckedException(1073952203L, new String[]{String.valueOf(50)});
        }
    }

    private static void checkSiteSize(List<SiteInfo> allSiteList) {
        int siteSize = allSiteList.stream().map(SiteInfo::getSiteName).collect(Collectors.toSet()).size();
        if (siteSize > 10) {
            LOG.error((Object)"Size of site exceeds limit:%s", new Object[]{String.valueOf(siteSize)});
            throw new LegoCheckedException(1073952202L, new String[]{String.valueOf(10)});
        }
    }

    public static void checkAddSiteRegionAzs(String siteId, List<SiteInfo> siteList) {
        ConfigChecker.checkSiteRegionAzRepeat(siteList, false);
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        List<SiteInfo> dbSiteList = service.getSiteInfosForChecker();
        List<SiteInfo> allSiteList = ConfigChecker.combine(siteList, dbSiteList);
        ConfigChecker.checkSiteRegionAzRepeat(allSiteList, true);
        List dbSiteListOfSiteId = dbSiteList.stream().filter(site -> site.getSiteId().equals(siteId)).collect(Collectors.toList());
        ConfigChecker.checkSiteRegionSize(ConfigChecker.combine(siteList, dbSiteListOfSiteId));
        ConfigChecker.checkSiteRegionAzCount(allSiteList);
        ConfigChecker.checkSiteItemSize(allSiteList);
    }

    public static void checkSiteNotEmpty(List<SiteInfo> dbSiteList) {
        if (VerifyUtil.isEmpty(dbSiteList)) {
            LOG.error((Object)"No site info exist.");
            throw new LegoCheckedException(1073952204L);
        }
    }

    private static <T> List<T> combine(List<T> list1, List<T> list2) {
        ArrayList<T> allList = new ArrayList<T>();
        if (!VerifyUtil.isEmpty(list1)) {
            allList.addAll(list1);
        }
        if (!VerifyUtil.isEmpty(list2)) {
            allList.addAll(list2);
        }
        return allList;
    }

    public static List<SiteInfo> checkAndGetRemoveSitesByRegionAzs(String siteId, List<SiteInfo> siteList) {
        ConfigChecker.checkSiteRegionAzRepeat(siteList, false);
        List<SiteInfo> dbSiteList = ConfigChecker.checkAndGetExistSiteInfos(siteId, siteList);
        ConfigChecker.checkServiceInfoRef(dbSiteList);
        return dbSiteList;
    }

    private static List<SiteInfo> checkAndGetExistSiteInfos(String siteId, List<SiteInfo> siteList) {
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        List<SiteInfo> dbSiteList = service.getSiteInfosForChecker();
        ConfigChecker.checkSiteNotEmpty(dbSiteList);
        ArrayList<SiteInfo> delList = new ArrayList<SiteInfo>();
        for (SiteInfo site : siteList) {
            boolean isFind = false;
            for (SiteInfo dbSite : dbSiteList) {
                if (!siteId.equals(dbSite.getSiteId()) || !site.getRegionId().equals(dbSite.getRegionId()) || !site.getAzId().equals(dbSite.getAzId())) continue;
                isFind = true;
                delList.add(dbSite);
                break;
            }
            if (isFind) continue;
            LOG.error((Object)"Can not find remove item, siteId:%s, region:%s, az:%s", new Object[]{siteId, site.getRegionId(), site.getAzId()});
            throw new LegoCheckedException(1073952204L);
        }
        return delList;
    }

    private static String getOrEmpty(String para) {
        return VerifyUtil.isEmpty((String)para) ? "" : para;
    }

    private static String[] getRegionAzParameter(ServiceInfo srv) {
        return new String[]{ConfigChecker.getOrEmpty(srv.getRegionName()), ConfigChecker.getOrEmpty(srv.getAzName()), ConfigChecker.getOrEmpty(srv.getDrRegionName()), ConfigChecker.getOrEmpty(srv.getDrAzName())};
    }

    public static void checkServiceInfoRef(List<SiteInfo> dbSiteList) {
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        List<ServiceInfo> dbSrvList = service.getServiceInfos();
        if (!VerifyUtil.isEmpty(dbSrvList)) {
            HashSet<String> records = new HashSet<String>();
            for (SiteInfo site : dbSiteList) {
                records.add(ConfigChecker.getRegionAzId(site.getRegionId(), site.getAzId()));
            }
            for (ServiceInfo srv : dbSrvList) {
                String primary = ConfigChecker.getRegionAzId(srv.getRegionId(), srv.getAzId());
                if (records.contains(primary)) {
                    LOG.error((Object)"Service info ref conflict:%s", new Object[]{primary});
                    throw new LegoCheckedException(1073952206L, new String[]{ConfigChecker.getOrEmpty(srv.getRegionName()), ConfigChecker.getOrEmpty(srv.getAzName())});
                }
                String second = ConfigChecker.getRegionAzId(srv.getDrRegionId(), srv.getDrAzId());
                if (!records.contains(second)) continue;
                LOG.error((Object)"Service info ref conflict:%s", new Object[]{second});
                throw new LegoCheckedException(1073952206L, new String[]{ConfigChecker.getOrEmpty(srv.getDrRegionName()), ConfigChecker.getOrEmpty(srv.getDrAzName())});
            }
        }
    }

    public static void checkRemoveSites(List<SiteInfo> dbSiteList) {
        ConfigChecker.checkSiteNotEmpty(dbSiteList);
        ConfigChecker.checkServiceInfoRef(dbSiteList);
    }

    public static void checkCreateServiceInfos(List<ServiceInfo> srvList) {
        srvList.forEach(ConfigChecker::checkServiceInSite);
        ConfigChecker.checkServiceRepeat(srvList, false);
        srvList.forEach(ConfigChecker::checkServiceRegionAz);
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        List<ServiceInfo> dbSrvList = service.getServiceInfos();
        ConfigChecker.checkServiceRepeat(ConfigChecker.combine(srvList, dbSrvList), true);
        ConfigChecker.checkServiceSizeLimit(srvList, dbSrvList);
    }

    private static void checkServiceInSite(ServiceInfo srv) {
        List<SiteInfo> siteInfoList;
        SiteInfoDao siteInfoDao = (SiteInfoDao)ServiceLocator.getInstance().getService(SiteInfoDao.class);
        if (!VerifyUtil.isEmpty((String)srv.getRegionId()) && VerifyUtil.isEmpty(siteInfoList = siteInfoDao.querySiteInfoByRegionId(srv.getRegionId()))) {
            LOG.error((Object)"Service %s region does not exist in site.", new Object[]{srv.getRegionId()});
            throw new LegoCheckedException(1073952400L);
        }
        if (!VerifyUtil.isEmpty((String)srv.getAzId()) && VerifyUtil.isEmpty(siteInfoList = siteInfoDao.querySiteInfoByAzId(srv.getAzId()))) {
            LOG.error((Object)"Service %s az does not exist in site.", new Object[]{srv.getAzId()});
            throw new LegoCheckedException(1073952400L);
        }
        if (!VerifyUtil.isEmpty((String)srv.getDrRegionId()) && VerifyUtil.isEmpty(siteInfoList = siteInfoDao.querySiteInfoByRegionId(srv.getDrRegionId()))) {
            LOG.error((Object)"Service %s dr region does not exist in site.", new Object[]{srv.getDrRegionId()});
            throw new LegoCheckedException(1073952400L);
        }
        if (!VerifyUtil.isEmpty((String)srv.getDrAzId()) && VerifyUtil.isEmpty(siteInfoList = siteInfoDao.querySiteInfoByAzId(srv.getDrAzId()))) {
            LOG.error((Object)"Service %s dr az does not exist in site.", new Object[]{srv.getDrAzId()});
            throw new LegoCheckedException(1073952400L);
        }
    }

    private static void checkServiceRepeat(List<ServiceInfo> srvList, boolean existDbData) {
        HashSet<String> oneSideKeys = new HashSet<String>();
        HashSet<String> twoSideKeys = new HashSet<String>();
        for (ServiceInfo srv : srvList) {
            String primary = ConfigChecker.getOneSideKey(srv, true);
            if (ServiceType.from(srv.getServiceType()).isLimitOneSideRegionAz()) {
                if (oneSideKeys.contains(primary)) {
                    LOG.error((Object)"Service info repeat:%s", new Object[]{srv.toString()});
                    throw new LegoCheckedException(existDbData ? 1073952209L : 1073952210L, ConfigChecker.getRegionAzParameter(srv));
                }
                oneSideKeys.add(primary);
                continue;
            }
            String second = ConfigChecker.getOneSideKey(srv, false);
            String twoSideKey = ConfigChecker.getTwoSideKey(primary, second);
            if (twoSideKeys.contains(twoSideKey)) {
                LOG.error((Object)"Service info repeat:%s", new Object[]{srv.toString()});
                throw new LegoCheckedException(existDbData ? 1073952209L : 1073952210L, ConfigChecker.getRegionAzParameter(srv));
            }
            twoSideKeys.add(twoSideKey);
        }
    }

    private static String getOneSideKey(ServiceInfo serviceInfo, boolean isPrimary) {
        String serviceType = serviceInfo.getServiceType();
        String drType = serviceInfo.getDrType();
        return isPrimary ? String.join((CharSequence)"_@_", serviceType, drType, serviceInfo.getAzId(), serviceInfo.getRegionId()) : String.join((CharSequence)"_@_", serviceType, drType, serviceInfo.getDrAzId(), serviceInfo.getDrRegionId());
    }

    private static String getTwoSideKey(String primary, String second) {
        if (primary.compareTo(second) < 0) {
            return String.join((CharSequence)"_@_", primary, second);
        }
        return String.join((CharSequence)"_@_", second, primary);
    }

    private static void checkServiceRegionAz(ServiceInfo srv) {
        if (!ServiceType.from(srv.getServiceType()).isLimitOneSideRegionAz() && DisasterRecoveryType.INTER_AZ.equals((Object)DisasterRecoveryType.from(srv.getDrType()))) {
            if (!srv.getRegionId().equals(srv.getDrRegionId())) {
                LOG.error((Object)"In a inter-az scenario, the regions at both ends must be the same.");
                throw new LegoCheckedException(1073952211L, new String[]{ConfigChecker.getOrEmpty(srv.getRegionName()), ConfigChecker.getOrEmpty(srv.getDrRegionName())});
            }
            if (srv.getAzId().equals(srv.getDrAzId())) {
                LOG.error((Object)"In a inter-az scenario, the azs at both ends must be the different.");
                throw new LegoCheckedException(1073952212L, new String[]{ConfigChecker.getOrEmpty(srv.getAzName()), ConfigChecker.getOrEmpty(srv.getDrAzName())});
            }
            ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
            SiteInfo pdSite = service.getSiteInfoByRegionAz(srv.getRegionId(), srv.getAzId());
            SiteInfo drSite = service.getSiteInfoByRegionAz(srv.getDrRegionId(), srv.getDrAzId());
            if (pdSite.getSiteId().equals(drSite.getSiteId())) {
                LOG.error((Object)"Site of pd region: %s, az: %s, dr region: %s, az: %s belong to the same site", new Object[]{srv.getRegionId(), srv.getAzId(), srv.getDrRegionId(), srv.getDrAzId()});
                throw new LegoCheckedException(1073952216L, ConfigChecker.getRegionAzParameter(srv));
            }
            ConfigChecker.checkAzDirectionReverse(srv, service);
        }
    }

    private static void checkAzDirectionReverse(ServiceInfo srv, ConfigService service) {
        service.getServiceInfos().forEach(serviceInfo -> {
            if (serviceInfo.getServiceType().equals(srv.getServiceType()) && serviceInfo.getAzId().equals(srv.getDrAzId()) && serviceInfo.getDrAzId().equals(srv.getAzId())) {
                LOG.error((Object)"Inter-az service: %s pd and dr az direction reverse.", new Object[]{serviceInfo.getId()});
                throw new LegoCheckedException(1073952209L, ConfigChecker.getRegionAzParameter(srv));
            }
        });
    }

    private static void checkServiceSizeLimit(List<ServiceInfo> srvList, List<ServiceInfo> dbSrvList) {
        int size = srvList.size() + (dbSrvList == null ? 0 : dbSrvList.size());
        if (size > 100) {
            LOG.error((Object)"Size of service info exceeds limit:%s", new Object[]{String.valueOf(size)});
            throw new LegoCheckedException(1073952213L, new String[]{String.valueOf(100)});
        }
    }

    public static void checkUpdateRegionAz(ServiceInfo srv) {
        ConfigChecker.checkServiceInSite(srv);
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        ArrayList<ServiceInfo> dbSrvList = new ArrayList<ServiceInfo>(service.getServiceInfos());
        if (VerifyUtil.isEmpty(dbSrvList)) {
            LOG.error((Object)"No service info exist.");
            throw new LegoCheckedException(1073952214L);
        }
        ServiceInfo dbSrv = null;
        for (ServiceInfo item : dbSrvList) {
            if (!item.getId().equals(srv.getId())) continue;
            dbSrv = item;
            break;
        }
        if (dbSrv == null) {
            LOG.error((Object)"Not found service info: %s", new Object[]{srv.getId()});
            throw new LegoCheckedException(1073952214L);
        }
        for (ServiceInfo srvInfo : dbSrvList) {
            ConfigChecker.checkServiceInfoRepeat(srv, srvInfo);
        }
        if (!srv.getServiceType().equals(dbSrv.getServiceType())) {
            LOG.error((Object)"The value of serviceType cannot be changed.");
            throw new LegoCheckedException(1073952208L, new String[]{srv.getServiceType(), ConfigChecker.getOrEmpty(srv.getRegionName()), ConfigChecker.getOrEmpty(srv.getAzName())});
        }
        srv.setDrType(dbSrv.getDrType());
        ConfigChecker.checkServiceRegionAz(srv);
        ConfigChecker.checkConfigUsedByApp(srv.getId());
    }

    private static void checkServiceInfoRepeat(ServiceInfo srv, ServiceInfo dbSrv) {
        if (dbSrv.getRegionId().equals(srv.getRegionId()) && dbSrv.getAzId().equals(srv.getAzId()) && dbSrv.getServiceType().equals(srv.getServiceType())) {
            if (VerifyUtil.isEmpty((String)srv.getDrRegionId()) && VerifyUtil.isEmpty((String)srv.getDrAzId())) {
                LOG.error((Object)"Service %s repeat in db.", new Object[]{srv.getId()});
                throw new LegoCheckedException(1073952209L, ConfigChecker.getRegionAzParameter(srv));
            }
            if (dbSrv.getDrAzId().equals(srv.getDrAzId()) && dbSrv.getDrRegionId().equals(srv.getDrRegionId())) {
                LOG.error((Object)"Service %s repeat in db.", new Object[]{srv.getId()});
                throw new LegoCheckedException(1073952209L, ConfigChecker.getRegionAzParameter(srv));
            }
        }
    }

    public static List<ServiceInfo> checkAndGetServiceByIds(List<String> srvIdList) {
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        List<ServiceInfo> dbSrvList = service.getServiceInfos();
        if (VerifyUtil.isEmpty(dbSrvList)) {
            LOG.error((Object)"No service info exist.");
            throw new LegoCheckedException(1073952214L);
        }
        Map<String, ServiceInfo> dbMap = dbSrvList.stream().collect(Collectors.toMap(AbstractEntity::getId, srv -> srv));
        ArrayList<ServiceInfo> delList = new ArrayList<ServiceInfo>();
        for (String id : new HashSet<String>(srvIdList)) {
            if (dbMap.containsKey(id)) {
                delList.add(dbMap.get(id));
                continue;
            }
            LOG.error((Object)"Can not find remove item id:%s", new Object[]{id});
            throw new LegoCheckedException(1073952214L);
        }
        ArrayList appUsedServices = new ArrayList();
        delList.forEach(srv -> {
            try {
                ConfigChecker.checkConfigUsedByApp(srv.getId());
            }
            catch (LegoCheckedException e) {
                if (srvIdList.size() == 1) {
                    LOG.error((Object)"Service %s is referred by app", new Object[]{srv.getId()});
                    throw e;
                }
                appUsedServices.add(srv.getId());
            }
        });
        delList.removeIf(srv -> appUsedServices.contains(srv.getId()));
        return delList;
    }

    public static void checkConfigUsedByApp(String srvId) {
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        ConfigService service = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        ServiceInfo serviceInfo = (ServiceInfo)service.getServiceInfos().stream().filter(srv -> srv.getId().equals(srvId)).collect(Collectors.toList()).get(0);
        List<AppServiceInstance> instanceList = appService.getServiceInstanceListByRegionAz(serviceInfo.getRegionId(), serviceInfo.getAzId(), serviceInfo.getDrRegionId(), serviceInfo.getDrAzId());
        if (!VerifyUtil.isEmpty((String)serviceInfo.getDrRegionId()) && !VerifyUtil.isEmpty((String)serviceInfo.getDrAzId())) {
            instanceList.addAll(appService.getServiceInstanceListByRegionAz(serviceInfo.getDrRegionId(), serviceInfo.getDrAzId(), serviceInfo.getRegionId(), serviceInfo.getAzId()));
        }
        if (!VerifyUtil.isEmpty(instanceList) && instanceList.stream().anyMatch(instance -> serviceInfo.getServiceType().equals(instance.getServiceType()))) {
            LOG.error((Object)"ServiceInfo region az are used by appServiceInstance");
            throw new LegoCheckedException(1073952217L, ConfigChecker.getRegionAzParameter(serviceInfo));
        }
    }

    public static void checkSiteUsedByApp(String siteId) {
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        List<Application> appList = appService.getAllApplications();
        appList.forEach(app -> {
            if (app.getServiceInstances().stream().anyMatch(instance -> siteId.equals(instance.getPdSiteId()) || siteId.equals(instance.getDrSiteId()))) {
                LOG.error((Object)"SiteId: %s is used by applications", new Object[]{siteId});
                throw new LegoCheckedException(1073952215L, new String[]{((ConfigService)ServiceLocator.getInstance().getService(ConfigService.class)).getSiteInfos(siteId).get(0).getSiteName()});
            }
        });
    }
}

