/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.checker;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.model.RecoverExecuteBo;
import com.huawei.csr.framework.common.model.RecoverLogQuery;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.RevocerPlanBo;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.AppOpt;
import com.huawei.csr.framework.common.statusopt.opt.RecoverPlanOpt;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.dao.RecoverPlanDao;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class PlanChecker {
    private static final Log LOG = LogFactory.getInstance(PlanChecker.class);

    private PlanChecker() {
    }

    public static void checkParamsForPriority(String projectId, String sitePlanId, Map<String, Integer> map) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)sitePlanId)) {
            LOG.error((Object)"ProjectId or SitePlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        if (VerifyUtil.isEmpty(map)) {
            LOG.error((Object)"PlanPriorityMap is empty.");
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkSitePlanCount(String sitePlanId, String siteName, int paraCount) {
        PlanService service = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        long count = service.getRecoverPlanCountBySitePlanId(sitePlanId);
        if (count + (long)paraCount > 16L) {
            LOG.error((Object)"Recover plan count reach limit.");
            throw new LegoCheckedException(1073952100L, new String[]{siteName, String.valueOf(16)});
        }
    }

    public static void checkCreatePlan(RevocerPlanBo parameters) {
        if (VerifyUtil.isEmpty((String)parameters.getProjectId()) || VerifyUtil.isEmpty((String)parameters.getName())) {
            LOG.error((Object)"ProjectId or name is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        if (planService.getAllRecoverPlanCount() >= 512) {
            LOG.error((Object)"The total number of recover plan is out of limit.");
            throw new LegoCheckedException(1073952110L, new String[]{String.valueOf(512)});
        }
        PlanChecker.checkRecoverPlanNameExist(null, parameters.getName());
        PlanChecker.checkAddApplicationIds(parameters.getApplicationIds());
    }

    private static void checkAddApplicationIds(List<String> applications) {
        if (VerifyUtil.isEmpty(applications)) {
            LOG.error((Object)"Applications is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        if (applications.size() > 32) {
            LOG.error((Object)"The size of applicationId list is large than %s, input size is %s.", new Object[]{32, applications.size()});
            throw new LegoCheckedException(1073952103L, new String[]{String.valueOf(32)});
        }
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        for (String applicationId : applications) {
            Application application = planService.getApp(applicationId);
            if (application == null) {
                LOG.error((Object)"Application is not exists,the applicationId is %s.", new Object[]{applicationId});
                throw new LegoCheckedException(1073952101L);
            }
            String recoverPlanId = application.getRecoverPlanId();
            if (!VerifyUtil.isEmpty((String)recoverPlanId)) {
                RecoverPlan recoverPlan = planService.getRecoverPlanById(recoverPlanId);
                LOG.error((Object)"The application is related to recover plan,the applicationId is %s.", new Object[]{applicationId});
                throw new LegoCheckedException(1073952104L, new String[]{application.getName(), recoverPlan.getName()});
            }
            AppStatus appState = AppStatus.from(application.getStatus());
            if (appState == null) {
                LOG.error((Object)"The application not in steady state,the applicationId is %s.", new Object[]{applicationId});
                throw new LegoCheckedException(1073952102L, new String[]{application.getName()});
            }
            StatusOptChecker.checkAppStatusOpt(appState.getIndex(), AppOpt.ADD_TO_RECOVER_PLAN.getIndex(), 1073952403L);
        }
    }

    public static void checkDeletePlan(String projectId, String planId) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)planId)) {
            LOG.error((Object)"ProjectId or planId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        RecoverPlan recoverPlan = planService.getRecoverPlanById(planId);
        if (recoverPlan == null) {
            LOG.error((Object)"Recover plan is not exist.");
            throw new LegoCheckedException(1073952109L);
        }
        RecoverStatus recoverPlanState = RecoverStatus.from(recoverPlan.getStatus());
        if (recoverPlanState == null) {
            LOG.error((Object)"Recover status is null, the plan id is %s", new Object[]{planId});
            throw new LegoCheckedException(1073952403L);
        }
        StatusOptChecker.checkRecoverPlanStatusOpt(recoverPlanState.getIndex(), RecoverPlanOpt.DELETE.getIndex(), 1073952403L);
        RecoverPreplanService recoverPreplanService = (RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class);
        RecoverPreplanQuery recoverPreplanQuery = new RecoverPreplanQuery();
        recoverPreplanQuery.setPlanId(planId);
        recoverPreplanQuery.setProjectId(projectId);
        int prePlanCount = recoverPreplanService.queryPreplansCount(recoverPreplanQuery);
        if (prePlanCount > 0) {
            LOG.error((Object)"Recover plan '%s' contains %s prePlans,can not be deleted.", new Object[]{planId, prePlanCount});
            throw new LegoCheckedException(1073952106L, new String[]{recoverPlan.getName()});
        }
    }

    public static void checkUpdatePlan(RevocerPlanBo params) {
        if (VerifyUtil.isEmpty((String)params.getProjectId()) || VerifyUtil.isEmpty((String)params.getPlanId()) || VerifyUtil.isEmpty((String)params.getName())) {
            LOG.error((Object)"ProjectId or planId or name is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        PlanChecker.checkRecoverPlanNameExist(params.getPlanId(), params.getName());
        PlanChecker.checkRecoverPlanIsSteadyState(params.getPlanId(), RecoverPlanOpt.MODIFY_INFO);
    }

    private static void checkRecoverPlanIsSteadyState(String planId, RecoverPlanOpt opt) {
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        RecoverPlan recoverPlan = planService.getRecoverPlanById(planId);
        if (recoverPlan == null) {
            LOG.error((Object)"The revover is not exist.recover plan id is '%s'.", new Object[]{planId});
            throw new LegoCheckedException(1073952109L);
        }
        RecoverStatus recoverPlanState = RecoverStatus.from(recoverPlan.getStatus());
        if (recoverPlanState == null) {
            LOG.error((Object)"Recover status is null, the plan id is %s", new Object[]{planId});
            throw new LegoCheckedException(1073952403L);
        }
        StatusOptChecker.checkRecoverPlanStatusOpt(recoverPlanState.getIndex(), opt.getIndex(), 1073952403L);
    }

    public static void checkAddAppToPlan(String projectId, String planId, List<String> applications) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty(applications)) {
            LOG.error((Object)"ProjectId or planId or applications is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        PlanChecker.checkRecoverPlanIsSteadyState(planId, RecoverPlanOpt.ADD_APP);
        PlanChecker.checkAddApplicationIds(applications);
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        List applicationList = planService.getAppByRecoverPlanId(projectId, planId).stream().map(AbstractEntity::getId).collect(Collectors.toList());
        applicationList.addAll(applications);
        if (applicationList.size() > 32) {
            LOG.error((Object)"The size of applicationId list is large than %s, input size is %s.The Plan id is %s", new Object[]{32, applications.size(), planId});
            throw new LegoCheckedException(1073952103L, new String[]{String.valueOf(32)});
        }
    }

    public static void checkRemoveAppFromPlan(String projectId, String planId, List<String> applications) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty(applications)) {
            LOG.error((Object)"ProjectId or planId or applications is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        PlanChecker.checkRecoverPlanIsSteadyState(planId, RecoverPlanOpt.REMOVE_APP);
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        Map<String, List<Application>> applicationGroupByIdMap = planService.getAppByRecoverPlanId(projectId, planId).stream().collect(Collectors.groupingBy(AbstractEntity::getId));
        for (String removedAppId : applications) {
            if (!applicationGroupByIdMap.containsKey(removedAppId)) {
                LOG.error((Object)"The application id '%s' not in the application list of the recover plan '%s'.", new Object[]{removedAppId, planId});
                throw new LegoCheckedException(1073952400L);
            }
            AppStatus appState = AppStatus.from(applicationGroupByIdMap.get(removedAppId).get(0).getStatus());
            if (appState == null) {
                LOG.error((Object)"The application not in steady state,the applicationId is %s.", new Object[]{removedAppId});
                throw new LegoCheckedException(1073952403L);
            }
            StatusOptChecker.checkAppStatusOpt(appState.getIndex(), AppOpt.REMOVE_FROM_RECOVER_PLAN.getIndex(), 1073952403L);
        }
    }

    public static void checkSitePlanMapExist(String sitePlanId, String siteName, String recoverPlanId) {
        PlanService service = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        long count = service.getSitePlanMapCount(sitePlanId, recoverPlanId);
        if (count > 0L) {
            LOG.error((Object)"Site plan map already exist.");
            PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
            RecoverPlan recoverPlan = planService.getRecoverPlanById(recoverPlanId);
            throw new LegoCheckedException(1073952111L, new String[]{siteName, recoverPlan.getName()});
        }
    }

    public static void checkSitePlanMapNotExist(String sitePlanId, String siteName, String recoverPlanId) {
        PlanService service = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        long count = service.getSitePlanMapCount(sitePlanId, recoverPlanId);
        if (count == 0L) {
            LOG.error((Object)"Site plan map not exist.");
            PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
            RecoverPlan recoverPlan = planService.getRecoverPlanById(recoverPlanId);
            throw new LegoCheckedException(1073952112L, new String[]{siteName, recoverPlan.getName()});
        }
    }

    public static void checkRecoverPlanAppSite(String projectId, String recoverPlanId, SitePlan sitePlan) {
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        List<Application> appList = appService.getApplicationListByPlanId(projectId, recoverPlanId);
        for (Application app : appList) {
            for (AppServiceInstance instance : app.getServiceInstances()) {
                if (!sitePlan.getSiteId().equals(instance.getPdSiteId()) && !sitePlan.getSiteId().equals(instance.getDrSiteId())) continue;
                return;
            }
        }
        LOG.error((Object)"Applications of recoverPlan %s all not belong to site.", new Object[]{recoverPlanId});
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        RecoverPlan recoverPlan = planService.getRecoverPlanById(recoverPlanId);
        throw new LegoCheckedException(1073952113L, new String[]{recoverPlan.getName(), sitePlan.getSiteName()});
    }

    public static void checkExecutePlan(RecoverExecuteBo executeBo, RecoverPreplan recoverPreplan, RecoverPlan recoverPlan) {
        if (!recoverPreplan.getIsValid()) {
            LOG.error((Object)"RecoverPreplan '%s' status is not Valid", new Object[]{recoverPreplan.getId()});
            throw new LegoCheckedException(1073952804L, new String[]{recoverPreplan.getName()});
        }
        Optional<RecoverLog> optionalRecoverLog = PlanChecker.getRecoverLog(recoverPreplan);
        if (optionalRecoverLog.isPresent() && RecoverLogStatus.RUNNING.getValue().equals(optionalRecoverLog.get().getStatus())) {
            switch (executeBo.getAction()) {
                case STOP: 
                case SUSPEND: {
                    return;
                }
                case EXECUTE: {
                    LOG.error((Object)"ExecutePlan error, action: %s, recoverPlan status:%s", new Object[]{executeBo.getAction().getValue(), recoverPlan.getStatus()});
                    throw new LegoCheckedException(1073952805L, new String[]{recoverPreplan.getName()});
                }
            }
            return;
        }
        switch (executeBo.getAction()) {
            case STOP: 
            case SUSPEND: {
                LOG.error((Object)"ExecutePlan error, action: %s, recoverPlan status:%s", new Object[]{executeBo.getAction().getValue(), recoverPlan.getStatus()});
                throw new LegoCheckedException(1073952805L, new String[]{recoverPreplan.getName()});
            }
            case EXECUTE: {
                PlanChecker.checkExecuteOperator(recoverPreplan, recoverPlan);
                break;
            }
        }
    }

    private static void checkExecuteOperator(RecoverPreplan recoverPreplan, RecoverPlan recoverPlan) {
        RecoverStatus recoverPlanStatus = RecoverStatus.from(recoverPlan.getStatus());
        RecoverOperateType recoverOperateType = RecoverOperateType.from(recoverPreplan.getType());
        StatusOptChecker.checkRecoverPlanStatusOpt(RecoverStatus.from(recoverPlanStatus.getValue()).getIndex(), RecoverPlanOpt.from(recoverOperateType.getValue()).getIndex(), 1073952805L, new String[]{recoverPreplan.getName()});
    }

    private static Optional<RecoverLog> getRecoverLog(RecoverPreplan recoverPreplan) {
        RecoverLogQuery recoverLogQuery = new RecoverLogQuery();
        recoverLogQuery.setProjectId(recoverPreplan.getProjectId());
        recoverLogQuery.setResourceIds(Collections.singletonList(recoverPreplan.getId()));
        PlanService service = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        List<RecoverLog> recoverLogs = service.getRecoverLogList(recoverLogQuery);
        if (VerifyUtil.isEmpty(recoverLogs)) {
            LOG.info((Object)"RecoverLogs is empty.");
            return Optional.empty();
        }
        return Optional.of(recoverLogs.get(0));
    }

    private static void checkRecoverPlanNameExist(String planId, String recoverPlanName) {
        RecoverPlanDao recoverPlanDao = (RecoverPlanDao)ServiceLocator.getInstance().getService(RecoverPlanDao.class);
        Optional<RecoverPlan> recoverPlanOptional = recoverPlanDao.getRecoverPlanByName(recoverPlanName);
        if (!recoverPlanOptional.isPresent()) {
            return;
        }
        RecoverPlan recoverPlan = recoverPlanOptional.get();
        if (recoverPlan.getId().equals(planId)) {
            return;
        }
        LOG.error((Object)"RecoverPlan name %s is exist.", new Object[]{recoverPlanName});
        throw new LegoCheckedException(1073952115L, new String[]{recoverPlanName});
    }

    public static void checkRecoverPlanStatus(String recoverPlanId) {
        RecoverPlan recoverPlan = ((PlanService)ServiceLocator.getInstance().getService(PlanService.class)).getRecoverPlanById(recoverPlanId);
        if (!RecoverStatus.NORMAL.getValue().equals(recoverPlan.getStatus())) {
            LOG.error((Object)"Recover plan %s status is not normal", new Object[]{recoverPlanId});
            throw new LegoCheckedException(1073952403L);
        }
    }
}

