/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.checker;

import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverFlowChain;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public final class RecoverFlowChecker {
    private static final Log LOGGER = LogFactory.getInstance(RecoverFlowChecker.class);

    private RecoverFlowChecker() {
    }

    public static void checkFlowNameExistInProject(String projectId, String name) {
        RecoverFlowQuery recoverFlowQuery = new RecoverFlowQuery();
        recoverFlowQuery.setProjectId(projectId);
        recoverFlowQuery.setFullFlowName(name);
        long count = ((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).queryRecoverFlowCount(recoverFlowQuery);
        if (count > 0L) {
            LOGGER.error((Object)"Recover Flow name '%s' already exist in project '%s'.", new Object[]{name, projectId});
            throw new LegoCheckedException(1073952600L, new String[]{name});
        }
    }

    public static void checkFlowId(String id) {
        if (VerifyUtil.isEmpty((String)id)) {
            LOGGER.error((Object)"Flow id is empty.");
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkRecoverFlowExist(String flowId) {
        if (VerifyUtil.isEmpty((Object)((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).getRecoverFlowById(flowId))) {
            LOGGER.error((Object)"Recover flow not exist, flow id: %s", new Object[]{flowId});
            throw new LegoCheckedException(1073952601L);
        }
    }

    public static void checkFlowExistedInStage(String stageId, String flowId) {
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        if (flowService.getStageFlowMapCount(stageId, flowId) > 0L) {
            LOGGER.error((Object)"Stage flow map has exist, stage id:'%s', flow id:'%s'.", new Object[]{stageId, flowId});
            throw new LegoCheckedException(1073952603L, new String[]{flowService.getRecoverFlowById(flowId).getName(), ((RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class)).getStageById(stageId).getName()});
        }
    }

    public static void checkFlowNoExistedInStage(String stageId, String flowId) {
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        if (flowService.getStageFlowMapCount(stageId, flowId) == 0L) {
            LOGGER.error((Object)"Stage flow map not exist, stage id:'%s', flow id:'%s'.", new Object[]{stageId, flowId});
            throw new LegoCheckedException(1073952604L, new String[]{flowService.getRecoverFlowById(flowId).getName(), ((RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class)).getStageById(stageId).getName()});
        }
    }

    public static void checkFlowChainNoExisted(RecoverFlowChain recoverFlowChain) {
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        if (!VerifyUtil.isEmpty((Object)flowService.getRecoverFlowChain(recoverFlowChain))) {
            LOGGER.error((Object)"Flow chain already exist.stageId:'%s',prepFlowId:'%s',nextFlowId:'%s'.", new Object[]{recoverFlowChain.getStageId(), recoverFlowChain.getPreFlowId(), recoverFlowChain.getNextFlowId()});
            throw new LegoCheckedException(1073952605L, new String[]{flowService.getRecoverFlowById(recoverFlowChain.getPreFlowId()).getName(), flowService.getRecoverFlowById(recoverFlowChain.getNextFlowId()).getName()});
        }
    }

    public static void checkFlowIsRelateStage(String flowId) {
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        if (flowService.getStageFlowMapCountByFlowId(flowId) > 0L) {
            LOGGER.error((Object)"Recover flow used by stage, can not update or delete, flow id: '%s'.", new Object[]{flowId});
            throw new LegoCheckedException(1073952611L, new String[]{flowService.getRecoverFlowById(flowId).getName()});
        }
    }

    public static void checkFlowTypeSameAsPreplan(String stageId, String flowId) {
        RecoverPreplan preplan = ((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplanByStageId(stageId);
        RecoverFlow flow = ((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).getRecoverFlowById(flowId);
        if (!flow.getType().equals(preplan.getType())) {
            LOGGER.error((Object)"flow type '%s' is not equals as stage of preplan type '%s', stageId is '%s', flowId:'%s'.", new Object[]{flow.getType(), preplan.getType(), stageId, flowId});
            throw new LegoCheckedException(1073952607L, new String[]{flow.getName(), preplan.getType()});
        }
    }

    public static void checkFlowApplicationExistInPreplan(String stageId, String flowId) {
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        RecoverPreplan recoverPreplan = ((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplanByStageId(stageId);
        RecoverFlow recoverFlow = flowService.getRecoverFlowById(flowId);
        RecoverFlowQuery flowQuery = new RecoverFlowQuery();
        flowQuery.setAppId(recoverFlow.getAppId());
        flowQuery.setPrePlanId(recoverPreplan.getId());
        if (flowService.queryRecoverFlowCount(flowQuery) > 0L) {
            LOGGER.error((Object)"app of flow already exists in stage of preplan, preplan id:'%s', app id:'%s'.", new Object[]{recoverPreplan.getId(), recoverFlow.getAppId()});
            throw new LegoCheckedException(1073952608L, new String[]{recoverFlow.getName(), recoverPreplan.getName()});
        }
    }

    public static void checkSingleAppFlowNumLimit(String appId) {
        RecoverFlowQuery flowQuery = new RecoverFlowQuery();
        flowQuery.setAppId(appId);
        if (((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).queryRecoverFlowCount(flowQuery) >= 60L) {
            LOGGER.error((Object)"Recover flow of single app out of limit, app id:'%s'.", new Object[]{appId});
            throw new LegoCheckedException(1073952610L, new String[]{((AppService)ServiceLocator.getInstance().getService(AppService.class)).getApplicationById(appId).getName(), String.valueOf(60)});
        }
    }
}

