/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.checker;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public final class RecoverPreplanChecker {
    private static final Log LOG = LogFactory.getInstance(RecoverPreplanChecker.class);
    private static final Map<String, Integer> TYPE_LIMIT_MAP = new HashMap<String, Integer>();

    private RecoverPreplanChecker() {
    }

    public static void checkPreplanTypeOutOfLimit(RecoverPreplan preplan) {
        String type = preplan.getType();
        int limit = 0;
        if (!VerifyUtil.isEmpty((String)type) && TYPE_LIMIT_MAP.containsKey(type)) {
            limit = TYPE_LIMIT_MAP.get(type);
        }
        RecoverPreplanQuery preplanQuery = new RecoverPreplanQuery();
        preplanQuery.setProjectId(preplan.getProjectId());
        preplanQuery.setPlanId(preplan.getRecoverPlanId());
        preplanQuery.setSiteId(preplan.getSiteId());
        preplanQuery.setPreplanType(type);
        if (((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplansCount(preplanQuery) >= limit) {
            LOG.error((Object)"Recover preplan num of type '%s' in site '%s' of recover plan '%s' reach limit.", new Object[]{type, preplan.getSiteId(), preplan.getRecoverPlanId()});
            throw new LegoCheckedException(1073952802L, new String[]{type, String.valueOf(limit)});
        }
    }

    public static void checkPreplanNameExistInRecoverPlan(String planId, String name) {
        RecoverPreplanService service = (RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class);
        RecoverPreplanQuery recoverPreplanQuery = new RecoverPreplanQuery();
        recoverPreplanQuery.setFullPreplanName(name);
        recoverPreplanQuery.setPlanId(planId);
        int total = service.queryPreplansCount(recoverPreplanQuery);
        if (total > 0) {
            LOG.error((Object)"Recover preplan name '%s' already exists in recoverPlan '%s'", new Object[]{name, planId});
            throw new LegoCheckedException(1073952801L, new String[]{name});
        }
    }

    static {
        TYPE_LIMIT_MAP.put(RecoverOperateType.PLANNED_MIGRATION.getValue(), 3);
        TYPE_LIMIT_MAP.put(RecoverOperateType.DISASTER_RECOVERY.getValue(), 1);
        TYPE_LIMIT_MAP.put(RecoverOperateType.REPROTECT.getValue(), 1);
        TYPE_LIMIT_MAP.put(RecoverOperateType.SWITCHBACK.getValue(), 1);
    }
}

