/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.checker;

import com.huawei.csr.framework.common.constants.RecoverStageType;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public final class RecoverStageChecker {
    private static final Log LOGGER = LogFactory.getInstance(RecoverStageChecker.class);

    private RecoverStageChecker() {
    }

    public static void checkRecoverStageName(String name) {
        if (VerifyUtil.isEmpty((String)name)) {
            LOGGER.error((Object)"Stage name is empty.");
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkPrePlanId(String prePlanId) {
        if (VerifyUtil.isEmpty((String)prePlanId)) {
            LOGGER.error((Object)"Stage prePlan is empty");
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkStageId(String stageId) {
        if (VerifyUtil.isEmpty((String)stageId)) {
            LOGGER.error((Object)"Stage id is empty.");
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkStageType(String stageType) {
        if (VerifyUtil.isEmpty((String)stageType)) {
            LOGGER.error((Object)"Stage type is empty.");
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkStageNameExistInPreplan(String stageName, String preplanId) {
        if (((RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class)).getStageCountByName(stageName, preplanId) > 0) {
            LOGGER.error((Object)"StagName exist in preplan, stageName:'%s', preplanId: '%s'.", new Object[]{stageName, preplanId});
            throw new LegoCheckedException(1073952701L, new String[]{stageName});
        }
    }

    public static void checkStageExist(String stageId) {
        if (VerifyUtil.isEmpty((Object)((RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class)).getStageById(stageId))) {
            LOGGER.error((Object)"Stage not exist, stage id: %s", new Object[]{stageId});
            throw new LegoCheckedException(1073952700L);
        }
    }

    public static void checkStageIsNotPause(String stageId, long errorCode, String errorMessage, String[] parameter) {
        if (((RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class)).getStageById(stageId).getType().equals(RecoverStageType.SUSPEND.getValue())) {
            LOGGER.error((Object)errorMessage);
            throw new LegoCheckedException(errorCode, parameter);
        }
    }

    public static void checkStageOutOfLimit(String projectId, String prePlanId) {
        if (((RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class)).getStageCount(projectId, prePlanId) >= 10) {
            LOGGER.error((Object)"The stage num of preplan out of limit, preplan id: %s", new Object[]{prePlanId});
            throw new LegoCheckedException(1073952803L, new String[]{String.valueOf(10)});
        }
    }

    public static void checkFlowAddtoStageLimit(String stageId) {
        RecoverStageService stageService = (RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class);
        if (stageService.getStageFlowMapCountByStageId(stageId) >= 32L) {
            LOGGER.error((Object)"The flow num of single stage out of limit,stage id:%s.", new Object[]{stageId});
            throw new LegoCheckedException(1073952704L, new String[]{stageService.getStageById(stageId).getName(), String.valueOf(32)});
        }
    }
}

