/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.checker;

import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.utils.RecoverStepUtil;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.impl.ServiceInstanceDaoImpl;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStepService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecoverStepChecker {
    private static final Log LOG = LogFactory.getInstance(RecoverStepChecker.class);
    private static final Map<String, Set<String>> TYPE_ACTION_MAP = new HashMap<String, Set<String>>();
    private static final Set<RecoverStatus> RECOVER_PLAN_IDLE_SET = new HashSet<RecoverStatus>();

    private RecoverStepChecker() {
    }

    public static void checkRecoverStepExist(String stepId) {
        RecoverStepService service = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        RecoverStep dbStep = service.queryRecoverStepById(stepId);
        if (VerifyUtil.isEmpty((Object)dbStep)) {
            LOG.error((Object)"Specified recoverStep does not exist, step id:%s.", new Object[]{stepId});
            throw new LegoCheckedException(1073952506L);
        }
    }

    public static void checkRecoverStepCount() {
        RecoverStepService service = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        long count = service.getAllRecoverStepCount();
        if (count >= 30000L) {
            LOG.error((Object)"FlowStepMap count out of limit.");
            throw new LegoCheckedException(1073952505L, new String[]{String.valueOf(30000)});
        }
    }

    private static boolean isRecoverPlanIdle(RecoverStatus status) {
        return RECOVER_PLAN_IDLE_SET.contains((Object)status);
    }

    public static void checkRecoverPlanIdle(RecoverStepQuery recoverStepQuery) {
        PlanService service = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        List<RecoverPlan> recoverPlanList = service.getRecoverPlanOfStepStatus(recoverStepQuery);
        if (VerifyUtil.isEmpty(recoverPlanList)) {
            return;
        }
        RecoverStatus status = RecoverStatus.from(recoverPlanList.get(0).getStatus());
        if (!RecoverStepChecker.isRecoverPlanIdle(status)) {
            LOG.error((Object)"RecoverPlan %s is not IDLE.", new Object[]{recoverPlanList.get(0).getStatus()});
            RecoverStep step = ((RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class)).queryRecoverStepById(recoverStepQuery.getStepId());
            throw new LegoCheckedException(1073952503L, new String[]{step.getName(), recoverPlanList.get(0).getName()});
        }
    }

    public static void checkFlowStepMapCount(String flowId) {
        RecoverStepService service = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        long count = service.getFlowStepMapCountByFlowId(flowId);
        if (count >= 64L) {
            LOG.error((Object)"The step num of single flow out of limit,flowId:%s.", new Object[]{flowId});
            RecoverFlow flow = ((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).getRecoverFlowById(flowId);
            throw new LegoCheckedException(1073952504L, new String[]{flow.getName(), String.valueOf(64)});
        }
    }

    public static void checkFlowStepMapExist(String flowId, String stepId) {
        RecoverStepService service = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        long count = service.getFlowStepMapCount(flowId, stepId);
        if (count > 0L) {
            LOG.error((Object)"FlowStepMap already exist,flow id:%s,step id:%s.", new Object[]{flowId, stepId});
            RecoverFlow flow = ((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).getRecoverFlowById(flowId);
            RecoverStep step = ((RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class)).queryRecoverStepById(stepId);
            throw new LegoCheckedException(1073952502L, new String[]{step.getName(), flow.getName()});
        }
    }

    public static void checkFlowStepMapNotExist(String flowId, String stepId) {
        RecoverStepService service = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        long count = service.getFlowStepMapCount(flowId, stepId);
        if (count == 0L) {
            LOG.error((Object)"FlowStepMap not exist, flowId %s, stepId %s.", new Object[]{flowId, stepId});
            RecoverFlow flow = ((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).getRecoverFlowById(flowId);
            RecoverStep step = ((RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class)).queryRecoverStepById(stepId);
            if (!VerifyUtil.isEmpty((Object)flow) && !VerifyUtil.isEmpty((Object)step)) {
                throw new LegoCheckedException(1073952501L, new String[]{step.getName(), flow.getName()});
            }
            throw new LegoCheckedException(1073952501L, new String[]{stepId, flowId});
        }
    }

    public static void checkOperationServiceMatch(String serviceType, String action) {
        Set<String> operateSet = TYPE_ACTION_MAP.get(serviceType);
        if (VerifyUtil.isEmpty(operateSet) || !operateSet.contains(action)) {
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkRecoverFlowExist(String flowId) {
        RecoverFlowService service = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        RecoverFlow flow = service.getRecoverFlowById(flowId);
        if (VerifyUtil.isEmpty((Object)flow)) {
            LOG.error((Object)"RecoverFlow not exist in db,flow id:%s.", new Object[]{flowId});
            throw new LegoCheckedException(1073952601L);
        }
    }

    public static void checkStepInstanceOfFlow(String flowId, String stepId) {
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        RecoverFlow flow = flowService.getRecoverFlowById(flowId);
        if (VerifyUtil.isEmpty((Object)flow)) {
            LOG.error((Object)"RecoverFlow: %s does not exist.", new Object[]{flowId});
            throw new LegoCheckedException(1073952400L);
        }
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        Application application = appService.getApplicationById(flow.getAppId());
        if (VerifyUtil.isEmpty((Object)application)) {
            LOG.error((Object)"Application: %s does not exist.", new Object[]{flow.getAppId()});
            throw new LegoCheckedException(1073952400L);
        }
        RecoverStepService stepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        RecoverStep recoverStep = stepService.queryRecoverStepById(stepId);
        if (VerifyUtil.isEmpty((Object)application)) {
            LOG.error((Object)"Application: %s does not exist.", new Object[]{flow.getAppId()});
            throw new LegoCheckedException(1073952400L);
        }
        if (application.getServiceInstances().stream().noneMatch(instance -> recoverStep.getServiceInstanceId().equals(instance.getId()))) {
            LOG.error((Object)"Instance of step: %s does not belong to flow %s app instances.", new Object[]{stepId, flowId});
            throw new LegoCheckedException(1073952400L);
        }
    }

    public static void checkStepFlowConsist(String flowId, String stepId) {
        RecoverStepService stepService;
        RecoverStep step;
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        RecoverFlow flow = flowService.getRecoverFlowById(flowId);
        Set<String> stepActionSet = RecoverStepUtil.getActionSetByOperateType(flow.getType());
        if (!stepActionSet.contains((step = (stepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class)).queryRecoverStepById(stepId)).getAction())) {
            LOG.error((Object)"Step %s action not allowed in flow %s.", new Object[]{stepId, flowId});
            throw new LegoCheckedException(1073952507L, new String[]{step.getName(), step.getAction(), flow.getType()});
        }
    }

    public static void checkRecoverStepName(String projectId, String name) {
        RecoverStepService stepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        RecoverStep step = stepService.queryRecoverStepByName(projectId, name);
        if (!VerifyUtil.isEmpty((Object)step)) {
            LOG.error((Object)"Step name %s already exist in projectId %s.", new Object[]{name, projectId});
            throw new LegoCheckedException(1073952500L, new String[]{step.getName()});
        }
    }

    public static void checkServiceActionExist(String flowId, String stepId) {
        RecoverStepService stepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        RecoverStep dbStep = stepService.queryRecoverStepById(stepId);
        List<FlowStepMap> mapList = stepService.queryFlowStepMapListByFlowId(flowId);
        for (FlowStepMap map : mapList) {
            RecoverStep step = stepService.queryRecoverStepById(map.getRecoverStepId());
            if (VerifyUtil.isEmpty((Object)step) || !step.getServiceType().equals(dbStep.getServiceType()) || !step.getServiceInstanceId().equals(dbStep.getServiceInstanceId())) continue;
            LOG.error((Object)"In flow: %s action %s of service type :%s already exist.", new Object[]{flowId, dbStep.getAction(), dbStep.getServiceType()});
            AppServiceInstance instance = ((ServiceInstanceDaoImpl)ServiceLocator.getInstance().getService(ServiceInstanceDaoImpl.class)).getServiceInstanceById(step.getServiceInstanceId());
            throw new LegoCheckedException(1073952508L, new String[]{instance.getInstanceName(), step.getName()});
        }
    }

    public static void checkStepInstanceCount(String serviceInstanceId) {
        RecoverStepService stepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        long dbCount = stepService.getRecoverStepCountByInstanceId(serviceInstanceId);
        if (dbCount >= 60L) {
            LOG.error((Object)"Service instance: %s has reach max recover steps.", new Object[]{serviceInstanceId});
            throw new LegoCheckedException(1073952509L, new String[]{String.valueOf(60)});
        }
    }

    public static void checkInstanceTypeConsist(RecoverStep recoverStep) {
        ServiceInstanceDao instanceDao = (ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class);
        AppServiceInstance instance = instanceDao.getServiceInstanceById(recoverStep.getServiceInstanceId());
        if (VerifyUtil.isEmpty((Object)instance)) {
            LOG.error((Object)"Instance : %s does not exist", new Object[]{recoverStep.getServiceInstanceId()});
            throw new LegoCheckedException(1073952003L);
        }
        if (!recoverStep.getServiceType().equals(instance.getServiceType())) {
            LOG.error((Object)"Instance type of step: %s and instance: %s does not consist", new Object[]{recoverStep.getId(), recoverStep.getServiceInstanceId()});
            throw new LegoCheckedException(1073952510L, new String[]{recoverStep.getName(), recoverStep.getServiceType(), instance.getInstanceName(), instance.getServiceType()});
        }
    }

    public static void checkInstanceMatchPreplan(String flowId, String stepId) {
        Set<String> siteIdSet = ((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplansSiteByFlowId(flowId);
        if (VerifyUtil.isEmpty(siteIdSet)) {
            LOG.info((Object)"Recover flow %s does not related to any preplan.", new Object[]{flowId});
            return;
        }
        RecoverStep step = ((RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class)).queryRecoverStepById(stepId);
        AppServiceInstance instance = ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).getServiceInstanceById(step.getServiceInstanceId());
        if (!siteIdSet.contains(instance.getPdSiteId()) && !siteIdSet.contains(instance.getDrSiteId())) {
            LOG.error((Object)"Instance %s of step %s does not match preplan site", new Object[]{instance.getId(), step.getId()});
            throw new LegoCheckedException(1073952400L);
        }
    }

    static {
        HashSet<String> ecsActionSet = new HashSet<String>();
        ecsActionSet.add(RecoverStepAction.POWER_ON.getValue());
        ecsActionSet.add(RecoverStepAction.POWER_OFF.getValue());
        TYPE_ACTION_MAP.put(ServiceType.ECS.getValue(), ecsActionSet);
        HashSet<String> cceActionSet = new HashSet<String>();
        cceActionSet.add(RecoverStepAction.START_CONTAINER.getValue());
        cceActionSet.add(RecoverStepAction.STOP_CONTAINER.getValue());
        TYPE_ACTION_MAP.put(ServiceType.CCE.getValue(), cceActionSet);
        HashSet<String> cshaActionSet = new HashSet<String>();
        cshaActionSet.add(RecoverStepAction.PLANNED_MIGRATION.getValue());
        cshaActionSet.add(RecoverStepAction.REPROTECT.getValue());
        cshaActionSet.add(RecoverStepAction.DISASTER_RECOVERY.getValue());
        cshaActionSet.add(RecoverStepAction.SWITCHBACK.getValue());
        TYPE_ACTION_MAP.put(ServiceType.CSHA.getValue(), cshaActionSet);
        HashSet<String> dcsActionSet = new HashSet<String>();
        dcsActionSet.add(RecoverStepAction.SWITCHOVER.getValue());
        dcsActionSet.add(RecoverStepAction.CHECK_INSTANCE.getValue());
        dcsActionSet.add(RecoverStepAction.CHECK_PD_STATUS.getValue());
        TYPE_ACTION_MAP.put(ServiceType.DCS.getValue(), dcsActionSet);
        HashSet<String> rdsActionSet = new HashSet<String>();
        rdsActionSet.add(RecoverStepAction.SWITCHOVER.getValue());
        rdsActionSet.add(RecoverStepAction.CHECK_INSTANCE.getValue());
        rdsActionSet.add(RecoverStepAction.CHECK_PD_STATUS.getValue());
        TYPE_ACTION_MAP.put(ServiceType.RDS.getValue(), rdsActionSet);
        RECOVER_PLAN_IDLE_SET.add(RecoverStatus.NORMAL);
        RECOVER_PLAN_IDLE_SET.add(RecoverStatus.PLANED_MOTION_FAILED);
        RECOVER_PLAN_IDLE_SET.add(RecoverStatus.DISASTER_RECOVERY_FAILED);
        RECOVER_PLAN_IDLE_SET.add(RecoverStatus.DISASTER_RECOVERY_COMPLETED);
        RECOVER_PLAN_IDLE_SET.add(RecoverStatus.REPROTECT_FAILED);
        RECOVER_PLAN_IDLE_SET.add(RecoverStatus.SWITCHBACK_FAILED);
    }
}

