/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.operationtask;

import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.BackTaskState;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public abstract class AbstractTask
implements Runnable {
    private static final Log logger = LogFactory.getInstance(AbstractTask.class);
    private static final Integer TASK_PROGRESS_100 = 100;
    private BackTask backTaskModel;
    private IBackTaskService backTaskService;
    private long timeout;

    public AbstractTask(BackTask backTaskModel) {
        this.backTaskModel = backTaskModel;
    }

    @Override
    public void run() {
        try {
            logger.info((Object)"Start execute task(%s)", new Object[]{String.valueOf(this.backTaskModel.getTaskId())});
            this.backTaskModel.setStartTime(new Date());
            this.doWork();
            this.succeed();
            logger.info((Object)"Task(%s) execute success.", new Object[]{String.valueOf(this.backTaskModel.getTaskId())});
        }
        catch (Exception err) {
            logger.error((Object)"Task(%s) execute failed, msg: %s", new Object[]{String.valueOf(this.backTaskModel.getTaskId()), ExceptionUtil.getErrorMessage((Throwable)err)});
            this.failed(err);
            throw err;
        }
    }

    public abstract void doWork();

    private void failed(Exception error) {
        String errorCode = "";
        String[] param = new String[]{};
        if (error instanceof LegoCheckedException) {
            errorCode = String.valueOf(((LegoCheckedException)((Object)error)).getErrorCode());
            if (((LegoCheckedException)((Object)error)).getParameters() != null) {
                param = ((LegoCheckedException)((Object)error)).getParameters();
            }
        }
        this.backTaskModel.setTaskProgress(TASK_PROGRESS_100);
        this.backTaskModel.setTaskResult(Integer.valueOf(BackTaskState.fail.getValue()));
        this.backTaskModel.setEndTime(new Date());
        this.backTaskModel.setTaskDetail(errorCode);
        this.backTaskModel.setTaskDetailParas(param);
        TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AbstractTask.this.backTaskService.updateTask(AbstractTask.this.backTaskModel);
            }
        });
    }

    private void succeed() {
        this.backTaskModel.setTaskProgress(TASK_PROGRESS_100);
        this.backTaskModel.setTaskResult(Integer.valueOf(BackTaskState.succeed.getValue()));
        this.backTaskModel.setEndTime(new Date());
        TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AbstractTask.this.backTaskService.updateTask(AbstractTask.this.backTaskModel);
            }
        });
    }

    public BackTask getBackTaskModel() {
        return this.backTaskModel;
    }

    public void setBackTaskModel(BackTask backTaskModel) {
        this.backTaskModel = backTaskModel;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setBackTaskService(IBackTaskService backTaskService) {
        this.backTaskService = backTaskService;
    }
}

