/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.operationtask;

import com.huawei.csr.framework.common.operationtask.AbstractTask;
import com.huawei.csr.framework.core.thread.ThreadPoolFactory;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.BackTaskState;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public final class OperationTaskManager {
    private static final Log logger = LogFactory.getInstance(OperationTaskManager.class);
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR;
    private static final IBackTaskService BACK_TASK_SERVICE;
    private static final ConcurrentLinkedQueue<TaskUnit> TASK_FUTURES;
    private static final Integer TASK_PROGRESS_100;

    private OperationTaskManager() {
    }

    public static long submitTask(AbstractTask operationTask) {
        if (VerifyUtil.isEmpty((Object)operationTask)) {
            throw new LegoCheckedException(1073952404L);
        }
        operationTask.setBackTaskService(BACK_TASK_SERVICE);
        long taskId = BACK_TASK_SERVICE.addTask(operationTask.getBackTaskModel());
        Future<?> future = THREAD_POOL_EXECUTOR.submit(operationTask);
        TASK_FUTURES.add(new TaskUnit(operationTask, future));
        return taskId;
    }

    private void checkTaskTimeout() {
        Iterator<TaskUnit> iterator = TASK_FUTURES.iterator();
        while (iterator.hasNext()) {
            long startTime;
            TaskUnit taskUnit = iterator.next();
            AbstractTask task = taskUnit.getTask();
            Future<?> future = taskUnit.getTaskFuture();
            long currentTime = System.currentTimeMillis();
            if (currentTime - (startTime = task.getBackTaskModel().getStartTime().getTime()) >= task.getTimeout()) {
                logger.warn((Object)"The task(%s) has timeout, start time: %s, so cancel it.", new Object[]{String.valueOf(task.getBackTaskModel().getTaskId()), startTime});
                future.cancel(true);
            }
            if (future.isDone()) {
                iterator.remove();
            }
            if (!future.isCancelled()) continue;
            BackTask backTaskModel = task.getBackTaskModel();
            backTaskModel.setTaskProgress(TASK_PROGRESS_100);
            backTaskModel.setTaskResult(Integer.valueOf(BackTaskState.fail.getValue()));
            backTaskModel.setEndTime(new Date());
            backTaskModel.setTaskDetail(String.valueOf(1073947433L));
            BACK_TASK_SERVICE.updateTask(backTaskModel);
        }
    }

    static {
        TASK_FUTURES = new ConcurrentLinkedQueue();
        TASK_PROGRESS_100 = 100;
        THREAD_POOL_EXECUTOR = ThreadPoolFactory.getThreadPool("operation-task");
        ServiceContext context = ServiceContext.getInstance();
        BACK_TASK_SERVICE = (IBackTaskService)context.lookup("task/backTask");
    }

    private static class TaskUnit {
        private final AbstractTask task;
        private final Future<?> taskFuture;

        TaskUnit(AbstractTask task, Future<?> taskFuture) {
            this.task = task;
            this.taskFuture = taskFuture;
        }

        public AbstractTask getTask() {
            return this.task;
        }

        public Future<?> getTaskFuture() {
            return this.taskFuture;
        }
    }
}

