/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.operationtask.app;

import com.huawei.csr.framework.checker.AppChecker;
import com.huawei.csr.framework.common.operationtask.AbstractTask;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.common.utils.AppServiceUtil;
import com.huawei.csr.framework.common.utils.ServiceConvertUtil;
import com.huawei.csr.framework.core.event.DefaultEventDispatcher;
import com.huawei.csr.framework.core.event.EventDispatcher;
import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.om.order.model.Instance;
import com.huawei.om.order.model.ModifyUsages;
import com.huawei.om.order.util.OmOrderUtil;
import com.huawei.sdk.connector.auth.Credential;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class AddServiceInstancesTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getInstance(AddServiceInstancesTask.class);
    private Set<AppServiceInstance> serviceInstanceSet;
    private final Credential credential;
    private final EventDispatcher eventDispatcher = DefaultEventDispatcher.getInstance();
    private final Application app;
    private final String subId;

    public AddServiceInstancesTask(BackTask backTaskModel, Set<AppServiceInstance> serviceInstanceSet, Credential credential, Application app, String subId) {
        super(backTaskModel);
        this.serviceInstanceSet = serviceInstanceSet;
        this.credential = credential;
        this.app = app;
        this.subId = subId;
    }

    @Override
    public void doWork() {
        String status = this.app.getStatus();
        try {
            ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).updateAppStatus(this.app.getId(), AppStatus.LOCKED.getValue());
            this.addServiceInstances();
        }
        finally {
            ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).updateAppStatus(this.app.getId(), status);
        }
    }

    public void addServiceInstances() {
        String orderResult = "successed";
        String instanceResult = "successed";
        try {
            AppChecker.checkServiceInstanceUsed(this.serviceInstanceSet, this.app);
            for (AppServiceInstance serviceInstance : this.serviceInstanceSet) {
                AppServiceUtil.completeAndCheckServiceInstance(serviceInstance, this.credential);
            }
            this.app.getServiceInstances().addAll(this.serviceInstanceSet);
            AppEventEntity eventEntity = new AppEventEntity();
            eventEntity.setApplication(this.app);
            eventEntity.setIncrementalInstanceIds(this.serviceInstanceSet.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
            this.eventDispatcher.process(() -> TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    ServiceInstanceDao serviceInstanceDao = (ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class);
                    serviceInstanceDao.saveServiceInstances(AddServiceInstancesTask.this.serviceInstanceSet);
                }
            }), new AppEvent(eventEntity, AppEvent.EventType.ADD_INSTANCES));
        }
        catch (Exception e) {
            LOG.error((Object)"Add serviceInstances failed. msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            orderResult = "failed";
            instanceResult = "failed";
            throw new LegoCheckedException(1073952012L, "Add serviceInstances failed.");
        }
        finally {
            List<Instance> orderInstances = ServiceConvertUtil.convert(this.serviceInstanceSet, instanceResult);
            ModifyUsages modifyUsages = ServiceConvertUtil.generateModifyUsage(0.0, this.serviceInstanceSet.size(), this.app.getProjectId());
            OmOrderUtil.putOrderResult((String)this.subId, (Credential)this.credential, orderInstances, (ModifyUsages)modifyUsages, (String)orderResult);
        }
    }
}

