/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.operationtask.app;

import com.huawei.csr.framework.checker.AppChecker;
import com.huawei.csr.framework.common.operationtask.AbstractTask;
import com.huawei.csr.framework.common.utils.AppServiceUtil;
import com.huawei.csr.framework.common.utils.ServiceConvertUtil;
import com.huawei.csr.framework.core.event.DefaultEventDispatcher;
import com.huawei.csr.framework.core.event.EventDispatcher;
import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.om.order.model.Instance;
import com.huawei.om.order.model.ModifyUsages;
import com.huawei.om.order.util.OmOrderUtil;
import com.huawei.sdk.connector.auth.Credential;
import java.util.ArrayList;
import java.util.Set;

public class CreateAppTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getInstance(CreateAppTask.class);
    private final Application application;
    private final String subId;
    private final Credential credential;
    private final EventDispatcher dispatcher = DefaultEventDispatcher.getInstance();

    public CreateAppTask(BackTask backTaskModel, String subId, Application application, Credential credential) {
        super(backTaskModel);
        this.application = application;
        this.subId = subId;
        this.credential = credential;
    }

    @Override
    public void doWork() {
        ArrayList<Instance> orderInstances = new ArrayList<Instance>();
        String orderResult = "successed";
        try {
            AppChecker.checkCreateApp(this.application);
            Set<AppServiceInstance> serviceInstances = this.application.getServiceInstances();
            for (AppServiceInstance serviceInstance : serviceInstances) {
                try {
                    AppServiceUtil.completeAndCheckServiceInstance(serviceInstance, this.credential);
                    Instance convert = ServiceConvertUtil.convert(serviceInstance, "successed");
                    orderInstances.add(convert);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Check service(%s) failed. msg: %s", new Object[]{serviceInstance.getInstanceId(), ExceptionUtil.getErrorMessage((Throwable)e)});
                    Instance convert = ServiceConvertUtil.convert(serviceInstance, "failed");
                    orderInstances.add(convert);
                    throw new LegoCheckedException(1073952002L);
                }
            }
            AppEventEntity eventEntity = new AppEventEntity();
            eventEntity.setApplication(this.application);
            this.dispatcher.process(() -> ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).saveApp(this.application), new AppEvent(eventEntity, AppEvent.EventType.CREATE_APP));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Create App failed. SubScribeId is %s. msg: %s", new Object[]{this.subId, ExceptionUtil.getErrorMessage((Throwable)e)});
            orderResult = "failed";
            throw new LegoCheckedException(1073952013L, "Create App failed.");
        }
        finally {
            ModifyUsages modifyUsages = ServiceConvertUtil.generateModifyUsage(1.0, this.application.getServiceInstances().size(), orderResult);
            OmOrderUtil.putOrderResult((String)this.subId, (Credential)this.credential, orderInstances, (ModifyUsages)modifyUsages, (String)orderResult);
        }
    }
}

