/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.operationtask.app;

import com.huawei.csr.framework.checker.AppChecker;
import com.huawei.csr.framework.common.constants.CsrFaultConstant;
import com.huawei.csr.framework.common.operationtask.AbstractTask;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.common.utils.AppRefreshUtil;
import com.huawei.csr.framework.common.utils.AppServiceUtil;
import com.huawei.csr.framework.common.utils.ResourceClearUtil;
import com.huawei.csr.framework.common.utils.ServiceConvertUtil;
import com.huawei.csr.framework.core.event.DefaultEventDispatcher;
import com.huawei.csr.framework.core.event.EventDispatcher;
import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.om.order.model.ModifyUsages;
import com.huawei.om.order.util.OmOrderUtil;
import com.huawei.sdk.connector.auth.Credential;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class DeleteAppTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getInstance(DeleteAppTask.class);
    private final String appId;
    private final String subId;
    private final Credential credential;
    private final EventDispatcher dispatcher = DefaultEventDispatcher.getInstance();

    public DeleteAppTask(BackTask backTaskModel, String appId, String subId, Credential credential) {
        super(backTaskModel);
        this.appId = appId;
        this.subId = subId;
        this.credential = credential;
    }

    @Override
    public void doWork() {
        final Application app = ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).getApp(this.appId);
        AppEventEntity eventEntity = new AppEventEntity();
        eventEntity.setApplication(app);
        try {
            AppChecker.checkDeleteApp(app);
            this.dispatcher.process(() -> TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    DeleteAppTask.this.removeApp(app);
                }
            }), new AppEvent(eventEntity, AppEvent.EventType.DELETE_APP));
            ModifyUsages modifyUsages = ServiceConvertUtil.generateModifyUsage(-1.0, -app.getServiceInstances().size(), app.getProjectId());
            OmOrderUtil.putOrderResult((String)this.subId, (Credential)this.credential, ServiceConvertUtil.convert(app.getServiceInstances(), "successed"), (ModifyUsages)modifyUsages, (String)"successed");
            AppRefreshUtil.resotreAlarm(CsrFaultConstant.FAULT_INSTANCE_DELETED, app);
            AppRefreshUtil.resotreAlarm(CsrFaultConstant.FAULT_INSTANCE_ERROR, app);
        }
        catch (Exception err) {
            LOG.error((Object)"Remove App[%s] failed,error:%s.", new Object[]{app.getId(), ExceptionUtil.getErrorMessage((Throwable)err)});
            OmOrderUtil.putOrderResult((String)this.subId, (Credential)this.credential, ServiceConvertUtil.convert(app.getServiceInstances(), "failed"), (String)"failed");
            throw new LegoCheckedException(1073952011L, "App[%s] remove failed.");
        }
    }

    private void removeApp(Application application) {
        ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).updateAppStatus(application.getId(), AppStatus.LOCKED.getValue());
        for (AppServiceInstance serviceInstance : application.getServiceInstances()) {
            AppServiceUtil.removeInstance(serviceInstance);
        }
        ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).deleteApp(application.getId());
        List<RecoverFlow> recoverFlows = ((RecoverFlowDao)ServiceLocator.getInstance().getService(RecoverFlowDao.class)).queryRecoverFlowsByAppId(application.getProjectId(), application.getId());
        List<String> flowIds = recoverFlows.stream().map(AbstractEntity::getId).collect(Collectors.toList());
        ResourceClearUtil.removeRecoverFlowCascade(application.getProjectId(), flowIds);
    }
}

