/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.operationtask.app;

import com.huawei.csr.framework.checker.AppChecker;
import com.huawei.csr.framework.common.operationtask.AbstractTask;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.ServiceInstanceOpt;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.common.utils.AppServiceUtil;
import com.huawei.csr.framework.common.utils.ServiceConvertUtil;
import com.huawei.csr.framework.core.event.DefaultEventDispatcher;
import com.huawei.csr.framework.core.event.EventDispatcher;
import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.order.model.Instance;
import com.huawei.om.order.model.ModifyUsages;
import com.huawei.om.order.util.OmOrderUtil;
import com.huawei.sdk.connector.auth.Credential;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class RemoveServiceInstancesTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getInstance(RemoveServiceInstancesTask.class);
    private final Set<String> serviceInstanceIds;
    private final Application application;
    private final EventDispatcher eventDispatcher = DefaultEventDispatcher.getInstance();
    private final String subId;
    private final Credential credential;
    private final Set<AppServiceInstance> deletedServiceInstanceSet = new HashSet<AppServiceInstance>();

    public RemoveServiceInstancesTask(BackTask backTaskModel, Set<String> serviceInstanceIds, Application application, String subId, Credential credential) {
        super(backTaskModel);
        this.serviceInstanceIds = serviceInstanceIds;
        this.application = application;
        this.subId = subId;
        this.credential = credential;
    }

    @Override
    public void doWork() {
        String instanceResult = "successed";
        String orderResult = "successed";
        ApplicationDao applicationDao = (ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class);
        try {
            AppChecker.checkAppCanRemoveInstances(this.application);
            applicationDao.updateAppStatus(this.application.getId(), AppStatus.LOCKED.getValue());
            this.initDeletedInstances(this.application.getServiceInstances());
            AppEventEntity eventEntity = new AppEventEntity();
            eventEntity.setApplication(this.application);
            eventEntity.setIncrementalInstanceIds(this.serviceInstanceIds);
            this.eventDispatcher.process(() -> TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RemoveServiceInstancesTask.this.removeInstances();
                }
            }), new AppEvent(eventEntity, AppEvent.EventType.REMOVE_INSTANCES));
        }
        catch (Exception err) {
            LOG.error((Object)"Remove instances from App[%s] failed,error:%s.", new Object[]{this.application.getId(), ExceptionUtil.getErrorMessage((Throwable)err)});
            instanceResult = "failed";
            orderResult = "failed";
            throw new LegoCheckedException(1073952014L, "Remove Instances failed.");
        }
        finally {
            List<Instance> convert = ServiceConvertUtil.convert(this.deletedServiceInstanceSet, instanceResult);
            ModifyUsages modifyUsages = ServiceConvertUtil.generateModifyUsage(0.0, -this.serviceInstanceIds.size(), this.application.getProjectId());
            OmOrderUtil.putOrderResult((String)this.subId, (Credential)this.credential, convert, (ModifyUsages)modifyUsages, (String)orderResult);
            applicationDao.updateAppStatus(this.application.getId(), this.getAppStatus(this.application.getId()));
        }
    }

    private void initDeletedInstances(Set<AppServiceInstance> instancesInMem) {
        HashMap<String, AppServiceInstance> instanceMap = new HashMap<String, AppServiceInstance>();
        for (AppServiceInstance instanceInMem : instancesInMem) {
            instanceMap.put(instanceInMem.getId(), instanceInMem);
        }
        for (String id : this.serviceInstanceIds) {
            AppServiceInstance serviceInstance = (AppServiceInstance)instanceMap.get(id);
            if (VerifyUtil.isEmpty((Object)serviceInstance)) continue;
            this.deletedServiceInstanceSet.add(serviceInstance);
        }
    }

    private void removeInstances() {
        for (AppServiceInstance serviceInstance : this.deletedServiceInstanceSet) {
            StatusOptChecker.checkServiceInstanceStatusOpt(ServiceInstanceStatus.from(serviceInstance.getStatus()).getIndex(), ServiceInstanceOpt.REMOVE_FROM_APP.getIndex(), 1073952002L);
            AppServiceUtil.removeInstance(serviceInstance);
        }
    }

    private String getAppStatus(String appId) {
        ServiceInstanceDao serviceInstanceDao = (ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class);
        List<AppServiceInstance> serviceInstances = serviceInstanceDao.getServiceInstanceByAppId(appId);
        HashSet<String> statusSet = new HashSet<String>();
        for (AppServiceInstance serviceInstance : serviceInstances) {
            statusSet.add(serviceInstance.getStatus());
        }
        if (statusSet.contains(ServiceInstanceStatus.ERROR.getValue())) {
            return AppStatus.ERROR.getValue();
        }
        if (statusSet.contains(ServiceInstanceStatus.MAINTAIN.getValue())) {
            return AppStatus.MAINTAIN.getValue();
        }
        return AppStatus.NORMAL.getValue();
    }
}

