/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.common.constants.CsrFaultConstant;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.ServiceRefreshResult;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.common.statusopt.status.ReplicaStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceRefreshStatus;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.common.utils.LockUtil;
import com.huawei.csr.framework.core.event.DefaultEventDispatcher;
import com.huawei.csr.framework.core.event.EventDispatcher;
import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AppManager;
import com.huawei.csr.framework.core.manager.AppPluginManager;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.InstanceObjectDao;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.om.alarm.service.model.AlarmInfo;
import com.huawei.om.alarm.util.AlarmReportHelper;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AppRefreshUtil {
    private static final Log LOGGER = LogFactory.getInstance(AppRefreshUtil.class);
    private static final EventDispatcher DISPATCHER = DefaultEventDispatcher.getInstance();
    private static final AppPluginManager PLUGINMANAGER = AppPluginManager.getInstance();
    private static final int URI_NOT_FOUND = 404;
    private static final String OPER_TYPE = "refresh";
    private static final Map<ServiceInstanceStatus, ServiceRefreshStatus> SIS_TO_SRS = new HashMap<ServiceInstanceStatus, ServiceRefreshStatus>();

    private AppRefreshUtil() {
    }

    public static void refreshApp(Application app, Credential credential) {
        if (VerifyUtil.isEmpty(app.getServiceInstances())) {
            return;
        }
        if (!LockUtil.tryLock(OPER_TYPE + app.getId())) {
            LOGGER.error((Object)"Fetch Lock(%s) failed.", new Object[]{app.getId()});
            return;
        }
        try {
            ApplicationDao applicationDao = (ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class);
            applicationDao.updateAppStatus(app.getId(), AppStatus.LOCKED.getValue());
            List<ServiceRefreshResult> refreshResultList = AppRefreshUtil.refreshServiceInstance(app, credential);
            Set statuses = refreshResultList.stream().map(refreshResult -> refreshResult.getRefreshStatus().getStatus()).collect(Collectors.toSet());
            if (statuses.contains((Object)ServiceInstanceStatus.ERROR)) {
                app.setStatus(AppStatus.ERROR.getValue());
            } else if (statuses.contains((Object)ServiceInstanceStatus.MAINTAIN)) {
                app.setStatus(AppStatus.MAINTAIN.getValue());
            } else {
                app.setStatus(AppStatus.NORMAL.getValue());
            }
            AppEventEntity eventEntity = new AppEventEntity();
            eventEntity.setApplication(app);
            DISPATCHER.process(() -> ((ApplicationDao)ServiceLocator.getInstance().getService(ApplicationDao.class)).updateAppStatus(app.getId(), app.getStatus()), new AppEvent(eventEntity, AppEvent.EventType.REFRESH_APP));
            AppRefreshUtil.processAlarm(app, refreshResultList);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Refresh app(%s) failed. msg: %s.", new Object[]{app.getId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Refresh App Failed.");
        }
        finally {
            LockUtil.unLock(OPER_TYPE + app.getId());
        }
    }

    private static void processAlarm(Application app, List<ServiceRefreshResult> refreshResultList) {
        HashSet<ServiceRefreshResult> deletedSet = new HashSet<ServiceRefreshResult>();
        HashSet<ServiceRefreshResult> errorSet = new HashSet<ServiceRefreshResult>();
        for (ServiceRefreshResult refreshResult : refreshResultList) {
            if (refreshResult.getRefreshStatus() == ServiceRefreshStatus.DELETED) {
                deletedSet.add(refreshResult);
                continue;
            }
            if (refreshResult.getRefreshStatus() != ServiceRefreshStatus.ERROR) continue;
            errorSet.add(refreshResult);
        }
        if (!VerifyUtil.isEmpty(deletedSet)) {
            AppRefreshUtil.sendAlarm(deletedSet, CsrFaultConstant.FAULT_INSTANCE_DELETED, app);
        } else {
            AppRefreshUtil.resotreAlarm(CsrFaultConstant.FAULT_INSTANCE_DELETED, app);
        }
        if (!VerifyUtil.isEmpty(errorSet)) {
            AppRefreshUtil.sendAlarm(errorSet, CsrFaultConstant.FAULT_INSTANCE_ERROR, app);
        } else {
            AppRefreshUtil.resotreAlarm(CsrFaultConstant.FAULT_INSTANCE_ERROR, app);
        }
    }

    private static boolean checkException(Exception e) {
        boolean isInstanceDeleted = false;
        if (e instanceof ResponseException && ((ResponseException)((Object)e)).getStatus() == 404) {
            isInstanceDeleted = true;
        }
        return isInstanceDeleted;
    }

    private static List<ServiceRefreshResult> refreshServiceInstance(Application app, Credential credential) {
        ArrayList<ServiceRefreshResult> refreshResultList = new ArrayList<ServiceRefreshResult>();
        for (AppServiceInstance serviceInstance : app.getServiceInstances()) {
            ServiceRefreshResult refreshResult = AppRefreshUtil.initRefreshResult(serviceInstance);
            try {
                AppIdentifier appIdentifier = new AppIdentifier(serviceInstance.getServiceType());
                AppManager appManager = PLUGINMANAGER.getAppManager(appIdentifier);
                String endPoint = EndpointUtil.getEndpoint(serviceInstance.getServiceType(), serviceInstance.getPdRegionId());
                credential.setEndpoint(endPoint);
                AppServiceInstance sdkInstance = null;
                boolean isInstanceDeleted = true;
                try {
                    sdkInstance = appManager.getProtectServiceInstance(serviceInstance.getInstanceId(), credential);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Query sdkInstance(%s) find Exception. msg: %s", new Object[]{serviceInstance.getId(), ExceptionUtil.getErrorMessage((Throwable)e)});
                    isInstanceDeleted = AppRefreshUtil.checkException(e);
                }
                if ((VerifyUtil.isEmpty((Object)sdkInstance) || VerifyUtil.isEmpty((String)sdkInstance.getInstanceId())) && isInstanceDeleted) {
                    ((AppService)ServiceLocator.getInstance().getService(AppService.class)).removeRelateSteps(serviceInstance.getProjectId(), serviceInstance.getId());
                    refreshResult.setRefreshStatus(ServiceRefreshStatus.DELETED);
                    refreshResultList.add(refreshResult);
                    serviceInstance.setStatus(ServiceInstanceStatus.ERROR.getValue());
                    serviceInstance.setReplicaStatus(ReplicaStatus.ERROR.getValue());
                    ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).updateServiceInstance(serviceInstance);
                    continue;
                }
                String status = sdkInstance.getStatus();
                refreshResult.setRefreshStatus(AppRefreshUtil.getRefreshStatus(status));
                AppRefreshUtil.updateAppServiceInstance(serviceInstance, sdkInstance);
                if (ServiceType.from(serviceInstance.getServiceType()) != ServiceType.CSHA) {
                    refreshResultList.add(refreshResult);
                    continue;
                }
                AppRefreshUtil.refreshInstanceObjects(serviceInstance, appManager, credential);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Refresh serviceInstance(%s) (%s) failed. msg:%s", new Object[]{serviceInstance.getId(), serviceInstance.getInstanceName(), ExceptionUtil.getErrorMessage((Throwable)e)});
                refreshResult.setRefreshStatus(ServiceRefreshStatus.ERROR);
            }
            refreshResultList.add(refreshResult);
        }
        return refreshResultList;
    }

    private static ServiceRefreshStatus getRefreshStatus(String status) {
        return SIS_TO_SRS.getOrDefault((Object)ServiceInstanceStatus.from(status), ServiceRefreshStatus.ERROR);
    }

    private static ServiceRefreshResult initRefreshResult(AppServiceInstance serviceInstance) {
        ServiceRefreshResult refreshResult = new ServiceRefreshResult(serviceInstance.getInstanceId(), serviceInstance.getInstanceName(), serviceInstance.getServiceType());
        refreshResult.setPdRegionId(serviceInstance.getPdRegionId());
        refreshResult.setPdAzId(serviceInstance.getPdAzId());
        refreshResult.setDrRegionId(serviceInstance.getDrRegionId());
        refreshResult.setDrAzId(serviceInstance.getDrAzId());
        return refreshResult;
    }

    public static void updateAppServiceInstance(AppServiceInstance oriServiceInstance, AppServiceInstance newServiceInstance) {
        if (newServiceInstance.getPdRegionId() != null) {
            oriServiceInstance.setPdRegionId(newServiceInstance.getPdRegionId());
        }
        if (newServiceInstance.getPdAzId() != null) {
            oriServiceInstance.setPdAzId(newServiceInstance.getPdAzId());
        }
        if (newServiceInstance.getDrRegionId() != null) {
            oriServiceInstance.setDrRegionId(newServiceInstance.getDrRegionId());
        }
        if (newServiceInstance.getDrAzId() != null) {
            oriServiceInstance.setDrAzId(newServiceInstance.getDrAzId());
        }
        oriServiceInstance.setInstanceName(newServiceInstance.getInstanceName());
        oriServiceInstance.setStatus(newServiceInstance.getStatus());
        oriServiceInstance.setInstanceAddress(newServiceInstance.getInstanceAddress());
        oriServiceInstance.setReplicaStatus(newServiceInstance.getReplicaStatus());
        oriServiceInstance.setInstanceObjectCount(newServiceInstance.getInstanceObjectCount());
        AppRefreshUtil.updateRegionAzInfo(oriServiceInstance);
        if (VerifyUtil.isEmpty((String)oriServiceInstance.getId())) {
            LOGGER.info((Object)"Instance(%s) id is null.", new Object[]{oriServiceInstance.getInstanceName()});
            return;
        }
        ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).updateServiceInstance(oriServiceInstance);
    }

    public static void updateRegionAzInfo(AppServiceInstance instance) {
        SiteInfo siteInfo;
        SiteInfo siteInfo2;
        ConfigService configService = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        String pdRegionId = instance.getPdRegionId();
        String pdAzId = instance.getPdAzId();
        if (!(VerifyUtil.isEmpty((String)pdRegionId) || VerifyUtil.isEmpty((String)pdAzId) || VerifyUtil.isEmpty((Object)(siteInfo2 = configService.getSiteInfoByRegionAz(pdRegionId, pdAzId))))) {
            instance.setPdRegionName(siteInfo2.getRegionName());
            instance.setPdAzName(siteInfo2.getAzName());
            instance.setPdSiteId(siteInfo2.getSiteId());
            instance.setPdSiteName(siteInfo2.getSiteName());
        }
        String drRegionId = instance.getDrRegionId();
        String drAzId = instance.getDrAzId();
        if (!(VerifyUtil.isEmpty((String)drRegionId) || VerifyUtil.isEmpty((String)drAzId) || VerifyUtil.isEmpty((Object)(siteInfo = configService.getSiteInfoByRegionAz(drRegionId, drAzId))))) {
            instance.setDrRegionName(siteInfo.getRegionName());
            instance.setDrAzName(siteInfo.getAzName());
            instance.setDrSiteId(siteInfo.getSiteId());
            instance.setDrSiteName(siteInfo.getSiteName());
        }
    }

    private static void refreshInstanceObjects(AppServiceInstance serviceInstance, AppManager appManager, Credential credential) {
        Set<InstanceObject> instanceObjects;
        try {
            instanceObjects = appManager.getInstanceObjects(serviceInstance.getInstanceId(), credential);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Query InstanceObjects failed serviceInstanceId is(%s), name is %s msg: %s.", new Object[]{serviceInstance.getInstanceId(), serviceInstance.getInstanceName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return;
        }
        if (VerifyUtil.isEmpty(instanceObjects)) {
            LOGGER.info((Object)"ServiceInstance(%s) query InstanceObjects failed", new Object[]{serviceInstance.getId()});
            return;
        }
        instanceObjects.forEach(instanceObject -> {
            instanceObject.setProjectId(serviceInstance.getProjectId());
            instanceObject.setServiceInstance(serviceInstance);
            instanceObject.setPdRegionId(serviceInstance.getPdRegionId());
            instanceObject.setPdRegionName(serviceInstance.getPdRegionName());
            instanceObject.setPdAzId(serviceInstance.getPdAzId());
            instanceObject.setPdAzName(serviceInstance.getPdAzName());
            instanceObject.setDrRegionId(serviceInstance.getDrRegionId());
            instanceObject.setDrRegionName(serviceInstance.getDrRegionName());
            instanceObject.setDrAzId(serviceInstance.getDrAzId());
            instanceObject.setDrAzName(serviceInstance.getDrAzName());
        });
        AppRefreshUtil.updateInstanceObject(serviceInstance, instanceObjects);
    }

    private static void updateInstanceObject(AppServiceInstance serviceInstance, Set<InstanceObject> newInstanceObjects) {
        InstanceObjectDao instanceObjectDao = (InstanceObjectDao)ServiceLocator.getInstance().getService(InstanceObjectDao.class);
        if (VerifyUtil.isEmpty(serviceInstance.getInstanceObjects())) {
            instanceObjectDao.saveInstanceObjects(newInstanceObjects);
        } else {
            instanceObjectDao.removeInstanceObjectByServiceInstanceId(serviceInstance.getId());
            instanceObjectDao.saveInstanceObjects(newInstanceObjects);
        }
    }

    private static List<SiteInfo> getSiteInfoList(ServiceRefreshResult refreshResult) {
        if (VerifyUtil.isEmpty((Object)refreshResult)) {
            LOGGER.error((Object)"ServiceInstance(null) getSiteInfoList failed.");
            return Collections.emptyList();
        }
        ConfigService configService = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        SiteInfo pdSiteInfo = null;
        if (!VerifyUtil.isEmpty((String)refreshResult.getPdRegionId()) && !VerifyUtil.isEmpty((String)refreshResult.getPdAzId())) {
            pdSiteInfo = configService.getSiteInfoByRegionAz(refreshResult.getPdRegionId(), refreshResult.getPdAzId());
        }
        SiteInfo drSiteInfo = null;
        if (!VerifyUtil.isEmpty((String)refreshResult.getDrRegionId()) && !VerifyUtil.isEmpty((String)refreshResult.getDrAzId())) {
            drSiteInfo = configService.getSiteInfoByRegionAz(refreshResult.getDrRegionId(), refreshResult.getDrAzId());
        }
        ArrayList<SiteInfo> siteInfoList = new ArrayList<SiteInfo>();
        if (!VerifyUtil.isEmpty((Object)pdSiteInfo)) {
            siteInfoList.add(pdSiteInfo);
        }
        if (!VerifyUtil.isEmpty(drSiteInfo)) {
            siteInfoList.add(drSiteInfo);
        }
        return siteInfoList;
    }

    public static void sendAlarm(Set<ServiceRefreshResult> refreshResults, Long alarmId, Application app) {
        ArrayList deletedNames = new ArrayList();
        List<SiteInfo> siteInfoList = refreshResults.stream().peek(refreshResult -> deletedNames.add(refreshResult.getInstanceName())).flatMap(refreshResult -> AppRefreshUtil.getSiteInfoList(refreshResult).stream()).distinct().collect(Collectors.toList());
        String deletedIdStr = String.join((CharSequence)",", deletedNames);
        AlarmInfo alarmInfo = new AlarmInfo();
        alarmInfo.setAlarmId(alarmId.longValue());
        alarmInfo.setAlarmSeverity(FaultEnum.AlarmSeverity.MAJOR);
        alarmInfo.setProjectId(app.getProjectId());
        alarmInfo.setRepeat(true);
        String locationStr = AppRefreshUtil.getLocationStr(siteInfoList);
        alarmInfo.setLocation(locationStr);
        String[] params = new String[]{app.getName(), app.getId(), deletedIdStr};
        alarmInfo.setParams(params);
        AlarmReportHelper.sendAlarm((AlarmInfo)alarmInfo);
    }

    private static String getLocationStr(List<SiteInfo> siteInfoList) {
        HashMap sn2RegionAzsMap = new HashMap();
        for (SiteInfo siteInfo : siteInfoList) {
            ArrayList<String> regionAzs = (ArrayList<String>)sn2RegionAzsMap.get(siteInfo.getSiteName());
            if (VerifyUtil.isEmpty((Collection)regionAzs)) {
                regionAzs = new ArrayList<String>();
            }
            String regionAzStr = siteInfo.getRegionId() + "/" + siteInfo.getAzId();
            regionAzs.add(regionAzStr);
            sn2RegionAzsMap.put(siteInfo.getSiteName(), regionAzs);
        }
        ArrayList<String> sraList = new ArrayList<String>();
        for (Map.Entry entry : sn2RegionAzsMap.entrySet()) {
            String siteName = (String)entry.getKey();
            String regionAzStr = String.join((CharSequence)",", (Iterable)entry.getValue());
            sraList.add(siteName + "(" + regionAzStr + ")");
        }
        return String.join((CharSequence)",", sraList);
    }

    public static void resotreAlarm(Long alarmId, Application app) {
        AlarmInfo alarmInfo = new AlarmInfo();
        alarmInfo.setAlarmId(alarmId.longValue());
        alarmInfo.setProjectId(app.getProjectId());
        alarmInfo.setAlarmSeverity(FaultEnum.AlarmSeverity.MAJOR);
        String[] params = new String[]{app.getName(), app.getId()};
        alarmInfo.setParams(params);
        AlarmReportHelper.restoreAlarm((AlarmInfo)alarmInfo);
    }

    static {
        SIS_TO_SRS.put(ServiceInstanceStatus.MAINTAIN, ServiceRefreshStatus.MAINTAIN);
        SIS_TO_SRS.put(ServiceInstanceStatus.NORMAL, ServiceRefreshStatus.NORMAL);
    }
}

