/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.ServiceInstanceOpt;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.common.utils.AppRefreshUtil;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.common.utils.ResourceClearUtil;
import com.huawei.csr.framework.common.utils.ServiceConvertUtil;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AppManager;
import com.huawei.csr.framework.core.manager.AppPluginManager;
import com.huawei.csr.framework.dao.InstanceObjectDao;
import com.huawei.csr.framework.dao.RecoverStepDao;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.service.AppService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class AppServiceUtil {
    private static final Log LOGGER = LogFactory.getInstance(AppServiceUtil.class);

    private AppServiceUtil() {
    }

    public static void removeInstance(AppServiceInstance serviceInstance) {
        if (VerifyUtil.isEmpty((Object)serviceInstance)) {
            return;
        }
        StatusOptChecker.checkServiceInstanceStatusOpt(ServiceInstanceStatus.from(serviceInstance.getStatus()).getIndex(), ServiceInstanceOpt.REMOVE_FROM_APP.getIndex(), 1073952002L);
        String projectId = serviceInstance.getProjectId();
        RecoverStepQuery query = new RecoverStepQuery();
        String instanceId = serviceInstance.getId();
        query.setInstanceId(instanceId);
        query.setProjectId(projectId);
        List<RecoverStep> recoverSteps = ((RecoverStepDao)ServiceLocator.getInstance().getService(RecoverStepDao.class)).queryRecoverStepList(query);
        if (!VerifyUtil.isEmpty(recoverSteps)) {
            ResourceClearUtil.removeRecoverStepCascade(projectId, recoverSteps);
        }
        ((InstanceObjectDao)ServiceLocator.getInstance().getService(InstanceObjectDao.class)).removeInstanceObjectByServiceInstanceId(instanceId);
        ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).removeServiceInstanceByInstanceId(instanceId);
        ResourceClearUtil.clearSiteResource(serviceInstance);
    }

    public static void completeAndCheckServiceInstance(AppServiceInstance service, Credential credential) throws ResponseException, ClientException, IOException {
        AppIdentifier appIdentifier = new AppIdentifier(service.getServiceType());
        AppManager appManager = AppPluginManager.getInstance().getAppManager(appIdentifier);
        String endPoint = EndpointUtil.getEndpoint(service.getServiceType(), service.getPdRegionId());
        credential.setEndpoint(endPoint);
        boolean isProtectable = appManager.isProtectableServiceInstance(service.getInstanceId(), credential);
        if (!isProtectable) {
            LOGGER.error((Object)"Instance(%s) is unavailable.", new Object[]{service.getInstanceName()});
            throw new LegoCheckedException(1073952002L, "instance unavailable.");
        }
        AppServiceInstance sdkServiceInstance = appManager.getProtectServiceInstance(service.getInstanceId(), credential);
        AppRefreshUtil.updateAppServiceInstance(service, sdkServiceInstance);
        ServiceInstanceQuery serviceInstanceQuery = new ServiceInstanceQuery();
        serviceInstanceQuery.setPage(false);
        serviceInstanceQuery.setProjectId(credential.getProjectId());
        serviceInstanceQuery.setInstanceId(service.getInstanceId());
        long serviceInstanceCount = ((AppService)ServiceLocator.getInstance().getService(AppService.class)).getServiceInstanceCount(serviceInstanceQuery);
        if (serviceInstanceCount > 0L) {
            LOGGER.error((Object)"instance(%s) already exist", new Object[]{service.getInstanceName()});
            throw new LegoCheckedException(1073952000L, "instance already protected.");
        }
        Set<InstanceObject> instanceObjects = appManager.getInstanceObjects(service.getInstanceId(), credential);
        if (!VerifyUtil.isEmpty(instanceObjects)) {
            Set<InstanceObject> protectedObjects = ServiceConvertUtil.completeInstanceObjects(instanceObjects, service);
            service.setInstanceObjects(protectedObjects);
            service.setInstanceObjectCount(protectedObjects.size());
        }
    }

    public static BackTask buildBackupTaskModel(String projectId, String targetName, String taskName) {
        BackTask backTask = new BackTask();
        backTask.setTargetName(targetName);
        backTask.setTaskName(taskName);
        backTask.setTaskNameLocal(Boolean.valueOf(true));
        backTask.setCreatedTime(new Date());
        backTask.setStartTime(new Date());
        backTask.setTaskProgress(Integer.valueOf(0));
        backTask.setCreateUser(projectId);
        backTask.setType("ark");
        return backTask;
    }
}

