/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectionHelper<T> {
    private final Collection<T> source;
    private Function<T, Object> keyProvider = Object::hashCode;
    private final List<Operate<T>> operateList = new ArrayList<Operate<T>>();

    private CollectionHelper(Collection<T> source) {
        this.source = new ArrayList<T>(source);
    }

    public static <T> CollectionHelper<T> of(Collection<T> source) {
        return new CollectionHelper<T>(source);
    }

    public CollectionHelper<T> intersect(Collection<T> target) {
        if (target == null) {
            return this;
        }
        this.operateList.add(new Operate<T>(target){

            @Override
            void doOperate() {
                if (CollectionHelper.this.source.size() == 0) {
                    return;
                }
                if (this.target.size() == 0) {
                    CollectionHelper.this.source.clear();
                    return;
                }
                Set targetKeySet = this.target.stream().map(CollectionHelper.this.keyProvider).collect(Collectors.toSet());
                CollectionHelper.this.source.removeIf(each -> !targetKeySet.contains(CollectionHelper.this.keyProvider.apply(each)));
            }
        });
        return this;
    }

    public CollectionHelper<T> subtract(Collection<T> target) {
        if (target == null) {
            return this;
        }
        this.operateList.add(new Operate<T>(target){

            @Override
            void doOperate() {
                if (CollectionHelper.this.source.size() == 0 || this.target.size() == 0) {
                    return;
                }
                Set targetKeySet = this.target.stream().map(CollectionHelper.this.keyProvider).collect(Collectors.toSet());
                CollectionHelper.this.source.removeIf(each -> targetKeySet.contains(CollectionHelper.this.keyProvider.apply(each)));
            }
        });
        return this;
    }

    public CollectionHelper<T> union(Collection<T> target) {
        if (target == null) {
            return this;
        }
        this.operateList.add(new Operate<T>(target){

            @Override
            void doOperate() {
                if (CollectionHelper.this.source.size() == 0) {
                    CollectionHelper.this.source.addAll(this.target);
                    return;
                }
                if (this.target.size() == 0) {
                    return;
                }
                Set currentKeySet = CollectionHelper.this.source.stream().map(CollectionHelper.this.keyProvider).collect(Collectors.toSet());
                for (Object each : this.target) {
                    if (currentKeySet.contains(CollectionHelper.this.keyProvider.apply(each))) continue;
                    CollectionHelper.this.source.add(each);
                }
            }
        });
        return this;
    }

    public CollectionHelper<T> keyProvider(Function<T, Object> keyProvider) {
        this.keyProvider = keyProvider;
        return this;
    }

    public <A, R> R collect(Collector<? super T, A, R> collector) {
        this.operateList.forEach(Operate::doOperate);
        return this.source.stream().collect(collector);
    }

    public static <T> boolean equal(Collection<T> source, Collection<T> target) {
        return CollectionHelper.equal(source, target, Objects::hashCode);
    }

    public static <T> boolean equal(Collection<T> source, Collection<T> target, Function<T, Object> keyProvider) {
        if (source.size() != target.size()) {
            return false;
        }
        Set targetKeySet = target.stream().map(keyProvider).collect(Collectors.toSet());
        for (T each : source) {
            if (targetKeySet.contains(keyProvider.apply(each))) continue;
            return false;
        }
        return true;
    }

    public static <T> List<List<T>> twoDimArray2List(T[][] twoDimArray) {
        return Arrays.stream(twoDimArray).map(item -> Arrays.stream(item).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public static <T> List<List<T>> twoDimArray2UnmodifiableList(T[][] twoDimArray) {
        return Collections.unmodifiableList(Arrays.stream(twoDimArray).map(item -> Collections.unmodifiableList(Arrays.stream(item).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    private static abstract class Operate<T> {
        Collection<T> target;

        Operate(Collection<T> target) {
            this.target = target;
        }

        abstract void doOperate();
    }
}

