/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class LockUtil {
    private static final Map<String, ReentrantLock> CSR_LOCK_MAP = new ConcurrentHashMap<String, ReentrantLock>();
    private static final int MAX_RETRIES = 600;
    private static final int SLEEP_TIME = 1000;

    private LockUtil() {
    }

    public static synchronized boolean tryLock(String key) {
        ReentrantLock lock = CSR_LOCK_MAP.get(key);
        if (lock == null) {
            lock = new ReentrantLock(true);
            CSR_LOCK_MAP.put(key, lock);
        }
        return lock.tryLock();
    }

    public static boolean tryLock(String key, int retries) {
        boolean locked = LockUtil.tryLock(key);
        int count = 0;
        while (!locked) {
            CommonUtil.sleep((long)1000L);
            locked = LockUtil.tryLock(key);
            if (++count != retries && count != 600) continue;
            break;
        }
        return locked;
    }

    public static synchronized void unLock(String key) {
        ReentrantLock lock = CSR_LOCK_MAP.get(key);
        if (lock != null) {
            lock.unlock();
            CSR_LOCK_MAP.remove(key);
        }
    }

    public static synchronized ReentrantLock getLock(String key) {
        return CSR_LOCK_MAP.get(key);
    }

    public static synchronized void removeLock(String key) {
        CSR_LOCK_MAP.remove(key);
    }
}

