/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.common.constants.RecoverExecuteAction;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.RecoverLogQuery;
import com.huawei.csr.framework.common.model.SitePlanExecuteBo;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.utils.RecoverPlanUtil;
import com.huawei.csr.framework.dao.impl.RecoverLogDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPlanDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class PlanExecuteUtil {
    private static final Log LOG = LogFactory.getInstance(PlanExecuteUtil.class);

    private PlanExecuteUtil() {
    }

    public static void updateSiteTaskResource(SitePlanExecuteBo executeBo, RecoverLog recoverLog) {
        List<RecoverLog> recoverPlanLogs = PlanExecuteUtil.queryRecoverPlanLogs(executeBo.getProjectId(), recoverLog.getId(), null);
        if (RecoverExecuteAction.SUSPEND.equals((Object)executeBo.getAction())) {
            recoverLog.setErrorCode(-1000L);
            PlanExecuteUtil.updateRecoverPlanAndLog(executeBo.getOperationType(), recoverPlanLogs, -1000L);
        }
        if (RecoverExecuteAction.STOP.equals((Object)executeBo.getAction())) {
            recoverLog.setErrorCode(1073952114L);
            PlanExecuteUtil.updateRecoverPlanAndLog(executeBo.getOperationType(), recoverPlanLogs, 1073952114L);
        }
        ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update(recoverLog);
    }

    private static List<RecoverLog> queryRecoverPlanLogs(String projectId, String parentId, List<String> statusList) {
        RecoverLogQuery recoverPlanLogQuery = new RecoverLogQuery();
        recoverPlanLogQuery.setProjectId(projectId);
        recoverPlanLogQuery.setParentIds(Collections.singletonList(parentId));
        recoverPlanLogQuery.setResourceType(RecoverResourceType.RECOVER_PLAN.getValue());
        recoverPlanLogQuery.setStatus(statusList);
        return ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).queryRecoverLogs(recoverPlanLogQuery);
    }

    private static void updateRecoverPlanAndLog(RecoverOperateType type, List<RecoverLog> recoverPlanLogs, long code) {
        recoverPlanLogs.forEach(planLog -> {
            PlanExecuteUtil.updateRecoverLog(planLog, code);
            PlanExecuteUtil.updateRecoverPlanStatus(type, planLog, code);
        });
    }

    private static void updateRecoverLog(RecoverLog recoverLog, long code) {
        if (RecoverLogStatus.WAITING.getValue().equals(recoverLog.getStatus())) {
            if (code == -1000L) {
                recoverLog.setStatus(RecoverLogStatus.SUSPENDED.getValue());
            }
            if (code == 1073952114L) {
                recoverLog.setStatus(RecoverLogStatus.FAILED.getValue());
            }
            recoverLog.setErrorCode(code);
            ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update(recoverLog);
        }
        if (RecoverLogStatus.RUNNING.getValue().equals(recoverLog.getStatus())) {
            recoverLog.setErrorCode(code);
            ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update(recoverLog);
        }
    }

    private static void updateRecoverPlanStatus(RecoverOperateType type, RecoverLog recoverLog, long code) {
        boolean drPlanFlag;
        RecoverPlanDaoImpl recoverPlanDao = (RecoverPlanDaoImpl)ServiceLocator.getInstance().getService(RecoverPlanDaoImpl.class);
        RecoverPlan recoverPlan = recoverPlanDao.getRecoverPlanById(recoverLog.getResourceId());
        boolean bl = drPlanFlag = RecoverStatus.DISASTER_RECOVERY_COMPLETED.getValue().equals(recoverPlan.getStatus()) && RecoverOperateType.REPROTECT.equals((Object)type);
        if ((drPlanFlag || RecoverStatus.NORMAL.getValue().equals(recoverPlan.getStatus())) && !RecoverLogStatus.SUCCESS.getValue().equals(recoverLog.getStatus())) {
            if (code == -1000L) {
                recoverPlan.setStatus(RecoverPlanUtil.getSuspendedStatus(type).getValue());
            }
            if (code == 1073952114L) {
                recoverPlan.setStatus(RecoverPlanUtil.getFailedStatus(type).getValue());
            }
            recoverPlanDao.updatePlanBasicInfo(recoverPlan);
        }
    }

    private static Optional<RecoverLog> querySitePlanLog(String sitePlanId, RecoverLogStatus status) {
        RecoverLogQuery logQuery = new RecoverLogQuery();
        logQuery.setResourceType(RecoverResourceType.SITE_PLAN.getValue());
        logQuery.setStatus(Collections.singletonList(status.getValue()));
        logQuery.setResourceIds(Collections.singletonList(sitePlanId));
        logQuery.setLimit(1);
        List<RecoverLog> logList = ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).queryRecoverLogs(logQuery);
        if (VerifyUtil.isEmpty(logList)) {
            return Optional.empty();
        }
        return Optional.of(logList.get(0));
    }

    public static void updateCallBack(String sitePlanId, RecoverLogStatus status) {
        Optional<RecoverLog> logOptional = PlanExecuteUtil.querySitePlanLog(sitePlanId, status);
        if (!logOptional.isPresent()) {
            LOG.info((Object)"SitePlan log is empty. sitePlanId:'%s', status:'%s'.", new Object[]{sitePlanId, status.getValue()});
            return;
        }
        RecoverPlanDaoImpl recoverPlanDao = (RecoverPlanDaoImpl)ServiceLocator.getInstance().getService(RecoverPlanDaoImpl.class);
        PlanExecuteUtil.queryRecoverPlanLogs(logOptional.get().getProjectId(), logOptional.get().getId(), Collections.singletonList(RecoverLogStatus.WAITING.getValue())).forEach(recoverLog -> {
            RecoverOperateType type = RecoverOperateType.from(recoverLog.getOperationType());
            RecoverPlan plan = recoverPlanDao.getRecoverPlanById(recoverLog.getResourceId());
            if (RecoverLogStatus.FAILED.equals((Object)status)) {
                plan.setStatus(RecoverPlanUtil.getFailedStatus(type).getValue());
                recoverLog.setErrorCode(1073952219L);
            }
            if (RecoverLogStatus.SUSPENDED.equals((Object)status)) {
                plan.setStatus(RecoverPlanUtil.getSuspendedStatus(type).getValue());
                recoverLog.setErrorCode(-1000L);
            }
            recoverLog.setStatus(status.getValue());
            recoverPlanDao.updatePlanBasicInfo(plan);
            ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update((RecoverLog)recoverLog);
        });
    }
}

