/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public final class RecoverPlanUtil {
    private static final Log logger = LogFactory.getInstance(RecoverPlanUtil.class);
    private static final Map<String, RecoverStatus> OPT_RUNNING_STATUS_MAP = new HashMap<String, RecoverStatus>();
    private static final Map<String, RecoverStatus> OPT_SUSPENDED_STATUS_MAP = new HashMap<String, RecoverStatus>();
    private static final Map<String, RecoverStatus> OPT_FAILED_STATUS_MAP = new HashMap<String, RecoverStatus>();
    private static final Map<String, RecoverStatus> OPT_COMPLETED_STATUS_MAP = new HashMap<String, RecoverStatus>();

    private RecoverPlanUtil() {
    }

    public static RecoverStatus getRunningStatus(RecoverOperateType operateType) {
        if (!OPT_RUNNING_STATUS_MAP.containsKey(operateType.getValue())) {
            logger.error((Object)"The recover operation type(%s) is not supported", new Object[]{operateType.getValue()});
            throw new LegoCheckedException(-1L);
        }
        return OPT_RUNNING_STATUS_MAP.get(operateType.getValue());
    }

    public static RecoverStatus getSuspendedStatus(RecoverOperateType operateType) {
        if (!OPT_SUSPENDED_STATUS_MAP.containsKey(operateType.getValue())) {
            logger.error((Object)"The recover operation type(%s) is not supported", new Object[]{operateType.getValue()});
            throw new LegoCheckedException(-1L);
        }
        return OPT_SUSPENDED_STATUS_MAP.get(operateType.getValue());
    }

    public static RecoverStatus getFailedStatus(RecoverOperateType operateType) {
        if (!OPT_FAILED_STATUS_MAP.containsKey(operateType.getValue())) {
            logger.error((Object)"The recover operation type(%s) is not supported", new Object[]{operateType.getValue()});
            throw new LegoCheckedException(-1L);
        }
        return OPT_FAILED_STATUS_MAP.get(operateType.getValue());
    }

    public static RecoverStatus getCompletedStatus(RecoverOperateType operateType) {
        if (!OPT_COMPLETED_STATUS_MAP.containsKey(operateType.getValue())) {
            logger.error((Object)"The recover operation type(%s) is not supported", new Object[]{operateType.getValue()});
            throw new LegoCheckedException(-1L);
        }
        return OPT_COMPLETED_STATUS_MAP.get(operateType.getValue());
    }

    static {
        OPT_RUNNING_STATUS_MAP.put(RecoverOperateType.REPROTECT.getValue(), RecoverStatus.REPROTECT_RUNNING);
        OPT_RUNNING_STATUS_MAP.put(RecoverOperateType.PLANNED_MIGRATION.getValue(), RecoverStatus.PLANED_MOTION_RUNNING);
        OPT_RUNNING_STATUS_MAP.put(RecoverOperateType.DISASTER_RECOVERY.getValue(), RecoverStatus.DISASTER_RECOVERY_RUNNING);
        OPT_RUNNING_STATUS_MAP.put(RecoverOperateType.SWITCHBACK.getValue(), RecoverStatus.SWITCHBACK_RUNNING);
        OPT_SUSPENDED_STATUS_MAP.put(RecoverOperateType.REPROTECT.getValue(), RecoverStatus.REPROTECT_SUSPENDED);
        OPT_SUSPENDED_STATUS_MAP.put(RecoverOperateType.PLANNED_MIGRATION.getValue(), RecoverStatus.PLANED_MOTION_SUSPENDED);
        OPT_SUSPENDED_STATUS_MAP.put(RecoverOperateType.DISASTER_RECOVERY.getValue(), RecoverStatus.DISASTER_RECOVERY_SUSPENDED);
        OPT_SUSPENDED_STATUS_MAP.put(RecoverOperateType.SWITCHBACK.getValue(), RecoverStatus.SWITCHBACK_SUSPENDED);
        OPT_FAILED_STATUS_MAP.put(RecoverOperateType.REPROTECT.getValue(), RecoverStatus.REPROTECT_FAILED);
        OPT_FAILED_STATUS_MAP.put(RecoverOperateType.PLANNED_MIGRATION.getValue(), RecoverStatus.PLANED_MOTION_FAILED);
        OPT_FAILED_STATUS_MAP.put(RecoverOperateType.DISASTER_RECOVERY.getValue(), RecoverStatus.DISASTER_RECOVERY_FAILED);
        OPT_FAILED_STATUS_MAP.put(RecoverOperateType.SWITCHBACK.getValue(), RecoverStatus.SWITCHBACK_FAILED);
        OPT_COMPLETED_STATUS_MAP.put(RecoverOperateType.REPROTECT.getValue(), RecoverStatus.NORMAL);
        OPT_COMPLETED_STATUS_MAP.put(RecoverOperateType.PLANNED_MIGRATION.getValue(), RecoverStatus.NORMAL);
        OPT_COMPLETED_STATUS_MAP.put(RecoverOperateType.DISASTER_RECOVERY.getValue(), RecoverStatus.DISASTER_RECOVERY_COMPLETED);
        OPT_COMPLETED_STATUS_MAP.put(RecoverOperateType.SWITCHBACK.getValue(), RecoverStatus.NORMAL);
    }
}

