/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecoverStepUtil {
    private static final Map<String, Set<String>> FLOW_STEP_ACTION_MAP = new HashMap<String, Set<String>>();

    private RecoverStepUtil() {
    }

    public static Set<String> getActionSetByOperateType(String operateType) {
        return FLOW_STEP_ACTION_MAP.get(operateType);
    }

    static {
        HashSet<String> plannedMigrationSet = new HashSet<String>();
        plannedMigrationSet.add(RecoverStepAction.PLANNED_MIGRATION.getValue());
        plannedMigrationSet.add(RecoverStepAction.POWER_ON.getValue());
        plannedMigrationSet.add(RecoverStepAction.POWER_OFF.getValue());
        plannedMigrationSet.add(RecoverStepAction.START_CONTAINER.getValue());
        plannedMigrationSet.add(RecoverStepAction.STOP_CONTAINER.getValue());
        plannedMigrationSet.add(RecoverStepAction.SWITCHOVER.getValue());
        FLOW_STEP_ACTION_MAP.put(RecoverOperateType.PLANNED_MIGRATION.getValue(), plannedMigrationSet);
        HashSet<String> disasterRecoverySet = new HashSet<String>();
        disasterRecoverySet.add(RecoverStepAction.DISASTER_RECOVERY.getValue());
        disasterRecoverySet.add(RecoverStepAction.POWER_ON.getValue());
        disasterRecoverySet.add(RecoverStepAction.POWER_OFF.getValue());
        disasterRecoverySet.add(RecoverStepAction.START_CONTAINER.getValue());
        disasterRecoverySet.add(RecoverStepAction.STOP_CONTAINER.getValue());
        disasterRecoverySet.add(RecoverStepAction.CHECK_PD_STATUS.getValue());
        FLOW_STEP_ACTION_MAP.put(RecoverOperateType.DISASTER_RECOVERY.getValue(), disasterRecoverySet);
        HashSet<String> switchBackSet = new HashSet<String>();
        switchBackSet.add(RecoverStepAction.SWITCHBACK.getValue());
        switchBackSet.add(RecoverStepAction.POWER_ON.getValue());
        switchBackSet.add(RecoverStepAction.POWER_OFF.getValue());
        switchBackSet.add(RecoverStepAction.START_CONTAINER.getValue());
        switchBackSet.add(RecoverStepAction.STOP_CONTAINER.getValue());
        switchBackSet.add(RecoverStepAction.SWITCHOVER.getValue());
        FLOW_STEP_ACTION_MAP.put(RecoverOperateType.SWITCHBACK.getValue(), switchBackSet);
        HashSet<String> reprotectSet = new HashSet<String>();
        reprotectSet.add(RecoverStepAction.SWITCHBACK.getValue());
        reprotectSet.add(RecoverStepAction.POWER_ON.getValue());
        reprotectSet.add(RecoverStepAction.POWER_OFF.getValue());
        reprotectSet.add(RecoverStepAction.START_CONTAINER.getValue());
        reprotectSet.add(RecoverStepAction.STOP_CONTAINER.getValue());
        reprotectSet.add(RecoverStepAction.CHECK_INSTANCE.getValue());
        reprotectSet.add(RecoverStepAction.REPROTECT.getValue());
        FLOW_STEP_ACTION_MAP.put(RecoverOperateType.REPROTECT.getValue(), reprotectSet);
    }
}

