/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.common.constants.RecoverStageType;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.dao.FlowStepMapDao;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.RecoverStageDao;
import com.huawei.csr.framework.dao.StageFlowMapDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.csr.framework.service.RecoverStepService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.Lists;

public class ResourceClearUtil {
    private static final Log LOGGER = LogFactory.getInstance(ResourceClearUtil.class);

    private ResourceClearUtil() {
    }

    public static void removeRecoverStepCascade(String projectId, List<RecoverStep> recoverSteps) {
        List<String> flowIds = ResourceClearUtil.deleteSteps(recoverSteps);
        List<String> stageIds = ResourceClearUtil.deleteFlows(projectId, flowIds);
        List<String> prePlanIds = ResourceClearUtil.deleteStages(projectId, stageIds);
        ResourceClearUtil.deletePrePlans(projectId, prePlanIds);
    }

    public static void removeRecoverFlowCascade(String projectId, List<String> recoverFlowIds) {
        List<String> stageIds = ResourceClearUtil.deleteFlows(projectId, recoverFlowIds);
        List<String> prePlanIds = ResourceClearUtil.deleteStages(projectId, stageIds);
        ResourceClearUtil.deletePrePlans(projectId, prePlanIds);
    }

    private static List<String> deleteSteps(List<RecoverStep> recoverSteps) {
        if (VerifyUtil.isEmpty(recoverSteps)) {
            return Lists.newArrayList();
        }
        FlowStepMapDao flowStepMapDao = (FlowStepMapDao)ServiceLocator.getInstance().getService(FlowStepMapDao.class);
        RecoverStepService recoverStepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        return recoverSteps.stream().flatMap(recoverStep -> {
            String stepId = recoverStep.getId();
            List<FlowStepMap> flowStepMaps = flowStepMapDao.queryFlowStepMapByStepId(stepId);
            flowStepMapDao.deleteAllByStepId(stepId);
            RecoverStepQuery query = new RecoverStepQuery();
            query.setStepId(recoverStep.getId());
            recoverStepService.deleteRecoverStep(query);
            if (VerifyUtil.isEmpty(flowStepMaps)) {
                return Stream.empty();
            }
            return flowStepMaps.stream();
        }).map(FlowStepMap::getRecoverFlowId).distinct().filter(recoverFlowId -> flowStepMapDao.getStepMapCountByFlowId((String)recoverFlowId) == 0L).collect(Collectors.toList());
    }

    public static List<String> deleteFlows(String projectId, List<String> flowIds) {
        if (VerifyUtil.isEmpty(flowIds)) {
            return Lists.newArrayList();
        }
        StageFlowMapDao stageFlowMapDao = (StageFlowMapDao)ServiceLocator.getInstance().getService(StageFlowMapDao.class);
        RecoverStageDao recoverStageDao = (RecoverStageDao)ServiceLocator.getInstance().getService(RecoverStageDao.class);
        RecoverFlowDao recoverFlowDao = (RecoverFlowDao)ServiceLocator.getInstance().getService(RecoverFlowDao.class);
        RecoverFlowService recoverFlowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        return flowIds.stream().flatMap(flowId -> {
            List<StageFlowMap> stageFlowMaps = stageFlowMapDao.queryStageFlowMapByFlowId((String)flowId);
            if (VerifyUtil.isEmpty(stageFlowMaps)) {
                recoverFlowDao.delete(projectId, (String)flowId);
                return Stream.empty();
            }
            return stageFlowMaps.stream();
        }).map(stageFlowMap -> {
            recoverFlowService.deleteFlow(projectId, stageFlowMap.getFlowId(), recoverStageDao.getRecoverStageById(stageFlowMap.getStageId()).getPrePlanId());
            return stageFlowMap.getStageId();
        }).filter(stageId -> stageFlowMapDao.getStageFlowMapCountByStageId((String)stageId) == 0L).distinct().collect(Collectors.toList());
    }

    public static List<String> deleteStages(String projectId, List<String> stageIds) {
        if (VerifyUtil.isEmpty(stageIds)) {
            return Lists.newArrayList();
        }
        RecoverStageService recoverStageService = (RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class);
        StageFlowMapDao stageFlowMapDao = (StageFlowMapDao)ServiceLocator.getInstance().getService(StageFlowMapDao.class);
        HashSet<String> prePlanIds = new HashSet<String>();
        for (String stageId : stageIds) {
            RecoverStage stage = recoverStageService.getStageById(stageId);
            List<RecoverStage> stageList = recoverStageService.getStageList(projectId, stage.getPrePlanId());
            if (VerifyUtil.isEmpty(stageList)) {
                prePlanIds.add(stage.getPrePlanId());
                continue;
            }
            boolean isFlowEmpty = false;
            for (RecoverStage recoverStage : stageList) {
                long flowMapCount = stageFlowMapDao.getStageFlowMapCountByStageId(recoverStage.getId());
                if (flowMapCount > 0L) {
                    ResourceClearUtil.delStageWhenPreOrNextUnsuspend(projectId, stage);
                    isFlowEmpty = false;
                    break;
                }
                isFlowEmpty = true;
            }
            if (!isFlowEmpty) continue;
            prePlanIds.add(stage.getPrePlanId());
        }
        return new ArrayList<String>(prePlanIds);
    }

    public static void deletePrePlans(String projectId, List<String> prePlanIds) {
        if (VerifyUtil.isEmpty(prePlanIds)) {
            return;
        }
        RecoverPreplanService recoverPreplanService = (RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class);
        prePlanIds.forEach(prePlanId -> recoverPreplanService.deletePreplan(projectId, (String)prePlanId));
    }

    public static void clearSiteResource(AppServiceInstance serviceInstance) {
        Application application = serviceInstance.getApplication();
        if (VerifyUtil.isEmpty((String)application.getRecoverPlanId())) {
            return;
        }
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        List<Application> apps = planService.getAppByRecoverPlanId(serviceInstance.getProjectId(), application.getRecoverPlanId());
        HashMap siteIdCountMap = new HashMap();
        apps.stream().flatMap(app -> VerifyUtil.isEmpty(app.getServiceInstances()) ? Stream.empty() : app.getServiceInstances().stream()).flatMap(instance -> Stream.of(instance.getPdSiteId(), instance.getDrSiteId())).forEach(siteId -> siteIdCountMap.put(siteId, siteIdCountMap.getOrDefault(siteId, 0) + 1));
        if (!siteIdCountMap.containsKey(serviceInstance.getPdSiteId())) {
            ResourceClearUtil.doClear(serviceInstance.getPdSiteId(), application.getRecoverPlanId(), serviceInstance.getProjectId());
        }
        if (!siteIdCountMap.containsKey(serviceInstance.getDrSiteId())) {
            ResourceClearUtil.doClear(serviceInstance.getDrSiteId(), application.getRecoverPlanId(), serviceInstance.getProjectId());
        }
    }

    private static void doClear(String siteId, String recoverPlanId, String projectId) {
        RecoverPreplanQuery query = new RecoverPreplanQuery();
        query.setPlanId(recoverPlanId);
        query.setSiteId(siteId);
        query.setProjectId(projectId);
        RecoverPreplanService preplanService = (RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class);
        List<RecoverPreplan> recoverPreplans = preplanService.queryPreplans(query);
        recoverPreplans.forEach(recoverPreplan -> {
            LOGGER.info((Object)"Start clear preplan under Site(%s) , recoverPlanId: %s , prePlanId: %s", new Object[]{siteId, recoverPlanId, recoverPreplan.getId()});
            preplanService.deletePreplan(projectId, recoverPreplan.getId());
        });
    }

    private static void delStageWhenPreOrNextUnsuspend(String projectId, RecoverStage stage) {
        RecoverStageService stageService = (RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class);
        boolean isPreStageSuspend = false;
        boolean isNextStageSuspend = false;
        if (!VerifyUtil.isEmpty((String)stage.getPreStageId())) {
            RecoverStage preStage = stageService.getStageById(stage.getPreStageId());
            isPreStageSuspend = RecoverStageType.SUSPEND.getValue().equals(preStage.getType());
        }
        if (!VerifyUtil.isEmpty((String)stage.getNextStageId())) {
            RecoverStage nextStage = stageService.getStageById(stage.getNextStageId());
            isNextStageSuspend = RecoverStageType.SUSPEND.getValue().equals(nextStage.getType());
        }
        if (!isPreStageSuspend || !isNextStageSuspend) {
            stageService.deleteStage(projectId, stage.getId());
        }
    }
}

