/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.dao.impl.FlowStepMapDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPreplanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStepDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public final class ResourceUpdateUtil {
    private static final Log LOG = LogFactory.getInstance(ResourceUpdateUtil.class);

    private ResourceUpdateUtil() {
    }

    public static void updateDisasterRecoveryResources(String reprotectPreplanId) {
        final Optional<RecoverPreplan> reprotectPreplanOptional = ((RecoverPreplanDaoImpl)ServiceLocator.getInstance().getService(RecoverPreplanDaoImpl.class)).queryPreplanById(reprotectPreplanId);
        if (!reprotectPreplanOptional.isPresent()) {
            LOG.error((Object)"Recover preplan not exist. The preplanId is '%s'.", new Object[]{reprotectPreplanId});
            throw new LegoCheckedException(1073952800L);
        }
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    Optional drOptional = ResourceUpdateUtil.updateDisasterRecoveryPreplan((RecoverPreplan)reprotectPreplanOptional.get());
                    if (drOptional.isPresent()) {
                        Set flowIdSet = ResourceUpdateUtil.updateDisasterRecoveryFlows((RecoverPreplan)drOptional.get());
                        ResourceUpdateUtil.updateDisasterRecoverySteps(flowIdSet);
                    }
                }
            });
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Update disaster recovery resources failed, reprotect preplanId is '%s'.", new Object[]{reprotectPreplanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Update disaster recovery resources failed, reprotect preplanId is '%s'.", new Object[]{reprotectPreplanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    public static List<RecoverPreplan> getSameSiteDrPreplanList(RecoverPreplan rpPreplan) {
        RecoverPreplanQuery preplanQuery = new RecoverPreplanQuery();
        preplanQuery.setProjectId(rpPreplan.getProjectId());
        preplanQuery.setPlanId(rpPreplan.getRecoverPlanId());
        preplanQuery.setSiteId(rpPreplan.getSiteId());
        preplanQuery.setPreplanType(RecoverOperateType.DISASTER_RECOVERY.getValue());
        preplanQuery.setStatus(RecoverStatus.DISASTER_RECOVERY_COMPLETED.getValue());
        preplanQuery.setLimit(1);
        return ((RecoverPreplanDaoImpl)ServiceLocator.getInstance().getService(RecoverPreplanDaoImpl.class)).queryPreplans(preplanQuery);
    }

    private static Optional<RecoverPreplan> updateDisasterRecoveryPreplan(RecoverPreplan rpPreplan) {
        List<RecoverPreplan> preplanList = ResourceUpdateUtil.getSameSiteDrPreplanList(rpPreplan);
        if (VerifyUtil.isEmpty(preplanList)) {
            LOG.info((Object)"Recover preplan %s not exist disaster recovery preplan.", new Object[]{rpPreplan.getId()});
            return Optional.empty();
        }
        RecoverPreplan drPreplan = preplanList.get(0);
        drPreplan.setStatus(RecoverStatus.NORMAL.getValue());
        ((RecoverPreplanDaoImpl)ServiceLocator.getInstance().getService(RecoverPreplanDaoImpl.class)).update(drPreplan);
        return Optional.of(drPreplan);
    }

    private static Set<String> updateDisasterRecoveryFlows(RecoverPreplan drPreplan) {
        RecoverFlowQuery flowQuery = new RecoverFlowQuery();
        flowQuery.setProjectId(drPreplan.getProjectId());
        flowQuery.setPrePlanId(drPreplan.getId());
        flowQuery.setType(RecoverOperateType.DISASTER_RECOVERY.getValue());
        flowQuery.setStatus(RecoverStatus.DISASTER_RECOVERY_COMPLETED.getValue());
        RecoverFlowDaoImpl recoverFlowDao = (RecoverFlowDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowDaoImpl.class);
        List<RecoverFlow> flowList = recoverFlowDao.queryRecoverFlows(flowQuery);
        HashSet<String> flowIdSet = new HashSet<String>();
        flowList.forEach(flow -> {
            flow.setStatus(RecoverStatus.NORMAL.getValue());
            recoverFlowDao.update((RecoverFlow)flow);
            flowIdSet.add(flow.getId());
        });
        return flowIdSet;
    }

    private static void updateDisasterRecoverySteps(Set<String> flowIdSet) {
        ArrayList flowStepMapList = new ArrayList();
        FlowStepMapDaoImpl flowStepMapDao = (FlowStepMapDaoImpl)ServiceLocator.getInstance().getService(FlowStepMapDaoImpl.class);
        flowIdSet.forEach(flowId -> flowStepMapList.addAll(flowStepMapDao.queryFlowStepMapByFlowId((String)flowId)));
        ArrayList stepList = new ArrayList();
        RecoverStepDaoImpl recoverStepDao = (RecoverStepDaoImpl)ServiceLocator.getInstance().getService(RecoverStepDaoImpl.class);
        flowStepMapList.forEach(flowStepMap -> stepList.add(recoverStepDao.queryRecoverStepById(flowStepMap.getRecoverStepId())));
        stepList.forEach(step -> {
            if (RecoverStatus.DISASTER_RECOVERY_COMPLETED.getValue().equals(step.getStatus())) {
                step.setStatus(RecoverStatus.NORMAL.getValue());
                recoverStepDao.update((RecoverStep)step);
            }
        });
    }
}

