/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.common.utils;

import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.order.model.DictUsage;
import com.huawei.om.order.model.Instance;
import com.huawei.om.order.model.ModifyUsages;
import com.huawei.om.order.model.QuotaUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ServiceConvertUtil {
    public static Instance convert(AppServiceInstance instance, String result) {
        Instance orderInstance = new Instance();
        if (VerifyUtil.isEmpty((Object)instance)) {
            return orderInstance;
        }
        orderInstance.setInstanceId(instance.getId());
        orderInstance.setInstanceName(instance.getInstanceName());
        orderInstance.setInstanceType(instance.getServiceType());
        orderInstance.setRegionId(instance.getPdRegionId());
        orderInstance.setProjectId(instance.getProjectId());
        orderInstance.setResult(result);
        return orderInstance;
    }

    public static List<Instance> convert(Collection<AppServiceInstance> instances, String orderResult) {
        return instances.stream().map(instance -> ServiceConvertUtil.convert(instance, orderResult)).collect(Collectors.toList());
    }

    public static Set<InstanceObject> completeInstanceObjects(Collection<InstanceObject> objects, AppServiceInstance serviceInstance) {
        return objects.stream().peek(instanceObject -> {
            instanceObject.setProjectId(serviceInstance.getProjectId());
            instanceObject.setServiceInstance(serviceInstance);
            instanceObject.setPdRegionId(serviceInstance.getPdRegionId());
            instanceObject.setPdRegionName(serviceInstance.getPdRegionName());
            instanceObject.setPdAzId(serviceInstance.getPdAzId());
            instanceObject.setPdAzName(serviceInstance.getPdAzName());
            instanceObject.setDrRegionId(serviceInstance.getDrRegionId());
            instanceObject.setDrRegionName(serviceInstance.getDrRegionName());
            instanceObject.setDrAzId(serviceInstance.getDrAzId());
            instanceObject.setDrAzName(serviceInstance.getDrAzName());
        }).collect(Collectors.toSet());
    }

    public static ModifyUsages generateModifyUsage(double appNum, double serviceInstanceNum, String projectId) {
        DictUsage appUsage = new DictUsage();
        appUsage.setResource("ark.app.num");
        appUsage.setUsed(appNum);
        DictUsage instanceUsage = new DictUsage();
        instanceUsage.setResource("ark.instance.num");
        instanceUsage.setUsed(serviceInstanceNum);
        ArrayList<DictUsage> resources = new ArrayList<DictUsage>();
        resources.add(appUsage);
        resources.add(instanceUsage);
        QuotaUsage quotaUsage = new QuotaUsage();
        quotaUsage.setResources(resources);
        quotaUsage.setServiceId("ark");
        ArrayList<QuotaUsage> usages = new ArrayList<QuotaUsage>();
        usages.add(quotaUsage);
        ModifyUsages modifyUsages = new ModifyUsages();
        modifyUsages.setProjectId(projectId);
        modifyUsages.setUsages(usages);
        return modifyUsages;
    }
}

