/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.config;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigFactory<T> {
    private static final Map<String, YamlConfigFactory<?>> INSTANCES = new HashMap();
    private String path;
    private Object config;

    private YamlConfigFactory(String yamlFile, Class<T> cls) {
        this.path = yamlFile;
        this.parse(yamlFile, cls);
    }

    public static synchronized <T> YamlConfigFactory<?> getInstance(String yamlFile, Class<T> cls) {
        if (INSTANCES.containsKey(yamlFile)) {
            return INSTANCES.get(yamlFile);
        }
        YamlConfigFactory<T> parser = new YamlConfigFactory<T>(yamlFile, cls);
        INSTANCES.put(yamlFile, parser);
        return parser;
    }

    private void parse(String yamlFile, Class<T> cls) {
        try (FileInputStream inputStream = new FileInputStream(yamlFile);){
            Yaml yaml = new Yaml();
            this.config = yaml.loadAs((InputStream)inputStream, cls);
        }
        catch (Exception err) {
            throw new LegoCheckedException("Parse yaml file failed, file path: " + this.path, (Throwable)err);
        }
    }

    public String getPath() {
        return this.path;
    }

    public Object getConfig() {
        return this.config;
    }
}

