/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.event;

import com.huawei.csr.framework.core.event.EventDispatcher;
import com.huawei.csr.framework.core.event.EventSupplier;
import com.huawei.csr.framework.core.event.listener.BaseEventListener;
import com.huawei.csr.framework.core.event.objects.AbstractEventObject;
import com.huawei.csr.framework.core.thread.ThreadPoolFactory;
import com.huawei.lego.core.base.framework.container.support.SystemLauncher;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;

public class DefaultEventDispatcher
implements EventDispatcher {
    private static final Log logger = LogFactory.getInstance(DefaultEventDispatcher.class);
    private static volatile DefaultEventDispatcher instance;
    private static List<BaseEventListener<AbstractEventObject<?>>> listeners;
    private static ThreadPoolExecutor taskExecutor;

    private DefaultEventDispatcher() {
    }

    @Override
    public void asyncDispatchEvent(AbstractEventObject<?> event) {
        List<BaseEventListener<AbstractEventObject<?>>> filterListeners = this.filterListeners(event);
        for (BaseEventListener<AbstractEventObject<?>> listener : filterListeners) {
            logger.info((Object)"Start async send event(%s) to listener(%s)", new Object[]{event.getClass().getSimpleName(), listener.getClass().getSimpleName()});
            taskExecutor.execute(() -> listener.onEvent(event));
        }
    }

    @Override
    public void dispatchEvent(AbstractEventObject<?> event) {
        List<BaseEventListener<AbstractEventObject<?>>> filterListeners = this.filterListeners(event);
        for (BaseEventListener<AbstractEventObject<?>> listener : filterListeners) {
            logger.info((Object)"Start sync send event(%s) to listener(%s)", new Object[]{event.getClass().getSimpleName(), listener.getClass().getSimpleName()});
            listener.onEvent(event);
        }
    }

    @Override
    public void process(EventSupplier eventSupplier, AbstractEventObject<?> event) {
        List<BaseEventListener<AbstractEventObject<?>>> filterListeners = this.filterListeners(event);
        this.onBefore(filterListeners, event);
        try {
            eventSupplier.apply();
        }
        catch (Exception err) {
            logger.error((Object)"Execute event supplier function failed, msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
            this.onException(filterListeners, event);
            throw err;
        }
        finally {
            this.onFinal(filterListeners, event);
        }
        this.onAfter(filterListeners, event);
    }

    private List<BaseEventListener<AbstractEventObject<?>>> filterListeners(AbstractEventObject<?> event) {
        return listeners.stream().filter(listener -> {
            try {
                return listener.supportEvent(event);
            }
            catch (ClassCastException err) {
                logger.info((Object)"The listener(%s) is not support event(%s)", new Object[]{listener.getClass().getSimpleName(), event.getClass().getSimpleName()});
                return false;
            }
        }).collect(Collectors.toList());
    }

    private void onBefore(List<BaseEventListener<AbstractEventObject<?>>> filterListeners, AbstractEventObject<?> event) {
        for (BaseEventListener<AbstractEventObject<?>> listener : filterListeners) {
            try {
                logger.info((Object)"Start send event(%s) to listener(%s) onBefore func", new Object[]{event.getClass().getSimpleName(), listener.getClass().getSimpleName()});
                listener.onBefore(event);
            }
            catch (Exception err) {
                logger.error((Object)"Execute listener(%s) onBefore function failed, msg: %s", new Object[]{listener.getClass().getSimpleName(), ExceptionUtil.getErrorMessage((Throwable)err)});
                throw err;
            }
        }
    }

    private void onAfter(List<BaseEventListener<AbstractEventObject<?>>> filterListeners, AbstractEventObject<?> event) {
        for (BaseEventListener<AbstractEventObject<?>> listener : filterListeners) {
            try {
                logger.info((Object)"Start send event(%s) to listener(%s) onAfter func", new Object[]{event.getClass().getSimpleName(), listener.getClass().getSimpleName()});
                listener.onAfter(event);
            }
            catch (Exception err) {
                logger.error((Object)"Execute listener(%s) onAfter function failed, msg: %s", new Object[]{listener.getClass().getSimpleName(), ExceptionUtil.getErrorMessage((Throwable)err)});
                throw err;
            }
        }
    }

    private void onException(List<BaseEventListener<AbstractEventObject<?>>> filterListeners, AbstractEventObject<?> event) {
        for (BaseEventListener<AbstractEventObject<?>> listener : filterListeners) {
            try {
                logger.info((Object)"Start send event(%s) to listener(%s) onException func", new Object[]{event.getClass().getSimpleName(), listener.getClass().getSimpleName()});
                listener.onException(event);
            }
            catch (Exception err) {
                logger.error((Object)"Execute listener(%s) onException function failed, msg: %s", new Object[]{listener.getClass().getSimpleName(), ExceptionUtil.getErrorMessage((Throwable)err)});
            }
        }
    }

    private void onFinal(List<BaseEventListener<AbstractEventObject<?>>> filterListeners, AbstractEventObject<?> event) {
        for (BaseEventListener<AbstractEventObject<?>> listener : filterListeners) {
            try {
                logger.info((Object)"Start send event(%s) to listener(%s) onFinal func", new Object[]{event.getClass().getSimpleName(), listener.getClass().getSimpleName()});
                listener.onFinal(event);
            }
            catch (Exception err) {
                logger.error((Object)"Execute listener(%s) onFinal function failed, msg: %s", new Object[]{listener.getClass().getSimpleName(), ExceptionUtil.getErrorMessage((Throwable)err)});
                throw err;
            }
        }
    }

    protected static List<BaseEventListener<AbstractEventObject<?>>> getAllListeners() {
        ApplicationContext context = SystemLauncher.getSpringContext();
        String[] beanNames = context.getBeanNamesForType(BaseEventListener.class);
        ArrayList result = new ArrayList();
        for (String beanName : beanNames) {
            Object service = context.getBean(beanName);
            if (!(service instanceof BaseEventListener)) continue;
            result.add((BaseEventListener)service);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventDispatcher getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<DefaultEventDispatcher> clazz = DefaultEventDispatcher.class;
        synchronized (DefaultEventDispatcher.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            listeners = DefaultEventDispatcher.getAllListeners();
            taskExecutor = ThreadPoolFactory.getThreadPool("event-dispatcher");
            instance = new DefaultEventDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

