/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.event.listener;

import com.huawei.csr.framework.core.task.app.AutoRefreshTask;
import com.huawei.csr.framework.dao.impl.ApplicationDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverLogDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPlanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPreplanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStepDaoImpl;
import com.huawei.csr.framework.dao.impl.SitePlanDaoImpl;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class CsrStartedListener
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(CsrStartedListener.class);
    private static final int EXECUTE_RATE = 43200;
    ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.executor.scheduleAtFixedRate(new AutoRefreshTask(), 10L, 43200L, TimeUnit.SECONDS);
            this.changeDbRecordsRunningToFailed();
        }
    }

    private void changeDbRecordsRunningToFailed() {
        new Thread(() -> TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ((SitePlanDaoImpl)ServiceLocator.getInstance().getService(SitePlanDaoImpl.class)).changeStatusRunningToFailed();
                logger.info((Object)"Change running site plan to failed status success.");
                ((RecoverPlanDaoImpl)ServiceLocator.getInstance().getService(RecoverPlanDaoImpl.class)).changeStatusRunningToFailed();
                logger.info((Object)"Change running recover plan to failed status success.");
                ((RecoverPreplanDaoImpl)ServiceLocator.getInstance().getService(RecoverPreplanDaoImpl.class)).changeStatusRunningToFailed();
                logger.info((Object)"Change running recover preplan to failed status success.");
                ((RecoverFlowDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowDaoImpl.class)).changeStatusRunningToFailed();
                logger.info((Object)"Change running recover flow to failed status success.");
                ((RecoverStepDaoImpl)ServiceLocator.getInstance().getService(RecoverStepDaoImpl.class)).changeStatusRunningToFailed();
                logger.info((Object)"Change running recover step to failed status success.");
                ((ApplicationDaoImpl)ServiceLocator.getInstance().getService(ApplicationDaoImpl.class)).changeStatusRunningToFailed();
                logger.info((Object)"Change running app to failed status success.");
                ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).changeStatusRunningToFailed();
                logger.info((Object)"Change running recover log to failed status success.");
            }
        })).start();
    }
}

