/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.executor;

import com.huawei.csr.framework.core.executor.PollingStrategy;
import com.huawei.csr.framework.core.executor.ResultChecker;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;

public abstract class AbstractPollingStrategy
implements PollingStrategy {
    private static final long MILLI_PER_SECOND = 1000L;
    private int sleepTimeDefault;
    private int sleepTimeShort;
    private int defaultRetryTime;
    private int fastRetryTime;

    public AbstractPollingStrategy(int sleepTimeDefault, int sleepTimeShort, int defaultRetryTime, int fastRetryTime) {
        this.sleepTimeDefault = sleepTimeDefault;
        this.sleepTimeShort = sleepTimeShort;
        this.defaultRetryTime = defaultRetryTime;
        this.fastRetryTime = fastRetryTime;
    }

    @Override
    public void executePoller(StepExecuteContext executeContext, ResultChecker checker) throws ResponseException, ClientException, IOException {
        for (int i = 0; i < this.defaultRetryTime; ++i) {
            if (i < this.fastRetryTime) {
                CommonUtil.sleep((long)((long)this.sleepTimeShort * 1000L));
            } else {
                CommonUtil.sleep((long)((long)this.sleepTimeDefault * 1000L));
            }
            if (!checker.checkResult(executeContext)) continue;
            return;
        }
        throw new LegoCheckedException(1073953400L);
    }

    public int getSleepTimeDefault() {
        return this.sleepTimeDefault;
    }

    public void setSleepTimeDefault(int sleepTimeDefault) {
        this.sleepTimeDefault = sleepTimeDefault;
    }

    public int getSleepTimeShort() {
        return this.sleepTimeShort;
    }

    public void setSleepTimeShort(int sleepTimeShort) {
        this.sleepTimeShort = sleepTimeShort;
    }

    public int getDefaultRetryTime() {
        return this.defaultRetryTime;
    }

    public void setDefaultRetryTime(int defaultRetryTime) {
        this.defaultRetryTime = defaultRetryTime;
    }

    public int getFastRetryTime() {
        return this.fastRetryTime;
    }

    public void setFastRetryTime(int fastRetryTime) {
        this.fastRetryTime = fastRetryTime;
    }
}

