/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.executor;

import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class StepExecutorManager {
    private static final Log logger = LogFactory.getInstance(StepExecutorManager.class);
    private static StepExecutorManager instance;
    private final Map<String, AbstractStepExecutor> stepExecutors = new HashMap<String, AbstractStepExecutor>();

    private StepExecutorManager() {
    }

    public static synchronized StepExecutorManager getInstance() {
        if (instance == null) {
            instance = new StepExecutorManager();
        }
        return instance;
    }

    public void register(AbstractStepExecutor stepExecutor, Map<String, Object> properties) {
        if (stepExecutor.getStepIdentifier() == null) {
            throw new LegoCheckedException(1073952404L, "The step register to csr failed, identifier is not found, class: " + stepExecutor.getClass().getName());
        }
        String identifier = stepExecutor.getStepIdentifier().render();
        this.stepExecutors.put(identifier, stepExecutor);
        logger.info((Object)"The step register to csr success, step identifier: %s", new Object[]{identifier});
    }

    public void unregister(AbstractStepExecutor stepExecutor, Map<String, Object> properties) {
        if (stepExecutor.getStepIdentifier() == null) {
            throw new LegoCheckedException(1073952404L, "The step unregister from csr failed, identifier is not found, class: " + stepExecutor.getClass().getName());
        }
        String identifier = stepExecutor.getStepIdentifier().render();
        this.stepExecutors.remove(identifier);
        logger.info((Object)"The step unregister from csr success, step identifier: %s", new Object[]{identifier});
    }

    public AbstractStepExecutor getStepExecutor(StepIdentifier stepIdentifier) {
        if (!this.stepExecutors.containsKey(stepIdentifier.render())) {
            throw new LegoCheckedException(1073952404L, "The step class is not found, identifier: " + stepIdentifier.render());
        }
        return this.stepExecutors.get(stepIdentifier.render());
    }
}

